/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.LinkedHashMap;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;

public abstract class AbstractNamedDataFactory<T>
extends AbstractDataFactory {
    private LinkedHashMap<String, T> queries = new LinkedHashMap();

    protected T mapQuery(String query) throws ReportDataFactoryException {
        T t = this.queries.get(query);
        if (t == null) {
            throw new ReportDataFactoryException("No such Query");
        }
        return t;
    }

    @Override
    public final TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        return this.queryDataInternal(this.mapQuery(query), parameters);
    }

    protected abstract TableModel queryDataInternal(T var1, DataRow var2) throws ReportDataFactoryException;

    @Override
    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.queries.containsKey(query);
    }

    @Override
    public String[] getQueryNames() {
        return this.queries.keySet().toArray(new String[this.queries.size()]);
    }

    @Override
    public final String[] getReferencedFields(String query, DataRow dataRow) throws ReportDataFactoryException {
        T queryObject = this.mapQuery(query);
        return this.getReferencedFieldsInternal(queryObject, dataRow);
    }

    protected abstract String[] getReferencedFieldsInternal(T var1, DataRow var2) throws ReportDataFactoryException;

    @Override
    public final Object getQueryHash(String query, DataRow dataRow) throws ReportDataFactoryException {
        T queryObject = this.mapQuery(query);
        return this.getQueryHashInternal(queryObject, dataRow);
    }

    protected abstract Object getQueryHashInternal(T var1, DataRow var2) throws ReportDataFactoryException;
}

