/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public class WizardItemHideFunction
extends AbstractElementFormatFunction
implements StructureFunction {
    private static final Log logger = LogFactory.getLog(WizardItemHideFunction.class);
    private boolean pageStarted;

    @Override
    public int getProcessingPriority() {
        return 6000;
    }

    @Override
    protected boolean evaluateElement(ReportElement e) {
        if (e == null) {
            throw new NullPointerException();
        }
        boolean retval = false;
        Object maybeShowChanging = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "only-show-changing-values");
        if (Boolean.TRUE.equals(maybeShowChanging)) {
            Object field = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for");
            if (field == null) {
                field = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
            }
            if (field != null) {
                String fieldText = String.valueOf(field);
                if (this.pageStarted || this.getDataRow().isChanged(fieldText)) {
                    e.getStyle().setStyleProperty(ElementStyleKeys.VISIBLE, true);
                } else {
                    e.getStyle().setStyleProperty(ElementStyleKeys.VISIBLE, false);
                }
                retval = true;
            }
        }
        return retval;
    }

    @Override
    public void pageStarted(ReportEvent event) {
        this.pageStarted = true;
        super.pageStarted(event);
    }

    @Override
    public void itemsStarted(ReportEvent event) {
        this.pageStarted = true;
        super.itemsStarted(event);
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        super.itemsAdvanced(event);
        this.pageStarted = false;
    }
}

