/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.InlineSubreportProcessor;
import org.pentaho.reporting.engine.classic.core.states.process.JoinDetailsHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class ProcessDetailsHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new ProcessDetailsHandler();

    private ProcessDetailsHandler() {
    }

    @Override
    public int getEventCode() {
        return 32;
    }

    @Override
    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState next = state.deriveForAdvance();
        next.fireReportEvent();
        ItemBand childs = next.getReport().getItemBand();
        if (childs != null) {
            return InlineSubreportProcessor.processInline(next, childs);
        }
        return next;
    }

    @Override
    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        ItemBand childs = next.getReport().getItemBand();
        if (childs == null) {
            return JoinDetailsHandler.HANDLER.commit(next);
        }
        if (InlineSubreportProcessor.hasSubReports(next, childs)) {
            next.setAdvanceHandler(JoinDetailsHandler.HANDLER);
            return InlineSubreportProcessor.processBandedSubReports(next, childs);
        }
        return JoinDetailsHandler.HANDLER.commit(next);
    }

    @Override
    public boolean isFinish() {
        return false;
    }

    @Override
    public boolean isRestoreHandler() {
        return false;
    }
}

