/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaRule;
import org.pentaho.reporting.engine.classic.core.wizard.DirectFieldSelectorRule;
import org.pentaho.reporting.engine.classic.core.wizard.GlobalRule;
import org.pentaho.reporting.engine.classic.core.wizard.MetaSelectorRule;

public class DefaultDataSchemaDefinition
implements DataSchemaDefinition {
    private ArrayList<DataSchemaRule> backend = new ArrayList();

    public void addRule(DataSchemaRule rule) {
        if (rule == null) {
            throw new NullPointerException();
        }
        this.backend.add(rule);
    }

    public DataSchemaRule getRule(int index) {
        return this.backend.get(index);
    }

    public int getRuleCount() {
        return this.backend.size();
    }

    @Override
    public GlobalRule[] getGlobalRules() {
        ArrayList<GlobalRule> retval = new ArrayList<GlobalRule>();
        for (int i = 0; i < this.backend.size(); ++i) {
            DataSchemaRule rule = this.backend.get(i);
            if (!(rule instanceof GlobalRule)) continue;
            retval.add((GlobalRule)rule);
        }
        return retval.toArray(new GlobalRule[retval.size()]);
    }

    @Override
    public MetaSelectorRule[] getIndirectRules() {
        ArrayList<MetaSelectorRule> retval = new ArrayList<MetaSelectorRule>();
        for (int i = 0; i < this.backend.size(); ++i) {
            DataSchemaRule rule = this.backend.get(i);
            if (!(rule instanceof MetaSelectorRule)) continue;
            retval.add((MetaSelectorRule)rule);
        }
        return retval.toArray(new MetaSelectorRule[retval.size()]);
    }

    @Override
    public DirectFieldSelectorRule[] getDirectRules() {
        ArrayList<DirectFieldSelectorRule> retval = new ArrayList<DirectFieldSelectorRule>();
        for (int i = 0; i < this.backend.size(); ++i) {
            DataSchemaRule rule = this.backend.get(i);
            if (!(rule instanceof DirectFieldSelectorRule)) continue;
            retval.add((DirectFieldSelectorRule)rule);
        }
        return retval.toArray(new DirectFieldSelectorRule[retval.size()]);
    }

    public DataSchemaRule[] getRules() {
        return this.backend.toArray(new DataSchemaRule[this.backend.size()]);
    }

    public void merge(DataSchemaDefinition schemaDefinition) {
        if (schemaDefinition == null) {
            throw new NullPointerException();
        }
        GlobalRule[] globalRules = schemaDefinition.getGlobalRules();
        MetaSelectorRule[] indirectRules = schemaDefinition.getIndirectRules();
        DirectFieldSelectorRule[] directRules = schemaDefinition.getDirectRules();
        this.backend.ensureCapacity(this.backend.size() + globalRules.length + indirectRules.length + directRules.length);
        this.backend.addAll(Arrays.asList(globalRules));
        this.backend.addAll(Arrays.asList(indirectRules));
        this.backend.addAll(Arrays.asList(directRules));
    }

    @Override
    public Object clone() {
        try {
            DefaultDataSchemaDefinition def = (DefaultDataSchemaDefinition)super.clone();
            def.backend = (ArrayList)this.backend.clone();
            return def;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Clone should always be supported in this class");
        }
    }
}

