/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.pvfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.ConnectionProvider;
import org.pentaho.hadoop.shim.pvfs.conf.HCPConf;
import org.pentaho.hadoop.shim.pvfs.conf.PvfsConf;
import org.pentaho.hadoop.shim.pvfs.conf.S3Conf;

public class PvfsHadoopBridge
extends FileSystem {
    private FileSystem fs;
    private final List<PvfsConf.ConfFactory> confFactories;
    private final ConnectionManager connMgr;
    private final Cache<PvfsConf, FileSystem> fsCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();

    public PvfsHadoopBridge() {
        this.confFactories = Arrays.asList(S3Conf::new, HCPConf::new);
        this.connMgr = ConnectionManager.getInstance();
    }

    @VisibleForTesting
    PvfsHadoopBridge(List<PvfsConf.ConfFactory> confFactories, ConnectionManager connMgr) {
        this.confFactories = confFactories;
        this.connMgr = connMgr;
    }

    public String getScheme() {
        return "pvfs";
    }

    protected void checkPath(Path path) {
        if (this.getFs(path) == null) {
            throw new IllegalArgumentException("Cannot find a supported filesystem for " + path);
        }
    }

    public Path makeQualified(Path path) {
        this.getFs(path);
        return super.makeQualified(path);
    }

    public URI getUri() {
        Objects.requireNonNull(this.fs);
        return this.fs.getUri();
    }

    public FSDataInputStream open(Path path, int i) throws IOException {
        return this.getFs(path).open(this.updatePath(path), i);
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean b, int i, short i1, long l, Progressable progressable) throws IOException {
        return this.getFs(path).create(this.updatePath(path), fsPermission, b, i, i1, l, progressable);
    }

    public FSDataOutputStream append(Path path, int i, Progressable progressable) throws IOException {
        return this.getFs(path).append(this.updatePath(path), i, progressable);
    }

    public boolean rename(Path path, Path path1) throws IOException {
        return this.getFs(path).rename(this.updatePath(path), this.updatePath(path1));
    }

    public boolean delete(Path path, boolean b) throws IOException {
        return this.getFs(path).delete(this.updatePath(path), b);
    }

    public void setWorkingDirectory(Path path) {
        this.getFs(path).setWorkingDirectory(this.updatePath(path));
    }

    public Path getWorkingDirectory() {
        Objects.requireNonNull(this.fs);
        return this.fs.getWorkingDirectory();
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        return this.getFs(path).mkdirs(this.updatePath(path), fsPermission);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        FileStatus fileStatus = this.getFs(path).getFileStatus(this.updatePath(path));
        fileStatus.setPath(path);
        return fileStatus;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        FileStatus[] fileStatuses = this.getFs(path).listStatus(this.updatePath(path));
        Arrays.stream(fileStatuses).forEach(status -> status.setPath(this.getPvfsConf(path).mapPath(path, status.getPath())));
        return fileStatuses;
    }

    private Path updatePath(final Path path) {
        if (this.schemeIsNotPvfs(path)) {
            return path;
        }
        Path updatedPath = this.getPvfsConf(path).mapPath(path);
        return new Path(updatedPath.toUri()){

            public FileSystem getFileSystem(Configuration conf) {
                return PvfsHadoopBridge.this.getCachedFs(path);
            }
        };
    }

    private boolean schemeIsNotPvfs(Path path) {
        return !this.getScheme().equals(path.toUri().getScheme());
    }

    private FileSystem getFs(Path path) {
        if (this.schemeIsNotPvfs(path)) {
            return Objects.requireNonNull(this.fs, "File system not initialized for " + path.toString());
        }
        return this.getCachedFs(path);
    }

    private FileSystem getCachedFs(Path path) {
        PvfsConf pvfsConf = this.getPvfsConf(path);
        try {
            this.fs = (FileSystem)this.fsCache.get((Object)pvfsConf, () -> this.getRealFileSystem(path, pvfsConf));
            return this.fs;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private FileSystem getRealFileSystem(Path path, PvfsConf pvfsConf) {
        try {
            Configuration conf = pvfsConf.conf(path);
            this.fs = FileSystem.get((URI)pvfsConf.mapPath(path).toUri(), (Configuration)conf);
            this.setConf(conf);
            return this.fs;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private PvfsConf getPvfsConf(Path path) {
        ConnectionDetails details = this.connMgr.getConnectionDetails(path.toUri().getHost());
        if (details == null) {
            throw new IllegalStateException("Could not find named connection " + path.toUri().getHost());
        }
        return this.confFactories.stream().map(f -> f.get(details)).filter(PvfsConf::supportsConnection).findFirst().orElseThrow(() -> new IllegalStateException("Unsupported VFS connection type:  " + this.getProviderName(details)));
    }

    private String getProviderName(ConnectionDetails details) {
        return this.connMgr.getProviders().stream().filter(connectionProvider -> connectionProvider.getKey().equals(details.getType())).findFirst().map(ConnectionProvider::getName).orElse(details.getType());
    }
}

