/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.pvfs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.thirdparty.apache.http.conn.socket.ConnectionSocketFactory;
import com.amazonaws.thirdparty.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.google.common.annotations.VisibleForTesting;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hadoop.fs.s3a.DefaultS3ClientFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class SelfSignedS3ClientFactory
extends DefaultS3ClientFactory {
    private final HostnameVerifier allowAllHosts = new NoopHostnameVerifier();
    @VisibleForTesting
    final SSLConnectionSocketFactory connectionFactory = this.selfSignedSSLConnFactory();

    protected AmazonS3 newAmazonS3Client(AWSCredentialsProvider credentials, ClientConfiguration awsConf) {
        awsConf.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)this.connectionFactory);
        return new AmazonS3Client(credentials, awsConf);
    }

    private SSLConnectionSocketFactory selfSignedSSLConnFactory() {
        SSLContext sslContext;
        try {
            sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return new SSLConnectionSocketFactory(sslContext, this.allowAllHosts);
    }
}

