/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.pvfs.conf;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.core.util.Utils;
import org.pentaho.hadoop.shim.pvfs.conf.PvfsConf;

public class HCPConf
extends PvfsConf {
    public HCPConf(ConnectionDetails details) {
        super(details);
    }

    @Override
    public boolean supportsConnection() {
        return "hcp".equalsIgnoreCase(this.details.getType());
    }

    @Override
    public Path mapPath(Path pvfsPath) {
        this.validatePath(pvfsPath);
        Map props = this.details.getProperties();
        String namespace = (String)props.get("namespace");
        try {
            return new Path(new URI("s3a", namespace, pvfsPath.toUri().getPath(), null));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Path mapPath(Path pvfsPath, Path realFsPath) {
        URI uri = realFsPath.toUri();
        return new Path(pvfsPath.toUri().getScheme(), pvfsPath.toUri().getHost(), "/" + uri.getPath());
    }

    @Override
    public Configuration conf(Path pvfsPath) {
        this.validatePath(pvfsPath);
        Configuration conf = new Configuration();
        Map props = this.details.getProperties();
        String port = (String)props.get("port");
        String hostPort = (String)props.get("host") + (port == null ? "" : ":" + port);
        String username = (String)props.get("username");
        String proxyHost = (String)props.get("proxyHost");
        String proxyPort = (String)props.get("proxyPort");
        boolean acceptSelfSignedCertificates = Boolean.parseBoolean((String)props.get("acceptSelfSignedCertificate"));
        if (!Utils.isEmpty((CharSequence)proxyHost)) {
            conf.set("fs.s3a.proxy.host", proxyHost);
            conf.set("fs.s3a.proxy.port", proxyPort);
        }
        conf.set("fs.s3a.access.key", Base64.getEncoder().encodeToString(username.getBytes()));
        conf.set("fs.s3a.secret.key", DigestUtils.md5Hex((String)((String)props.get("password"))));
        conf.set("fs.s3a.endpoint", (String)props.get("tenant") + "." + hostPort);
        conf.set("fs.s3a.signing-algorithm", "S3SignerType");
        conf.set("fs.s3a.impl", "org.apache.hadoop.fs.s3a.S3AFileSystem");
        conf.set("fs.s3a.connection.ssl.enabled", "true");
        conf.set("fs.s3a.attempts.maximum", "3");
        conf.set("fs.s3a.impl.disable.cache", "true");
        if (acceptSelfSignedCertificates) {
            conf.set("fs.s3a.s3.client.factory.impl", "org.pentaho.hadoop.shim.pvfs.SelfSignedS3ClientFactory");
        }
        return conf;
    }
}

