/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.pvfs.conf;

import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.pentaho.di.connections.ConnectionDetails;

public abstract class PvfsConf {
    protected final ConnectionDetails details;

    PvfsConf(ConnectionDetails details) {
        this.details = details;
    }

    public abstract boolean supportsConnection();

    public abstract Path mapPath(Path var1);

    public abstract Path mapPath(Path var1, Path var2);

    public abstract Configuration conf(Path var1);

    void validatePath(Path pvfsPath) {
        if (!this.supportsConnection() || !pvfsPath.toUri().getScheme().equals("pvfs")) {
            throw new IllegalStateException(pvfsPath.toString() + " not supported by " + this.details.getClass().getName());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PvfsConf pvfsConf = (PvfsConf)o;
        if (this.details == null && pvfsConf.details == null) {
            return true;
        }
        if (this.details == null || pvfsConf.details == null) {
            return false;
        }
        return Objects.equals(this.details.getProperties(), pvfsConf.details.getProperties());
    }

    public int hashCode() {
        if (this.details == null) {
            return Objects.hash(this);
        }
        return Objects.hash(this.details.getProperties());
    }

    @FunctionalInterface
    public static interface ConfFactory {
        public PvfsConf get(ConnectionDetails var1);
    }
}

