/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.api.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.SystemUtils;

public class ShimProperties
extends Properties {
    private static final long serialVersionUID = 2033564331119378266L;
    public static final String SHIM_CP_CONFIG = "shim.current.config";
    private final WindowsChecker windowsChecker;

    public ShimProperties() {
        this(new WindowsChecker(){

            @Override
            public boolean isWindows() {
                return SystemUtils.IS_OS_WINDOWS;
            }
        });
    }

    protected ShimProperties(WindowsChecker windowsChecker) {
        this.windowsChecker = windowsChecker;
    }

    private List<String> getShimConfigs() {
        ArrayList<String> shimConfigs = new ArrayList<String>();
        String shimCurrentConfig = super.getProperty(SHIM_CP_CONFIG);
        String os = "linux";
        if (this.windowsChecker.isWindows()) {
            os = "windows";
        }
        shimConfigs.add(os);
        if (shimCurrentConfig != null) {
            for (String config : shimCurrentConfig.trim().split(",")) {
                shimConfigs.add(config.trim());
                shimConfigs.add(os + "." + config.trim());
            }
        }
        return shimConfigs;
    }

    private List<String> getShimConfigProperties(String property) {
        ArrayList<String> shimConfigProperties = new ArrayList<String>();
        for (String config : this.getShimConfigs()) {
            shimConfigProperties.add(super.getProperty(config + "." + property));
        }
        return shimConfigProperties;
    }

    public List<String> getConfigList(String property) {
        return this.getConfigList(property, ListOverrideType.APPEND);
    }

    public List<String> getConfigList(String property, ListOverrideType listOverrideType) {
        List<String> shimConfigValues = this.getShimConfigProperties(property);
        ArrayList<String> shimProperties = new ArrayList<String>();
        String globalValues = super.getProperty(property);
        if (globalValues != null && globalValues.trim().length() > 0) {
            shimProperties.addAll(Arrays.asList(globalValues.split(",")));
        }
        for (String shimConfigValue : shimConfigValues) {
            if (shimConfigValue == null) continue;
            ArrayList<String> shimProperty = new ArrayList<String>();
            if (shimConfigValue.trim().length() > 0) {
                for (String prop : shimConfigValue.trim().split(",")) {
                    shimProperty.add(prop.trim());
                }
            }
            switch (listOverrideType) {
                case APPEND: {
                    shimProperties.addAll(shimProperty);
                    break;
                }
                case PREPEND: {
                    shimProperty.addAll(shimProperties);
                    shimProperties = shimProperty;
                    break;
                }
                case REPLACE: {
                    shimProperties = shimProperty;
                }
            }
        }
        return shimProperties;
    }

    public Set<String> getConfigSet(String property) {
        return this.getConfigSet(property, SetOverrideType.OVERLAY);
    }

    public Set<String> getConfigSet(String property, SetOverrideType overrideType) {
        List<String> shimConfigValues = this.getShimConfigProperties(property);
        HashSet<String> shimProperties = new HashSet<String>();
        String globalValues = super.getProperty(property);
        if (globalValues != null && globalValues.trim().length() > 0) {
            shimProperties.addAll(Arrays.asList(globalValues.split(",")));
        }
        for (String shimConfigValue : shimConfigValues) {
            if (shimConfigValue == null) continue;
            HashSet<String> shimProperty = new HashSet<String>();
            if (shimConfigValue.trim().length() > 0) {
                for (String prop : shimConfigValue.trim().split(",")) {
                    shimProperty.add(prop.trim());
                }
            }
            switch (overrideType) {
                case OVERLAY: {
                    shimProperties.addAll(shimProperty);
                    break;
                }
                case REPLACE: {
                    shimProperties = shimProperty;
                }
            }
        }
        return shimProperties;
    }

    @Override
    public String getProperty(String key) {
        List<String> configProperties = this.getShimConfigProperties(key);
        for (int i = configProperties.size() - 1; i >= 0; --i) {
            String property = configProperties.get(i);
            if (property == null || (property = property.trim()).length() <= 0) continue;
            return property;
        }
        return super.getProperty(key);
    }

    public Map<String, String> getPrefixedProperties(String prefix) {
        ArrayList<String> propertyPrefixes = new ArrayList<String>();
        propertyPrefixes.add(prefix + ".");
        for (String shimConfig : this.getShimConfigs()) {
            propertyPrefixes.add(shimConfig + "." + prefix.trim() + ".");
        }
        HashMap<String, String> prefixedProperties = new HashMap<String, String>();
        for (String currentPrefix : propertyPrefixes) {
            for (String propertyName : this.stringPropertyNames()) {
                if (!propertyName.startsWith(currentPrefix)) continue;
                prefixedProperties.put(propertyName.substring(currentPrefix.length()), super.getProperty(propertyName));
            }
        }
        return prefixedProperties;
    }

    public static enum SetOverrideType {
        REPLACE,
        OVERLAY;

    }

    public static enum ListOverrideType {
        REPLACE,
        APPEND,
        PREPEND;

    }

    public static interface WindowsChecker {
        public boolean isWindows();
    }
}

