/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.io.IOException;
import java.util.List;
import org.pentaho.hadoop.shim.ShimException;
import org.pentaho.hadoop.shim.ShimRuntimeException;
import org.pentaho.hadoop.shim.api.internal.Configuration;
import org.pentaho.hadoop.shim.api.internal.mapred.RunningJob;
import org.pentaho.hadoop.shim.common.CommonHadoopShim;
import org.pentaho.hadoop.shim.common.ConfigurationProxyV2;

public class HadoopShimImpl
extends CommonHadoopShim {
    @Override
    protected String getDefaultNamenodePort() {
        return "8020";
    }

    @Override
    protected String getDefaultJobtrackerPort() {
        return "8021";
    }

    @Override
    public RunningJob submitJob(Configuration c) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            RunningJob runningJob = c.submit();
            return runningJob;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ShimRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ShimRuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public Configuration createConfiguration() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigurationProxyV2 configurationProxyV2 = new ConfigurationProxyV2();
            return configurationProxyV2;
        }
        catch (IOException e) {
            throw new ShimRuntimeException("Unable to create configuration for new mapreduce api: ", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public Configuration createConfiguration(String namedCluster) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigurationProxyV2 configurationProxyV2 = new ConfigurationProxyV2(namedCluster);
            return configurationProxyV2;
        }
        catch (IOException e) {
            throw new ShimRuntimeException("Unable to create configuration for new mapreduce api: ", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public void configureConnectionInformation(String namenodeHost, String namenodePort, String jobtrackerHost, String jobtrackerPort, Configuration conf, List<String> logMessages) throws Exception {
        String runtimeFsDefaultName = conf.get("pentaho.runtime.fs.default.name");
        String runtimeFsDefaultScheme = conf.get("pentaho.runtime.fs.default.scheme", "hdfs");
        String runtimeJobTracker = conf.get("pentaho.runtime.job.tracker");
        if (runtimeFsDefaultName == null) {
            if (namenodeHost == null || namenodeHost.trim().length() == 0) {
                throw new ShimException("No hdfs host specified!");
            }
            if (namenodePort != null && namenodePort.trim().length() != 0 && !"-1".equals(namenodePort.trim())) {
                namenodePort = ":" + namenodePort;
            } else {
                namenodePort = "";
                logMessages.add("No hdfs port specified - HA? ");
            }
            runtimeFsDefaultName = runtimeFsDefaultScheme + "://" + namenodeHost + namenodePort;
        }
        if (runtimeJobTracker == null) {
            if (jobtrackerHost == null || jobtrackerHost.trim().length() == 0) {
                throw new ShimException("No job tracker host specified!");
            }
            if (jobtrackerPort == null || jobtrackerPort.trim().length() == 0) {
                jobtrackerPort = this.getDefaultJobtrackerPort();
                logMessages.add("No job tracker port specified - using default: " + jobtrackerPort);
            }
            runtimeJobTracker = jobtrackerHost + ":" + jobtrackerPort;
        }
        conf.set("fs.default.name", runtimeFsDefaultName);
        conf.set("mapred.job.tracker", runtimeJobTracker);
    }
}

