/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.ftp4che.exception.ProxyConnectionException;
import org.ftp4che.proxy.Proxy;

public class Socks5
implements Proxy {
    static final int PROTOCOL_VERSION = 5;
    static final int DEFAULT_PORT = 1080;
    static final int DEFAULT_TIMEOUT = 20000;
    static final int NO_AUTH = 0;
    static final int GSSAPI = 1;
    static final int USER_PASS = 2;
    static final int CONNECT = 1;
    static final int BIND = 2;
    static final int UDP = 3;
    static final int IPV4 = 1;
    static final int DOMAIN_NAME = 3;
    static final int IPV6 = 4;
    static final int REQUEST_OK = 0;
    static final int GENERAL_FAILURE = 1;
    static final int NOT_ALLOWED = 2;
    static final int NET_UNREACHABLE = 3;
    static final int HOST_UNREACHABLE = 4;
    static final int CONNECTION_REFUSED = 5;
    static final int TTL_EXPIRED = 6;
    static final int CMD_NOT_SUPPORTED = 7;
    static final int ADDR_TYPE_NOT_SUPPORTED = 8;
    public static final Logger log = Logger.getLogger((String)Socks5.class.getName());
    private String host;
    private String user;
    private String pass;
    private int port = 1080;
    private int primaryConnectionPort;
    private int timeout = 20000;
    private Socket socket = null;
    private InetSocketAddress bindAddress;

    public Socks5(String proxyHost, String proxyUser, String proxyPass) {
        this(proxyHost, -1, -1, proxyUser, proxyPass);
    }

    public Socks5(String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
        this(proxyHost, proxyPort, -1, proxyUser, proxyPass);
    }

    public Socks5(String proxyHost, int proxyPort, int timeout, String proxyUser, String proxyPass) {
        this.setHost(proxyHost);
        this.setPort(proxyPort);
        this.setUser(proxyUser);
        this.setPass(proxyPass);
    }

    public Socket connect(String host, int port) throws ProxyConnectionException {
        this.setPrimaryConnectionPort(port);
        InetSocketAddress isa = null;
        try {
            isa = new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (IOException ioe) {
            throw new ProxyConnectionException(-2, "SOCK5 - IOException: " + ioe.getMessage());
        }
        InetAddress addr = isa.getAddress();
        byte[] hostbytes = addr.getAddress();
        byte[] requestPacket = new byte[300];
        byte[] response = new byte[2];
        int methodCount = 2;
        requestPacket[0] = 5;
        requestPacket[1] = methodCount;
        requestPacket[2] = 0;
        if (this.getUser() != null && this.getPass() != null) {
            requestPacket[3] = 2;
        }
        try {
            this.connectToProxy();
            this.socket.getOutputStream().write(requestPacket, 0, methodCount + 2);
            this.socket.getInputStream().read(response, 0, 2);
        }
        catch (IOException ioe) {
            throw new ProxyConnectionException(-2, "SOCK5 - IOException: " + ioe.getMessage());
        }
        log.debug((Object)("Using method: " + response[1]));
        if (response[1] == 0) {
            return this.request(hostbytes);
        }
        if (response[1] == 2 && this.authUserPass(hostbytes)) {
            return this.request(hostbytes);
        }
        return null;
    }

    private Socket request(byte[] hostbytes) throws ProxyConnectionException {
        byte[] requestPacket = new byte[1024];
        byte[] response = new byte[10];
        requestPacket[0] = 5;
        requestPacket[1] = 1;
        requestPacket[2] = 0;
        requestPacket[3] = 1;
        System.arraycopy(hostbytes, 0, requestPacket, 4, 4);
        requestPacket[8] = (byte)(this.getPrimaryConnectionPort() >> 8);
        requestPacket[9] = (byte)(this.getPrimaryConnectionPort() & 0xFF);
        OutputStream out = null;
        InputStream in = null;
        try {
            out = this.socket.getOutputStream();
            in = this.socket.getInputStream();
            out.write(requestPacket, 0, 10);
            in.read(response, 0, 10);
        }
        catch (IOException ioe) {
            throw new ProxyConnectionException(-2, "SOCK5 - IOException: " + ioe.getMessage());
        }
        ProxyConnectionException pce = null;
        switch (response[1]) {
            case 0: {
                break;
            }
            case 1: {
                pce = new ProxyConnectionException(1, "SOCKS5 general SOCKS server failure");
                break;
            }
            case 2: {
                pce = new ProxyConnectionException(2, "SOCKS5 connection not allowed by ruleset");
                break;
            }
            case 3: {
                pce = new ProxyConnectionException(3, "SOCKS5 Network unreachable");
                break;
            }
            case 4: {
                pce = new ProxyConnectionException(4, "SOCKS5 Host unreachable");
                break;
            }
            case 5: {
                pce = new ProxyConnectionException(5, "SOCKS5 Connection refused");
                break;
            }
            case 6: {
                pce = new ProxyConnectionException(6, "SOCKS5 TTL expired");
                break;
            }
            case 7: {
                pce = new ProxyConnectionException(7, "SOCKS5 Command not supported");
                break;
            }
            case 8: {
                pce = new ProxyConnectionException(8, "SOCKS5 Address type not supported");
                break;
            }
            default: {
                pce = new ProxyConnectionException(-1, "SOCKS5 unknown proxy response");
            }
        }
        if (pce != null) {
            try {
                out.close();
                in.close();
                this.socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw pce;
        }
        return this.socket;
    }

    private boolean authUserPass(byte[] hostbytes) throws ProxyConnectionException {
        byte[] requestPacket = new byte[1024];
        byte[] response = new byte[2];
        byte userLen = (byte)this.getUser().getBytes().length;
        byte passLen = (byte)this.getPass().getBytes().length;
        requestPacket[0] = 1;
        requestPacket[1] = userLen;
        System.arraycopy(this.getUser().getBytes(), 0, requestPacket, 2, userLen);
        requestPacket[2 + userLen] = passLen;
        System.arraycopy(this.getPass().getBytes(), 0, requestPacket, 3 + userLen, passLen);
        OutputStream out = null;
        InputStream in = null;
        try {
            out = this.socket.getOutputStream();
            in = this.socket.getInputStream();
            out.write(requestPacket, 0, 3 + userLen + passLen);
            in.read(response, 0, 2);
        }
        catch (IOException ioe) {
            throw new ProxyConnectionException(-2, "SOCK5 - IOException: " + ioe.getMessage());
        }
        ProxyConnectionException pce = null;
        switch (response[1]) {
            case 0: {
                return true;
            }
            case 1: {
                pce = new ProxyConnectionException(1, "SOCKS5 general SOCKS server failure");
                break;
            }
            case 2: {
                pce = new ProxyConnectionException(2, "SOCKS5 connection not allowed by ruleset");
                break;
            }
            case 3: {
                pce = new ProxyConnectionException(3, "SOCKS5 Network unreachable");
                break;
            }
            case 4: {
                pce = new ProxyConnectionException(4, "SOCKS5 Host unreachable");
                break;
            }
            case 5: {
                pce = new ProxyConnectionException(5, "SOCKS5 Connection refused");
                break;
            }
            case 6: {
                pce = new ProxyConnectionException(6, "SOCKS5 TTL expired");
                break;
            }
            case 7: {
                pce = new ProxyConnectionException(7, "SOCKS5 Command not supported");
                break;
            }
            case 8: {
                pce = new ProxyConnectionException(8, "SOCKS5 Address type not supported");
                break;
            }
            default: {
                pce = new ProxyConnectionException(-1, "SOCKS5 unknown proxy response");
            }
        }
        if (pce != null) {
            try {
                out.close();
                in.close();
                this.socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw pce;
        }
        return false;
    }

    private void connectToProxy() throws IOException {
        this.socket = new Socket();
        this.socket.setSoTimeout(this.getTimeout());
        this.socket.connect(new InetSocketAddress(InetAddress.getByName(this.getHost()), this.getPort()), this.getTimeout());
    }

    public Socket bind(InetSocketAddress isa) throws ProxyConnectionException {
        this.setPrimaryConnectionPort(this.port);
        InetAddress addr = isa.getAddress();
        byte[] hostbytes = addr.getAddress();
        byte[] requestPacket = new byte[300];
        byte[] response = new byte[2];
        int methodCount = 2;
        requestPacket[0] = 5;
        requestPacket[1] = methodCount;
        requestPacket[2] = 0;
        if (this.getUser() != null && this.getPass() != null) {
            requestPacket[3] = 2;
        }
        try {
            this.connectToProxy();
            this.socket.getOutputStream().write(requestPacket, 0, methodCount + 2);
            this.socket.getInputStream().read(response, 0, 2);
        }
        catch (IOException ioe) {
            throw new ProxyConnectionException(-2, "SOCK4 - IOException: " + ioe.getMessage());
        }
        requestPacket = new byte[1024];
        requestPacket[0] = 5;
        requestPacket[1] = 2;
        requestPacket[2] = 0;
        requestPacket[3] = 1;
        System.arraycopy(hostbytes, 0, requestPacket, 4, 4);
        requestPacket[8] = (byte)(this.getPrimaryConnectionPort() >> 8);
        requestPacket[9] = (byte)(this.getPrimaryConnectionPort() & 0xFF);
        response = new byte[10];
        OutputStream out = null;
        InputStream in = null;
        try {
            out = this.socket.getOutputStream();
            in = this.socket.getInputStream();
            out.write(requestPacket, 0, 10);
            in.read(response, 0, 10);
        }
        catch (IOException ioe) {
            throw new ProxyConnectionException(-2, "SOCK5 - IOException: " + ioe.getMessage());
        }
        ProxyConnectionException pce = null;
        switch (response[1]) {
            case 0: {
                break;
            }
            case 1: {
                pce = new ProxyConnectionException(1, "SOCKS5 general SOCKS server failure");
                break;
            }
            case 2: {
                pce = new ProxyConnectionException(2, "SOCKS5 connection not allowed by ruleset");
                break;
            }
            case 3: {
                pce = new ProxyConnectionException(3, "SOCKS5 Network unreachable");
                break;
            }
            case 4: {
                pce = new ProxyConnectionException(4, "SOCKS5 Host unreachable");
                break;
            }
            case 5: {
                pce = new ProxyConnectionException(5, "SOCKS5 Connection refused");
                break;
            }
            case 6: {
                pce = new ProxyConnectionException(6, "SOCKS5 TTL expired");
                break;
            }
            case 7: {
                pce = new ProxyConnectionException(7, "SOCKS5 Command not supported");
                break;
            }
            case 8: {
                pce = new ProxyConnectionException(8, "SOCKS5 Address type not supported");
                break;
            }
            default: {
                pce = new ProxyConnectionException(-1, "SOCKS5 unknown proxy response");
            }
        }
        if (pce != null) {
            try {
                out.close();
                in.close();
                this.socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw pce;
        }
        return this.socket;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port > 0 ? port : 1080;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public int getPrimaryConnectionPort() {
        return this.primaryConnectionPort;
    }

    public void setPrimaryConnectionPort(int primaryConnectionPort) {
        this.primaryConnectionPort = primaryConnectionPort;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout > 0 ? timeout : 20000;
    }

    public InetSocketAddress getBindAddress() {
        return null;
    }

    public InetSocketAddress getProxyAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }
}

