/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl.handlers;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginFileHandler;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginHandlingException;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLibraryFileHandler
implements PluginFileHandler {
    private static Logger log = LoggerFactory.getLogger(PluginLibraryFileHandler.class);
    public static final Pattern LIB_PATTERN = Pattern.compile(".+\\/lib\\/.+\\.jar");
    public static final String JAR = ".jar";
    public static final String LIB = "/lib/";

    @Override
    public boolean handles(String fileName) {
        return fileName != null && fileName.contains(LIB) && fileName.endsWith(JAR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handle(String relativePath, byte[] file, PluginMetadata pluginMetadata) throws PluginHandlingException {
        try (ByteArrayInputStream fin = new ByteArrayInputStream(file);
             JarInputStream jarInputStream = new JarInputStream(fin);){
            ZipEntry nextEntry;
            String bundleSymbolicName = jarInputStream.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
            if (bundleSymbolicName != null) {
                log.info(String.format("Jar identified as an OSGi bundle [%s]; no auto-deploy. Assumed to be provided by the container.", bundleSymbolicName.toString()));
                boolean bl = false;
                return bl;
            }
            while ((nextEntry = jarInputStream.getNextEntry()) != null) {
                if (nextEntry.isDirectory()) continue;
                String name = nextEntry.getName();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)Math.min(Integer.MAX_VALUE, Math.max(0L, nextEntry.getSize())));
                Throwable throwable = null;
                try {
                    ByteStreams.copy((InputStream)jarInputStream, (OutputStream)byteArrayOutputStream);
                    if (name.matches(".+\\.xml")) {
                        String contents = byteArrayOutputStream.toString("UTF-8");
                        if (!contents.contains("http://www.springframework.org/schema/beans")) continue;
                        FileWriter fileWriter = pluginMetadata.getFileWriter("META-INF/spring/" + name);
                        fileWriter.append(contents);
                        fileWriter.close();
                        continue;
                    }
                    OutputStream fileOut = pluginMetadata.getFileOutputStream(nextEntry.getName());
                    fileOut.write(byteArrayOutputStream.toByteArray());
                    fileOut.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (byteArrayOutputStream == null) continue;
                    if (throwable != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    byteArrayOutputStream.close();
                }
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

