/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Comparator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AbstractAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class NodeAllocationResult
implements ToXContentObject,
Writeable,
Comparable<NodeAllocationResult> {
    private static final Comparator<NodeAllocationResult> nodeResultComparator = Comparator.comparing(NodeAllocationResult::getNodeDecision).thenComparingInt(NodeAllocationResult::getWeightRanking).thenComparing(r -> r.getNode().getId());
    private final DiscoveryNode node;
    @Nullable
    private final ShardStoreInfo shardStoreInfo;
    private final AllocationDecision nodeDecision;
    @Nullable
    private final Decision canAllocateDecision;
    private final int weightRanking;

    public NodeAllocationResult(DiscoveryNode node, ShardStoreInfo shardStoreInfo, @Nullable Decision decision) {
        this.node = node;
        this.shardStoreInfo = shardStoreInfo;
        this.canAllocateDecision = decision;
        this.nodeDecision = decision != null ? AllocationDecision.fromDecisionType(this.canAllocateDecision.type()) : AllocationDecision.NO;
        this.weightRanking = 0;
    }

    public NodeAllocationResult(DiscoveryNode node, AllocationDecision nodeDecision, Decision canAllocate, int weightRanking) {
        this.node = node;
        this.shardStoreInfo = null;
        this.canAllocateDecision = canAllocate;
        this.nodeDecision = nodeDecision;
        this.weightRanking = weightRanking;
    }

    public NodeAllocationResult(DiscoveryNode node, Decision decision, int weightRanking) {
        this.node = node;
        this.shardStoreInfo = null;
        this.canAllocateDecision = decision;
        this.nodeDecision = AllocationDecision.fromDecisionType(decision.type());
        this.weightRanking = weightRanking;
    }

    public NodeAllocationResult(StreamInput in) throws IOException {
        this.node = new DiscoveryNode(in);
        this.shardStoreInfo = in.readOptionalWriteable(ShardStoreInfo::new);
        this.canAllocateDecision = in.getVersion().before(Version.V_5_2_1) ? Decision.readFrom(in) : in.readOptionalWriteable(Decision::readFrom);
        this.nodeDecision = AllocationDecision.readFrom(in);
        this.weightRanking = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.node.writeTo(out);
        out.writeOptionalWriteable(this.shardStoreInfo);
        if (out.getVersion().before(Version.V_5_2_1)) {
            if (this.canAllocateDecision == null) {
                Decision.NO.writeTo(out);
            } else {
                this.canAllocateDecision.writeTo(out);
            }
        } else {
            out.writeOptionalWriteable(this.canAllocateDecision);
        }
        this.nodeDecision.writeTo(out);
        out.writeVInt(this.weightRanking);
    }

    public DiscoveryNode getNode() {
        return this.node;
    }

    @Nullable
    public ShardStoreInfo getShardStoreInfo() {
        return this.shardStoreInfo;
    }

    @Nullable
    public Decision getCanAllocateDecision() {
        return this.canAllocateDecision;
    }

    public boolean isWeightRanked() {
        return this.weightRanking > 0;
    }

    public int getWeightRanking() {
        return this.weightRanking;
    }

    public AllocationDecision getNodeDecision() {
        return this.nodeDecision;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        AbstractAllocationDecision.discoveryNodeToXContent(this.node, false, builder);
        builder.field("node_decision", (Object)this.nodeDecision);
        if (this.shardStoreInfo != null) {
            this.shardStoreInfo.toXContent(builder, params);
        }
        if (this.isWeightRanked()) {
            builder.field("weight_ranking", this.getWeightRanking());
        }
        if (this.canAllocateDecision != null && !this.canAllocateDecision.getDecisions().isEmpty()) {
            builder.startArray("deciders");
            this.canAllocateDecision.toXContent(builder, params);
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public int compareTo(NodeAllocationResult other) {
        return nodeResultComparator.compare(this, other);
    }

    public static final class ShardStoreInfo
    implements ToXContentFragment,
    Writeable {
        private final boolean inSync;
        @Nullable
        private final String allocationId;
        private final long matchingBytes;
        @Nullable
        private final Exception storeException;

        public ShardStoreInfo(String allocationId, boolean inSync, Exception storeException) {
            this.inSync = inSync;
            this.allocationId = allocationId;
            this.matchingBytes = -1L;
            this.storeException = storeException;
        }

        public ShardStoreInfo(long matchingBytes) {
            this.inSync = false;
            this.allocationId = null;
            this.matchingBytes = matchingBytes;
            this.storeException = null;
        }

        public ShardStoreInfo(StreamInput in) throws IOException {
            this.inSync = in.readBoolean();
            this.allocationId = in.readOptionalString();
            this.matchingBytes = in.readLong();
            this.storeException = in.readException();
        }

        public boolean isInSync() {
            return this.inSync;
        }

        @Nullable
        public String getAllocationId() {
            return this.allocationId;
        }

        public boolean hasMatchingSyncId() {
            return this.matchingBytes == Long.MAX_VALUE;
        }

        public long getMatchingBytes() {
            return this.matchingBytes;
        }

        @Nullable
        public Exception getStoreException() {
            return this.storeException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.inSync);
            out.writeOptionalString(this.allocationId);
            out.writeLong(this.matchingBytes);
            out.writeException(this.storeException);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("store");
            if (this.matchingBytes < 0L) {
                if (this.allocationId == null && this.storeException == null) {
                    builder.field("found", false);
                } else {
                    builder.field("in_sync", this.inSync);
                }
            }
            if (this.allocationId != null) {
                builder.field("allocation_id", this.allocationId);
            }
            if (this.matchingBytes >= 0L) {
                if (this.hasMatchingSyncId()) {
                    builder.field("matching_sync_id", true);
                } else {
                    builder.humanReadableField("matching_size_in_bytes", "matching_size", (Object)new ByteSizeValue(this.matchingBytes));
                }
            }
            if (this.storeException != null) {
                builder.startObject("store_exception");
                ElasticsearchException.generateThrowableXContent(builder, params, this.storeException);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }
    }
}

