/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;

final class GlobalOrdinalMapping
extends SortedSetDocValues {
    private final SortedSetDocValues values;
    private final OrdinalMap ordinalMap;
    private final LongValues mapping;
    private final SortedSetDocValues[] bytesValues;

    GlobalOrdinalMapping(OrdinalMap ordinalMap, SortedSetDocValues[] bytesValues, int segmentIndex) {
        this.values = bytesValues[segmentIndex];
        this.bytesValues = bytesValues;
        this.ordinalMap = ordinalMap;
        this.mapping = ordinalMap.getGlobalOrds(segmentIndex);
    }

    public long getValueCount() {
        return this.ordinalMap.getValueCount();
    }

    public long getGlobalOrd(long segmentOrd) {
        return this.mapping.get(segmentOrd);
    }

    public boolean advanceExact(int target) throws IOException {
        return this.values.advanceExact(target);
    }

    public long nextOrd() throws IOException {
        long segmentOrd = this.values.nextOrd();
        if (segmentOrd == -1L) {
            return -1L;
        }
        return this.getGlobalOrd(segmentOrd);
    }

    public BytesRef lookupOrd(long globalOrd) throws IOException {
        long segmentOrd = this.ordinalMap.getFirstSegmentOrd(globalOrd);
        int readerIndex = this.ordinalMap.getFirstSegmentNumber(globalOrd);
        return this.bytesValues[readerIndex].lookupOrd(segmentOrd);
    }

    public int docID() {
        return this.values.docID();
    }

    public int nextDoc() throws IOException {
        return this.values.nextDoc();
    }

    public int advance(int target) throws IOException {
        return this.values.advance(target);
    }

    public long cost() {
        return this.values.cost();
    }
}

