/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.oozie;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.pentaho.big.data.kettle.plugins.job.AbstractJobEntry;
import org.pentaho.big.data.kettle.plugins.job.JobEntryMode;
import org.pentaho.big.data.kettle.plugins.job.JobEntryUtils;
import org.pentaho.big.data.kettle.plugins.job.PropertyEntry;
import org.pentaho.big.data.kettle.plugins.oozie.OozieJobExecutorConfig;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.hadoop.shim.api.HadoopClientServices;
import org.pentaho.hadoop.shim.api.HadoopClientServicesException;
import org.pentaho.hadoop.shim.api.cluster.ClusterInitializationException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.hadoop.shim.api.oozie.OozieJobInfo;
import org.pentaho.hadoop.shim.api.oozie.OozieServiceException;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;

@JobEntry(id="OozieJobExecutor", name="Oozie.JobExecutor.PluginName", description="Oozie.JobExecutor.PluginDescription", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", image="oozie-job-executor.svg", documentationUrl="http://wiki.pentaho.com/display/EAI/Oozie+Job+Executor", i18nPackageName="org.pentaho.di.job.entries.oozie", version="1")
public class OozieJobExecutorJobEntry
extends AbstractJobEntry<OozieJobExecutorConfig>
implements Cloneable,
JobEntryInterface {
    public static final String HTTP_ERROR_CODE_404 = "HTTP error code: 404";
    public static final String HTTP_ERROR_CODE_401 = "HTTP error code: 401";
    public static final String HTTP_ERROR_CODE_403 = "HTTP error code: 403";
    public static final String USER_NAME = "user.name";
    public static final String VALIDATION_MESSAGES_MISSING_CONFIGURATION = "ValidationMessages.Missing.Configuration";
    private final NamedClusterService namedClusterService;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private HadoopClientServices hadoopClientServices = null;

    public OozieJobExecutorJobEntry(NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester, NamedClusterServiceLocator namedClusterServiceLocator) {
        this.namedClusterService = namedClusterService;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
    }

    @VisibleForTesting
    OozieJobExecutorJobEntry() {
        this.namedClusterService = null;
        this.namedClusterServiceLocator = null;
        this.runtimeTestActionService = null;
        this.runtimeTester = null;
    }

    protected OozieJobExecutorConfig createJobConfig() {
        return new OozieJobExecutorConfig();
    }

    public List<String> getValidationWarnings(OozieJobExecutorConfig config, boolean checkOozieConnection) {
        ArrayList<String> messages = new ArrayList<String>();
        if (StringUtil.isEmpty((String)config.getJobEntryName())) {
            messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.JobName", (String[])new String[0]));
        }
        NamedCluster nc = null;
        try {
            nc = this.getNamedCluster(config);
        }
        catch (MetaStoreException e) {
            messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)VALIDATION_MESSAGES_MISSING_CONFIGURATION, (String[])new String[0]));
        }
        if (null == nc || nc.getName().equals("") || nc.getShimIdentifier().equals("")) {
            messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.NamedCluster", (String[])new String[]{config.getClusterName()}));
            return messages;
        }
        this.verifyOozieUrl(config, checkOozieConnection, messages, nc);
        this.checkOozieConnection(config, checkOozieConnection, messages);
        this.verifyJobConfiguration(config, checkOozieConnection, messages);
        boolean pollingIntervalValid = false;
        try {
            long pollingInterval = JobEntryUtils.asLong((String)config.getBlockingPollingInterval(), (VariableSpace)this.variables);
            pollingIntervalValid = pollingInterval > 0L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!pollingIntervalValid) {
            messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Invalid.PollingInterval", (String[])new String[0]));
        }
        return messages;
    }

    private void verifyJobConfiguration(OozieJobExecutorConfig config, boolean checkOozieConnection, List<String> messages) {
        if (config.getModeAsEnum() == JobEntryMode.QUICK_SETUP && StringUtil.isEmpty((String)config.getOozieWorkflowConfig())) {
            messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.Workflow.Properties", (String[])new String[0]));
        } else {
            try {
                Properties props = this.getProperties(config);
                if (checkOozieConnection && !this.hadoopClientServices.hasOozieAppPath(props)) {
                    messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.App.Path.Property.Missing", (String[])new String[0]));
                }
            }
            catch (KettleFileException e) {
                messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Workflow.Properties.FileNotFound", (String[])new String[0]));
            }
            catch (IOException e) {
                messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Workflow.Properties.ReadError", (String[])new String[0]));
            }
        }
    }

    private void checkOozieConnection(OozieJobExecutorConfig config, boolean checkOozieConnection, List<String> messages) {
        if (checkOozieConnection && !StringUtils.isEmpty((String)this.getEffectiveOozieUrl(config))) {
            try {
                this.hadoopClientServices = this.getHadoopClientServices(config);
                this.hadoopClientServices.getOozieProtocolUrl();
                this.hadoopClientServices.validateOozieWSVersion();
            }
            catch (HadoopClientServicesException e) {
                if (e.getErrorCode().equals(HTTP_ERROR_CODE_404) || e.getCause() != null && (e.getCause() instanceof MalformedURLException || e.getCause() instanceof ConnectException)) {
                    messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Invalid.Oozie.URL", (String[])new String[0]));
                }
                if (e.getErrorCode().equals(HTTP_ERROR_CODE_401) || e.getErrorCode().equals(HTTP_ERROR_CODE_403)) {
                    messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Unauthorized.Oozie.Access", (String[])new String[0]));
                }
                messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Incompatible.Oozie.Versions", (String[])new String[0]));
            }
        }
    }

    private void verifyOozieUrl(OozieJobExecutorConfig config, boolean checkOozieConnection, List<String> messages, NamedCluster nc) {
        if (StringUtils.isEmpty((String)this.getEffectiveOozieUrl(config))) {
            messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)VALIDATION_MESSAGES_MISSING_CONFIGURATION, (String[])new String[0]));
        } else {
            try {
                if (!checkOozieConnection) {
                    if (nc == null) {
                        messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)VALIDATION_MESSAGES_MISSING_CONFIGURATION, (String[])new String[0]));
                    } else if (StringUtils.isEmpty((String)nc.getOozieUrl())) {
                        messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.Oozie.URL", (String[])new String[0]));
                    }
                }
            }
            catch (Throwable t) {
                messages.add(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Missing.Oozie.URL", (String[])new String[0]));
            }
        }
    }

    private NamedCluster getNamedCluster(OozieJobExecutorConfig config) throws MetaStoreException {
        NamedCluster nc = null;
        if (!StringUtils.isEmpty((String)((OozieJobExecutorConfig)this.jobConfig).getClusterName()) && this.namedClusterService.contains(((OozieJobExecutorConfig)this.jobConfig).getClusterName(), this.metaStore)) {
            nc = this.namedClusterService.read(((OozieJobExecutorConfig)this.jobConfig).getClusterName(), this.metaStore);
        }
        if (nc == null) {
            nc = config.getNamedCluster();
        }
        if (nc == null && this.namedClusterService != null) {
            nc = this.namedClusterService.getClusterTemplate();
            nc.setOozieUrl(config.getOozieUrl());
        }
        return nc;
    }

    public List<String> getValidationWarnings(OozieJobExecutorConfig config) {
        return this.getValidationWarnings(config, true);
    }

    public Properties getPropertiesFromFile(OozieJobExecutorConfig config) throws IOException, KettleFileException {
        return OozieJobExecutorJobEntry.getPropertiesFromFile(config, this.getVariableSpace());
    }

    public static Properties getPropertiesFromFile(OozieJobExecutorConfig config, VariableSpace variableSpace) throws IOException, KettleFileException {
        InputStreamReader reader = new InputStreamReader(KettleVFS.getInputStream((String)variableSpace.environmentSubstitute(config.getOozieWorkflowConfig())));
        Properties jobProps = new Properties();
        jobProps.load(reader);
        return jobProps;
    }

    public Properties getProperties(OozieJobExecutorConfig config) throws KettleFileException, IOException {
        return OozieJobExecutorJobEntry.getProperties(config, this.getVariableSpace());
    }

    public static Properties getProperties(OozieJobExecutorConfig config, VariableSpace variableSpace) throws KettleFileException, IOException {
        Properties jobProps;
        if (config.getModeAsEnum() == JobEntryMode.ADVANCED_LIST && config.getWorkflowProperties() != null) {
            jobProps = new Properties();
            for (PropertyEntry propertyEntry : config.getWorkflowProperties()) {
                if (propertyEntry.getKey() == null) continue;
                String value = propertyEntry.getValue() == null ? "" : propertyEntry.getValue();
                jobProps.setProperty(propertyEntry.getKey(), variableSpace.environmentSubstitute(value));
            }
        } else {
            jobProps = OozieJobExecutorJobEntry.getPropertiesFromFile(config, variableSpace);
        }
        return jobProps;
    }

    protected Runnable getExecutionRunnable(final Result jobResult) {
        return new Runnable(){

            @Override
            public void run() {
                HadoopClientServices hadoopClientServices = OozieJobExecutorJobEntry.this.getHadoopClientServices();
                try {
                    hadoopClientServices.validateOozieWSVersion();
                }
                catch (HadoopClientServicesException e) {
                    OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                    if (e.getErrorCode().equals(OozieJobExecutorJobEntry.HTTP_ERROR_CODE_404) || e.getCause() != null && (e.getCause() instanceof MalformedURLException || e.getCause() instanceof ConnectException)) {
                        OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Invalid.Oozie.URL", (String[])new String[0]), e);
                    }
                    if (e.getErrorCode().equals(OozieJobExecutorJobEntry.HTTP_ERROR_CODE_401) || e.getErrorCode().equals(OozieJobExecutorJobEntry.HTTP_ERROR_CODE_403)) {
                        OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Unauthorized.Oozie.Access", (String[])new String[0]));
                    }
                    OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMessages.Incompatible.Oozie.Versions", (String[])new String[0]), e);
                }
                try {
                    Properties jobProps = OozieJobExecutorJobEntry.this.getProperties((OozieJobExecutorConfig)OozieJobExecutorJobEntry.this.jobConfig);
                    if (!jobProps.containsKey(OozieJobExecutorJobEntry.USER_NAME)) {
                        jobProps.setProperty(OozieJobExecutorJobEntry.USER_NAME, OozieJobExecutorJobEntry.this.getVariableSpace().environmentSubstitute("${user.name}"));
                    }
                    OozieJobInfo job = hadoopClientServices.runOozie(jobProps);
                    if (JobEntryUtils.asBoolean((String)((OozieJobExecutorConfig)OozieJobExecutorJobEntry.this.getJobConfig()).getBlockingExecution(), (VariableSpace)OozieJobExecutorJobEntry.this.variables)) {
                        while (job.isRunning()) {
                            long interval = JobEntryUtils.asLong((String)((OozieJobExecutorConfig)OozieJobExecutorJobEntry.this.jobConfig).getBlockingPollingInterval(), (VariableSpace)OozieJobExecutorJobEntry.this.variables);
                            Thread.sleep(interval);
                        }
                        String logDetail = job.getJobLog();
                        if (job.didSucceed()) {
                            jobResult.setResult(true);
                            OozieJobExecutorJobEntry.this.logDetailed(logDetail);
                        } else {
                            OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                            OozieJobExecutorJobEntry.this.logError(logDetail);
                        }
                    }
                }
                catch (KettleFileException e) {
                    OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                    OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.JobExecutor.ERROR.File.Resolution", (String[])new String[0]), e);
                }
                catch (IOException e) {
                    OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                    OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.JobExecutor.ERROR.Props.Loading", (String[])new String[0]), e);
                }
                catch (HadoopClientServicesException | OozieServiceException e) {
                    OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                    OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.JobExecutor.ERROR.OozieClient", (String[])new String[0]), e);
                }
                catch (InterruptedException e) {
                    OozieJobExecutorJobEntry.this.setJobResultFailed(jobResult);
                    OozieJobExecutorJobEntry.this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.JobExecutor.ERROR.Threading", (String[])new String[0]), e);
                }
            }
        };
    }

    protected void handleUncaughtThreadException(Thread t, Throwable e, Result jobResult) {
        this.logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.JobExecutor.ERROR.Generic", (String[])new String[0]), e);
        this.setJobResultFailed(jobResult);
    }

    @VisibleForTesting
    String getEffectiveOozieUrl(OozieJobExecutorConfig config) {
        String oozieUrl = config.getOozieUrl();
        try {
            NamedCluster nc = this.getNamedCluster(config);
            if (nc != null && !StringUtils.isEmpty((String)nc.getOozieUrl())) {
                oozieUrl = nc.getOozieUrl();
            }
        }
        catch (Throwable t) {
            this.logDebug(t.getMessage(), new Object[]{t});
        }
        return this.getVariableSpace().environmentSubstitute(oozieUrl);
    }

    public HadoopClientServices getHadoopClientServices() {
        return this.getHadoopClientServices((OozieJobExecutorConfig)this.jobConfig);
    }

    public HadoopClientServices getHadoopClientServices(OozieJobExecutorConfig config) {
        try {
            NamedCluster cluster = this.getNamedCluster(config).clone();
            cluster.setOozieUrl(this.getEffectiveOozieUrl(config));
            return (HadoopClientServices)this.namedClusterServiceLocator.getService(cluster, HadoopClientServices.class);
        }
        catch (ClusterInitializationException e) {
            this.logError("Cluster initialization failure on service load", e);
        }
        catch (NullPointerException | MetaStoreException e) {
            this.logError("Failed to read cluster from metastore", e);
        }
        return null;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }
}

