/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.java2d.Java2DCanvasProvider;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class BarcodeDrawable
implements ReportDrawable {
    private BarcodeGenerator generator;
    private String message;
    private BarcodeDimension barcodeDimension;
    private Font font;
    private Color backgroundColor;
    private Color foregroundColor;

    public BarcodeDrawable(BarcodeGenerator generator, String message) throws IllegalArgumentException {
        this.generator = generator;
        this.message = message;
        this.barcodeDimension = this.generator.calcDimensions(message);
    }

    public BarcodeGenerator getGenerator() {
        return this.generator;
    }

    protected BarcodeDimension getBarcodeDimension() {
        return this.barcodeDimension;
    }

    public void draw(Graphics2D g2d, Rectangle2D bounds) {
        double scale;
        double horzScale = bounds.getWidth() / this.getBarcodeDimension().getWidthPlusQuiet();
        double vertScale = bounds.getHeight() / this.getBarcodeDimension().getHeightPlusQuiet();
        double dx = 0.0;
        double dy = 0.0;
        if (horzScale < vertScale) {
            scale = horzScale;
            dy = (bounds.getHeight() / scale - this.getBarcodeDimension().getHeightPlusQuiet()) / 2.0;
        } else {
            scale = vertScale;
            dx = (bounds.getWidth() / scale - this.getBarcodeDimension().getWidthPlusQuiet()) / 2.0;
        }
        g2d.scale(scale, scale);
        g2d.translate(dx, dy);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (this.font != null) {
            g2d.setFont(this.font);
        }
        if (this.backgroundColor != null) {
            g2d.setColor(this.backgroundColor);
            g2d.fill(bounds);
        }
        if (this.foregroundColor != null) {
            g2d.setColor(this.foregroundColor);
        }
        Java2DCanvasProvider canvas = new Java2DCanvasProvider(g2d, 0);
        this.generator.generateBarcode((CanvasProvider)canvas, this.message);
    }

    public void setConfiguration(Configuration config) {
    }

    public void setStyleSheet(StyleSheet style) {
        if (style != null) {
            String fontName = (String)style.getStyleProperty(TextStyleKeys.FONT);
            int fontSize = style.getIntStyleProperty(TextStyleKeys.FONTSIZE, 0);
            boolean bold = style.getBooleanStyleProperty(TextStyleKeys.BOLD);
            boolean italics = style.getBooleanStyleProperty(TextStyleKeys.ITALIC);
            Color foregroundColor = (Color)style.getStyleProperty(ElementStyleKeys.PAINT);
            Color backgroundColor = (Color)style.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
            if (fontName != null && fontSize > 0) {
                int fontstyle = 0;
                if (bold) {
                    fontstyle |= 1;
                }
                if (italics) {
                    fontstyle |= 2;
                }
                this.font = new Font(fontName, fontstyle, fontSize);
            }
            if (foregroundColor != null) {
                this.foregroundColor = foregroundColor;
            }
            if (backgroundColor != null) {
                this.backgroundColor = backgroundColor;
            }
        }
    }

    public void setResourceBundleFactory(ResourceBundleFactory bundleFactory) {
    }

    public ImageMap getImageMap(Rectangle2D bounds) {
        return null;
    }
}

