/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.kitchen;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.pentaho.di.base.AbstractBaseCommandExecutor;
import org.pentaho.di.base.CommandExecutorCodes;
import org.pentaho.di.base.KettleConstants;
import org.pentaho.di.base.Params;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.util.FileUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.resource.ResourceUtil;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.metastore.api.IMetaStore;

public class KitchenCommandExecutor
extends AbstractBaseCommandExecutor {
    Future<KettleException> kettleInit;

    public KitchenCommandExecutor(Class<?> pkgClazz) {
        this(pkgClazz, (LogChannelInterface)new LogChannel((Object)"Kitchen"), null);
    }

    public KitchenCommandExecutor(Class<?> pkgClazz, LogChannelInterface log) {
        this(pkgClazz, log, null);
    }

    public KitchenCommandExecutor(Class<?> pkgClazz, LogChannelInterface log, Future<KettleException> kettleInit) {
        this.setPkgClazz(pkgClazz);
        this.setLog(log);
        this.setKettleInit(kettleInit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Params params) throws Throwable {
        Result launchFile;
        this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Log.Starting", (String[])new String[0]));
        Date start = Calendar.getInstance().getTime();
        this.logDebug("Kitchen.Log.AllocateNewJob");
        Job job = null;
        Repository repository = null;
        try {
            if (this.getMetaStore() == null) {
                this.setMetaStore(this.createDefaultMetastore());
            }
            if (!Utils.isEmpty((CharSequence)params.getRepoName()) || !Utils.isEmpty((CharSequence)params.getLocalFile())) {
                this.logDebug("Kitchen.Log.ParsingCommandLine");
                if (!Utils.isEmpty((CharSequence)params.getRepoName()) && !this.isEnabled(params.getBlockRepoConns())) {
                    RepositoryMeta repositoryMeta;
                    if (this.isEnabled(params.getTrustRepoUser())) {
                        System.setProperty("pentaho.repository.client.attemptTrust", "Y");
                    }
                    if ((repositoryMeta = this.loadRepositoryConnection(params.getRepoName(), "Kitchen.Log.LoadingRep", "Kitchen.Error.NoRepDefinied", "Kitchen.Log.FindingRep")) == null) {
                        System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.CanNotConnectRep", (String[])new String[0]));
                        return this.exitWithStatus(CommandExecutorCodes.Kitchen.COULD_NOT_LOAD_JOB.getCode());
                    }
                    this.logDebug("Kitchen.Log.CheckUserPass");
                    repository = this.establishRepositoryConnection(repositoryMeta, params.getRepoUsername(), params.getRepoPassword(), RepositoryOperation.EXECUTE_JOB);
                    if (this.isEnabled(params.getListRepoFiles()) || this.isEnabled(params.getListRepoDirs())) {
                        this.executeRepositoryBasedCommand(repository, params.getInputDir(), params.getListRepoFiles(), params.getListRepoDirs());
                        return this.exitWithStatus(CommandExecutorCodes.Kitchen.SUCCESS.getCode());
                    }
                    job = this.loadJobFromRepository(repository, params.getInputDir(), params.getInputFile());
                }
                if (job == null) {
                    job = this.loadJobFromFilesystem(params.getLocalInitialDir(), params.getLocalFile(), (Serializable)((Object)params.getBase64Zip()));
                }
            } else if (this.isEnabled(params.getListRepos())) {
                this.printRepositories(this.loadRepositoryInfo("Kitchen.Log.ListRep", "Kitchen.Error.NoRepDefinied"));
            }
        }
        catch (KettleException e) {
            job = null;
            if (repository != null) {
                repository.disconnect();
            }
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.StopProcess", (String[])new String[]{e.getMessage()}));
        }
        if (job == null) {
            if (!(this.isEnabled(params.getListRepoFiles()) || this.isEnabled(params.getListRepoDirs()) || this.isEnabled(params.getListRepos()))) {
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.canNotLoadJob", (String[])new String[0]));
            }
            return this.exitWithStatus(CommandExecutorCodes.Kitchen.COULD_NOT_LOAD_JOB.getCode());
        }
        if (!Utils.isEmpty((CharSequence)params.getExportRepo())) {
            try {
                TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(params.getExportRepo(), job.getJobMeta(), job, repository, (IMetaStore)this.getMetaStore());
                launchFile = topLevelResource.getResourceName();
                String message = ResourceUtil.getExplanation(params.getExportRepo(), (String)launchFile, job.getJobMeta());
                System.out.println();
                System.out.println(message);
                params.setListFileParams("Y");
            }
            catch (Exception e) {
                System.out.println(Const.getStackTracker((Throwable)e));
                return this.exitWithStatus(CommandExecutorCodes.Kitchen.UNEXPECTED_ERROR.getCode());
            }
        }
        try {
            Result jobParams;
            job.setArguments(this.convert(KettleConstants.toJobMap(params)));
            job.initializeVariablesFrom(null);
            job.setLogLevel(this.getLog().getLogLevel());
            job.getJobMeta().setInternalKettleVariables(job);
            job.setRepository(repository);
            job.getJobMeta().setRepository(repository);
            job.getJobMeta().setMetaStore((IMetaStore)this.getMetaStore());
            for (String param : jobParams = job.getJobMeta().listParameters()) {
                try {
                    String value = params.getNamedParams().getParameterValue(param);
                    if (value == null) continue;
                    job.getJobMeta().setParameterValue(param, value);
                }
                catch (UnknownParamException value) {
                    // empty catch block
                }
            }
            job.copyParametersFrom(job.getJobMeta());
            job.activateParameters();
            for (String optionName : params.getCustomNamedParams().listParameters()) {
                try {
                    String optionValue = params.getCustomNamedParams().getParameterValue(optionName);
                    if (optionName == null || optionValue == null) continue;
                    job.getExtensionDataMap().put(optionName, optionValue);
                }
                catch (UnknownParamException unknownParamException) {
                    // empty catch block
                }
            }
            if (this.isEnabled(params.getListFileParams())) {
                this.printJobParameters(job);
                launchFile = this.exitWithStatus(CommandExecutorCodes.Kitchen.COULD_NOT_LOAD_JOB.getCode());
                return launchFile;
            }
            job.start();
            job.waitUntilFinished();
            this.setResult(job.getResult());
        }
        finally {
            if (repository != null) {
                repository.disconnect();
            }
            if (this.isEnabled(params.getTrustRepoUser())) {
                System.clearProperty("pentaho.repository.client.attemptTrust");
            }
        }
        this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Log.Finished", (String[])new String[0]));
        int returnCode = this.getReturnCode();
        Date stop = Calendar.getInstance().getTime();
        this.calculateAndPrintElapsedTime(start, stop, "Kitchen.Log.StartStop", "Kitchen.Log.ProcessEndAfter", "Kitchen.Log.ProcessEndAfterLong", "Kitchen.Log.ProcessEndAfterLonger", "Kitchen.Log.ProcessEndAfterLongest");
        this.getResult().setElapsedTimeMillis(stop.getTime() - start.getTime());
        return this.exitWithStatus(returnCode);
    }

    public int printVersion() {
        this.printVersion("Kitchen.Log.KettleVersion");
        return CommandExecutorCodes.Kitchen.KETTLE_VERSION_PRINT.getCode();
    }

    protected void executeRepositoryBasedCommand(Repository repository, String dirName, String listJobs, String listDirs) throws Exception {
        RepositoryDirectoryInterface directory = this.loadRepositoryDirectory(repository, dirName, "Kitchen.Error.NoRepProvided", "Kitchen.Log.Alocate&ConnectRep", "Kitchen.Error.CanNotFindSuppliedDirectory");
        if (directory == null) {
            return;
        }
        if (this.isEnabled(listJobs)) {
            this.printRepositoryStoredJobs(repository, directory);
        } else if (this.isEnabled(listDirs)) {
            this.printRepositoryDirectories(repository, directory);
        }
    }

    public Job loadJobFromRepository(Repository repository, String dirName, String jobName) throws Exception {
        if (Utils.isEmpty((CharSequence)jobName)) {
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.canNotLoadJob", (String[])new String[0]));
            return null;
        }
        RepositoryDirectoryInterface directory = this.loadRepositoryDirectory(repository, dirName, "Kitchen.Error.NoRepProvided", "Kitchen.Log.Alocate&ConnectRep", "Kitchen.Error.CanNotFindSuppliedDirectory");
        if (directory == null) {
            return null;
        }
        if (repository.getMetaStore() != null && this.getMetaStore() != null) {
            this.getMetaStore().addMetaStore(repository.getMetaStore());
        }
        this.logDebug("Kitchen.Log.LoadingJobInfo");
        this.blockAndThrow(this.getKettleInit());
        JobMeta jobMeta = repository.loadJob(jobName, directory, null, null);
        this.logDebug("Kitchen.Log.AllocateJob");
        return new Job(repository, jobMeta);
    }

    public Job loadJobFromFilesystem(String initialDir, String filename, Serializable base64Zip) throws Exception {
        File zip;
        if (Utils.isEmpty((CharSequence)filename)) {
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.canNotLoadJob", (String[])new String[0]));
            return null;
        }
        if (base64Zip != null && (zip = this.decodeBase64ToZipFile(base64Zip, true)) != null) {
            filename = "zip:file:" + File.separator + File.separator + zip.getAbsolutePath() + "!" + filename;
        }
        this.blockAndThrow(this.getKettleInit());
        String fileName = filename;
        if (!KettleVFS.startsWithScheme((String)fileName) && !FileUtil.isFullyQualified(fileName)) {
            fileName = initialDir + fileName;
        }
        JobMeta jobMeta = new JobMeta(fileName, null, null);
        return new Job(null, jobMeta);
    }

    protected void printJobParameters(Job job) throws UnknownParamException {
        if (job != null && job.listParameters() != null) {
            for (String pName : job.listParameters()) {
                this.printParameter(pName, job.getParameterValue(pName), job.getParameterDefault(pName), job.getParameterDescription(pName));
            }
        }
    }

    protected void printRepositoryStoredJobs(Repository repository, RepositoryDirectoryInterface directory) throws KettleException {
        this.logDebug("Kitchen.Log.GettingLostJobsInDirectory", "" + directory);
        String[] jobnames = repository.getJobNames(directory.getObjectId(), false);
        for (int i = 0; i < jobnames.length; ++i) {
            System.out.println(jobnames[i]);
        }
    }

    protected void printRepositories(RepositoriesMeta repositoriesMeta) {
        if (repositoriesMeta != null) {
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Log.ListRep", (String[])new String[0]));
            for (int i = 0; i < repositoriesMeta.nrRepositories(); ++i) {
                RepositoryMeta rinfo = repositoriesMeta.getRepository(i);
                System.out.println("#" + (i + 1) + " : " + rinfo.getName() + " [" + rinfo.getDescription() + "]  id=" + rinfo.getId());
            }
        }
    }

    private <T extends Throwable> void blockAndThrow(Future<T> future) throws T {
        if (future == null) {
            return;
        }
        try {
            Throwable e = (Throwable)future.get();
            if (e != null) {
                throw e;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Future<KettleException> getKettleInit() {
        return this.kettleInit;
    }

    public void setKettleInit(Future<KettleException> kettleInit) {
        this.kettleInit = kettleInit;
    }

    @VisibleForTesting
    int getReturnCode() {
        int successCode = CommandExecutorCodes.Kitchen.SUCCESS.getCode();
        if (this.getResult().getNrErrors() != 0L) {
            this.getLog().logError(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.FinishedWithErrors", (String[])new String[0]));
            return CommandExecutorCodes.Kitchen.ERRORS_DURING_PROCESSING.getCode();
        }
        return this.getResult().getResult() ? successCode : CommandExecutorCodes.Kitchen.ERRORS_DURING_PROCESSING.getCode();
    }
}

