/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceExportInterface;
import org.pentaho.di.resource.SequenceResourceNaming;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metastore.api.IMetaStore;

public class ResourceUtil {
    private static Class<?> PKG = ResourceUtil.class;

    public static final TopLevelResource serializeResourceExportInterface(String zipFilename, ResourceExportInterface resourceExportInterface, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleException {
        return ResourceUtil.serializeResourceExportInterface(zipFilename, resourceExportInterface, space, repository, metaStore, null, null);
    }

    public static final TopLevelResource serializeResourceExportInterface(String zipFilename, ResourceExportInterface resourceExportInterface, VariableSpace space, Repository repository, IMetaStore metaStore, String injectXML, String injectFilename) throws KettleException {
        ZipOutputStream out;
        block12: {
            TopLevelResource topLevelResource;
            block13: {
                SequenceResourceNaming namingInterface;
                String topLevelResource2;
                out = null;
                HashMap<String, ResourceDefinition> definitions = new HashMap<String, ResourceDefinition>();
                if (injectXML != null) {
                    ResourceDefinition resourceDefinition = new ResourceDefinition(injectFilename, injectXML);
                    definitions.put(injectFilename, resourceDefinition);
                }
                if ((topLevelResource2 = resourceExportInterface.exportResources(space, definitions, namingInterface = new SequenceResourceNaming(), repository, metaStore)) == null || definitions.isEmpty()) break block12;
                FileObject fileObject = KettleVFS.getFileObject((String)zipFilename, (VariableSpace)space);
                out = new ZipOutputStream(KettleVFS.getOutputStream((FileObject)fileObject, (boolean)false));
                for (Map.Entry entry : definitions.entrySet()) {
                    String filename = (String)entry.getKey();
                    ResourceDefinition resourceDefinition = (ResourceDefinition)entry.getValue();
                    ZipEntry zipEntry = new ZipEntry(resourceDefinition.getFilename());
                    String comment = BaseMessages.getString(PKG, (String)"ResourceUtil.SerializeResourceExportInterface.ZipEntryComment.OriginatingFile", (String[])new String[]{filename, Const.NVL((String)resourceDefinition.getOrigin(), (String)"-")});
                    zipEntry.setComment(comment);
                    out.putNextEntry(zipEntry);
                    out.write(resourceDefinition.getContent().getBytes());
                    out.closeEntry();
                }
                String zipURL = fileObject.getName().toString();
                topLevelResource = new TopLevelResource(topLevelResource2, zipURL, "zip:" + zipURL + "!" + topLevelResource2);
                if (out == null) break block13;
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ResourceUtil.Exception.ErrorClosingZipStream", (String[])new String[]{zipFilename}));
                }
            }
            return topLevelResource;
        }
        try {
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ResourceUtil.Exception.NoResourcesFoundToExport", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ResourceUtil.Exception.ErrorSerializingExportInterface", (String[])new String[]{resourceExportInterface.toString()}), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ResourceUtil.Exception.ErrorClosingZipStream", (String[])new String[]{zipFilename}));
                }
            }
            throw throwable;
        }
    }

    public static String getExplanation(String zipFilename, String launchFile, ResourceExportInterface resourceExportInterface) {
        String commandString = "";
        commandString = Const.isWindows() ? (resourceExportInterface instanceof TransMeta ? commandString + "Pan.bat /file:\"" : commandString + "Kitchen.bat /file:\"") : (resourceExportInterface instanceof TransMeta ? commandString + "sh pan.sh -file='" : commandString + "sh kitchen.sh -file='");
        commandString = commandString + launchFile;
        commandString = Const.isWindows() ? commandString + "\"" : commandString + "'";
        String message = BaseMessages.getString(PKG, (String)"ResourceUtil.ExportResourcesExplanation", (String[])new String[]{zipFilename, commandString, launchFile, Const.CR});
        return message;
    }
}

