/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.BlockingBatchingRowSet;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.ExecutorInterface;
import org.pentaho.di.core.ExtensionDataInterface;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.SingleRowRowSet;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.DatabaseTransactionListener;
import org.pentaho.di.core.database.map.DatabaseConnectionMap;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleTransException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.ChannelLogTable;
import org.pentaho.di.core.logging.HasLogChannelInterface;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.LoggingHierarchy;
import org.pentaho.di.core.logging.LoggingMetric;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.logging.Metrics;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.core.logging.MetricsLogTable;
import org.pentaho.di.core.logging.MetricsRegistry;
import org.pentaho.di.core.logging.PerformanceLogTable;
import org.pentaho.di.core.logging.StepLogTable;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.core.metrics.MetricsDuration;
import org.pentaho.di.core.metrics.MetricsSnapshotInterface;
import org.pentaho.di.core.metrics.MetricsUtil;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.ConnectionUtil;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.DelegationListener;
import org.pentaho.di.job.Job;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.resource.ResourceUtil;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.TransAdapter;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransDependency;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransStoppedListener;
import org.pentaho.di.trans.cluster.TransSplitter;
import org.pentaho.di.trans.performance.StepPerformanceSnapShot;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.RunThread;
import org.pentaho.di.trans.step.StepAdapter;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInitThread;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.WebResult;
import org.pentaho.metastore.api.IMetaStore;

public class Trans
implements VariableSpace,
NamedParams,
HasLogChannelInterface,
LoggingObjectInterface,
ExecutorInterface,
ExtensionDataInterface {
    private static Class<?> PKG = Trans.class;
    public static final String REPLAY_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    protected LogChannelInterface log;
    protected LogLevel logLevel = LogLevel.BASIC;
    protected String containerObjectId;
    protected int logCommitSize = 10;
    protected TransMeta transMeta;
    protected Repository repository;
    protected IMetaStore metaStore;
    private Job parentJob;
    private Trans parentTrans;
    private LoggingObjectInterface parent;
    private String mappingStepName;
    private boolean monitored;
    private boolean preview;
    private Date startDate;
    private Date endDate;
    private Date currentDate;
    private Date logDate;
    private Date depDate;
    private Date jobStartDate;
    private Date jobEndDate;
    private long batchId;
    private long passedBatchId;
    private VariableSpace variables = new Variables();
    public List<RowSet> rowsets;
    private List<StepMetaDataCombi> steps;
    private boolean resultRowsSet;
    public int class_nr;
    private Date replayDate;
    public static final int TYPE_DISP_1_1 = 1;
    public static final int TYPE_DISP_1_N = 2;
    public static final int TYPE_DISP_N_1 = 3;
    public static final int TYPE_DISP_N_N = 4;
    public static final int TYPE_DISP_N_M = 5;
    public static final String STRING_FINISHED = "Finished";
    public static final String STRING_FINISHED_WITH_ERRORS = "Finished (with errors)";
    public static final String STRING_RUNNING = "Running";
    public static final String STRING_PAUSED = "Paused";
    public static final String STRING_PREPARING = "Preparing executing";
    public static final String STRING_INITIALIZING = "Initializing";
    public static final String STRING_WAITING = "Waiting";
    public static final String STRING_STOPPED = "Stopped";
    public static final String STRING_STOPPED_WITH_ERRORS = "Stopped (with errors)";
    public static final String STRING_HALTING = "Halting";
    public static final String CONFIGURATION_IN_EXPORT_FILENAME = "__job_execution_configuration__.xml";
    private boolean safeModeEnabled;
    @Deprecated
    private String threadName;
    private String transactionId;
    private AtomicInteger status;
    private AtomicInteger errors;
    private boolean readyToStart;
    private Map<String, List<StepPerformanceSnapShot>> stepPerformanceSnapShots;
    private Timer stepPerformanceSnapShotTimer;
    private List<TransListener> transListeners;
    private List<TransStoppedListener> transStoppedListeners;
    private List<DelegationListener> delegationListeners;
    private int nrOfFinishedSteps;
    private int nrOfActiveSteps;
    private NamedParams namedParams = new NamedParamsDefault();
    private SocketRepository socketRepository;
    private Database transLogTableDatabaseConnection;
    private AtomicInteger stepPerformanceSnapshotSeqNr;
    private int lastWrittenStepPerformanceSequenceNr = 0;
    private int lastStepPerformanceSnapshotSeqNrAdded;
    private Map<String, Trans> activeSubtransformations;
    private Map<String, Job> activeSubjobs;
    private int stepPerformanceSnapshotSizeLimit;
    private PrintWriter servletPrintWriter;
    private ArrayBlockingQueue<Object> transFinishedBlockingQueue;
    private String executingServer;
    private String executingUser;
    private Result previousResult;
    protected List<RowMetaAndData> resultRows;
    protected List<ResultFile> resultFiles;
    protected String[] arguments;
    protected Hashtable<String, Counter> counters;
    private HttpServletResponse servletResponse;
    private HttpServletRequest servletRequest;
    private Map<String, Object> extensionDataMap;
    private ExecutorService heartbeat = null;
    private boolean executingClustered;

    public Trans() {
        this.status = new AtomicInteger();
        this.transListeners = Collections.synchronizedList(new ArrayList());
        this.transStoppedListeners = Collections.synchronizedList(new ArrayList());
        this.delegationListeners = new ArrayList<DelegationListener>();
        this.threadName = this.transactionId = this.calculateTransactionId();
        this.errors = new AtomicInteger(0);
        this.stepPerformanceSnapshotSeqNr = new AtomicInteger(0);
        this.activeSubtransformations = new ConcurrentHashMap<String, Trans>();
        this.activeSubjobs = new HashMap<String, Job>();
        this.resultRows = new ArrayList<RowMetaAndData>();
        this.resultFiles = new ArrayList<ResultFile>();
        this.counters = new Hashtable();
        this.extensionDataMap = new HashMap<String, Object>();
    }

    public Trans(TransMeta transMeta) {
        this(transMeta, null);
    }

    public Trans(TransMeta transMeta, LoggingObjectInterface parent) {
        this();
        this.transMeta = transMeta;
        this.containerObjectId = transMeta.getContainerObjectId();
        this.setParent(parent);
        this.initializeVariablesFrom(transMeta);
        this.copyParametersFrom(transMeta);
        transMeta.activateParameters();
        this.threadName = this.transactionId = this.calculateTransactionId();
    }

    public void setParent(LoggingObjectInterface parent) {
        this.parent = parent;
        this.log = new LogChannel((Object)this, parent);
        this.logLevel = this.log.getLogLevel();
        if (this.containerObjectId == null) {
            this.containerObjectId = this.log.getContainerObjectId();
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.TransformationIsPreloaded", (String[])new String[0]));
        }
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"Trans.Log.NumberOfStepsToRun", (String[])new String[]{String.valueOf(this.transMeta.nrSteps()), String.valueOf(this.transMeta.nrTransHops())}));
        }
    }

    private void setDefaultLogCommitSize() {
        String propLogCommitSize = this.getVariable("pentaho.log.commit.size");
        if (propLogCommitSize != null) {
            try {
                this.logCommitSize = Integer.parseInt(propLogCommitSize);
            }
            catch (Exception ignored) {
                this.logCommitSize = 10;
            }
        }
    }

    @Override
    public LogChannelInterface getLogChannel() {
        return this.log;
    }

    public void setLog(LogChannelInterface log) {
        this.log = log;
    }

    public String getName() {
        if (this.transMeta == null) {
            return null;
        }
        return this.transMeta.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <Parent extends VariableSpace & NamedParams> Trans(Parent parent, Repository rep, String name, String dirname, String filename) throws KettleException {
        this();
        try {
            if (rep != null) {
                RepositoryDirectoryInterface repdir = rep.findDirectory(dirname);
                if (repdir == null) throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Exception.UnableToLoadTransformation", (String[])new String[]{name, dirname}));
                this.transMeta = rep.loadTransformation(name, repdir, null, false, null);
            } else {
                this.transMeta = new TransMeta(filename, false);
            }
            this.log = LogChannel.GENERAL;
            this.transMeta.initializeVariablesFrom(parent);
            this.initializeVariablesFrom(parent);
            this.copyParametersFrom(parent);
            this.activateParameters();
            this.setDefaultLogCommitSize();
            this.threadName = this.transactionId = this.calculateTransactionId();
            return;
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Exception.UnableToOpenTransformation", (String[])new String[]{name}), (Throwable)e);
        }
    }

    public void execute(String[] arguments) throws KettleException {
        this.prepareExecution(arguments);
        this.startThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareExecution(String[] arguments) throws KettleException {
        int i;
        int i2;
        Object combi;
        int i3;
        this.setPreparing(true);
        this.startDate = null;
        this.setRunning(false);
        this.log.snap((MetricsInterface)Metrics.METRIC_TRANSFORMATION_EXECUTION_START, new long[0]);
        this.log.snap((MetricsInterface)Metrics.METRIC_TRANSFORMATION_INIT_START, new long[0]);
        ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.TransformationPrepareExecution.id, (Object)this);
        this.transMeta.disposeEmbeddedMetastoreProvider();
        if (this.transMeta.getMetastoreLocatorOsgi() != null) {
            this.transMeta.setEmbeddedMetastoreProviderKey(this.transMeta.getMetastoreLocatorOsgi().setEmbeddedMetastore((IMetaStore)this.transMeta.getEmbeddedMetaStore()));
        }
        this.checkCompatibility();
        if (arguments != null) {
            this.setArguments(arguments);
        }
        this.activateParameters();
        this.transMeta.activateParameters();
        ConnectionUtil.init(this.transMeta);
        if (this.transMeta.getName() == null) {
            if (this.transMeta.getFilename() != null) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"Trans.Log.DispacthingStartedForFilename", (String[])new String[]{this.transMeta.getFilename()}));
            }
        } else {
            this.log.logBasic(BaseMessages.getString(PKG, (String)"Trans.Log.DispacthingStartedForTransformation", (String[])new String[]{this.transMeta.getName()}));
        }
        if (this.getArguments() != null && this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.NumberOfArgumentsDetected", (String[])new String[]{String.valueOf(this.getArguments().length)}));
        }
        if (this.isSafeModeEnabled() && this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.SafeModeIsEnabled", (String[])new String[]{this.transMeta.getName()}));
        }
        if (this.getReplayDate() != null) {
            SimpleDateFormat df = new SimpleDateFormat(REPLAY_DATE_FORMAT);
            this.log.logBasic(BaseMessages.getString(PKG, (String)"Trans.Log.ThisIsAReplayTransformation", (String[])new String[0]) + df.format(this.getReplayDate()));
        } else if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.ThisIsNotAReplayTransformation", (String[])new String[0]));
        }
        if (this.servletPrintWriter == null) {
            String encoding = System.getProperty("KETTLE_DEFAULT_SERVLET_ENCODING", null);
            if (encoding == null) {
                this.servletPrintWriter = new PrintWriter(new OutputStreamWriter(System.out));
            } else {
                try {
                    this.servletPrintWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding));
                }
                catch (UnsupportedEncodingException ex) {
                    this.servletPrintWriter = new PrintWriter(new OutputStreamWriter(System.out));
                }
            }
        }
        this.steps = new ArrayList<StepMetaDataCombi>();
        this.rowsets = new ArrayList<RowSet>();
        List<StepMeta> hopsteps = this.transMeta.getTransHopSteps(false);
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.FoundDefferentSteps", (String[])new String[]{String.valueOf(hopsteps.size())}));
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.AllocatingRowsets", (String[])new String[0]));
        }
        for (i3 = 0; i3 < hopsteps.size(); ++i3) {
            StepMeta thisStep = hopsteps.get(i3);
            if (thisStep.isMapping()) continue;
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.AllocateingRowsetsForStep", (String[])new String[]{String.valueOf(i3), thisStep.getName()}));
            }
            List<StepMeta> nextSteps = this.transMeta.findNextSteps(thisStep);
            int nrTargets = nextSteps.size();
            for (int n = 0; n < nrTargets; ++n) {
                int nrCopies;
                int dispatchType;
                StepMeta nextStep = nextSteps.get(n);
                if (nextStep.isMapping()) continue;
                int thisCopies = thisStep.getCopies();
                if (thisCopies < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Log.StepCopiesNotCorrectlyDefined", (String[])new String[]{thisStep.getName()}));
                }
                int nextCopies = nextStep.getCopies();
                boolean repartitioning = thisStep.isPartitioned() ? !thisStep.getStepPartitioningMeta().equals(nextStep.getStepPartitioningMeta()) : nextStep.isPartitioned();
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.copiesInfo", (String[])new String[]{String.valueOf(thisCopies), String.valueOf(nextCopies)}));
                }
                if (thisCopies == 1 && nextCopies == 1) {
                    dispatchType = 1;
                    nrCopies = 1;
                } else if (thisCopies == 1 && nextCopies > 1) {
                    dispatchType = 2;
                    nrCopies = nextCopies;
                } else if (thisCopies > 1 && nextCopies == 1) {
                    dispatchType = 3;
                    nrCopies = thisCopies;
                } else if (thisCopies == nextCopies && !repartitioning) {
                    dispatchType = 4;
                    nrCopies = nextCopies;
                } else {
                    dispatchType = 5;
                    nrCopies = nextCopies;
                }
                if (dispatchType != 5) {
                    for (int c = 0; c < nrCopies; ++c) {
                        SingleRowRowSet rowSet;
                        switch (this.transMeta.getTransformationType()) {
                            case Normal: {
                                Boolean batchingRowSet = ValueMetaString.convertStringToBoolean((String)System.getProperty("KETTLE_BATCHING_ROWSET"));
                                if (batchingRowSet != null && batchingRowSet.booleanValue()) {
                                    rowSet = new BlockingBatchingRowSet(this.transMeta.getSizeRowset());
                                    break;
                                }
                                rowSet = new BlockingRowSet(this.transMeta.getSizeRowset());
                                break;
                            }
                            case SerialSingleThreaded: {
                                rowSet = new SingleRowRowSet();
                                break;
                            }
                            case SingleThreaded: {
                                rowSet = new QueueRowSet();
                                break;
                            }
                            default: {
                                throw new KettleException("Unhandled transformation type: " + (Object)((Object)this.transMeta.getTransformationType()));
                            }
                        }
                        switch (dispatchType) {
                            case 1: {
                                rowSet.setThreadNameFromToCopy(thisStep.getName(), 0, nextStep.getName(), 0);
                                break;
                            }
                            case 2: {
                                rowSet.setThreadNameFromToCopy(thisStep.getName(), 0, nextStep.getName(), c);
                                break;
                            }
                            case 3: {
                                rowSet.setThreadNameFromToCopy(thisStep.getName(), c, nextStep.getName(), 0);
                                break;
                            }
                            case 4: {
                                rowSet.setThreadNameFromToCopy(thisStep.getName(), c, nextStep.getName(), c);
                                break;
                            }
                        }
                        this.rowsets.add((RowSet)rowSet);
                        if (!this.log.isDetailed()) continue;
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.TransformationAllocatedNewRowset", (String[])new String[]{rowSet.toString()}));
                    }
                    continue;
                }
                for (int s = 0; s < thisCopies; ++s) {
                    for (int t = 0; t < nextCopies; ++t) {
                        BlockingRowSet rowSet = new BlockingRowSet(this.transMeta.getSizeRowset());
                        rowSet.setThreadNameFromToCopy(thisStep.getName(), s, nextStep.getName(), t);
                        this.rowsets.add((RowSet)rowSet);
                        if (!this.log.isDetailed()) continue;
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.TransformationAllocatedNewRowset", (String[])new String[]{rowSet.toString()}));
                    }
                }
            }
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.AllocatedRowsets", (String[])new String[]{String.valueOf(this.rowsets.size()), String.valueOf(i3), thisStep.getName()}) + " ");
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.AllocatingStepsAndStepData", (String[])new String[0]));
        }
        for (i3 = 0; i3 < hopsteps.size(); ++i3) {
            StepMeta stepMeta = hopsteps.get(i3);
            String stepid = stepMeta.getStepID();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.TransformationIsToAllocateStep", (String[])new String[]{stepMeta.getName(), stepid}));
            }
            int nrCopies = stepMeta.getCopies();
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"Trans.Log.StepHasNumberRowCopies", (String[])new String[]{String.valueOf(nrCopies)}));
            }
            for (int c = 0; c < nrCopies; ++c) {
                List<String> partitionIDs;
                StepDataInterface data;
                if (this.hasStepStarted(stepMeta.getName(), c)) continue;
                StepMetaDataCombi combi2 = new StepMetaDataCombi();
                combi2.stepname = stepMeta.getName();
                combi2.copy = c;
                combi2.stepMeta = stepMeta;
                combi2.meta = stepMeta.getStepMetaInterface();
                combi2.data = data = combi2.meta.getStepData();
                StepInterface step = combi2.meta.getStep(stepMeta, data, c, this.transMeta, this);
                step.initializeVariablesFrom(this);
                step.setUsingThreadPriorityManagment(this.transMeta.isUsingThreadPriorityManagment());
                step.setRepository(this.repository);
                step.setMetaStore(this.metaStore);
                if (stepMeta.isPartitioned() && (partitionIDs = stepMeta.getStepPartitioningMeta().getPartitionSchema().getPartitionIDs()) != null && !partitionIDs.isEmpty()) {
                    step.setPartitionID(partitionIDs.get(c));
                }
                combi2.step = step;
                if (combi2.step instanceof LoggingObjectInterface) {
                    LogChannelInterface logChannel = combi2.step.getLogChannel();
                    logChannel.setLogLevel(this.logLevel);
                    logChannel.setGatheringMetrics(this.log.isGatheringMetrics());
                }
                this.steps.add(combi2);
                if (!this.log.isDetailed()) continue;
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.TransformationHasAllocatedANewStep", (String[])new String[]{stepMeta.getName(), String.valueOf(c)}));
            }
        }
        for (int s = 0; s < this.steps.size(); ++s) {
            combi = this.steps.get(s);
            if (!((StepMetaDataCombi)combi).stepMeta.isDoingErrorHandling()) continue;
            ((StepMetaDataCombi)combi).step.identifyErrorOutput();
        }
        ExtensionDataInterface syncObject = this;
        if (this.parentJob != null) {
            syncObject = this.parentJob;
        }
        if (this.parentTrans != null) {
            syncObject = this.parentTrans;
        }
        combi = syncObject;
        synchronized (combi) {
            this.calculateBatchIdAndDateRange();
            this.beginProcessing();
        }
        for (int i4 = 0; i4 < this.steps.size(); ++i4) {
            StepPartitioningMeta targetStepPartitioningMeta;
            StepMetaDataCombi sid = this.steps.get(i4);
            StepMeta stepMeta = sid.stepMeta;
            StepInterface baseStep = sid.step;
            baseStep.setPartitioned(stepMeta.isPartitioned());
            boolean isThisPartitioned = stepMeta.isPartitioned();
            PartitionSchema thisPartitionSchema = null;
            if (isThisPartitioned) {
                thisPartitionSchema = stepMeta.getStepPartitioningMeta().getPartitionSchema();
            }
            boolean isNextPartitioned = false;
            StepPartitioningMeta nextStepPartitioningMeta = null;
            PartitionSchema nextPartitionSchema = null;
            List<StepMeta> nextSteps = this.transMeta.findNextSteps(stepMeta);
            int nrNext = nextSteps.size();
            for (int p = 0; p < nrNext; ++p) {
                StepMeta nextStep = nextSteps.get(p);
                if (!nextStep.isPartitioned()) continue;
                isNextPartitioned = true;
                nextStepPartitioningMeta = nextStep.getStepPartitioningMeta();
                nextPartitionSchema = nextStepPartitioningMeta.getPartitionSchema();
            }
            baseStep.setRepartitioning(0);
            if (!isThisPartitioned && isNextPartitioned || isThisPartitioned && isNextPartitioned && !thisPartitionSchema.equals(nextPartitionSchema)) {
                baseStep.setRepartitioning(nextStepPartitioningMeta.getMethodType());
            }
            if ((targetStepPartitioningMeta = baseStep.getStepMeta().getTargetStepPartitioningMeta()) == null) continue;
            baseStep.setRepartitioning(targetStepPartitioningMeta.getMethodType());
        }
        this.setPreparing(false);
        this.setInitializing(true);
        if (this.isMonitored() && this.steps.size() < 150) {
            this.doTopologySortOfSteps();
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.InitialisingSteps", (String[])new String[]{String.valueOf(this.steps.size())}));
        }
        StepInitThread[] initThreads = new StepInitThread[this.steps.size()];
        Thread[] threads = new Thread[this.steps.size()];
        for (i2 = 0; i2 < this.steps.size(); ++i2) {
            StepMetaDataCombi sid = this.steps.get(i2);
            initThreads[i2] = new StepInitThread(sid, this.log);
            threads[i2] = new Thread(initThreads[i2]);
            threads[i2].setName("init of " + sid.stepname + "." + sid.copy + " (" + threads[i2].getName() + ")");
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.StepBeforeInitialize.id, (Object)initThreads[i2]);
            threads[i2].start();
        }
        for (i2 = 0; i2 < threads.length; ++i2) {
            try {
                threads[i2].join();
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.StepAfterInitialize.id, (Object)initThreads[i2]);
                continue;
            }
            catch (Exception ex) {
                this.log.logError("Error with init thread: " + ex.getMessage(), new Object[]{ex.getMessage()});
                this.log.logError(Const.getStackTracker((Throwable)ex));
            }
        }
        this.setInitializing(false);
        boolean ok = true;
        for (i = 0; i < initThreads.length; ++i) {
            StepMetaDataCombi combi3 = initThreads[i].getCombi();
            if (!initThreads[i].isOk()) {
                this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Log.StepFailedToInit", (String[])new String[]{combi3.stepname + "." + combi3.copy}));
                combi3.data.setStatus(BaseStepData.StepExecutionStatus.STATUS_STOPPED);
                ok = false;
                continue;
            }
            combi3.data.setStatus(BaseStepData.StepExecutionStatus.STATUS_IDLE);
            if (!this.log.isDetailed()) continue;
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.StepInitialized", (String[])new String[]{combi3.stepname + "." + combi3.copy}));
        }
        if (!ok) {
            for (i = 0; i < initThreads.length; ++i) {
                StepMetaDataCombi combi4 = initThreads[i].getCombi();
                combi4.step.dispose(combi4.meta, combi4.data);
                if (initThreads[i].isOk()) {
                    combi4.data.setStatus(BaseStepData.StepExecutionStatus.STATUS_HALTED);
                    continue;
                }
                combi4.data.setStatus(BaseStepData.StepExecutionStatus.STATUS_STOPPED);
            }
            try {
                this.fireTransFinishedListeners();
            }
            catch (KettleException e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"Trans.FinishListeners.Exception", (String[])new String[0]));
            }
            finally {
                this.setFinished(true);
            }
            if (this.preview) {
                String logText = KettleLogStore.getAppender().getBuffer(this.getLogChannelId(), true).toString();
                throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Log.FailToInitializeAtLeastOneStep", (String[])new String[0]) + Const.CR + logText);
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Log.FailToInitializeAtLeastOneStep", (String[])new String[0]) + Const.CR);
        }
        this.log.snap((MetricsInterface)Metrics.METRIC_TRANSFORMATION_INIT_STOP, new long[0]);
        KettleEnvironment.setExecutionInformation(this, this.repository);
        this.setReadyToStart(true);
    }

    private void checkCompatibility() {
        if (this.transMeta.getPreviousResult() != null && this.getPreviousResult() == null) {
            this.setPreviousResult(this.transMeta.getPreviousResult());
        }
        if (this.transMeta.getArguments() != null && this.getArguments() == null) {
            this.setArguments(this.transMeta.getArguments());
        }
    }

    public void startThreads() throws KettleException {
        this.nrOfFinishedSteps = 0;
        this.nrOfActiveSteps = 0;
        ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.TransformationStartThreads.id, (Object)this);
        this.fireTransStartedListeners();
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            sid.step.markStart();
            sid.step.initBeforeStart();
            StepListener stepListener = new StepListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void stepActive(Trans trans, StepMeta stepMeta, StepInterface step) {
                    Trans.this.nrOfActiveSteps++;
                    if (Trans.this.nrOfActiveSteps == 1) {
                        List list = Trans.this.transListeners;
                        synchronized (list) {
                            for (TransListener listener : Trans.this.transListeners) {
                                listener.transActive(Trans.this);
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void stepFinished(Trans trans, StepMeta stepMeta, StepInterface step) {
                    Trans trans2 = Trans.this;
                    synchronized (trans2) {
                        Trans.this.nrOfFinishedSteps++;
                        if (Trans.this.nrOfFinishedSteps >= Trans.this.steps.size()) {
                            Trans.this.setFinished(true);
                            Trans.this.addStepPerformanceSnapShot();
                            try {
                                Trans.this.fireTransFinishedListeners();
                            }
                            catch (Exception e) {
                                step.setErrors(step.getErrors() + 1L);
                                Trans.this.log.logError(Trans.this.getName() + " : " + BaseMessages.getString((Class)PKG, (String)"Trans.Log.UnexpectedErrorAtTransformationEnd", (String[])new String[0]), (Throwable)e);
                            }
                        }
                        if (step.getErrors() > 0L) {
                            Trans.this.log.logMinimal(BaseMessages.getString((Class)PKG, (String)"Trans.Log.TransformationDetectedErrors", (String[])new String[0]));
                            Trans.this.log.logMinimal(BaseMessages.getString((Class)PKG, (String)"Trans.Log.TransformationIsKillingTheOtherSteps", (String[])new String[0]));
                            Trans.this.killAllNoWait();
                        }
                    }
                }
            };
            if (sid.step instanceof BaseStep) {
                ((BaseStep)sid.step).getStepListeners().add(0, stepListener);
                continue;
            }
            sid.step.addStepListener(stepListener);
        }
        if (this.transMeta.isCapturingStepPerformanceSnapShots()) {
            this.stepPerformanceSnapshotSeqNr = new AtomicInteger(0);
            this.stepPerformanceSnapShots = new ConcurrentHashMap<String, List<StepPerformanceSnapShot>>();
            String limitString = this.environmentSubstitute(this.transMeta.getStepPerformanceCapturingSizeLimit());
            if (Utils.isEmpty((CharSequence)limitString)) {
                limitString = EnvUtil.getSystemProperty((String)"KETTLE_STEP_PERFORMANCE_SNAPSHOT_LIMIT");
            }
            this.stepPerformanceSnapshotSizeLimit = Const.toInt((String)limitString, (int)0);
            this.stepPerformanceSnapShotTimer = new Timer("stepPerformanceSnapShot Timer: " + this.transMeta.getName());
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (!Trans.this.isFinished()) {
                        Trans.this.addStepPerformanceSnapShot();
                    }
                }
            };
            this.stepPerformanceSnapShotTimer.schedule(timerTask, 100L, this.transMeta.getStepPerformanceCapturingDelay());
        }
        this.setFinished(false);
        this.setPaused(false);
        this.setStopped(false);
        this.transFinishedBlockingQueue = new ArrayBlockingQueue(10);
        TransAdapter transListener = new TransAdapter(){

            @Override
            public void transFinished(Trans trans) {
                try {
                    Trans.this.shutdownHeartbeat(trans != null ? trans.heartbeat : null);
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)Trans.this.log, (String)KettleExtensionPoint.TransformationFinish.id, (Object)trans);
                }
                catch (KettleException e) {
                    throw new RuntimeException("Error calling extension point at end of transformation", e);
                }
                if (Trans.this.transMeta.isCapturingStepPerformanceSnapShots() && Trans.this.stepPerformanceSnapShotTimer != null) {
                    Trans.this.stepPerformanceSnapShotTimer.cancel();
                }
                Trans.this.transMeta.disposeEmbeddedMetastoreProvider();
                Trans.this.setFinished(true);
                Trans.this.setRunning(false);
                Trans.this.log.snap((MetricsInterface)Metrics.METRIC_TRANSFORMATION_EXECUTION_STOP, new long[0]);
                MetricsLogTable metricsLogTable = Trans.this.transMeta.getMetricsLogTable();
                if (metricsLogTable.isDefined()) {
                    try {
                        Trans.this.writeMetricsInformation();
                    }
                    catch (Exception e) {
                        Trans.this.log.logError("Error writing metrics information", (Throwable)e);
                        Trans.this.errors.incrementAndGet();
                    }
                }
                if (Trans.this.transMeta.isUsingUniqueConnections()) {
                    trans.closeUniqueDatabaseConnections(Trans.this.getResult());
                }
                KettleVFS.freeUnusedResources();
            }
        };
        this.transListeners.add(0, transListener);
        this.setRunning(true);
        switch (this.transMeta.getTransformationType()) {
            case Normal: {
                for (int i = 0; i < this.steps.size(); ++i) {
                    final StepMetaDataCombi combi = this.steps.get(i);
                    RunThread runThread = new RunThread(combi);
                    Thread thread = new Thread(runThread);
                    thread.setName(this.getName() + " - " + combi.stepname);
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.StepBeforeStart.id, (Object)combi);
                    combi.step.addStepListener(new StepAdapter(){

                        @Override
                        public void stepFinished(Trans trans, StepMeta stepMeta, StepInterface step) {
                            try {
                                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)Trans.this.log, (String)KettleExtensionPoint.StepFinished.id, (Object)combi);
                            }
                            catch (KettleException e) {
                                throw new RuntimeException("Unexpected error in calling extension point upon step finish", e);
                            }
                        }
                    });
                    thread.start();
                }
                break;
            }
            case SerialSingleThreaded: {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object stepDone;
                        try {
                            for (StepMetaDataCombi combi : Trans.this.steps) {
                                combi.step.setUsingThreadPriorityManagment(false);
                            }
                            Collections.sort(Trans.this.steps, new Comparator<StepMetaDataCombi>(){

                                @Override
                                public int compare(StepMetaDataCombi c1, StepMetaDataCombi c2) {
                                    boolean c1BeforeC2 = Trans.this.transMeta.findPrevious(c2.stepMeta, c1.stepMeta);
                                    if (c1BeforeC2) {
                                        return -1;
                                    }
                                    return 1;
                                }
                            });
                            stepDone = new boolean[Trans.this.steps.size()];
                            int nrDone = 0;
                            while (nrDone < Trans.this.steps.size() && !Trans.this.isStopped()) {
                                for (int i = 0; i < Trans.this.steps.size() && !Trans.this.isStopped(); ++i) {
                                    boolean cont;
                                    StepMetaDataCombi combi = (StepMetaDataCombi)Trans.this.steps.get(i);
                                    if (stepDone[i] != false || (cont = combi.step.processRow(combi.meta, combi.data))) continue;
                                    stepDone[i] = true;
                                    ++nrDone;
                                }
                            }
                        }
                        catch (Exception e) {
                            try {
                                Trans.this.errors.addAndGet(1);
                                Trans.this.log.logError("Error executing single threaded", (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                for (StepMetaDataCombi combi : Trans.this.steps) {
                                    combi.step.dispose(combi.meta, combi.data);
                                    combi.step.markStop();
                                }
                                throw throwable;
                            }
                            for (StepMetaDataCombi combi : Trans.this.steps) {
                                combi.step.dispose(combi.meta, combi.data);
                                combi.step.markStop();
                            }
                        }
                        stepDone = Trans.this.steps.iterator();
                        while (stepDone.hasNext()) {
                            StepMetaDataCombi combi = (StepMetaDataCombi)stepDone.next();
                            combi.step.dispose(combi.meta, combi.data);
                            combi.step.markStop();
                        }
                    }
                }).start();
                break;
            }
            case SingleThreaded: {
                break;
            }
        }
        ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.TransformationStart.id, (Object)this);
        this.heartbeat = this.startHeartbeat(this.getHeartbeatIntervalInSeconds());
        if (this.steps.isEmpty()) {
            this.fireTransFinishedListeners();
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.TransformationHasAllocated", (String[])new String[]{String.valueOf(this.steps.size()), String.valueOf(this.rowsets.size())}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTransFinishedListeners() throws KettleException {
        List<TransListener> list = this.transListeners;
        synchronized (list) {
            if (this.transListeners.size() == 0) {
                return;
            }
            ArrayList<KettleException> badGuys = new ArrayList<KettleException>(this.transListeners.size());
            for (TransListener transListener : this.transListeners) {
                try {
                    transListener.transFinished(this);
                }
                catch (KettleException e) {
                    badGuys.add(e);
                }
            }
            if (this.transFinishedBlockingQueue != null) {
                this.transFinishedBlockingQueue.add(new Object());
            }
            if (!badGuys.isEmpty()) {
                throw new KettleException((Throwable)badGuys.get(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTransStartedListeners() throws KettleException {
        List<TransListener> list = this.transListeners;
        synchronized (list) {
            for (TransListener transListener : this.transListeners) {
                transListener.transStarted(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStepPerformanceSnapShot() {
        boolean stoppedAndNotEmpty;
        if (this.stepPerformanceSnapShots == null) {
            return;
        }
        boolean pausedAndNotEmpty = this.isPaused() && !this.stepPerformanceSnapShots.isEmpty();
        boolean bl = stoppedAndNotEmpty = this.isStopped() && !this.stepPerformanceSnapShots.isEmpty();
        if (this.transMeta.isCapturingStepPerformanceSnapShots() && !pausedAndNotEmpty && !stoppedAndNotEmpty) {
            int seqNr = this.stepPerformanceSnapshotSeqNr.incrementAndGet();
            for (int i = 0; i < this.steps.size(); ++i) {
                StepMeta stepMeta = this.steps.get((int)i).stepMeta;
                StepInterface step = this.steps.get((int)i).step;
                StepPerformanceSnapShot snapShot = new StepPerformanceSnapShot(seqNr, this.getBatchId(), new Date(), this.getName(), stepMeta.getName(), step.getCopy(), step.getLinesRead(), step.getLinesWritten(), step.getLinesInput(), step.getLinesOutput(), step.getLinesUpdated(), step.getLinesRejected(), step.getErrors());
                Map<String, List<StepPerformanceSnapShot>> map = this.stepPerformanceSnapShots;
                synchronized (map) {
                    StepPerformanceSnapShot previous;
                    List<StepPerformanceSnapShot> snapShotList = this.stepPerformanceSnapShots.get(step.toString());
                    if (snapShotList == null) {
                        snapShotList = new ArrayList<StepPerformanceSnapShot>();
                        this.stepPerformanceSnapShots.put(step.toString(), snapShotList);
                        previous = null;
                    } else {
                        previous = snapShotList.get(snapShotList.size() - 1);
                    }
                    snapShot.diff(previous, step.rowsetInputSize(), step.rowsetOutputSize());
                    snapShotList.add(snapShot);
                    if (this.stepPerformanceSnapshotSizeLimit > 0 && snapShotList.size() > this.stepPerformanceSnapshotSizeLimit) {
                        snapShotList.remove(0);
                    }
                    continue;
                }
            }
            this.lastStepPerformanceSnapshotSeqNrAdded = this.stepPerformanceSnapshotSeqNr.get();
        }
    }

    public void cleanup() {
        if (this.steps == null) {
            return;
        }
        for (StepMetaDataCombi combi : this.steps) {
            if (!combi.data.isDisposed()) {
                combi.step.setOutputDone();
                combi.step.dispose(combi.meta, combi.data);
                combi.step.markStop();
            }
            combi.step.cleanup();
        }
    }

    public void logSummary(StepInterface si) {
        this.log.logBasic(si.getStepname(), new Object[]{BaseMessages.getString(PKG, (String)"Trans.Log.FinishedProcessing", (String[])new String[]{String.valueOf(si.getLinesInput()), String.valueOf(si.getLinesOutput()), String.valueOf(si.getLinesRead())}) + BaseMessages.getString(PKG, (String)"Trans.Log.FinishedProcessing2", (String[])new String[]{String.valueOf(si.getLinesWritten()), String.valueOf(si.getLinesUpdated()), String.valueOf(si.getErrors())})});
    }

    public void waitUntilFinished() {
        try {
            if (this.transFinishedBlockingQueue == null) {
                return;
            }
            boolean wait = true;
            while (wait) {
                wait = this.transFinishedBlockingQueue.poll(1L, TimeUnit.DAYS) == null;
                if (!wait) continue;
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Waiting for transformation to be finished interrupted!", e);
        }
    }

    public int getErrors() {
        int nrErrors = this.errors.get();
        if (this.steps == null) {
            return nrErrors;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (sid.step.getErrors() == 0L) continue;
            nrErrors = (int)((long)nrErrors + sid.step.getErrors());
        }
        if (nrErrors > 0) {
            this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Log.TransformationErrorsDetected", (String[])new String[0]));
        }
        return nrErrors;
    }

    public int getEnded() {
        int nrEnded = 0;
        if (this.steps == null) {
            return 0;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            StepDataInterface data = sid.data;
            if ((sid.step == null || sid.step.isRunning()) && data.getStatus() != BaseStepData.StepExecutionStatus.STATUS_FINISHED && data.getStatus() != BaseStepData.StepExecutionStatus.STATUS_HALTED && data.getStatus() != BaseStepData.StepExecutionStatus.STATUS_STOPPED) continue;
            ++nrEnded;
        }
        return nrEnded;
    }

    public boolean isFinished() {
        int exist = this.status.get() & BitMaskStatus.FINISHED.mask;
        return exist != 0;
    }

    protected void setFinished(boolean finished) {
        this.status.updateAndGet(v -> finished ? v | BitMaskStatus.FINISHED.mask : (0x3F ^ BitMaskStatus.FINISHED.mask) & v);
    }

    public boolean isFinishedOrStopped() {
        return this.isFinished() || this.isStopped();
    }

    @Deprecated
    public void killAll() {
        if (this.steps == null) {
            return;
        }
        int nrStepsFinished = 0;
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"Trans.Log.LookingAtStep", (String[])new String[0]) + sid.step.getStepname());
            }
            while (sid.step.isRunning()) {
                sid.step.stopAll();
                try {
                    Thread.sleep(20L);
                }
                catch (Exception e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Log.TransformationErrors", (String[])new String[0]) + e.toString());
                    return;
                }
            }
            if (sid.step.isRunning()) continue;
            ++nrStepsFinished;
        }
        if (nrStepsFinished == this.steps.size()) {
            this.setFinished(true);
        }
    }

    private void killAllNoWait() {
        if (this.steps == null) {
            return;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            StepInterface step = sid.step;
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"Trans.Log.LookingAtStep", (String[])new String[0]) + step.getStepname());
            }
            step.stopAll();
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (Exception e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Log.TransformationErrors", (String[])new String[0]) + e.toString());
                return;
            }
        }
    }

    public void printStats(int seconds) {
        this.log.logBasic(" ");
        if (this.steps == null) {
            return;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            StepInterface step = sid.step;
            long proc = step.getProcessed();
            if (seconds != 0) {
                if (step.getErrors() == 0L) {
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"Trans.Log.ProcessSuccessfullyInfo", (String[])new String[]{step.getStepname(), "." + step.getCopy(), String.valueOf(proc), String.valueOf(proc / (long)seconds)}));
                    continue;
                }
                this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Log.ProcessErrorInfo", (String[])new String[]{step.getStepname(), "." + step.getCopy(), String.valueOf(step.getErrors()), String.valueOf(proc), String.valueOf(proc / (long)seconds)}));
                continue;
            }
            if (step.getErrors() == 0L) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"Trans.Log.ProcessSuccessfullyInfo", (String[])new String[]{step.getStepname(), "." + step.getCopy(), String.valueOf(proc), seconds != 0 ? String.valueOf(proc / (long)seconds) : "-"}));
                continue;
            }
            this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Log.ProcessErrorInfo2", (String[])new String[]{step.getStepname(), "." + step.getCopy(), String.valueOf(step.getErrors()), String.valueOf(proc), String.valueOf(seconds)}));
        }
    }

    public long getLastProcessed() {
        if (this.steps == null || this.steps.size() == 0) {
            return 0L;
        }
        StepMetaDataCombi sid = this.steps.get(this.steps.size() - 1);
        return sid.step.getProcessed();
    }

    public RowSet findRowSet(String rowsetname) {
        for (int i = 0; i < this.rowsets.size(); ++i) {
            RowSet rs = this.rowsets.get(i);
            if (!rs.getName().equalsIgnoreCase(rowsetname)) continue;
            return rs;
        }
        return null;
    }

    public RowSet findRowSet(String from, int fromcopy, String to, int tocopy) {
        for (int i = 0; i < this.rowsets.size(); ++i) {
            RowSet rs = this.rowsets.get(i);
            if (!rs.getOriginStepName().equalsIgnoreCase(from) || !rs.getDestinationStepName().equalsIgnoreCase(to) || rs.getOriginStepCopy() != fromcopy || rs.getDestinationStepCopy() != tocopy) continue;
            return rs;
        }
        return null;
    }

    public boolean hasStepStarted(String sname, int copy) {
        for (int i = 0; i < this.steps.size(); ++i) {
            boolean started;
            StepMetaDataCombi sid = this.steps.get(i);
            boolean bl = started = sid.stepname != null && sid.stepname.equalsIgnoreCase(sname) && sid.copy == copy;
            if (!started) continue;
            return true;
        }
        return false;
    }

    public void safeStop() {
        if (this.steps == null) {
            return;
        }
        this.steps.stream().filter(this::isInputStep).forEach(combi -> this.stopStep((StepMetaDataCombi)combi, true));
        this.notifyStoppedListeners();
    }

    private boolean isInputStep(StepMetaDataCombi combi) {
        Preconditions.checkNotNull((Object)combi);
        return this.transMeta.findPreviousSteps(combi.stepMeta, true).size() == 0;
    }

    public void stopAll() {
        if (this.steps == null) {
            return;
        }
        this.steps.forEach(combi -> this.stopStep((StepMetaDataCombi)combi, false));
        this.setPaused(false);
        this.setStopped(true);
        this.notifyStoppedListeners();
    }

    public void stopStep(StepMetaDataCombi combi, boolean safeStop) {
        StepInterface rt = combi.step;
        rt.setStopped(true);
        rt.setSafeStopped(safeStop);
        rt.resumeRunning();
        try {
            rt.stopRunning(combi.meta, combi.data);
        }
        catch (Exception e) {
            this.log.logError("Something went wrong while trying to safe stop the transformation: ", (Throwable)e);
        }
        combi.data.setStatus(BaseStepData.StepExecutionStatus.STATUS_STOPPED);
        if (safeStop) {
            rt.setOutputDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStoppedListeners() {
        List<TransStoppedListener> list = this.transStoppedListeners;
        synchronized (list) {
            for (TransStoppedListener listener : this.transStoppedListeners) {
                listener.transStopped(this);
            }
        }
    }

    public int nrSteps() {
        if (this.steps == null) {
            return 0;
        }
        return this.steps.size();
    }

    public int nrActiveSteps() {
        if (this.steps == null) {
            return 0;
        }
        int nr = 0;
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (!sid.step.isRunning() && sid.step.getStatus() == BaseStepData.StepExecutionStatus.STATUS_FINISHED) continue;
            ++nr;
        }
        return nr;
    }

    public boolean[] getTransStepIsRunningLookup() {
        if (this.steps == null) {
            return null;
        }
        boolean[] tResult = new boolean[this.steps.size()];
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            tResult[i] = sid.step.isRunning() || sid.step.getStatus() != BaseStepData.StepExecutionStatus.STATUS_FINISHED;
        }
        return tResult;
    }

    public BaseStepData.StepExecutionStatus[] getTransStepExecutionStatusLookup() {
        if (this.steps == null) {
            return null;
        }
        int totalSteps = this.steps.size();
        BaseStepData.StepExecutionStatus[] tList = new BaseStepData.StepExecutionStatus[totalSteps];
        for (int i = 0; i < totalSteps; ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            tList[i] = sid.step.getStatus();
        }
        return tList;
    }

    public StepInterface getRunThread(int i) {
        if (this.steps == null) {
            return null;
        }
        return this.steps.get((int)i).step;
    }

    public StepInterface getRunThread(String name, int copy) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            StepInterface step = sid.step;
            if (!step.getStepname().equalsIgnoreCase(name) || step.getCopy() != copy) continue;
            return step;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void calculateBatchIdAndDateRange() throws KettleTransException {
        TransLogTable transLogTable = this.transMeta.getTransLogTable();
        this.currentDate = new Date();
        this.logDate = new Date();
        this.startDate = Const.MIN_DATE;
        this.endDate = this.currentDate;
        DatabaseMeta logConnection = transLogTable.getDatabaseMeta();
        String logTable = this.environmentSubstitute(transLogTable.getActualTableName());
        String logSchema = this.environmentSubstitute(transLogTable.getActualSchemaName());
        try {
            Date maxdesired;
            if (logConnection != null) {
                Object[] lastr;
                String logSchemaAndTable = logConnection.getQuotedSchemaTableCombination(logSchema, logTable);
                if (Utils.isEmpty((CharSequence)logTable)) {
                    throw new KettleTransException(BaseMessages.getString(PKG, (String)"Trans.Exception.NoLogTableDefined", (String[])new String[0]));
                }
                if (Utils.isEmpty((CharSequence)this.transMeta.getName()) && logTable != null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Exception.NoTransnameAvailableForLogging", (String[])new String[0]));
                }
                this.transLogTableDatabaseConnection = new Database((LoggingObjectInterface)this, logConnection);
                this.transLogTableDatabaseConnection.shareVariablesWith((VariableSpace)this);
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.OpeningLogConnection", (String[])new String[]{"" + logConnection}));
                }
                this.transLogTableDatabaseConnection.connect();
                this.transLogTableDatabaseConnection.setCommit(this.logCommitSize);
                if (transLogTable.isBatchIdUsed()) {
                    Long id_batch = logConnection.getNextBatchId(this.transLogTableDatabaseConnection, logSchema, logTable, transLogTable.getKeyField().getFieldName());
                    this.setBatchId(id_batch);
                }
                if ((lastr = this.transLogTableDatabaseConnection.getLastLogDate(logSchemaAndTable, this.transMeta.getName(), false, LogStatus.END)) != null && lastr.length > 0) {
                    this.startDate = (Date)lastr[0];
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.StartDateFound", (String[])new String[0]) + this.startDate);
                    }
                }
                if (this.transMeta.getMaxDateConnection() != null && this.transMeta.getMaxDateTable() != null && this.transMeta.getMaxDateTable().length() > 0 && this.transMeta.getMaxDateField() != null && this.transMeta.getMaxDateField().length() > 0) {
                    DatabaseMeta maxcon;
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.LookingForMaxdateConnection", (String[])new String[]{"" + this.transMeta.getMaxDateConnection()}));
                    }
                    if ((maxcon = this.transMeta.getMaxDateConnection()) == null) throw new KettleTransException(BaseMessages.getString(PKG, (String)"Trans.Exception.MaximumDateConnectionCouldNotBeFound", (String[])new String[]{"" + this.transMeta.getMaxDateConnection()}));
                    Database maxdb = new Database((LoggingObjectInterface)this, maxcon);
                    maxdb.shareVariablesWith((VariableSpace)this);
                    try {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.OpeningMaximumDateConnection", (String[])new String[0]));
                        }
                        maxdb.connect();
                        maxdb.setCommit(this.logCommitSize);
                        String sql = "SELECT MAX(" + this.transMeta.getMaxDateField() + ") FROM " + this.transMeta.getMaxDateTable();
                        RowMetaAndData r1 = maxdb.getOneRow(sql);
                        if (r1 != null) {
                            Date maxvalue = r1.getRowMeta().getDate(r1.getData(), 0);
                            if (maxvalue != null) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.LastDateFoundOnTheMaxdateConnection", (String[])new String[0]) + r1);
                                }
                                this.endDate.setTime((long)((double)maxvalue.getTime() + this.transMeta.getMaxDateOffset() * 1000.0));
                            }
                        } else if (this.log.isDetailed()) {
                            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.NoLastDateFoundOnTheMaxdateConnection", (String[])new String[0]));
                        }
                    }
                    catch (KettleException e) {
                        throw new KettleTransException(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorConnectingToDatabase", (String[])new String[]{"" + this.transMeta.getMaxDateConnection()}), (Throwable)e);
                    }
                    finally {
                        maxdb.disconnect();
                    }
                }
                if (this.transMeta.nrDependencies() > 0) {
                    Date dep;
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.CheckingForMaxDependencyDate", (String[])new String[0]));
                    }
                    this.depDate = Const.MIN_DATE;
                    Date maxdepdate = Const.MIN_DATE;
                    if (lastr != null && lastr.length > 0 && (dep = (Date)lastr[1]) != null) {
                        maxdepdate = dep;
                        this.depDate = dep;
                    }
                    for (int i = 0; i < this.transMeta.nrDependencies(); ++i) {
                        TransDependency td = this.transMeta.getDependency(i);
                        DatabaseMeta depcon = td.getDatabase();
                        if (depcon == null) throw new KettleTransException(BaseMessages.getString(PKG, (String)"Trans.Exception.ConnectionCouldNotBeFound", (String[])new String[]{"" + td.getDatabase()}));
                        Database depdb = new Database((LoggingObjectInterface)this, depcon);
                        try {
                            depdb.connect();
                            depdb.setCommit(this.logCommitSize);
                            String sql = "SELECT MAX(" + td.getFieldname() + ") FROM " + td.getTablename();
                            RowMetaAndData r1 = depdb.getOneRow(sql);
                            if (r1 == null) throw new KettleTransException(BaseMessages.getString(PKG, (String)"Trans.Exception.UnableToGetDependencyInfoFromDB", (String[])new String[]{td.getDatabase().getName() + ".", td.getTablename() + ".", td.getFieldname()}));
                            Date maxvalue = (Date)r1.getData()[0];
                            if (maxvalue == null) throw new KettleTransException(BaseMessages.getString(PKG, (String)"Trans.Exception.UnableToGetDependencyInfoFromDB", (String[])new String[]{td.getDatabase().getName() + ".", td.getTablename() + ".", td.getFieldname()}));
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.FoundDateFromTable", (String[])new String[]{td.getTablename(), "." + td.getFieldname(), " = " + maxvalue.toString()}));
                            }
                            if (maxvalue.getTime() > maxdepdate.getTime()) {
                                maxdepdate = maxvalue;
                            }
                        }
                        catch (KettleException e) {
                            throw new KettleTransException(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorInDatabase", (String[])new String[]{"" + td.getDatabase()}), (Throwable)e);
                        }
                        finally {
                            depdb.disconnect();
                        }
                        if (!this.log.isDetailed()) continue;
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.Maxdepdate", (String[])new String[0]) + XMLHandler.date2string((Date)maxdepdate));
                    }
                    if (maxdepdate.getTime() > this.depDate.getTime()) {
                        this.depDate = maxdepdate;
                        this.startDate = Const.MIN_DATE;
                    }
                } else {
                    this.depDate = this.currentDate;
                }
            }
            if (!(this.transMeta.getMaxDateDifference() > 0.0) || this.startDate.getTime() <= Const.MIN_DATE.getTime() || this.endDate.compareTo(maxdesired = new Date(this.startDate.getTime() + (long)this.transMeta.getMaxDateDifference() * 1000L)) <= 0) return;
            this.endDate = maxdesired;
            return;
        }
        catch (KettleException e) {
            throw new KettleTransException(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorCalculatingDateRange", (String[])new String[]{logTable}), (Throwable)e);
        }
    }

    public void beginProcessing() throws KettleTransException {
        TransLogTable transLogTable = this.transMeta.getTransLogTable();
        int intervalInSeconds = Const.toInt((String)this.environmentSubstitute(transLogTable.getLogInterval()), (int)-1);
        try {
            String logTable = transLogTable.getActualTableName();
            SimpleDateFormat df = new SimpleDateFormat(REPLAY_DATE_FORMAT);
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Trans.Log.TransformationCanBeReplayed", (String[])new String[0]) + df.format(this.currentDate));
            try {
                ChannelLogTable channelLogTable;
                StepLogTable stepLogTable;
                if (this.transLogTableDatabaseConnection != null && !Utils.isEmpty((CharSequence)logTable) && !Utils.isEmpty((CharSequence)this.transMeta.getName())) {
                    this.transLogTableDatabaseConnection.writeLogRecord((LogTableCoreInterface)transLogTable, LogStatus.START, (Object)this, null);
                    if (!this.transLogTableDatabaseConnection.isAutoCommit()) {
                        this.transLogTableDatabaseConnection.commitLog(true, (LogTableCoreInterface)transLogTable);
                    }
                    if (intervalInSeconds > 0) {
                        final Timer timer = new Timer(this.getName() + " - interval logging timer");
                        TimerTask timerTask = new TimerTask(){

                            @Override
                            public void run() {
                                try {
                                    Trans.this.endProcessing();
                                }
                                catch (Exception e) {
                                    Trans.this.log.logError(BaseMessages.getString((Class)PKG, (String)"Trans.Exception.UnableToPerformIntervalLogging", (String[])new String[0]), (Throwable)e);
                                    Trans.this.errors.incrementAndGet();
                                    Trans.this.stopAll();
                                }
                            }
                        };
                        timer.schedule(timerTask, intervalInSeconds * 1000, (long)(intervalInSeconds * 1000));
                        this.addTransListener(new TransAdapter(){

                            @Override
                            public void transFinished(Trans trans) {
                                timer.cancel();
                            }
                        });
                    }
                    this.addTransListener(new TransAdapter(){

                        @Override
                        public void transFinished(Trans trans) throws KettleException {
                            try {
                                Trans.this.endProcessing();
                                Trans.this.lastWrittenStepPerformanceSequenceNr = Trans.this.writeStepPerformanceLogRecords(Trans.this.lastWrittenStepPerformanceSequenceNr, LogStatus.END);
                            }
                            catch (KettleException e) {
                                throw new KettleException(BaseMessages.getString((Class)PKG, (String)"Trans.Exception.UnableToPerformLoggingAtTransEnd", (String[])new String[0]), (Throwable)e);
                            }
                        }
                    });
                }
                if ((stepLogTable = this.transMeta.getStepLogTable()).isDefined()) {
                    this.addTransListener(new TransAdapter(){

                        @Override
                        public void transFinished(Trans trans) throws KettleException {
                            try {
                                Trans.this.writeStepLogInformation();
                            }
                            catch (KettleException e) {
                                throw new KettleException(BaseMessages.getString((Class)PKG, (String)"Trans.Exception.UnableToPerformLoggingAtTransEnd", (String[])new String[0]), (Throwable)e);
                            }
                        }
                    });
                }
                if ((channelLogTable = this.transMeta.getChannelLogTable()).isDefined()) {
                    this.addTransListener(new TransAdapter(){

                        @Override
                        public void transFinished(Trans trans) throws KettleException {
                            try {
                                Trans.this.writeLogChannelInformation();
                            }
                            catch (KettleException e) {
                                throw new KettleException(BaseMessages.getString((Class)PKG, (String)"Trans.Exception.UnableToPerformLoggingAtTransEnd", (String[])new String[0]), (Throwable)e);
                            }
                        }
                    });
                }
                PerformanceLogTable performanceLogTable = this.transMeta.getPerformanceLogTable();
                int perfLogInterval = Const.toInt((String)this.environmentSubstitute(performanceLogTable.getLogInterval()), (int)-1);
                if (performanceLogTable.isDefined() && perfLogInterval > 0) {
                    final Timer timer = new Timer(this.getName() + " - step performance log interval timer");
                    TimerTask timerTask = new TimerTask(){

                        @Override
                        public void run() {
                            try {
                                Trans.this.lastWrittenStepPerformanceSequenceNr = Trans.this.writeStepPerformanceLogRecords(Trans.this.lastWrittenStepPerformanceSequenceNr, LogStatus.RUNNING);
                            }
                            catch (Exception e) {
                                Trans.this.log.logError(BaseMessages.getString((Class)PKG, (String)"Trans.Exception.UnableToPerformIntervalPerformanceLogging", (String[])new String[0]), (Throwable)e);
                                Trans.this.errors.incrementAndGet();
                                Trans.this.stopAll();
                            }
                        }
                    };
                    timer.schedule(timerTask, perfLogInterval * 1000, (long)(perfLogInterval * 1000));
                    this.addTransListener(new TransAdapter(){

                        @Override
                        public void transFinished(Trans trans) {
                            timer.cancel();
                        }
                    });
                }
            }
            catch (KettleException e) {
                throw new KettleTransException(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorWritingLogRecordToTable", (String[])new String[]{logTable}), (Throwable)e);
            }
            finally {
                if (this.transLogTableDatabaseConnection != null && intervalInSeconds <= 0) {
                    this.transLogTableDatabaseConnection.disconnect();
                    this.transLogTableDatabaseConnection = null;
                }
            }
        }
        catch (KettleException e) {
            throw new KettleTransException(BaseMessages.getString(PKG, (String)"Trans.Exception.UnableToBeginProcessingTransformation", (String[])new String[0]), (Throwable)e);
        }
    }

    protected void writeLogChannelInformation() throws KettleException {
        Database db = null;
        ChannelLogTable channelLogTable = this.transMeta.getChannelLogTable();
        Trans t = this.getParentTrans();
        if (t != null && channelLogTable.equals(t.getTransMeta().getChannelLogTable())) {
            return;
        }
        Job j = this.getParentJob();
        if (j != null && channelLogTable.equals(j.getJobMeta().getChannelLogTable())) {
            return;
        }
        try {
            db = new Database((LoggingObjectInterface)this, channelLogTable.getDatabaseMeta());
            db.shareVariablesWith((VariableSpace)this);
            db.connect();
            db.setCommit(this.logCommitSize);
            List<LoggingHierarchy> loggingHierarchyList = this.getLoggingHierarchy();
            for (LoggingHierarchy loggingHierarchy : loggingHierarchyList) {
                db.writeLogRecord((LogTableCoreInterface)channelLogTable, LogStatus.START, (Object)loggingHierarchy, null);
            }
            db.cleanupLogRecords((LogTableCoreInterface)channelLogTable);
        }
        catch (Exception e) {
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Exception.UnableToWriteLogChannelInformationToLogTable", (String[])new String[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.disconnectDb(db);
                throw throwable;
            }
        }
        this.disconnectDb(db);
    }

    protected void writeStepLogInformation() throws KettleException {
        Database db = null;
        StepLogTable stepLogTable = this.getTransMeta().getStepLogTable();
        try {
            db = this.createDataBase(stepLogTable.getDatabaseMeta());
            db.shareVariablesWith((VariableSpace)this);
            db.connect();
            db.setCommit(this.logCommitSize);
            for (StepMetaDataCombi combi : this.getSteps()) {
                db.writeLogRecord((LogTableCoreInterface)stepLogTable, LogStatus.START, (Object)combi, null);
            }
            db.cleanupLogRecords((LogTableCoreInterface)stepLogTable);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Exception.UnableToWriteStepInformationToLogTable", (String[])new String[0]), (Throwable)e);
        }
        finally {
            this.disconnectDb(db);
        }
    }

    protected Database createDataBase(DatabaseMeta meta) {
        return new Database((LoggingObjectInterface)this, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeMetricsInformation() throws KettleException {
        Preconditions.checkNotNull((Object)this.log);
        List metricsList = MetricsUtil.getDuration((String)this.log.getLogChannelId(), (Metrics)Metrics.METRIC_PLUGIN_REGISTRY_REGISTER_EXTENSIONS_START);
        if (this.log.isDebug() && !metricsList.isEmpty()) {
            this.log.logDebug(((MetricsDuration)metricsList.get(0)).toString());
        }
        metricsList = MetricsUtil.getDuration((String)this.log.getLogChannelId(), (Metrics)Metrics.METRIC_PLUGIN_REGISTRY_PLUGIN_REGISTRATION_START);
        if (this.log != null && this.log.isDebug() && !metricsList.isEmpty()) {
            this.log.logDebug(((MetricsDuration)metricsList.get(0)).toString());
        }
        long total = 0L;
        metricsList = MetricsUtil.getDuration((String)this.log.getLogChannelId(), (Metrics)Metrics.METRIC_PLUGIN_REGISTRY_PLUGIN_TYPE_REGISTRATION_START);
        if (this.log != null && this.log.isDebug() && metricsList != null && !metricsList.isEmpty()) {
            for (MetricsDuration duration : metricsList) {
                this.log.logDebug("   - " + duration.toString() + "  Total=" + (total += duration.getDuration().longValue()));
            }
        }
        Database db = null;
        MetricsLogTable metricsLogTable = this.transMeta.getMetricsLogTable();
        try {
            db = new Database((LoggingObjectInterface)this, metricsLogTable.getDatabaseMeta());
            db.shareVariablesWith((VariableSpace)this);
            db.connect();
            db.setCommit(this.logCommitSize);
            List logChannelIds = LoggingRegistry.getInstance().getLogChannelChildren(this.getLogChannelId());
            for (String logChannelId : logChannelIds) {
                Map snapshotMap;
                Queue snapshotList = (Queue)MetricsRegistry.getInstance().getSnapshotLists().get(logChannelId);
                if (snapshotList != null) {
                    for (MetricsSnapshotInterface snapshot : snapshotList) {
                        db.writeLogRecord((LogTableCoreInterface)metricsLogTable, LogStatus.START, (Object)new LoggingMetric(this.batchId, snapshot), null);
                    }
                }
                if ((snapshotMap = (Map)MetricsRegistry.getInstance().getSnapshotMaps().get(logChannelId)) == null) continue;
                Map map = snapshotMap;
                synchronized (map) {
                    for (MetricsSnapshotInterface snapshot : snapshotMap.values()) {
                        db.writeLogRecord((LogTableCoreInterface)metricsLogTable, LogStatus.START, (Object)new LoggingMetric(this.batchId, snapshot), null);
                    }
                }
            }
            db.cleanupLogRecords((LogTableCoreInterface)metricsLogTable);
        }
        catch (Exception e) {
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Exception.UnableToWriteMetricsInformationToLogTable", (String[])new String[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.disconnectDb(db);
                throw throwable;
            }
        }
        this.disconnectDb(db);
    }

    private void disconnectDb(Database db) throws KettleDatabaseException {
        if (db == null) {
            return;
        }
        if (!db.isAutoCommit()) {
            db.commit(true);
        }
        db.disconnect();
    }

    public Result getResult() {
        if (this.steps == null) {
            return null;
        }
        Result result = new Result();
        result.setNrErrors(this.errors.longValue());
        result.setResult(this.errors.longValue() == 0L);
        TransLogTable transLogTable = this.transMeta.getTransLogTable();
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            StepInterface step = sid.step;
            result.setNrErrors(result.getNrErrors() + sid.step.getErrors());
            result.getResultFiles().putAll(step.getResultFiles());
            if (step.isSafeStopped()) {
                result.setSafeStop(step.isSafeStopped());
            }
            if (step.getStepname().equals(transLogTable.getSubjectString(TransLogTable.ID.LINES_READ))) {
                result.setNrLinesRead(result.getNrLinesRead() + step.getLinesRead());
            }
            if (step.getStepname().equals(transLogTable.getSubjectString(TransLogTable.ID.LINES_INPUT))) {
                result.setNrLinesInput(result.getNrLinesInput() + step.getLinesInput());
            }
            if (step.getStepname().equals(transLogTable.getSubjectString(TransLogTable.ID.LINES_WRITTEN))) {
                result.setNrLinesWritten(result.getNrLinesWritten() + step.getLinesWritten());
            }
            if (step.getStepname().equals(transLogTable.getSubjectString(TransLogTable.ID.LINES_OUTPUT))) {
                result.setNrLinesOutput(result.getNrLinesOutput() + step.getLinesOutput());
            }
            if (step.getStepname().equals(transLogTable.getSubjectString(TransLogTable.ID.LINES_UPDATED))) {
                result.setNrLinesUpdated(result.getNrLinesUpdated() + step.getLinesUpdated());
            }
            if (!step.getStepname().equals(transLogTable.getSubjectString(TransLogTable.ID.LINES_REJECTED))) continue;
            result.setNrLinesRejected(result.getNrLinesRejected() + step.getLinesRejected());
        }
        result.setRows(this.resultRows);
        if (!Utils.isEmpty(this.resultFiles)) {
            result.setResultFiles(new HashMap());
            for (ResultFile resultFile : this.resultFiles) {
                result.getResultFiles().put(resultFile.toString(), resultFile);
            }
        }
        result.setStopped(this.isStopped());
        result.setLogChannelId(this.log.getLogChannelId());
        return result;
    }

    private synchronized boolean endProcessing() throws KettleException {
        LogStatus status = this.isFinished() ? (this.isStopped() ? LogStatus.STOP : LogStatus.END) : (this.isPaused() ? LogStatus.PAUSED : LogStatus.RUNNING);
        TransLogTable transLogTable = this.transMeta.getTransLogTable();
        int intervalInSeconds = Const.toInt((String)this.environmentSubstitute(transLogTable.getLogInterval()), (int)-1);
        this.logDate = new Date();
        DatabaseMeta logcon = this.transMeta.getTransLogTable().getDatabaseMeta();
        String logTable = this.transMeta.getTransLogTable().getActualTableName();
        if (logcon != null) {
            Database ldb = null;
            try {
                if (this.transLogTableDatabaseConnection == null) {
                    ldb = new Database((LoggingObjectInterface)this, logcon);
                    ldb.shareVariablesWith((VariableSpace)this);
                    ldb.connect();
                    ldb.setCommit(this.logCommitSize);
                    this.transLogTableDatabaseConnection = ldb;
                } else {
                    ldb = this.transLogTableDatabaseConnection;
                }
                if (!Utils.isEmpty((CharSequence)logTable)) {
                    ldb.writeLogRecord((LogTableCoreInterface)transLogTable, status, (Object)this, null);
                }
                if (status.equals(LogStatus.END) || status.equals(LogStatus.STOP)) {
                    ldb.cleanupLogRecords((LogTableCoreInterface)transLogTable);
                }
                if (!ldb.isAutoCommit()) {
                    ldb.commitLog(true, (LogTableCoreInterface)this.transMeta.getTransLogTable());
                }
            }
            catch (KettleDatabaseException e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"Database.Error.WriteLogTable", (String[])new String[]{logTable}), (Throwable)e);
                this.errors.incrementAndGet();
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorWritingLogRecordToTable", (String[])new String[]{this.transMeta.getTransLogTable().getActualTableName()}), (Throwable)e);
            }
            finally {
                if (intervalInSeconds <= 0 || status.equals(LogStatus.END) || status.equals(LogStatus.STOP)) {
                    ldb.disconnect();
                    this.transLogTableDatabaseConnection = null;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeStepPerformanceLogRecords(int startSequenceNr, LogStatus status) throws KettleException {
        int lastSeqNr = 0;
        Database ldb = null;
        PerformanceLogTable performanceLogTable = this.transMeta.getPerformanceLogTable();
        if (!performanceLogTable.isDefined() || !this.transMeta.isCapturingStepPerformanceSnapShots() || this.stepPerformanceSnapShots == null || this.stepPerformanceSnapShots.isEmpty()) {
            return 0;
        }
        try {
            ldb = new Database((LoggingObjectInterface)this, performanceLogTable.getDatabaseMeta());
            ldb.shareVariablesWith((VariableSpace)this);
            ldb.connect();
            ldb.setCommit(this.logCommitSize);
            RowMetaInterface rowMeta = performanceLogTable.getLogRecord(LogStatus.START, null, null).getRowMeta();
            ldb.prepareInsert(rowMeta, performanceLogTable.getActualSchemaName(), performanceLogTable.getActualTableName());
            Map<String, List<StepPerformanceSnapShot>> map = this.stepPerformanceSnapShots;
            synchronized (map) {
                Iterator<List<StepPerformanceSnapShot>> iterator = this.stepPerformanceSnapShots.values().iterator();
                while (iterator.hasNext()) {
                    List<StepPerformanceSnapShot> snapshots;
                    List<StepPerformanceSnapShot> list = snapshots = iterator.next();
                    synchronized (list) {
                        for (StepPerformanceSnapShot snapshot : snapshots) {
                            if (snapshot.getSeqNr() >= startSequenceNr && snapshot.getSeqNr() <= this.lastStepPerformanceSnapshotSeqNrAdded) {
                                RowMetaAndData row = performanceLogTable.getLogRecord(LogStatus.START, snapshot, null);
                                ldb.setValuesInsert(row.getRowMeta(), row.getData());
                                ldb.insertRow(true);
                            }
                            lastSeqNr = snapshot.getSeqNr();
                        }
                    }
                }
            }
            ldb.insertFinished(true);
            if (status.equals(LogStatus.END)) {
                ldb.cleanupLogRecords((LogTableCoreInterface)performanceLogTable);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorWritingStepPerformanceLogRecordToTable", (String[])new String[0]), (Throwable)e);
        }
        finally {
            if (ldb != null) {
                ldb.disconnect();
            }
        }
        return lastSeqNr + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void closeUniqueDatabaseConnections(Result result) {
        DatabaseConnectionMap map;
        if (this.parentJob != null && this.transactionId != null && this.parentJob.getTransactionId() != null && this.transactionId.equals(this.parentJob.getTransactionId())) {
            return;
        }
        if (this.parentTrans != null && this.parentTrans.getTransMeta().isUsingUniqueConnections() && this.transactionId != null && this.parentTrans.getTransactionId() != null && this.transactionId.equals(this.parentTrans.getTransactionId())) {
            return;
        }
        DatabaseConnectionMap databaseConnectionMap = map = DatabaseConnectionMap.getInstance();
        synchronized (databaseConnectionMap) {
            ArrayList databaseList = new ArrayList(map.getMap().values());
            for (Database database : databaseList) {
                block38: {
                    if (!database.getConnectionGroup().equals(this.getTransactionId())) continue;
                    if (result.getNrErrors() > 0L) {
                        try {
                            database.rollback(true);
                            this.log.logBasic(BaseMessages.getString(PKG, (String)"Trans.Exception.TransactionsRolledBackOnConnection", (String[])new String[]{database.toString()}));
                            break block38;
                        }
                        catch (Exception e) {
                            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorRollingBackUniqueConnection", (String[])new String[]{database.toString()}), (Throwable)e);
                        }
                    }
                    try {
                        database.commit(true);
                        this.log.logBasic(BaseMessages.getString(PKG, (String)"Trans.Exception.TransactionsCommittedOnConnection", (String[])new String[]{database.toString()}));
                    }
                    catch (Exception e) {
                        throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorCommittingUniqueConnection", (String[])new String[]{database.toString()}), (Throwable)e);
                    }
                }
                try {
                    database.closeConnectionOnly();
                    continue;
                }
                catch (Exception e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorHandlingTransformationTransaction", (String[])new String[]{database.toString()}), (Throwable)e);
                    result.setNrErrors(result.getNrErrors() + 1L);
                    continue;
                }
                finally {
                    map.removeConnection(database.getConnectionGroup(), database.getPartitionId(), database);
                    continue;
                }
                catch (Exception e) {
                    try {
                        this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorHandlingTransformationTransaction", (String[])new String[]{database.toString()}), (Throwable)e);
                        result.setNrErrors(result.getNrErrors() + 1L);
                    }
                    catch (Throwable throwable) {
                        try {
                            database.closeConnectionOnly();
                        }
                        catch (Exception e2) {
                            this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorHandlingTransformationTransaction", (String[])new String[]{database.toString()}), (Throwable)e2);
                            result.setNrErrors(result.getNrErrors() + 1L);
                        }
                        finally {
                            map.removeConnection(database.getConnectionGroup(), database.getPartitionId(), database);
                        }
                        throw throwable;
                    }
                    try {
                        database.closeConnectionOnly();
                    }
                    catch (Exception e3) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorHandlingTransformationTransaction", (String[])new String[]{database.toString()}), (Throwable)e3);
                        result.setNrErrors(result.getNrErrors() + 1L);
                    }
                    finally {
                        map.removeConnection(database.getConnectionGroup(), database.getPartitionId(), database);
                    }
                }
            }
            List transactionListeners = map.getTransactionListeners(this.getTransactionId());
            if (result.getNrErrors() > 0L) {
                for (DatabaseTransactionListener listener : transactionListeners) {
                    try {
                        listener.rollback();
                    }
                    catch (Exception e) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorHandlingTransactionListenerRollback", (String[])new String[0]), (Throwable)e);
                        result.setNrErrors(result.getNrErrors() + 1L);
                    }
                }
            } else {
                for (DatabaseTransactionListener listener : transactionListeners) {
                    try {
                        listener.commit();
                    }
                    catch (Exception e) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Exception.ErrorHandlingTransactionListenerCommit", (String[])new String[0]), (Throwable)e);
                        result.setNrErrors(result.getNrErrors() + 1L);
                    }
                }
            }
        }
    }

    public StepInterface findRunThread(String stepname) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            StepInterface step = sid.step;
            if (!step.getStepname().equalsIgnoreCase(stepname)) continue;
            return step;
        }
        return null;
    }

    public List<StepInterface> findBaseSteps(String stepname) {
        ArrayList<StepInterface> baseSteps = new ArrayList<StepInterface>();
        if (this.steps == null) {
            return baseSteps;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            StepInterface stepInterface = sid.step;
            if (!stepInterface.getStepname().equalsIgnoreCase(stepname)) continue;
            baseSteps.add(stepInterface);
        }
        return baseSteps;
    }

    public StepInterface findStepInterface(String stepname, int copyNr) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            StepInterface stepInterface = sid.step;
            if (!stepInterface.getStepname().equalsIgnoreCase(stepname) || sid.copy != copyNr) continue;
            return stepInterface;
        }
        return null;
    }

    public List<StepInterface> findStepInterfaces(String stepname) {
        if (this.steps == null) {
            return null;
        }
        ArrayList<StepInterface> list = new ArrayList<StepInterface>();
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            StepInterface stepInterface = sid.step;
            if (!stepInterface.getStepname().equalsIgnoreCase(stepname)) continue;
            list.add(stepInterface);
        }
        return list;
    }

    public StepDataInterface findDataInterface(String name) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            StepInterface rt = sid.step;
            if (!rt.getStepname().equalsIgnoreCase(name)) continue;
            return sid.data;
        }
        return null;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isMonitored() {
        return this.monitored;
    }

    public void setMonitored(boolean monitored) {
        this.monitored = monitored;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public Date getDepDate() {
        return this.depDate;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public List<RowSet> getRowsets() {
        return this.rowsets;
    }

    public List<StepMetaDataCombi> getSteps() {
        return this.steps;
    }

    protected void setSteps(List<StepMetaDataCombi> steps) {
        this.steps = steps;
    }

    public String toString() {
        if (this.transMeta == null || this.transMeta.getName() == null) {
            return this.getClass().getSimpleName();
        }
        StringBuilder string = new StringBuilder(50);
        if (this.getParentTrans() != null) {
            string.append('[').append(this.getParentTrans().toString()).append(']').append('.');
        }
        if (!Utils.isEmpty((CharSequence)this.mappingStepName)) {
            string.append('[').append(this.mappingStepName).append(']').append('.');
        }
        string.append(this.transMeta.getName());
        return string.toString();
    }

    public MappingInput[] findMappingInput() {
        if (this.steps == null) {
            return null;
        }
        ArrayList<MappingInput> list = new ArrayList<MappingInput>();
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi smdc = this.steps.get(i);
            StepInterface step = smdc.step;
            if (!step.getStepID().equalsIgnoreCase("MappingInput")) continue;
            list.add((MappingInput)step);
        }
        return list.toArray(new MappingInput[list.size()]);
    }

    public MappingOutput[] findMappingOutput() {
        ArrayList<MappingOutput> list = new ArrayList<MappingOutput>();
        if (this.steps != null) {
            for (int i = 0; i < this.steps.size(); ++i) {
                StepMetaDataCombi smdc = this.steps.get(i);
                StepInterface step = smdc.step;
                if (!step.getStepID().equalsIgnoreCase("MappingOutput")) continue;
                list.add((MappingOutput)step);
            }
        }
        return list.toArray(new MappingOutput[list.size()]);
    }

    public StepInterface getStepInterface(String stepname, int copy) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (!sid.stepname.equalsIgnoreCase(stepname) || sid.copy != copy) continue;
            return sid.step;
        }
        return null;
    }

    public Date getReplayDate() {
        return this.replayDate;
    }

    public void setReplayDate(Date replayDate) {
        this.replayDate = replayDate;
    }

    public void setSafeModeEnabled(boolean safeModeEnabled) {
        this.safeModeEnabled = safeModeEnabled;
    }

    public boolean isSafeModeEnabled() {
        return this.safeModeEnabled;
    }

    public RowProducer addRowProducer(String stepname, int copynr) throws KettleException {
        SingleRowRowSet rowSet;
        StepInterface stepInterface = this.getStepInterface(stepname, copynr);
        if (stepInterface == null) {
            throw new KettleException("Unable to find thread with name " + stepname + " and copy number " + copynr);
        }
        switch (this.transMeta.getTransformationType()) {
            case Normal: {
                rowSet = new BlockingRowSet(this.transMeta.getSizeRowset());
                break;
            }
            case SerialSingleThreaded: {
                rowSet = new SingleRowRowSet();
                break;
            }
            case SingleThreaded: {
                rowSet = new QueueRowSet();
                break;
            }
            default: {
                throw new KettleException("Unhandled transformation type: " + (Object)((Object)this.transMeta.getTransformationType()));
            }
        }
        stepInterface.addRowSetToInputRowSets((RowSet)rowSet);
        return new RowProducer(stepInterface, (RowSet)rowSet);
    }

    public Job getParentJob() {
        return this.parentJob;
    }

    public void setParentJob(Job parentJob) {
        this.logLevel = parentJob.getLogLevel();
        this.log.setLogLevel(this.logLevel);
        this.parentJob = parentJob;
        this.transactionId = this.calculateTransactionId();
    }

    public StepDataInterface getStepDataInterface(String stepname, int stepcopy) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (!sid.stepname.equals(stepname) || sid.copy != stepcopy) continue;
            return sid.data;
        }
        return null;
    }

    public boolean hasHaltedSteps() {
        if (this.steps == null) {
            return false;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = this.steps.get(i);
            if (sid.data.getStatus() != BaseStepData.StepExecutionStatus.STATUS_HALTED) continue;
            return true;
        }
        return false;
    }

    public Date getJobStartDate() {
        return this.jobStartDate;
    }

    public Date getJobEndDate() {
        return this.jobEndDate;
    }

    public void setJobEndDate(Date jobEndDate) {
        this.jobEndDate = jobEndDate;
    }

    public void setJobStartDate(Date jobStartDate) {
        this.jobStartDate = jobStartDate;
    }

    public long getPassedBatchId() {
        return this.passedBatchId;
    }

    public void setPassedBatchId(long jobBatchId) {
        this.passedBatchId = jobBatchId;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    @Deprecated
    public String getThreadName() {
        return this.threadName;
    }

    @Deprecated
    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getStatus() {
        String message;
        if (this.isRunning()) {
            message = this.isStopped() ? STRING_HALTING : (this.isPaused() ? STRING_PAUSED : STRING_RUNNING);
        } else if (this.isFinished()) {
            message = STRING_FINISHED;
            if (this.getResult().getNrErrors() > 0L) {
                message = message + " (with errors)";
            }
        } else {
            message = this.isStopped() ? STRING_STOPPED : (this.isPreparing() ? STRING_PREPARING : (this.isInitializing() ? STRING_INITIALIZING : STRING_WAITING));
        }
        return message;
    }

    public boolean isInitializing() {
        int exist = this.status.get() & BitMaskStatus.INITIALIZING.mask;
        return exist != 0;
    }

    public void setInitializing(boolean initializing) {
        this.status.updateAndGet(v -> initializing ? v | BitMaskStatus.INITIALIZING.mask : (0x3F ^ BitMaskStatus.INITIALIZING.mask) & v);
    }

    public boolean isPreparing() {
        int exist = this.status.get() & BitMaskStatus.PREPARING.mask;
        return exist != 0;
    }

    public void setPreparing(boolean preparing) {
        this.status.updateAndGet(v -> preparing ? v | BitMaskStatus.PREPARING.mask : (0x3F ^ BitMaskStatus.PREPARING.mask) & v);
    }

    public boolean isRunning() {
        int exist = this.status.get() & BitMaskStatus.RUNNING.mask;
        return exist != 0;
    }

    public void setRunning(boolean running) {
        this.status.updateAndGet(v -> running ? v | BitMaskStatus.RUNNING.mask : (0x3F ^ BitMaskStatus.RUNNING.mask) & v);
    }

    public static TransSplitter executeClustered(TransMeta transMeta, TransExecutionConfiguration executionConfiguration) throws KettleException {
        if (Utils.isEmpty((CharSequence)transMeta.getName())) {
            throw new KettleException("The transformation needs a name to uniquely identify it by on the remote server.");
        }
        TransSplitter transSplitter = new TransSplitter(transMeta);
        transSplitter.splitOriginalTransformation();
        executionConfiguration.getVariables().put("Internal.Cluster.Run.ID", transSplitter.getClusteredRunId());
        Trans.executeClustered(transSplitter, executionConfiguration);
        return transSplitter;
    }

    public static void executeClustered(final TransSplitter transSplitter, final TransExecutionConfiguration executionConfiguration) throws KettleException {
        try {
            int i;
            TransMeta master = transSplitter.getMaster();
            final SlaveServer[] slaves = transSplitter.getSlaveTargets();
            Thread[] threads = new Thread[slaves.length];
            final Throwable[] errors = new Throwable[slaves.length];
            final Map<TransMeta, String> carteObjectMap = transSplitter.getCarteObjectMap();
            SlaveServer masterServer = null;
            List<StepMeta> masterSteps = master.getTransHopSteps(false);
            if (masterSteps.size() > 0) {
                masterServer = transSplitter.getMasterServer();
                if (executionConfiguration.isClusterPosting()) {
                    TransConfiguration transConfiguration = new TransConfiguration(master, executionConfiguration);
                    Map<String, String> variables = transConfiguration.getTransExecutionConfiguration().getVariables();
                    variables.put("Internal.Cluster.Size", Integer.toString(slaves.length));
                    variables.put("Internal.Cluster.Master", "Y");
                    Map<String, String> params = transConfiguration.getTransExecutionConfiguration().getParams();
                    TransMeta ot = transSplitter.getOriginalTransformation();
                    for (String param : ot.listParameters()) {
                        String value = Const.NVL((String)ot.getParameterValue(param), (String)Const.NVL((String)ot.getParameterDefault(param), (String)ot.getVariable(param)));
                        params.put(param, value);
                    }
                    String masterReply = masterServer.sendXML(transConfiguration.getXML(), "/kettle/registerTrans/?xml=Y");
                    WebResult webResult = WebResult.fromXMLString((String)masterReply);
                    if (!webResult.getResult().equalsIgnoreCase("OK")) {
                        throw new KettleException("An error occurred sending the master transformation: " + webResult.getMessage());
                    }
                    carteObjectMap.put(master, webResult.getId());
                }
            }
            for (i = 0; i < slaves.length; ++i) {
                final int index = i;
                final TransMeta slaveTrans = transSplitter.getSlaveTransMap().get(slaves[i]);
                if (!executionConfiguration.isClusterPosting()) continue;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TransExecutionConfiguration slaveTransExecutionConfiguration = (TransExecutionConfiguration)executionConfiguration.clone();
                            TransConfiguration transConfiguration = new TransConfiguration(slaveTrans, slaveTransExecutionConfiguration);
                            Map<String, String> variables = slaveTransExecutionConfiguration.getVariables();
                            variables.put("Internal.Slave.Transformation.Number", Integer.toString(index));
                            variables.put("Internal.Slave.Server.Name", slaves[index].getName());
                            variables.put("Internal.Cluster.Size", Integer.toString(slaves.length));
                            variables.put("Internal.Cluster.Master", "N");
                            Map<String, String> params = slaveTransExecutionConfiguration.getParams();
                            TransMeta ot = transSplitter.getOriginalTransformation();
                            for (String param : ot.listParameters()) {
                                String value = Const.NVL((String)ot.getParameterValue(param), (String)Const.NVL((String)ot.getParameterDefault(param), (String)ot.getVariable(param)));
                                params.put(param, value);
                            }
                            String slaveReply = slaves[index].sendXML(transConfiguration.getXML(), "/kettle/registerTrans/?xml=Y");
                            WebResult webResult = WebResult.fromXMLString((String)slaveReply);
                            if (!webResult.getResult().equalsIgnoreCase("OK")) {
                                throw new KettleException("An error occurred sending a slave transformation: " + webResult.getMessage());
                            }
                            carteObjectMap.put(slaveTrans, webResult.getId());
                        }
                        catch (Throwable t) {
                            errors[index] = t;
                        }
                    }
                };
                threads[i] = new Thread(runnable);
            }
            for (i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                threads[i].join();
                if (errors[i] == null) continue;
                throw new KettleException(errors[i]);
            }
            if (executionConfiguration.isClusterPosting()) {
                WebResult webResult;
                String slaveReply;
                String carteObjectId;
                TransMeta slaveTrans;
                WebResult webResult2;
                String masterReply;
                if (executionConfiguration.isClusterPreparing()) {
                    if (masterSteps.size() > 0) {
                        String carteObjectId2 = carteObjectMap.get(master);
                        masterReply = masterServer.execService("/kettle/prepareExec/?name=" + URLEncoder.encode(master.getName(), "UTF-8") + "&id=" + URLEncoder.encode(carteObjectId2, "UTF-8") + "&xml=Y");
                        webResult2 = WebResult.fromXMLString((String)masterReply);
                        if (!webResult2.getResult().equalsIgnoreCase("OK")) {
                            throw new KettleException("An error occurred while preparing the execution of the master transformation: " + webResult2.getMessage());
                        }
                    }
                    for (i = 0; i < slaves.length; ++i) {
                        slaveTrans = transSplitter.getSlaveTransMap().get(slaves[i]);
                        carteObjectId = carteObjectMap.get(slaveTrans);
                        slaveReply = slaves[i].execService("/kettle/prepareExec/?name=" + URLEncoder.encode(slaveTrans.getName(), "UTF-8") + "&id=" + URLEncoder.encode(carteObjectId, "UTF-8") + "&xml=Y");
                        webResult = WebResult.fromXMLString((String)slaveReply);
                        if (webResult.getResult().equalsIgnoreCase("OK")) continue;
                        throw new KettleException("An error occurred while preparing the execution of a slave transformation: " + webResult.getMessage());
                    }
                }
                if (executionConfiguration.isClusterStarting()) {
                    if (masterSteps.size() > 0) {
                        String carteObjectId3 = carteObjectMap.get(master);
                        masterReply = masterServer.execService("/kettle/startExec/?name=" + URLEncoder.encode(master.getName(), "UTF-8") + "&id=" + URLEncoder.encode(carteObjectId3, "UTF-8") + "&xml=Y");
                        webResult2 = WebResult.fromXMLString((String)masterReply);
                        if (!webResult2.getResult().equalsIgnoreCase("OK")) {
                            throw new KettleException("An error occurred while starting the execution of the master transformation: " + webResult2.getMessage());
                        }
                    }
                    for (int i2 = 0; i2 < slaves.length; ++i2) {
                        slaveTrans = transSplitter.getSlaveTransMap().get(slaves[i2]);
                        carteObjectId = carteObjectMap.get(slaveTrans);
                        slaveReply = slaves[i2].execService("/kettle/startExec/?name=" + URLEncoder.encode(slaveTrans.getName(), "UTF-8") + "&id=" + URLEncoder.encode(carteObjectId, "UTF-8") + "&xml=Y");
                        webResult = WebResult.fromXMLString((String)slaveReply);
                        if (webResult.getResult().equalsIgnoreCase("OK")) continue;
                        throw new KettleException("An error occurred while starting the execution of a slave transformation: " + webResult.getMessage());
                    }
                }
            }
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException("There was an error during transformation split", (Throwable)e);
        }
    }

    public static final long monitorClusteredTransformation(LogChannelInterface log, TransSplitter transSplitter, Job parentJob) {
        return Trans.monitorClusteredTransformation(log, transSplitter, parentJob, 1);
    }

    public static final long monitorClusteredTransformation(LogChannelInterface log, TransSplitter transSplitter, Job parentJob, int sleepTimeSeconds) {
        SlaveServer masterServer;
        long errors = 0L;
        SlaveServer[] slaveServers = transSplitter.getSlaveTargets();
        TransMeta[] slaves = transSplitter.getSlaves();
        Map<TransMeta, String> carteObjectMap = transSplitter.getCarteObjectMap();
        try {
            masterServer = transSplitter.getMasterServer();
        }
        catch (KettleException e) {
            log.logError("Error getting the master server", (Throwable)e);
            masterServer = null;
            ++errors;
        }
        TransMeta masterTransMeta = transSplitter.getMaster();
        boolean allFinished = false;
        while (!(allFinished || errors != 0L || parentJob != null && parentJob.isStopped())) {
            String carteObjectId;
            int s;
            allFinished = true;
            errors = 0L;
            for (s = 0; s < slaveServers.length && allFinished && errors == 0L; ++s) {
                try {
                    carteObjectId = carteObjectMap.get(slaves[s]);
                    SlaveServerTransStatus transStatus = slaveServers[s].getTransStatus(slaves[s].getName(), carteObjectId, 0);
                    if (transStatus.isRunning()) {
                        if (log.isDetailed()) {
                            log.logDetailed("Slave transformation on '" + slaveServers[s] + "' is still running.");
                        }
                        allFinished = false;
                    } else if (log.isDetailed()) {
                        log.logDetailed("Slave transformation on '" + slaveServers[s] + "' has finished.");
                    }
                    errors += transStatus.getNrStepErrors();
                    continue;
                }
                catch (Exception e) {
                    ++errors;
                    log.logError("Unable to contact slave server '" + slaveServers[s].getName() + "' to check slave transformation : " + e.toString());
                }
            }
            if (allFinished && errors == 0L && masterTransMeta != null && masterTransMeta.nrSteps() > 0) {
                try {
                    String carteObjectId2 = carteObjectMap.get(masterTransMeta);
                    SlaveServerTransStatus transStatus = masterServer.getTransStatus(masterTransMeta.getName(), carteObjectId2, 0);
                    if (transStatus.isRunning()) {
                        if (log.isDetailed()) {
                            log.logDetailed("Master transformation is still running.");
                        }
                        allFinished = false;
                    } else if (log.isDetailed()) {
                        log.logDetailed("Master transformation has finished.");
                    }
                    Result result = transStatus.getResult(transSplitter.getOriginalTransformation());
                    errors += result.getNrErrors();
                }
                catch (Exception e) {
                    ++errors;
                    log.logError("Unable to contact master server '" + masterServer.getName() + "' to check master transformation : " + e.toString());
                }
            }
            if (parentJob != null && parentJob.isStopped() || errors != 0L) {
                for (s = 0; s < slaveServers.length && allFinished && errors == 0L; ++s) {
                    try {
                        carteObjectId = carteObjectMap.get(slaves[s]);
                        WebResult webResult = slaveServers[s].stopTransformation(slaves[s].getName(), carteObjectId);
                        if ("OK".equals(webResult.getResult())) continue;
                        log.logError("Unable to stop slave transformation '" + slaves[s].getName() + "' : " + webResult.getMessage());
                        continue;
                    }
                    catch (Exception e) {
                        ++errors;
                        log.logError("Unable to contact slave server '" + slaveServers[s].getName() + "' to stop transformation : " + e.toString());
                    }
                }
                try {
                    String carteObjectId3 = carteObjectMap.get(masterTransMeta);
                    WebResult webResult = masterServer.stopTransformation(masterTransMeta.getName(), carteObjectId3);
                    if (!"OK".equals(webResult.getResult())) {
                        log.logError("Unable to stop master transformation '" + masterServer.getName() + "' : " + webResult.getMessage());
                    }
                }
                catch (Exception e) {
                    ++errors;
                    log.logError("Unable to contact master server '" + masterServer.getName() + "' to stop the master : " + e.toString());
                }
            }
            if (allFinished) continue;
            if (log.isDetailed()) {
                log.logDetailed("Clustered transformation is still running, waiting a few seconds...");
            }
            try {
                Thread.sleep((long)sleepTimeSeconds * 2000L);
            }
            catch (Exception exception) {}
        }
        log.logBasic("All transformations in the cluster have finished.");
        return errors += (long)Trans.cleanupCluster(log, transSplitter);
    }

    public static int cleanupCluster(LogChannelInterface log, TransSplitter transSplitter) {
        SlaveServer masterServer;
        SlaveServer[] slaveServers = transSplitter.getSlaveTargets();
        TransMeta[] slaves = transSplitter.getSlaves();
        try {
            masterServer = transSplitter.getMasterServer();
        }
        catch (KettleException e) {
            log.logError("Unable to obtain the master server from the cluster", (Throwable)e);
            return 1;
        }
        TransMeta masterTransMeta = transSplitter.getMaster();
        int errors = 0;
        for (int s = 0; s < slaveServers.length; ++s) {
            try {
                Trans.cleanupSlaveServer(transSplitter, slaveServers[s], slaves[s]);
                continue;
            }
            catch (Exception e) {
                ++errors;
                log.logError("Unable to contact slave server '" + slaveServers[s].getName() + "' to clean up slave transformation", (Throwable)e);
            }
        }
        if (masterTransMeta != null && masterTransMeta.nrSteps() > 0) {
            try {
                Trans.cleanupSlaveServer(transSplitter, masterServer, masterTransMeta);
            }
            catch (Exception e) {
                ++errors;
                log.logError("Unable to contact master server '" + masterServer.getName() + "' to clean up master transformation", (Throwable)e);
            }
            try {
                masterServer.deAllocateServerSockets(transSplitter.getOriginalTransformation().getName(), transSplitter.getClusteredRunId());
            }
            catch (Exception e) {
                ++errors;
                log.logError("Unable to contact master server '" + masterServer.getName() + "' to clean up port sockets for transformation'" + transSplitter.getOriginalTransformation().getName() + "'", (Throwable)e);
            }
        }
        return errors;
    }

    public static void cleanupSlaveServer(TransSplitter transSplitter, SlaveServer slaveServer, TransMeta slaveTransMeta) throws KettleException {
        String transName = slaveTransMeta.getName();
        try {
            String carteObjectId = transSplitter.getCarteObjectMap().get(slaveTransMeta);
            WebResult webResult = slaveServer.cleanupTransformation(transName, carteObjectId);
            if (!"OK".equals(webResult.getResult())) {
                throw new KettleException("Unable to run clean-up on slave server '" + slaveServer + "' for transformation '" + transName + "' : " + webResult.getMessage());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error contacting slave server '" + slaveServer + "' to clear up transformation '" + transName + "'", (Throwable)e);
        }
    }

    public static final Result getClusteredTransformationResult(LogChannelInterface log, TransSplitter transSplitter, Job parentJob) {
        return Trans.getClusteredTransformationResult(log, transSplitter, parentJob, false);
    }

    public static final Result getClusteredTransformationResult(LogChannelInterface log, TransSplitter transSplitter, Job parentJob, boolean loggingRemoteWork) {
        SlaveServer masterServer;
        Result result = new Result();
        SlaveServer[] slaveServers = transSplitter.getSlaveTargets();
        TransMeta[] slaves = transSplitter.getSlaves();
        try {
            masterServer = transSplitter.getMasterServer();
        }
        catch (KettleException e) {
            log.logError("Error getting the master server", (Throwable)e);
            masterServer = null;
            result.setNrErrors(result.getNrErrors() + 1L);
        }
        TransMeta master = transSplitter.getMaster();
        for (int s = 0; s < slaveServers.length; ++s) {
            try {
                SlaveServerTransStatus transStatus = slaveServers[s].getTransStatus(slaves[s].getName(), "", 0);
                Result transResult = transStatus.getResult(slaves[s]);
                result.add(transResult);
                if (!loggingRemoteWork) continue;
                log.logBasic("-- Slave : " + slaveServers[s].getName());
                log.logBasic(transStatus.getLoggingString());
                continue;
            }
            catch (Exception e) {
                result.setNrErrors(result.getNrErrors() + 1L);
                log.logError("Unable to contact slave server '" + slaveServers[s].getName() + "' to get result of slave transformation : " + e.toString());
            }
        }
        if (master != null && master.nrSteps() > 0) {
            try {
                SlaveServerTransStatus transStatus = masterServer.getTransStatus(master.getName(), "", 0);
                Result transResult = transStatus.getResult(master);
                result.add(transResult);
                if (loggingRemoteWork) {
                    log.logBasic("-- Master : " + masterServer.getName());
                    log.logBasic(transStatus.getLoggingString());
                }
            }
            catch (Exception e) {
                result.setNrErrors(result.getNrErrors() + 1L);
                log.logError("Unable to contact master server '" + masterServer.getName() + "' to get result of master transformation : " + e.toString());
            }
        }
        return result;
    }

    public static String sendToSlaveServer(TransMeta transMeta, TransExecutionConfiguration executionConfiguration, Repository repository, IMetaStore metaStore) throws KettleException {
        SlaveServer slaveServer = executionConfiguration.getRemoteServer();
        if (slaveServer == null) {
            throw new KettleException("No slave server specified");
        }
        if (Utils.isEmpty((CharSequence)transMeta.getName())) {
            throw new KettleException("The transformation needs a name to uniquely identify it by on the remote server.");
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        for (String var : Const.INTERNAL_TRANS_VARIABLES) {
            vars.put(var, transMeta.getVariable(var));
        }
        for (String var : Const.INTERNAL_JOB_VARIABLES) {
            vars.put(var, transMeta.getVariable(var));
        }
        executionConfiguration.getVariables().putAll(vars);
        slaveServer.injectVariables(executionConfiguration.getVariables());
        slaveServer.getLogChannel().setLogLevel(executionConfiguration.getLogLevel());
        try {
            String carteObjectId;
            if (executionConfiguration.isPassingExport()) {
                FileObject tempFile = KettleVFS.createTempFile((String)"transExport", (KettleVFS.Suffix)KettleVFS.Suffix.ZIP, (VariableSpace)transMeta);
                TransExecutionConfiguration clonedConfiguration = (TransExecutionConfiguration)executionConfiguration.clone();
                clonedConfiguration.setRepository(null);
                TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(tempFile.getName().toString(), transMeta, transMeta, repository, metaStore, clonedConfiguration.getXML(), CONFIGURATION_IN_EXPORT_FILENAME);
                String result = slaveServer.sendExport(topLevelResource.getArchiveName(), "trans", topLevelResource.getBaseResourceName());
                WebResult webResult = WebResult.fromXMLString((String)result);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    throw new KettleException("There was an error passing the exported transformation to the remote server: " + Const.CR + webResult.getMessage());
                }
                carteObjectId = webResult.getId();
            } else {
                String xml = new TransConfiguration(transMeta, executionConfiguration).getXML();
                String reply = slaveServer.sendXML(xml, "/kettle/registerTrans/?xml=Y");
                WebResult webResult = WebResult.fromXMLString((String)reply);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    throw new KettleException("There was an error posting the transformation on the remote server: " + Const.CR + webResult.getMessage());
                }
                carteObjectId = webResult.getId();
            }
            String reply = slaveServer.execService("/kettle/prepareExec/?name=" + URLEncoder.encode(transMeta.getName(), "UTF-8") + "&xml=Y&id=" + carteObjectId);
            WebResult webResult = WebResult.fromXMLString((String)reply);
            if (!webResult.getResult().equalsIgnoreCase("OK")) {
                throw new KettleException("There was an error preparing the transformation for excution on the remote server: " + Const.CR + webResult.getMessage());
            }
            reply = slaveServer.execService("/kettle/startExec/?name=" + URLEncoder.encode(transMeta.getName(), "UTF-8") + "&xml=Y&id=" + carteObjectId);
            webResult = WebResult.fromXMLString((String)reply);
            if (!webResult.getResult().equalsIgnoreCase("OK")) {
                throw new KettleException("There was an error starting the transformation on the remote server: " + Const.CR + webResult.getMessage());
            }
            return carteObjectId;
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public boolean isReadyToStart() {
        return this.readyToStart;
    }

    protected void setReadyToStart(boolean ready) {
        this.readyToStart = ready;
    }

    public void setInternalKettleVariables(VariableSpace var) {
        boolean hasFilename;
        boolean bl = hasFilename = this.transMeta != null && !Utils.isEmpty((CharSequence)this.transMeta.getFilename());
        if (hasFilename) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.transMeta.getFilename(), (VariableSpace)var);
                FileName fileName = fileObject.getName();
                this.variables.setVariable("Internal.Transformation.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                this.variables.setVariable("Internal.Transformation.Filename.Directory", fileDir.getURI());
            }
            catch (KettleFileException e) {
                this.variables.setVariable("Internal.Transformation.Filename.Directory", "");
                this.variables.setVariable("Internal.Transformation.Filename.Name", "");
            }
        } else {
            this.variables.setVariable("Internal.Transformation.Filename.Directory", "");
            this.variables.setVariable("Internal.Transformation.Filename.Name", "");
        }
        boolean hasRepoDir = this.transMeta.getRepositoryDirectory() != null && this.transMeta.getRepository() != null;
        this.variables.setVariable("Internal.Transformation.Name", Const.NVL((String)this.transMeta.getName(), (String)""));
        if (hasRepoDir) {
            this.variables.setVariable("Internal.Transformation.Filename.Directory", this.variables.getVariable("Internal.Transformation.Repository.Directory"));
        } else {
            this.variables.setVariable("Internal.Transformation.Repository.Directory", this.variables.getVariable("Internal.Transformation.Filename.Directory"));
        }
        this.variables.setVariable("Internal.Transformation.Repository.Directory", this.transMeta.getRepositoryDirectory() != null ? this.transMeta.getRepositoryDirectory().getPath() : "");
        if (hasRepoDir) {
            this.variables.setVariable("Internal.Entry.Current.Directory", this.variables.getVariable("Internal.Transformation.Repository.Directory"));
            if ("/".equals(this.variables.getVariable("Internal.Entry.Current.Directory"))) {
                this.variables.setVariable("Internal.Entry.Current.Directory", "");
            }
        }
        this.setInternalEntryCurrentDirectory(hasFilename, hasRepoDir);
    }

    protected void setInternalEntryCurrentDirectory(boolean hasFilename, boolean hasRepoDir) {
        this.variables.setVariable("Internal.Entry.Current.Directory", this.variables.getVariable(hasRepoDir ? "Internal.Transformation.Repository.Directory" : (hasFilename ? "Internal.Transformation.Filename.Directory" : "Internal.Entry.Current.Directory")));
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty((CharSequence)variableName) && !Utils.isEmpty((CharSequence)(value = this.environmentSubstitute(variableName)))) {
            return ValueMetaString.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public void pauseRunning() {
        this.setPaused(true);
        for (StepMetaDataCombi combi : this.steps) {
            combi.step.pauseRunning();
        }
    }

    public void resumeRunning() {
        for (StepMetaDataCombi combi : this.steps) {
            combi.step.resumeRunning();
        }
        this.setPaused(false);
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public Repository getRepository() {
        if (this.repository == null && this.transMeta != null) {
            return this.transMeta.getRepository();
        }
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
        if (this.transMeta != null) {
            this.transMeta.setRepository(repository);
        }
    }

    public Map<String, List<StepPerformanceSnapShot>> getStepPerformanceSnapShots() {
        return this.stepPerformanceSnapShots;
    }

    public void setStepPerformanceSnapShots(Map<String, List<StepPerformanceSnapShot>> stepPerformanceSnapShots) {
        this.stepPerformanceSnapShots = stepPerformanceSnapShots;
    }

    public List<TransListener> getTransListeners() {
        return this.transListeners;
    }

    public void setTransListeners(List<TransListener> transListeners) {
        this.transListeners = Collections.synchronizedList(transListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransListener(TransListener transListener) {
        List<TransListener> list = this.transListeners;
        synchronized (list) {
            this.transListeners.add(transListener);
        }
    }

    public void setTransStoppedListeners(List<TransStoppedListener> transStoppedListeners) {
        this.transStoppedListeners = Collections.synchronizedList(transStoppedListeners);
    }

    public List<TransStoppedListener> getTransStoppedListeners() {
        return this.transStoppedListeners;
    }

    public void addTransStoppedListener(TransStoppedListener transStoppedListener) {
        this.transStoppedListeners.add(transStoppedListener);
    }

    public boolean isPaused() {
        int exist = this.status.get() & BitMaskStatus.PAUSED.mask;
        return exist != 0;
    }

    public void setPaused(boolean paused) {
        this.status.updateAndGet(v -> paused ? v | BitMaskStatus.PAUSED.mask : (0x3F ^ BitMaskStatus.PAUSED.mask) & v);
    }

    public boolean isStopped() {
        int exist = this.status.get() & BitMaskStatus.STOPPED.mask;
        return exist != 0;
    }

    public void setStopped(boolean stopped) {
        this.status.updateAndGet(v -> stopped ? v | BitMaskStatus.STOPPED.mask : (0x3F ^ BitMaskStatus.STOPPED.mask) & v);
    }

    public static void monitorRemoteTransformation(LogChannelInterface log, String carteObjectId, String transName, SlaveServer remoteSlaveServer) {
        Trans.monitorRemoteTransformation(log, carteObjectId, transName, remoteSlaveServer, 5);
    }

    public static void monitorRemoteTransformation(LogChannelInterface log, String carteObjectId, String transName, SlaveServer remoteSlaveServer, int sleepTimeSeconds) {
        long errors = 0L;
        boolean allFinished = false;
        while (!allFinished && errors == 0L) {
            allFinished = true;
            errors = 0L;
            if (allFinished && errors == 0L) {
                try {
                    SlaveServerTransStatus transStatus = remoteSlaveServer.getTransStatus(transName, carteObjectId, 0);
                    if (transStatus.isRunning()) {
                        if (log.isDetailed()) {
                            log.logDetailed(transName, new Object[]{"Remote transformation is still running."});
                        }
                        allFinished = false;
                    } else if (log.isDetailed()) {
                        log.logDetailed(transName, new Object[]{"Remote transformation has finished."});
                    }
                    Result result = transStatus.getResult();
                    errors += result.getNrErrors();
                }
                catch (Exception e) {
                    ++errors;
                    log.logError(transName, new Object[]{"Unable to contact remote slave server '" + remoteSlaveServer.getName() + "' to check transformation status : " + e.toString()});
                }
            }
            if (allFinished) continue;
            if (log.isDetailed()) {
                log.logDetailed(transName, new Object[]{"The remote transformation is still running, waiting a few seconds..."});
            }
            try {
                Thread.sleep(sleepTimeSeconds * 1000);
            }
            catch (Exception e) {}
        }
        log.logMinimal(transName, new Object[]{"The remote transformation has finished."});
        try {
            WebResult webResult = remoteSlaveServer.cleanupTransformation(transName, carteObjectId);
            if (!"OK".equals(webResult.getResult())) {
                log.logError(transName, new Object[]{"Unable to run clean-up on remote transformation '" + transName + "' : " + webResult.getMessage()});
                ++errors;
            }
        }
        catch (Exception e) {
            ++errors;
            log.logError(transName, new Object[]{"Unable to contact slave server '" + remoteSlaveServer.getName() + "' to clean up transformation : " + e.toString()});
        }
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void eraseParameters() {
        this.namedParams.eraseParameters();
    }

    public void clearParameters() {
        this.namedParams.clearParameters();
    }

    public void activateParameters() {
        String[] keys;
        for (String key : keys = this.listParameters()) {
            String defValue;
            String value;
            try {
                value = this.getParameterValue(key);
            }
            catch (UnknownParamException e) {
                value = "";
            }
            try {
                defValue = this.getParameterDefault(key);
            }
            catch (UnknownParamException e) {
                defValue = "";
            }
            if (Utils.isEmpty((CharSequence)value)) {
                this.setVariable(key, Const.NVL((String)defValue, (String)""));
                continue;
            }
            this.setVariable(key, Const.NVL((String)value, (String)""));
        }
    }

    public void copyParametersFrom(NamedParams params) {
        this.namedParams.copyParametersFrom(params);
    }

    public void mergeParametersWith(NamedParams params, boolean replace) {
        this.namedParams.mergeParametersWith(params, replace);
    }

    public Trans getParentTrans() {
        return this.parentTrans;
    }

    public void setParentTrans(Trans parentTrans) {
        this.logLevel = parentTrans.getLogLevel();
        this.log.setLogLevel(this.logLevel);
        this.parentTrans = parentTrans;
        this.transactionId = this.calculateTransactionId();
    }

    public String getMappingStepName() {
        return this.mappingStepName;
    }

    public void setMappingStepName(String mappingStepName) {
        this.mappingStepName = mappingStepName;
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    public String getObjectName() {
        return this.getName();
    }

    public String getObjectCopy() {
        return null;
    }

    public String getFilename() {
        if (this.transMeta == null) {
            return null;
        }
        return this.transMeta.getFilename();
    }

    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    public ObjectId getObjectId() {
        if (this.transMeta == null) {
            return null;
        }
        return this.transMeta.getObjectId();
    }

    public ObjectRevision getObjectRevision() {
        if (this.transMeta == null) {
            return null;
        }
        return this.transMeta.getObjectRevision();
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.TRANS;
    }

    public LoggingObjectInterface getParent() {
        return this.parent;
    }

    public RepositoryDirectoryInterface getRepositoryDirectory() {
        if (this.transMeta == null) {
            return null;
        }
        return this.transMeta.getRepositoryDirectory();
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        this.log.setLogLevel(logLevel);
    }

    public List<LoggingHierarchy> getLoggingHierarchy() {
        ArrayList<LoggingHierarchy> hierarchy = new ArrayList<LoggingHierarchy>();
        List childIds = LoggingRegistry.getInstance().getLogChannelChildren(this.getLogChannelId());
        for (String childId : childIds) {
            LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(childId);
            if (loggingObject == null) continue;
            hierarchy.add(new LoggingHierarchy(this.getLogChannelId(), this.batchId, loggingObject));
        }
        return hierarchy;
    }

    @Deprecated
    public Map<String, Trans> getActiveSubtransformations() {
        return this.activeSubtransformations;
    }

    public void addActiveSubTransformation(String subTransName, Trans subTrans) {
        this.activeSubtransformations.put(subTransName, subTrans);
    }

    public Trans removeActiveSubTransformation(String subTransName) {
        return this.activeSubtransformations.remove(subTransName);
    }

    public Trans getActiveSubTransformation(String subTransName) {
        return this.activeSubtransformations.get(subTransName);
    }

    public Map<String, Job> getActiveSubjobs() {
        return this.activeSubjobs;
    }

    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    public void setContainerObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    public Date getRegistrationDate() {
        return null;
    }

    public void setServletPrintWriter(PrintWriter servletPrintWriter) {
        this.servletPrintWriter = servletPrintWriter;
    }

    public PrintWriter getServletPrintWriter() {
        return this.servletPrintWriter;
    }

    @Override
    public String getExecutingServer() {
        if (this.executingServer == null) {
            this.setExecutingServer(Const.getHostname());
        }
        return this.executingServer;
    }

    @Override
    public void setExecutingServer(String executingServer) {
        this.executingServer = executingServer;
    }

    @Override
    public String getExecutingUser() {
        return this.executingUser;
    }

    @Override
    public void setExecutingUser(String executingUser) {
        this.executingUser = executingUser;
    }

    public boolean isGatheringMetrics() {
        return this.log != null && this.log.isGatheringMetrics();
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        if (this.log != null) {
            this.log.setGatheringMetrics(gatheringMetrics);
        }
    }

    public boolean isForcingSeparateLogging() {
        return this.log != null && this.log.isForcingSeparateLogging();
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        if (this.log != null) {
            this.log.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }

    public List<ResultFile> getResultFiles() {
        return this.resultFiles;
    }

    public void setResultFiles(List<ResultFile> resultFiles) {
        this.resultFiles = resultFiles;
    }

    public List<RowMetaAndData> getResultRows() {
        return this.resultRows;
    }

    public void setResultRows(List<RowMetaAndData> resultRows) {
        this.resultRows = resultRows;
    }

    public Result getPreviousResult() {
        return this.previousResult;
    }

    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    public Hashtable<String, Counter> getCounters() {
        return this.counters;
    }

    public void setCounters(Hashtable<String, Counter> counters) {
        this.counters = counters;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public void clearError() {
        this.setStopped(false);
        this.errors.set(0);
        this.setFinished(false);
        for (StepMetaDataCombi combi : this.steps) {
            StepInterface step = combi.step;
            for (RowSet rowSet : step.getInputRowSets()) {
                rowSet.clear();
            }
            step.setStopped(false);
        }
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String calculateTransactionId() {
        if (this.getTransMeta() != null && this.getTransMeta().isUsingUniqueConnections()) {
            if (this.parentJob != null && this.parentJob.getTransactionId() != null) {
                return this.parentJob.getTransactionId();
            }
            if (this.parentTrans != null && this.parentTrans.getTransMeta().isUsingUniqueConnections()) {
                return this.parentTrans.getTransactionId();
            }
            return DatabaseConnectionMap.getInstance().getNextTransactionId();
        }
        return Thread.currentThread().getName();
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
        if (this.transMeta != null) {
            this.transMeta.setMetaStore(metaStore);
        }
    }

    public void setServletReponse(HttpServletResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("HttpServletResponse cannot be null ");
        }
        String encoding = System.getProperty("KETTLE_DEFAULT_SERVLET_ENCODING", null);
        if (!StringUtils.isBlank((String)encoding)) {
            try {
                response.setCharacterEncoding(encoding.trim());
                response.setContentType("text/html; charset=" + encoding);
            }
            catch (Exception ex) {
                LogChannel.GENERAL.logError("Unable to encode data with encoding : '" + encoding + "'", (Throwable)ex);
            }
        }
        this.servletResponse = response;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public List<DelegationListener> getDelegationListeners() {
        return this.delegationListeners;
    }

    public void setDelegationListeners(List<DelegationListener> delegationListeners) {
        this.delegationListeners = delegationListeners;
    }

    public void addDelegationListener(DelegationListener delegationListener) {
        this.delegationListeners.add(delegationListener);
    }

    public synchronized void doTopologySortOfSteps() {
        this.transMeta.clearCaches();
        int stepsMinSize = 0;
        int stepsSize = this.steps.size();
        int windowShrinkThreshold = (int)Math.round((double)stepsSize * 0.75);
        int totalIterations = stepsSize * 2;
        boolean isBefore = false;
        boolean forwardChange = false;
        boolean backwardChange = false;
        boolean lastForwardChange = true;
        boolean keepSortingForward = true;
        StepMetaDataCombi one = null;
        StepMetaDataCombi two = null;
        for (int x = 0; x < totalIterations; ++x) {
            if (keepSortingForward) {
                for (int y = stepsMinSize; y < stepsSize - 1; ++y) {
                    one = this.steps.get(y);
                    two = this.steps.get(y + 1);
                    isBefore = one.stepMeta.equals(two.stepMeta) ? one.copy > two.copy : this.transMeta.findPrevious(one.stepMeta, two.stepMeta);
                    if (!isBefore) continue;
                    this.steps.set(y, two);
                    this.steps.set(y + 1, one);
                    forwardChange = true;
                }
            }
            for (int z = stepsSize - 1; z > stepsMinSize; --z) {
                one = this.steps.get(z);
                two = this.steps.get(z - 1);
                isBefore = one.stepMeta.equals(two.stepMeta) ? one.copy > two.copy : this.transMeta.findPrevious(one.stepMeta, two.stepMeta);
                if (isBefore) continue;
                this.steps.set(z, two);
                this.steps.set(z - 1, one);
                backwardChange = true;
            }
            if (x > windowShrinkThreshold && !forwardChange && --stepsSize <= stepsMinSize || x > windowShrinkThreshold && !backwardChange && ++stepsMinSize >= stepsSize || !forwardChange && !backwardChange) break;
            if (keepSortingForward && x > 0 && !lastForwardChange && !forwardChange) {
                keepSortingForward = false;
            }
            lastForwardChange = forwardChange;
            forwardChange = false;
            backwardChange = false;
        }
    }

    public void setResultRowSet(boolean resultRowsSet) {
        this.resultRowsSet = resultRowsSet;
    }

    public boolean isResultRowsSet() {
        return this.resultRowsSet;
    }

    public boolean isExecutingClustered() {
        return this.executingClustered;
    }

    public void setExecutingClustered(boolean executingClustered) {
        this.executingClustered = executingClustered;
    }

    public Map<String, Object> getExtensionDataMap() {
        return this.extensionDataMap;
    }

    protected ExecutorService startHeartbeat(final long intervalInSeconds) {
        ScheduledExecutorService heartbeat = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Transformation Heartbeat Thread for: " + Trans.this.getName());
                thread.setDaemon(true);
                return thread;
            }
        });
        heartbeat.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Trans.this.isFinished()) {
                        Trans.this.log.logBasic("Shutting down heartbeat signal for " + Trans.this.getName());
                        Trans.this.shutdownHeartbeat(Trans.this.heartbeat);
                        return;
                    }
                    Trans.this.log.logDebug("Triggering heartbeat signal for " + Trans.this.getName() + " at every " + intervalInSeconds + " seconds");
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)Trans.this.log, (String)KettleExtensionPoint.TransformationHeartbeat.id, (Object)Trans.this);
                }
                catch (KettleException e) {
                    Trans.this.log.logError(e.getMessage(), (Throwable)e);
                }
            }
        }, intervalInSeconds, intervalInSeconds, TimeUnit.SECONDS);
        return heartbeat;
    }

    protected void shutdownHeartbeat(ExecutorService heartbeat) {
        if (heartbeat != null) {
            try {
                heartbeat.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private int getHeartbeatIntervalInSeconds() {
        TransMeta meta = this.getTransMeta();
        try {
            if (meta != null) {
                return Const.toInt((String)meta.getParameterValue("heartbeat.periodic.interval.seconds"), (int)Const.toInt((String)meta.getParameterDefault("heartbeat.periodic.interval.seconds"), (int)10));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 10;
    }

    static enum BitMaskStatus {
        RUNNING(1),
        INITIALIZING(2),
        PREPARING(4),
        STOPPED(8),
        FINISHED(16),
        PAUSED(32);

        private final int mask;
        public static final int BIT_STATUS_SUM = 63;

        private BitMaskStatus(int mask) {
            this.mask = mask;
        }
    }
}

