/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.numberrange;

import java.util.LinkedList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.numberrange.NumberRange;
import org.pentaho.di.trans.steps.numberrange.NumberRangeData;
import org.pentaho.di.trans.steps.numberrange.NumberRangeRule;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class NumberRangeMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String inputField;
    private String outputField;
    private String fallBackValue;
    private List<NumberRangeRule> rules;

    public NumberRangeMeta() {
    }

    public void emptyRules() {
        this.rules = new LinkedList<NumberRangeRule>();
    }

    public NumberRangeMeta(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.loadXML(stepnode, databases, metaStore);
    }

    public NumberRangeMeta(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.readRep(rep, metaStore, id_step, databases);
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XMLHandler.addTagValue((String)"inputField", (String)this.inputField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"outputField", (String)this.outputField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fallBackValue", (String)this.getFallBackValue()));
        retval.append("    <rules>").append(Const.CR);
        for (NumberRangeRule rule : this.rules) {
            retval.append("      <rule>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"lower_bound", (double)rule.getLowerBound()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"upper_bound", (double)rule.getUpperBound()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"value", (String)rule.getValue()));
            retval.append("      </rule>").append(Const.CR);
        }
        retval.append("    </rules>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString mcValue = new ValueMetaString(this.outputField);
        mcValue.setOrigin(name);
        mcValue.setLength(255);
        row.addValueMeta((ValueMetaInterface)mcValue);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            this.inputField = XMLHandler.getTagValue((Node)stepnode, (String)"inputField");
            this.outputField = XMLHandler.getTagValue((Node)stepnode, (String)"outputField");
            this.emptyRules();
            String fallBackValue = XMLHandler.getTagValue((Node)stepnode, (String)"fallBackValue");
            this.setFallBackValue(fallBackValue);
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"rules");
            int count = XMLHandler.countNodes((Node)fields, (String)"rule");
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"rule", (int)i);
                String lowerBoundStr = XMLHandler.getTagValue((Node)fnode, (String)"lower_bound");
                String upperBoundStr = XMLHandler.getTagValue((Node)fnode, (String)"upper_bound");
                String value = XMLHandler.getTagValue((Node)fnode, (String)"value");
                double lowerBound = Double.parseDouble(lowerBoundStr);
                double upperBound = Double.parseDouble(upperBoundStr);
                this.addRule(lowerBound, upperBound, value);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step info from XML node", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.emptyRules();
        this.setFallBackValue("unknown");
        this.addRule(-1.7976931348623157E308, 5.0, "Less than 5");
        this.addRule(5.0, 10.0, "5-10");
        this.addRule(10.0, Double.MAX_VALUE, "More than 10");
        this.inputField = "";
        this.outputField = "range";
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.inputField = rep.getStepAttributeString(id_step, "inputField");
            this.outputField = rep.getStepAttributeString(id_step, "outputField");
            this.emptyRules();
            String fallBackValue = rep.getStepAttributeString(id_step, "fallBackValue");
            this.setFallBackValue(fallBackValue);
            int nrfields = rep.countNrStepAttributes(id_step, "lower_bound");
            for (int i = 0; i < nrfields; ++i) {
                String lowerBoundStr = rep.getStepAttributeString(id_step, i, "lower_bound");
                String upperBoundStr = rep.getStepAttributeString(id_step, i, "upper_bound");
                String value = rep.getStepAttributeString(id_step, i, "value");
                double lowerBound = Double.parseDouble(lowerBoundStr);
                double upperBound = Double.parseDouble(upperBoundStr);
                this.addRule(lowerBound, upperBound, value);
            }
        }
        catch (Exception dbe) {
            throw new KettleException("error reading step with id_step=" + id_step + " from the repository", (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "inputField", this.inputField);
            rep.saveStepAttribute(id_transformation, id_step, "outputField", this.outputField);
            rep.saveStepAttribute(id_transformation, id_step, "fallBackValue", this.getFallBackValue());
            int i = 0;
            for (NumberRangeRule rule : this.rules) {
                rep.saveStepAttribute(id_transformation, id_step, i, "lower_bound", String.valueOf(rule.getLowerBound()));
                rep.saveStepAttribute(id_transformation, id_step, i, "upper_bound", String.valueOf(rule.getUpperBound()));
                rep.saveStepAttribute(id_transformation, id_step, i, "value", String.valueOf(rule.getValue()));
                ++i;
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save step information to the repository, id_step=" + id_step, (Throwable)dbe);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
        return new NumberRange(stepMeta, stepDataInterface, cnr, transMeta, disp);
    }

    @Override
    public StepDataInterface getStepData() {
        return new NumberRangeData();
    }

    public String getInputField() {
        return this.inputField;
    }

    public String getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String outputField) {
        this.outputField = outputField;
    }

    public List<NumberRangeRule> getRules() {
        return this.rules;
    }

    public String getFallBackValue() {
        return this.fallBackValue;
    }

    public void setInputField(String inputField) {
        this.inputField = inputField;
    }

    public void setFallBackValue(String fallBackValue) {
        this.fallBackValue = fallBackValue;
    }

    public void addRule(double lowerBound, double upperBound, String value) {
        NumberRangeRule rule = new NumberRangeRule(lowerBound, upperBound, value);
        this.rules.add(rule);
    }

    public void setRules(List<NumberRangeRule> rules) {
        this.rules = rules;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

