/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pentahoreporting;

import java.awt.GraphicsEnvironment;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingOutputData;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingOutputMeta;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingSwingGuiContext;
import org.pentaho.di.trans.steps.pentahoreporting.ReportExportTask;
import org.pentaho.di.trans.steps.pentahoreporting.urlrepository.FileObjectRepository;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.ReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.csv.FastCsvExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlContentItems;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.ReportStructureValidator;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PdfOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.StreamCSVOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FileSystemURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FlowHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.StreamRTFOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.FlowExcelOutputProcessor;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PentahoReportingOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = PentahoReportingOutput.class;
    private PentahoReportingOutputMeta meta;
    private PentahoReportingOutputData data;

    public PentahoReportingOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        if (Const.isOSX()) {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (PentahoReportingOutputMeta)smi;
        this.data = (PentahoReportingOutputData)sdi;
        boolean result = true;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.inputFieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getInputFileField());
            if (this.data.inputFieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Exception.CanNotFindField", (String[])new String[]{this.meta.getInputFileField()}));
            }
            this.data.outputFieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getOutputFileField());
            if (this.data.inputFieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Exception.CanNotFindField", (String[])new String[]{this.meta.getOutputFileField()}));
            }
            PentahoReportingOutput.performPentahoReportingBoot(this.log, this.getClass());
        }
        String sourceFilename = this.getInputRowMeta().getString(r, this.data.inputFieldIndex);
        String targetFilename = this.getInputRowMeta().getString(r, this.data.outputFieldIndex);
        this.processReport(r, sourceFilename, targetFilename, this.meta.getOutputProcessorType(), this.meta.getCreateParentfolder());
        this.putRow(this.getInputRowMeta(), r);
        if (this.checkFeedback(this.getLinesOutput())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Log.LineNumber", (String[])new String[0]) + this.getLinesOutput());
        }
        return result;
    }

    public static void performPentahoReportingBoot(LogChannelInterface log, Class<?> referenceClass) {
        if (!ClassicEngineBoot.getInstance().isBootDone()) {
            ObjectUtilities.setClassLoader((ClassLoader)referenceClass.getClassLoader());
            ObjectUtilities.setClassLoaderSource((String)"ClassContext");
            LibLoaderBoot.getInstance().start();
            LibFontBoot.getInstance().start();
            ClassicEngineBoot.getInstance().start();
            Exception exception = ClassicEngineBoot.getInstance().getBootFailureReason();
            if (exception != null) {
                log.logError("Error booting the Pentaho reporting engine", (Throwable)exception);
            }
        }
    }

    public static MasterReport loadMasterReport(String sourceFilename) throws Exception {
        ResourceManager manager = new ResourceManager();
        manager.registerDefaults();
        FileObject fileObject = KettleVFS.getFileObject((String)sourceFilename);
        Resource resource = manager.createDirectly((Object)fileObject, MasterReport.class);
        MasterReport report = (MasterReport)resource.getResource();
        return report;
    }

    private void processReport(Object[] r, String sourceFilename, String targetFilename, PentahoReportingOutputMeta.ProcessorType outputProcessorType, Boolean createParentFolder) throws KettleException {
        try {
            Runnable exportTask;
            MasterReport report = PentahoReportingOutput.loadMasterReport(sourceFilename);
            ReportParameterValues values = report.getParameterValues();
            ReportParameterDefinition definition = report.getParameterDefinition();
            for (String parameterName : this.meta.getParameterFieldMap().keySet()) {
                String fieldName = this.meta.getParameterFieldMap().get(parameterName);
                if (fieldName == null) continue;
                int index = this.getInputRowMeta().indexOfValue(fieldName);
                if (index < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Exception.CanNotFindField", (String[])new String[]{fieldName}));
                }
                Class<?> clazz = this.findParameterClass(definition, parameterName);
                Object value = null;
                if (clazz != null) {
                    value = clazz.equals(String.class) ? this.getInputRowMeta().getString(r, index) : (clazz.equals(new String[0].getClass()) ? this.getInputRowMeta().getString(r, index).split("\t") : (clazz.equals(Date.class) ? this.getInputRowMeta().getDate(r, index) : (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class) ? Byte.valueOf(this.getInputRowMeta().getInteger(r, index).byteValue()) : (clazz.equals(Short.class) || clazz.equals(Short.TYPE) ? Short.valueOf(this.getInputRowMeta().getInteger(r, index).shortValue()) : (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) ? Integer.valueOf(this.getInputRowMeta().getInteger(r, index).intValue()) : (clazz.equals(Long.class) || clazz.equals(Long.TYPE) ? this.getInputRowMeta().getInteger(r, index) : (clazz.equals(Double.class) || clazz.equals(Double.TYPE) ? this.getInputRowMeta().getNumber(r, index) : (clazz.equals(Float.class) || clazz.equals(Float.TYPE) ? Float.valueOf(this.getInputRowMeta().getNumber(r, index).floatValue()) : (clazz.equals(Number.class) ? Float.valueOf(this.getInputRowMeta().getBigNumber(r, index).floatValue()) : (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE) ? this.getInputRowMeta().getBoolean(r, index) : (clazz.equals(BigDecimal.class) ? this.getInputRowMeta().getBigNumber(r, index) : (clazz.equals(new byte[0].getClass()) ? (Object)this.getInputRowMeta().getBinary(r, index) : this.getInputRowMeta().getValueMeta(index).convertToNormalStorageType(r[index])))))))))))));
                    values.put(parameterName, value);
                    continue;
                }
                this.logBasic(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Log.ParameterNotFoundInReport", (String[])new String[]{parameterName, sourceFilename}));
            }
            PentahoReportingSwingGuiContext context = new PentahoReportingSwingGuiContext();
            switch (outputProcessorType) {
                case PDF: {
                    exportTask = new ReportExportTask(report, context, targetFilename, createParentFolder){

                        @Override
                        protected ReportProcessor createReportProcessor(OutputStream fout) throws Exception {
                            PdfOutputProcessor outputProcessor = new PdfOutputProcessor(this.report.getConfiguration(), fout, this.report.getResourceManager());
                            return new PageableReportProcessor(this.report, (PageableOutputProcessor)outputProcessor);
                        }
                    };
                    break;
                }
                case CSV: {
                    exportTask = new ReportExportTask(report, context, targetFilename, createParentFolder){

                        @Override
                        protected ReportProcessor createReportProcessor(OutputStream fout) throws Exception {
                            ReportStructureValidator validator = new ReportStructureValidator();
                            if (!validator.isValidForFastProcessing(this.report)) {
                                StreamCSVOutputProcessor target = new StreamCSVOutputProcessor(fout);
                                return new StreamReportProcessor(this.report, (OutputProcessor)target);
                            }
                            return new FastCsvExportProcessor(this.report, fout);
                        }
                    };
                    break;
                }
                case Excel: {
                    exportTask = new ReportExportTask(report, context, targetFilename, createParentFolder){

                        @Override
                        protected ReportProcessor createReportProcessor(OutputStream fout) throws Exception {
                            ReportStructureValidator validator = new ReportStructureValidator();
                            if (!validator.isValidForFastProcessing(this.report)) {
                                FlowExcelOutputProcessor target = new FlowExcelOutputProcessor(this.report.getConfiguration(), fout, this.report.getResourceManager());
                                target.setUseXlsxFormat(false);
                                return new FlowReportProcessor(this.report, (OutputProcessor)target);
                            }
                            return new FastExcelExportProcessor(this.report, fout, false);
                        }
                    };
                    break;
                }
                case Excel_2007: {
                    exportTask = new ReportExportTask(report, context, targetFilename, createParentFolder){

                        @Override
                        protected ReportProcessor createReportProcessor(OutputStream fout) throws Exception {
                            ReportStructureValidator validator = new ReportStructureValidator();
                            if (!validator.isValidForFastProcessing(this.report)) {
                                FlowExcelOutputProcessor target = new FlowExcelOutputProcessor(this.report.getConfiguration(), fout, this.report.getResourceManager());
                                target.setUseXlsxFormat(true);
                                return new FlowReportProcessor(this.report, (OutputProcessor)target);
                            }
                            return new FastExcelExportProcessor(this.report, fout, true);
                        }
                    };
                    break;
                }
                case StreamingHTML: {
                    exportTask = new ReportExportTask(report, context, targetFilename, createParentFolder){
                        protected String filename;
                        protected String suffix;
                        protected ContentLocation targetRoot;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void execute() throws Exception {
                            FileObject targetDirectory = this.targetFile.getParent();
                            FileObjectRepository targetRepository = new FileObjectRepository(targetDirectory);
                            this.targetRoot = targetRepository.getRoot();
                            this.suffix = this.getSuffix(this.targetPath);
                            this.filename = IOUtils.getInstance().stripFileExtension(this.targetFile.getName().toString());
                            try (ReportProcessor reportProcessor = this.createReportProcessor(null);){
                                reportProcessor.processReport();
                            }
                        }

                        @Override
                        protected ReportProcessor createReportProcessor(OutputStream fout) throws Exception {
                            ReportStructureValidator validator = new ReportStructureValidator();
                            if (!validator.isValidForFastProcessing(this.report)) {
                                StreamHtmlOutputProcessor outputProcessor = new StreamHtmlOutputProcessor(this.report.getConfiguration());
                                AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(this.report.getResourceManager());
                                printer.setContentWriter(this.targetRoot, (NameGenerator)new DefaultNameGenerator(this.targetRoot, this.filename, this.suffix));
                                printer.setDataWriter(null, null);
                                printer.setUrlRewriter((URLRewriter)new FileSystemURLRewriter());
                                outputProcessor.setPrinter((HtmlPrinter)printer);
                                return new StreamReportProcessor(this.report, (OutputProcessor)outputProcessor);
                            }
                            FastHtmlContentItems printer = new FastHtmlContentItems();
                            printer.setContentWriter(this.targetRoot, (NameGenerator)new DefaultNameGenerator(this.targetRoot, this.filename, this.suffix));
                            printer.setDataWriter(null, null);
                            printer.setUrlRewriter((URLRewriter)new FileSystemURLRewriter());
                            return new FastHtmlExportProcessor(this.report, printer);
                        }
                    };
                    break;
                }
                case PagedHTML: {
                    exportTask = new ReportExportTask(report, context, targetFilename, createParentFolder){
                        protected String filename;
                        protected String suffix;
                        protected ContentLocation targetRoot;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void execute() throws Exception {
                            FileObject targetDirectory = this.targetFile.getParent();
                            FileObjectRepository targetRepository = new FileObjectRepository(targetDirectory);
                            this.targetRoot = targetRepository.getRoot();
                            this.suffix = this.getSuffix(this.targetPath);
                            Path p = Paths.get(this.targetFile.getName().getPath(), new String[0]);
                            this.filename = IOUtils.getInstance().stripFileExtension(p.getFileName().toString());
                            try (ReportProcessor reportProcessor = this.createReportProcessor(null);){
                                reportProcessor.processReport();
                            }
                        }

                        @Override
                        protected ReportProcessor createReportProcessor(OutputStream fout) throws Exception {
                            FlowHtmlOutputProcessor outputProcessor = new FlowHtmlOutputProcessor();
                            AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(this.report.getResourceManager());
                            printer.setContentWriter(this.targetRoot, (NameGenerator)new DefaultNameGenerator(this.targetRoot, this.filename, this.suffix));
                            printer.setDataWriter(this.targetRoot, (NameGenerator)new DefaultNameGenerator(this.targetRoot, "content"));
                            printer.setUrlRewriter((URLRewriter)new FileSystemURLRewriter());
                            outputProcessor.setPrinter((HtmlPrinter)printer);
                            return new FlowReportProcessor(this.report, (OutputProcessor)outputProcessor);
                        }
                    };
                    break;
                }
                case RTF: {
                    exportTask = new ReportExportTask(report, context, targetFilename, createParentFolder){

                        @Override
                        protected ReportProcessor createReportProcessor(OutputStream fout) throws Exception {
                            StreamRTFOutputProcessor target = new StreamRTFOutputProcessor(this.report.getConfiguration(), fout, this.report.getResourceManager());
                            return new StreamReportProcessor(this.report, (OutputProcessor)target);
                        }
                    };
                    break;
                }
                default: {
                    exportTask = null;
                }
            }
            if (exportTask != null) {
                exportTask.run();
            }
            if (context.getStatusType() == StatusType.ERROR) {
                KettleVFS.getFileObject((String)targetFilename, (VariableSpace)this.getTransMeta()).delete();
                if (context.getCause() != null) {
                    throw context.getCause();
                }
                throw new KettleStepException(context.getMessage());
            }
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)targetFilename, (VariableSpace)this.getTransMeta()), this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment("This file was created with a Pentaho Reporting Output step");
            this.addResultFile(resultFile);
        }
        catch (Throwable e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Exception.UnexpectedErrorRenderingReport", (String[])new String[]{sourceFilename, targetFilename, outputProcessorType.getDescription()}), e);
        }
    }

    private Class<?> findParameterClass(ReportParameterDefinition definition, String parameterName) {
        for (int i = 0; i < definition.getParameterCount(); ++i) {
            ParameterDefinitionEntry entry = definition.getParameterDefinition(i);
            if (!parameterName.equals(entry.getName())) continue;
            return entry.getValueType();
        }
        return null;
    }
}

