/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.replacestring;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringData;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringMeta;

public class ReplaceString
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ReplaceStringMeta.class;
    private ReplaceStringMeta meta;
    private ReplaceStringData data;

    public ReplaceString(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public static String replaceString(String originalString, Pattern pattern, String replaceByString) {
        if (originalString == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(originalString);
        if (replaceByString == null) {
            if (matcher.matches()) {
                return null;
            }
            return originalString;
        }
        return matcher.replaceAll(replaceByString);
    }

    @VisibleForTesting
    static Pattern buildPattern(boolean literalParsing, boolean caseSensitive, boolean wholeWord, String patternString, boolean isUnicode) {
        int flags = 0;
        if (literalParsing && !wholeWord) {
            flags |= 0x10;
        }
        if (!caseSensitive) {
            flags |= 2;
        }
        if (isUnicode) {
            flags |= 0x100;
        }
        if (wholeWord) {
            if (literalParsing) {
                patternString = "\\Q" + patternString + "\\E";
            }
            patternString = "\\b" + patternString + "\\b";
        }
        return Pattern.compile(patternString, flags);
    }

    private String getResolvedReplaceByString(int index, Object[] row) throws KettleException {
        if (this.data.setEmptyString[index]) {
            return "";
        }
        if (this.data.replaceFieldIndex[index] == -1) {
            return this.data.replaceByString[index];
        }
        return this.getInputRowMeta().getString(row, this.data.replaceFieldIndex[index]);
    }

    synchronized Object[] getOneRow(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        Object[] rowData = RowDataUtil.resizeArray((Object[])row, (int)this.data.outputRowMeta.size());
        int index = 0;
        HashSet<Integer> numFieldsAlreadyBeenTransformed = new HashSet<Integer>();
        for (int i = 0; i < this.data.numFields; ++i) {
            RowMetaInterface currentRowMeta = numFieldsAlreadyBeenTransformed.contains(this.data.inStreamNrs[i]) ? this.data.outputRowMeta : this.getInputRowMeta();
            String value = ReplaceString.replaceString(currentRowMeta.getString(rowData, this.data.inStreamNrs[i]), this.data.patterns[i], this.getResolvedReplaceByString(i, row));
            if (Utils.isEmpty((CharSequence)this.data.outStreamNrs[i])) {
                rowData[this.data.inStreamNrs[i]] = value;
                numFieldsAlreadyBeenTransformed.add(this.data.inStreamNrs[i]);
                continue;
            }
            rowData[this.data.inputFieldsNr + index++] = value;
        }
        return rowData;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block12: {
            this.meta = (ReplaceStringMeta)smi;
            this.data = (ReplaceStringData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.data.inputFieldsNr = this.data.outputRowMeta.size();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                this.data.numFields = this.meta.getFieldInStream().length;
                this.data.inStreamNrs = new int[this.data.numFields];
                this.data.outStreamNrs = new String[this.data.numFields];
                this.data.patterns = new Pattern[this.data.numFields];
                this.data.replaceByString = new String[this.data.numFields];
                this.data.setEmptyString = new boolean[this.data.numFields];
                this.data.replaceFieldIndex = new int[this.data.numFields];
                for (int i = 0; i < this.data.numFields; ++i) {
                    this.data.inStreamNrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldInStream()[i]);
                    if (this.data.inStreamNrs[i] < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"ReplaceString.Exception.FieldRequired", (String[])new String[]{this.meta.getFieldInStream()[i]}));
                    }
                    if (this.getInputRowMeta().getValueMeta(this.data.inStreamNrs[i]).getType() != 2) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"ReplaceString.Exception.FieldTypeNotString", (String[])new String[]{this.meta.getFieldInStream()[i]}));
                    }
                    this.data.outStreamNrs[i] = this.environmentSubstitute(this.meta.getFieldOutStream()[i]);
                    this.data.patterns[i] = ReplaceString.buildPattern(!this.meta.getUseRegEx()[i], this.meta.getCaseSensitive()[i], this.meta.getWholeWord()[i], this.environmentSubstitute(this.meta.getReplaceString()[i]), this.meta.isUnicode()[i]);
                    String field = this.meta.getFieldReplaceByString()[i];
                    if (!Utils.isEmpty((CharSequence)field)) {
                        this.data.replaceFieldIndex[i] = this.getInputRowMeta().indexOfValue(field);
                        if (this.data.replaceFieldIndex[i] < 0) {
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"ReplaceString.Exception.FieldRequired", (String[])new String[]{field}));
                        }
                    } else {
                        this.data.replaceFieldIndex[i] = -1;
                        this.data.replaceByString[i] = this.environmentSubstitute(this.meta.getReplaceByString()[i]);
                    }
                    this.data.setEmptyString[i] = this.meta.isSetEmptyString()[i];
                }
            }
            try {
                Object[] output = this.getOneRow(this.getInputRowMeta(), r);
                this.putRow(this.data.outputRowMeta, output);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ReplaceString.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ReplaceString.Log.ErrorInStep", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block12;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ReplaceString001");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ReplaceStringMeta)smi;
        this.data = (ReplaceStringData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ReplaceStringMeta)smi;
        this.data = (ReplaceStringData)sdi;
        this.data.outStreamNrs = null;
        this.data.patterns = null;
        this.data.replaceByString = null;
        this.data.replaceString = null;
        this.data.valueChange = null;
        super.dispose(smi, sdi);
    }
}

