/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.ui.xul.util.XmlParserFactoryProducer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class StatusServletUtils {
    static final String RESOURCES_PATH = "/content/common-ui/resources/themes";
    static final String STATIC_PATH = "/static";
    static final String PENTAHO_ROOT = "/pentaho";
    private static final String LINK_HTML_PREFIX = "<link rel=\"stylesheet\" type=\"text/css\" href=\"";

    private StatusServletUtils() {
    }

    static String getPentahoStyles(String root) {
        StringBuilder sb = new StringBuilder();
        String themeName = "ruby";
        String themeCss = "globalRuby.css";
        String mantleThemeCss = "mantleRuby.css";
        try {
            String relativePathSeparator = ".." + File.separator + ".." + File.separator;
            String themeSetting = relativePathSeparator + "pentaho-solutions" + File.separator + "system" + File.separator + "pentaho.xml";
            File f = new File(themeSetting);
            if (!f.exists()) {
                relativePathSeparator = ".." + File.separator;
            }
            DocumentBuilderFactory dbFactory = XmlParserFactoryProducer.createSecureDocBuilderFactory();
            DocumentBuilder db = dbFactory.newDocumentBuilder();
            Document doc = db.parse(f);
            themeName = doc.getElementsByTagName("default-theme").item(0).getTextContent();
            String themeDirStr = relativePathSeparator + "pentaho-solutions" + File.separator + "system" + File.separator + "common-ui" + File.separator + "resources" + File.separator + "themes" + File.separator + themeName + File.separator;
            File themeDir = new File(themeDirStr);
            for (File fName : Optional.ofNullable(themeDir.listFiles()).orElse(new File[0])) {
                if (!fName.getName().contains(".css")) continue;
                themeCss = fName.getName();
                break;
            }
            relativePathSeparator = relativePathSeparator.replaceFirst("(\\.\\.\\\\)", "");
            String mantleThemeDirStr = relativePathSeparator + "webapps" + root + File.separator + "mantle" + File.separator + "themes" + File.separator + themeName + File.separator;
            File mantleThemeDir = new File(mantleThemeDirStr);
            for (File fName : Optional.ofNullable(mantleThemeDir.listFiles()).orElse(new File[0])) {
                if (!fName.getName().contains(".css")) continue;
                mantleThemeCss = fName.getName();
                break;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LogChannel.GENERAL.logError(e.getMessage(), (Throwable)e);
        }
        sb.append(LINK_HTML_PREFIX).append(root).append("/content/common-ui/resources/themes/").append(themeName).append("/").append(themeCss).append("\"/>");
        sb.append(LINK_HTML_PREFIX).append(root).append("/mantle/themes/").append(themeName).append("/").append(mantleThemeCss).append("\"/>");
        sb.append(LINK_HTML_PREFIX).append(root).append("/mantle/MantleStyle.css\"/>");
        return sb.toString();
    }
}

