/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.cluster.tests.zookeeper;

import java.util.ArrayList;
import java.util.HashSet;
import org.pentaho.big.data.impl.cluster.tests.ClusterRuntimeTestEntry;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.runtime.test.i18n.MessageGetter;
import org.pentaho.runtime.test.i18n.MessageGetterFactory;
import org.pentaho.runtime.test.network.ConnectivityTestFactory;
import org.pentaho.runtime.test.result.RuntimeTestEntrySeverity;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;
import org.pentaho.runtime.test.result.RuntimeTestResultSummary;
import org.pentaho.runtime.test.result.org.pentaho.runtime.test.result.impl.RuntimeTestResultSummaryImpl;
import org.pentaho.runtime.test.test.impl.BaseRuntimeTest;

public class PingZookeeperEnsembleTest
extends BaseRuntimeTest {
    public static final String HADOOP_FILE_SYSTEM_PING_FILE_SYSTEM_ENTRY_POINT_TEST = "zookeeperPingZookeeperEnsembleTest";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_NAME = "PingZookeeperEnsembleTest.Name";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_BLANK_HOST_DESC = "PingZookeeperEnsembleTest.BlankHost.Desc";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_BLANK_HOST_MESSAGE = "PingZookeeperEnsembleTest.BlankHost.Message";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_BLANK_PORT_DESC = "PingZookeeperEnsembleTest.BlankPort.Desc";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_BLANK_PORT_MESSAGE = "PingZookeeperEnsembleTest.BlankPort.Message";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_NO_NODES_SUCCEEDED_DESC = "PingZookeeperEnsembleTest.NoNodesSucceeded.Desc";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_NO_NODES_SUCCEEDED_MESSAGE = "PingZookeeperEnsembleTest.NoNodesSucceeded.Message";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_SOME_NODES_FAILED_DESC = "PingZookeeperEnsembleTest.SomeNodesFailed.Desc";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_SOME_NODES_FAILED_MESSAGE = "PingZookeeperEnsembleTest.SomeNodesFailed.Message";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_ALL_NODES_SUCCEEDED_DESC = "PingZookeeperEnsembleTest.AllNodesSucceeded.Desc";
    public static final String PING_ZOOKEEPER_ENSEMBLE_TEST_ALL_NODES_SUCCEEDED_MESSAGE = "PingZookeeperEnsembleTest.AllNodesSucceeded.Message";
    private static final Class<?> PKG = PingZookeeperEnsembleTest.class;
    private final MessageGetterFactory messageGetterFactory;
    protected final MessageGetter messageGetter;
    private final ConnectivityTestFactory connectivityTestFactory;

    public PingZookeeperEnsembleTest(MessageGetterFactory messageGetterFactory, ConnectivityTestFactory connectivityTestFactory) {
        super(NamedCluster.class, "Zookeeper", HADOOP_FILE_SYSTEM_PING_FILE_SYSTEM_ENTRY_POINT_TEST, messageGetterFactory.create(PKG).getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_NAME, new String[0]), new HashSet());
        this.messageGetterFactory = messageGetterFactory;
        this.connectivityTestFactory = connectivityTestFactory;
        this.messageGetter = messageGetterFactory.create(PKG);
    }

    public RuntimeTestResultSummary runTest(Object objectUnderTest) {
        NamedCluster namedCluster = (NamedCluster)objectUnderTest;
        Variables variables = new Variables();
        variables.initializeVariablesFrom(null);
        String zooKeeperHost = variables.environmentSubstitute(namedCluster.getZooKeeperHost());
        String zooKeeperPort = variables.environmentSubstitute(namedCluster.getZooKeeperPort());
        if (Const.isEmpty((String)zooKeeperHost)) {
            return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_BLANK_HOST_DESC, new String[0]), this.messageGetter.getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_BLANK_HOST_MESSAGE, new String[0]), ClusterRuntimeTestEntry.DocAnchor.ZOOKEEPER));
        }
        if (Const.isEmpty((String)zooKeeperPort)) {
            return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_BLANK_PORT_DESC, new String[0]), this.messageGetter.getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_BLANK_PORT_MESSAGE, new String[0]), ClusterRuntimeTestEntry.DocAnchor.ZOOKEEPER));
        }
        String[] quorum = zooKeeperHost.split(",");
        ArrayList<ClusterRuntimeTestEntry> clusterTestResultEntries = new ArrayList<ClusterRuntimeTestEntry>();
        int failedNodes = 0;
        StringBuilder failedNodeString = new StringBuilder();
        for (String node : quorum) {
            ClusterRuntimeTestEntry nodeResults = new ClusterRuntimeTestEntry(this.messageGetterFactory, this.connectivityTestFactory.create(this.messageGetterFactory, node, zooKeeperPort, false, RuntimeTestEntrySeverity.WARNING).runTest(), ClusterRuntimeTestEntry.DocAnchor.ZOOKEEPER);
            if (nodeResults.getSeverity() == RuntimeTestEntrySeverity.WARNING) {
                failedNodeString.append(node).append(", ");
                ++failedNodes;
            }
            clusterTestResultEntries.add(nodeResults);
        }
        if (failedNodes > 0) {
            failedNodeString.setLength(failedNodeString.length() - 2);
        }
        ClusterRuntimeTestEntry overallResult = failedNodes == quorum.length ? new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_NO_NODES_SUCCEEDED_DESC, new String[0]), this.messageGetter.getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_NO_NODES_SUCCEEDED_MESSAGE, new String[]{failedNodeString.toString()}), ClusterRuntimeTestEntry.DocAnchor.ZOOKEEPER) : (failedNodes > 0 ? new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.WARNING, this.messageGetter.getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_SOME_NODES_FAILED_DESC, new String[0]), this.messageGetter.getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_SOME_NODES_FAILED_MESSAGE, new String[]{failedNodeString.toString()}), ClusterRuntimeTestEntry.DocAnchor.ZOOKEEPER) : new ClusterRuntimeTestEntry(this.messageGetterFactory, RuntimeTestEntrySeverity.INFO, this.messageGetter.getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_ALL_NODES_SUCCEEDED_DESC, new String[0]), this.messageGetter.getMessage(PING_ZOOKEEPER_ENSEMBLE_TEST_ALL_NODES_SUCCEEDED_MESSAGE, new String[0]), ClusterRuntimeTestEntry.DocAnchor.ZOOKEEPER));
        return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)overallResult, clusterTestResultEntries);
    }
}

