/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.pentaho.caching.api.PentahoCacheManager;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.dataservice.Context;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.optimization.AutoOptimizationService;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaStoreUtil;
import org.pentaho.di.trans.dataservice.streaming.StreamServiceKey;
import org.pentaho.di.trans.dataservice.streaming.execution.StreamingGeneratedTransExecution;
import org.pentaho.di.trans.dataservice.streaming.execution.StreamingServiceTransExecutor;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.UIFactory;

public class DataServiceContext
implements Context {
    private final DataServiceMetaStoreUtil metaStoreUtil;
    private final List<AutoOptimizationService> autoOptimizationServices;
    private final PentahoCacheManager cacheManager;
    private final List<PushDownFactory> pushDownFactories;
    private final LogChannelInterface logChannel;
    private final UIFactory uiFactory;
    private final Cache<String, StreamingGeneratedTransExecution> streamingGeneratedTransExecutionCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).removalListener((RemovalListener)new RemovalListener<String, StreamingGeneratedTransExecution>(){

        public void onRemoval(RemovalNotification<String, StreamingGeneratedTransExecution> removal) {
            ((StreamingGeneratedTransExecution)removal.getValue()).clearRowConsumers();
            DataServiceContext.this.logChannel.logDebug("Streaming generated transformation cache listener removed: " + (String)removal.getKey());
        }
    }).softValues().build();
    private final ConcurrentMap<String, DataServiceExecutor> executors = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).softValues().build().asMap();
    private final Cache<StreamServiceKey, StreamingServiceTransExecutor> serviceExecutors = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).removalListener((RemovalListener)new RemovalListener<StreamServiceKey, StreamingServiceTransExecutor>(){

        public void onRemoval(RemovalNotification<StreamServiceKey, StreamingServiceTransExecutor> removal) {
            StreamingServiceTransExecutor item = (StreamingServiceTransExecutor)removal.getValue();
            LogChannelInterface log = item.getServiceTrans().getLogChannel();
            item.stopAll();
            log.logDebug("Streaming service cache listener removed: " + removal.getKey());
        }
    }).softValues().build();

    public DataServiceContext(List<PushDownFactory> pushDownFactories, List<AutoOptimizationService> autoOptimizationServices, PentahoCacheManager cacheManager, UIFactory uiFactory, LogChannelInterface logChannel) {
        this.pushDownFactories = pushDownFactories;
        this.autoOptimizationServices = autoOptimizationServices;
        this.cacheManager = cacheManager;
        this.metaStoreUtil = DataServiceMetaStoreUtil.create(this);
        this.logChannel = logChannel;
        this.uiFactory = uiFactory;
    }

    @VisibleForTesting
    protected DataServiceContext(List<PushDownFactory> pushDownFactories, List<AutoOptimizationService> autoOptimizationServices, PentahoCacheManager cacheManager, DataServiceMetaStoreUtil metaStoreUtil, UIFactory uiFactory, LogChannelInterface logChannel) {
        this.pushDownFactories = pushDownFactories;
        this.autoOptimizationServices = autoOptimizationServices;
        this.cacheManager = cacheManager;
        this.metaStoreUtil = metaStoreUtil;
        this.logChannel = logChannel;
        this.uiFactory = uiFactory;
    }

    @Override
    public PentahoCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public DataServiceMetaStoreUtil getMetaStoreUtil() {
        return this.metaStoreUtil;
    }

    @Override
    public List<AutoOptimizationService> getAutoOptimizationServices() {
        return this.autoOptimizationServices;
    }

    @Override
    public List<PushDownFactory> getPushDownFactories() {
        return this.pushDownFactories;
    }

    @Override
    public LogChannelInterface getLogChannel() {
        return this.logChannel;
    }

    @Override
    public UIFactory getUIFactory() {
        return this.uiFactory;
    }

    @Override
    public DataServiceDelegate getDataServiceDelegate() {
        return DataServiceDelegate.withDefaultSpoonInstance(this);
    }

    @Override
    public void addExecutor(DataServiceExecutor executor) {
        this.executors.putIfAbsent(executor.getId(), executor);
    }

    @Override
    public DataServiceExecutor getExecutor(String id) {
        return (DataServiceExecutor)this.executors.get(id);
    }

    @Override
    public void removeExecutor(String id) {
        this.executors.remove(id);
    }

    @Override
    public void addServiceTransExecutor(StreamingServiceTransExecutor serviceExecutor) {
        this.serviceExecutors.put((Object)serviceExecutor.getKey(), (Object)serviceExecutor);
    }

    @Override
    public StreamingServiceTransExecutor getServiceTransExecutor(StreamServiceKey key) {
        return (StreamingServiceTransExecutor)this.serviceExecutors.getIfPresent((Object)key);
    }

    @Override
    public void removeServiceTransExecutor(StreamServiceKey key) {
        this.serviceExecutors.invalidate((Object)key);
        this.serviceExecutors.cleanUp();
    }

    @Override
    public void removeServiceTransExecutor(String dataServiceName) {
        for (StreamServiceKey key : this.serviceExecutors.asMap().keySet()) {
            if (!key.getDataServiceId().equals(dataServiceName)) continue;
            this.removeServiceTransExecutor(key);
        }
    }

    @Override
    public StreamingGeneratedTransExecution getStreamingGeneratedTransExecution(String key) {
        if (key != null) {
            return (StreamingGeneratedTransExecution)this.streamingGeneratedTransExecutionCache.getIfPresent((Object)key);
        }
        return null;
    }

    @Override
    public void addStreamingGeneratedTransExecution(String key, StreamingGeneratedTransExecution streamingGeneratedTransExecution) {
        if (key != null) {
            this.streamingGeneratedTransExecutionCache.put((Object)key, (Object)streamingGeneratedTransExecution);
        }
    }

    @Override
    public void removeStreamingGeneratedTransExecution(String key) {
        if (key != null) {
            this.streamingGeneratedTransExecutionCache.invalidate((Object)key);
            this.streamingGeneratedTransExecutionCache.cleanUp();
        }
    }
}

