/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.acls;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoAclObjectIdentity;
import org.pentaho.platform.api.engine.IPentahoBasicAclEntry;

public abstract class PentahoAbstractBasicAclEntry
implements IPentahoBasicAclEntry {
    private static final Log logger = LogFactory.getLog(PentahoAbstractBasicAclEntry.class);
    private IPentahoAclObjectIdentity aclObjectIdentity;
    private IPentahoAclObjectIdentity aclObjectParentIdentity;
    private Object recipient;
    private int[] validPermissions;
    private int mask = 0;

    public PentahoAbstractBasicAclEntry(Object recipient, IPentahoAclObjectIdentity aclObjectIdentity, IPentahoAclObjectIdentity aclObjectParentIdentity, int mask) {
        assert (recipient != null);
        assert (aclObjectIdentity != null);
        this.validPermissions = this.getValidPermissions();
        Arrays.sort(this.validPermissions);
        for (int i = 0; i < this.validPermissions.length; ++i) {
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Valid permission:   " + this.printPermissionsBlock(this.validPermissions[i]) + " " + this.printBinary(this.validPermissions[i]) + " (" + this.validPermissions[i] + ")"));
        }
        this.recipient = recipient;
        this.aclObjectIdentity = aclObjectIdentity;
        this.aclObjectParentIdentity = aclObjectParentIdentity;
        this.mask = mask;
    }

    protected PentahoAbstractBasicAclEntry() {
        this.validPermissions = this.getValidPermissions();
        Arrays.sort(this.validPermissions);
    }

    public int addPermission(int permissionToAdd) {
        return this.addPermissions(new int[]{permissionToAdd});
    }

    public int addPermissions(int[] permissionsToAdd) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BEFORE Permissions: " + this.printPermissionsBlock(this.mask) + " " + this.printBinary(this.mask) + " (" + this.mask + ")"));
        }
        for (int i = 0; i < permissionsToAdd.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add permission: " + this.printPermissionsBlock(permissionsToAdd[i]) + " " + this.printBinary(permissionsToAdd[i]) + " (" + permissionsToAdd[i] + ")"));
            }
            this.mask |= permissionsToAdd[i];
        }
        if (Arrays.binarySearch(this.validPermissions, this.mask) < 0) {
            throw new IllegalArgumentException("Resulting permission set will be invalid.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AFTER  Permissions: " + this.printPermissionsBlock(this.mask) + " " + this.printBinary(this.mask) + " (" + this.mask + ")"));
        }
        return this.mask;
    }

    public int deletePermission(int permissionToDelete) {
        return this.deletePermissions(new int[]{permissionToDelete});
    }

    public int deletePermissions(int[] permissionsToDelete) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BEFORE Permissions: " + this.printPermissionsBlock(this.mask) + " " + this.printBinary(this.mask) + " (" + this.mask + ")"));
        }
        for (int i = 0; i < permissionsToDelete.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Delete  permission: " + this.printPermissionsBlock(permissionsToDelete[i]) + " " + this.printBinary(permissionsToDelete[i]) + " (" + permissionsToDelete[i] + ")"));
            }
            this.mask &= ~permissionsToDelete[i];
        }
        if (Arrays.binarySearch(this.validPermissions, this.mask) < 0) {
            throw new IllegalArgumentException("Resulting permission set will be invalid.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AFTER  Permissions: " + this.printPermissionsBlock(this.mask) + " " + this.printBinary(this.mask) + " (" + this.mask + ")"));
        }
        return this.mask;
    }

    public IPentahoAclObjectIdentity getAclObjectIdentity() {
        return this.aclObjectIdentity;
    }

    public IPentahoAclObjectIdentity getAclObjectParentIdentity() {
        return this.aclObjectParentIdentity;
    }

    public int getMask() {
        return this.mask;
    }

    public Object getRecipient() {
        return this.recipient;
    }

    public abstract int[] getValidPermissions();

    public boolean isPermitted(int permissionToCheck) {
        return this.isPermitted(this.mask, permissionToCheck);
    }

    protected boolean isPermitted(int maskToCheck, int permissionToCheck) {
        return (maskToCheck & permissionToCheck) == permissionToCheck;
    }

    private String printBinary(int i) {
        String s = Integer.toString(i, 2);
        String pattern = "................................";
        String temp1 = pattern.substring(0, pattern.length() - s.length());
        String temp2 = temp1 + s;
        return temp2.replace('0', '.');
    }

    public abstract String printPermissionsBlock(int var1);

    public String printPermissionsBlock() {
        return this.printPermissionsBlock(this.mask);
    }

    public void setAclObjectIdentity(IPentahoAclObjectIdentity aclObjectIdentity) {
        this.aclObjectIdentity = aclObjectIdentity;
    }

    public void setAclObjectParentIdentity(IPentahoAclObjectIdentity aclObjectParentIdentity) {
        this.aclObjectParentIdentity = aclObjectParentIdentity;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public void setRecipient(Object recipient) {
        this.recipient = recipient;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[").append(this.aclObjectIdentity).append(",").append(this.recipient);
        sb.append("=").append(this.printPermissionsBlock(this.mask)).append(" ");
        sb.append(this.printBinary(this.mask)).append(" (");
        sb.append(this.mask).append(")").append("]");
        return sb.toString();
    }

    public int togglePermission(int permissionToToggle) {
        this.mask ^= permissionToToggle;
        if (Arrays.binarySearch(this.validPermissions, this.mask) < 0) {
            throw new IllegalArgumentException("Resulting permission set will be invalid.");
        }
        return this.mask;
    }
}

