/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IFileFilter;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.SequenceDefinition;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class ActionSequenceJCRHelper {
    protected static final String PROPERTIES_SUFFIX = ".properties";
    protected static final Log logger = LogFactory.getLog(ActionSequenceJCRHelper.class);
    private IPentahoSession pentahoSession;
    private IUnifiedRepository repository;

    public ActionSequenceJCRHelper() {
        this(PentahoSessionHolder.getSession());
    }

    public ActionSequenceJCRHelper(IPentahoSession pentahoSession) {
        assert (pentahoSession != null);
        this.pentahoSession = pentahoSession;
        this.repository = PentahoSystem.get(IUnifiedRepository.class, pentahoSession);
        if (this.repository == null) {
            String errorMessage = Messages.getInstance().getErrorString("ActionSequenceJCRHelper.ERROR_0001_INVALID_REPOSITORY");
            logger.error((Object)errorMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    @Deprecated
    public IActionSequence getActionSequence(String actionPath, int loggingLevel, int actionOperation) {
        return this.getActionSequence(actionPath, loggingLevel, RepositoryFilePermission.READ);
    }

    public IActionSequence getActionSequence(String actionPath, int loggingLevel, RepositoryFilePermission actionOperation) {
        Document actionSequenceDocument = this.getSolutionDocument(actionPath, actionOperation);
        if (actionSequenceDocument == null) {
            return null;
        }
        IActionSequence actionSequence = SequenceDefinition.ActionSequenceFactory(actionSequenceDocument, actionPath, (ILogger)this.pentahoSession, PentahoSystem.getApplicationContext(), loggingLevel);
        if (actionSequence == null) {
            return null;
        }
        return actionSequence;
    }

    public Document getSolutionDocument(String documentPath, RepositoryFilePermission actionOperation) {
        RepositoryFile file = this.repository.getFile(documentPath);
        Document document = null;
        SimpleRepositoryFileData data = null;
        if (file != null) {
            data = (SimpleRepositoryFileData)this.repository.getDataForRead(file.getId(), SimpleRepositoryFileData.class);
            if (data != null) {
                try {
                    document = XmlDom4JHelper.getDocFromStream(data.getStream());
                }
                catch (Throwable t) {
                    logger.error((Object)Messages.getInstance().getErrorString("ActionSequenceJCRHelper.ERROR_0017_INVALID_XML_DOCUMENT", documentPath), t);
                    return null;
                }
            } else {
                logger.error((Object)Messages.getInstance().getErrorString("ActionSequenceJCRHelper.ERROR_0019_NO_DATA_IN_FILE", file.getName()));
                return null;
            }
            if (document == null && file != null && data != null) {
                logger.error((Object)Messages.getInstance().getErrorString("ActionSequenceJCRHelper.ERROR_0009_INVALID_DOCUMENT", documentPath));
                return null;
            }
            this.localizeDoc((Node)document, file);
        }
        return document;
    }

    public String getURL(String filePath) {
        RepositoryFile file = this.repository.getFile(filePath);
        if (file == null || !file.getName().endsWith(".url")) {
            return "";
        }
        SimpleRepositoryFileData data = null;
        data = (SimpleRepositoryFileData)this.repository.getDataForRead(file.getId(), SimpleRepositoryFileData.class);
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)data.getStream(), (Writer)writer);
        }
        catch (IOException e) {
            return "";
        }
        String props = writer.toString();
        StringTokenizer tokenizer = new StringTokenizer(props, "\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            int pos = line.indexOf(61);
            if (pos <= 0) continue;
            String propname = line.substring(0, pos);
            String value = line.substring(pos + 1);
            if (value != null && value.length() > 0 && value.charAt(value.length() - 1) == '\r') {
                value = value.substring(0, value.length() - 1);
            }
            if (!"URL".equalsIgnoreCase(propname)) continue;
            return value;
        }
        return "";
    }

    public void localizeDoc(Node document, RepositoryFile file) {
        String fileName = file.getName();
        int dotIndex = fileName.indexOf(46);
        String baseName = fileName.substring(0, dotIndex);
        try {
            List nodes = document.selectNodes("descendant::*");
            for (Node node : nodes) {
                String name = node.getText();
                if (!name.startsWith("%") || node.getPath().endsWith("/text()")) continue;
                try {
                    String localeText = this.getLocaleString(name, baseName, file, true);
                    if (localeText == null) continue;
                    node.setText(localeText);
                }
                catch (Exception e) {
                    logger.warn((Object)Messages.getInstance().getString("ActionSequenceJCRHelper.WARN_MISSING_RESOURCE_PROPERTY", name.substring(1), baseName, this.getLocale().toString()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)Messages.getInstance().getErrorString("ActionSequenceJCRHelper.ERROR_0007_COULD_NOT_READ_PROPERTIES", file.getPath()), (Throwable)e);
        }
    }

    protected String getLocaleString(String key, String baseName, RepositoryFile baseFile, boolean marchUpParents) {
        String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)baseFile.getPath());
        RepositoryFile searchDir = this.repository.getFile(parentPath);
        if (baseFile.isFolder()) {
            searchDir = baseFile;
        }
        try {
            boolean searching = true;
            while (searching) {
                RepositoryFile[] propertyFiles = this.listFiles(searchDir, new IFileFilter(){

                    public boolean accept(RepositoryFile file) {
                        return file.getName().toLowerCase().endsWith(ActionSequenceJCRHelper.PROPERTIES_SUFFIX);
                    }
                });
                RepositoryFile blcv = null;
                RepositoryFile blc = null;
                RepositoryFile bl = null;
                RepositoryFile b = null;
                for (RepositoryFile element : propertyFiles) {
                    if (element.getName().equalsIgnoreCase(baseName + '_' + this.getLocale().getLanguage() + '_' + this.getLocale().getCountry() + '_' + this.getLocale().getVariant() + PROPERTIES_SUFFIX)) {
                        blcv = element;
                    }
                    if (element.getName().equalsIgnoreCase(baseName + '_' + this.getLocale().getLanguage() + '_' + this.getLocale().getCountry() + PROPERTIES_SUFFIX)) {
                        blc = element;
                    }
                    if (element.getName().equalsIgnoreCase(baseName + '_' + this.getLocale().getLanguage() + PROPERTIES_SUFFIX)) {
                        bl = element;
                    }
                    if (!element.getName().equalsIgnoreCase(baseName + PROPERTIES_SUFFIX)) continue;
                    b = element;
                }
                String localeText = this.getLocaleText(key, blcv);
                if (localeText == null && (localeText = this.getLocaleText(key, blc)) == null && (localeText = this.getLocaleText(key, bl)) == null) {
                    localeText = this.getLocaleText(key, b);
                }
                if (localeText != null) {
                    return localeText;
                }
                if (searching && marchUpParents) {
                    if (!baseName.equals("messages")) {
                        baseName = "messages";
                        continue;
                    }
                    parentPath = FilenameUtils.getFullPathNoEndSeparator((String)searchDir.getPath());
                    if (parentPath == null || parentPath.length() < 1 || parentPath.equals(searchDir.getPath())) {
                        searching = false;
                        continue;
                    }
                    searchDir = this.repository.getFile(parentPath);
                    continue;
                }
                if (marchUpParents) continue;
                searching = false;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getInstance().getErrorString("ActionSequenceJCRHelper.ERROR_0007_COULD_NOT_READ_PROPERTIES", baseFile.getPath()), (Throwable)e);
            return null;
        }
    }

    protected Locale getLocale() {
        return LocaleHelper.getLocale();
    }

    protected String getLocaleText(String key, RepositoryFile file) throws IOException {
        if (file != null) {
            SimpleRepositoryFileData data = null;
            data = (SimpleRepositoryFileData)this.repository.getDataForRead(file.getId(), SimpleRepositoryFileData.class);
            Properties p = new Properties();
            p.load(data.getStream());
            String localeText = p.getProperty(key.substring(1));
            if (localeText == null) {
                localeText = p.getProperty(key);
            }
            if (localeText != null) {
                return localeText;
            }
        }
        return null;
    }

    private RepositoryFile[] listFiles(RepositoryFile searchDir, IFileFilter filter) {
        Object[] objArray;
        ArrayList<RepositoryFile> matchedFiles = new ArrayList<RepositoryFile>();
        for (Object element : objArray = this.repository.getChildren(searchDir.getId(), null, Boolean.valueOf(true)).toArray()) {
            if (!filter.accept((RepositoryFile)element)) continue;
            matchedFiles.add((RepositoryFile)element);
        }
        return matchedFiles.toArray(new RepositoryFile[0]);
    }
}

