/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.meta;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.hadoop.hbase.util.Bytes;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterface;

public class AELHBaseValueMetaImpl
extends ValueMetaBase
implements HBaseValueMetaInterface {
    private boolean isKey;
    private String alias;
    private String columnName;
    private String columnFamily;
    private String mappingName;
    private String tableName;
    private boolean isLongOrDouble = true;

    public AELHBaseValueMetaImpl(boolean isKey, String alias, String columnName, String columnFamily, String mappingName, String tableName) {
        super(alias);
        this.isKey = isKey;
        this.alias = alias;
        this.columnName = columnName;
        this.columnFamily = columnFamily;
        this.mappingName = mappingName;
        this.tableName = tableName;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean key) {
        this.isKey = key;
    }

    public String getAlias() {
        return this.getName();
    }

    public void setAlias(String alias) {
        this.alias = alias;
        this.setName(alias);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public void setColumnFamily(String columnFamily) {
        this.columnFamily = columnFamily;
    }

    public void setHBaseTypeFromString(String hbaseType) throws IllegalArgumentException {
        if (hbaseType.equalsIgnoreCase("Integer")) {
            this.setType(ValueMeta.getType((String)hbaseType));
            this.setIsLongOrDouble(false);
            return;
        }
        if (hbaseType.equalsIgnoreCase("Long")) {
            this.setType(ValueMeta.getType((String)"Integer"));
            this.setIsLongOrDouble(true);
            return;
        }
        if (hbaseType.equals("Float")) {
            this.setType(ValueMeta.getType((String)"Number"));
            this.setIsLongOrDouble(false);
            return;
        }
        if (hbaseType.equals("Double")) {
            this.setType(ValueMeta.getType((String)"Number"));
            this.setIsLongOrDouble(true);
            return;
        }
        int type = ValueMeta.getType((String)hbaseType);
        if (type == 0) {
            throw new IllegalArgumentException(BaseMessages.getString((Class)PKG, (String)"HBaseValueMeta.Error.UnknownType", (String[])new String[]{hbaseType}));
        }
        this.setType(type);
    }

    public String getHBaseTypeDesc() {
        if (this.isInteger()) {
            return this.getIsLongOrDouble() ? "Long" : "Integer";
        }
        if (this.isNumber()) {
            return this.getIsLongOrDouble() ? "Double" : "Float";
        }
        return ValueMeta.getTypeDesc((int)this.getType());
    }

    public Object decodeColumnValue(byte[] rawColValue) throws KettleException {
        if (rawColValue == null) {
            return null;
        }
        if (this.isString()) {
            String convertedString = Bytes.toString((byte[])rawColValue);
            if (this.getStorageType() == 2) {
                Object[] legalVals = this.getIndex();
                int foundIndex = -1;
                for (int i = 0; i < legalVals.length; ++i) {
                    if (!legalVals[i].toString().trim().equals(convertedString.trim())) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex >= 0) {
                    return new Integer(foundIndex);
                }
                throw new KettleException(BaseMessages.getString((Class)PKG, (String)"HBaseValueMeta.Error.IllegalIndexedColumnValue", (String[])new String[]{convertedString, this.getAlias()}));
            }
            return convertedString;
        }
        if (this.isNumber()) {
            if (rawColValue.length == 4) {
                float floatResult = Bytes.toFloat((byte[])rawColValue);
                return new Double(floatResult);
            }
            if (rawColValue.length == 8) {
                return new Double(Bytes.toDouble((byte[])rawColValue));
            }
        }
        if (this.isInteger()) {
            if (rawColValue.length == 4) {
                int intResult = Bytes.toInt((byte[])rawColValue);
                return new Long(intResult);
            }
            if (rawColValue.length == 8) {
                return new Long(Bytes.toLong((byte[])rawColValue));
            }
            if (rawColValue.length == 2) {
                short tempShort = Bytes.toShort((byte[])rawColValue);
                return new Long(tempShort);
            }
            throw new KettleException(BaseMessages.getString((Class)PKG, (String)"HBaseValueMeta.Error.IllegalIntegerLength", (String[])new String[0]));
        }
        if (this.isBigNumber()) {
            String temp = Bytes.toString((byte[])rawColValue);
            BigDecimal result = new BigDecimal(temp);
            if (result == null) {
                throw new KettleException(BaseMessages.getString((Class)PKG, (String)"HBaseValueMeta.Error.UnableToDecodeBigDecimal", (String[])new String[0]));
            }
            return result;
        }
        if (this.isBinary()) {
            return rawColValue;
        }
        if (this.isBoolean()) {
            Boolean result = AELHBaseValueMetaImpl.decodeBoolFromString(rawColValue);
            if (result == null) {
                result = AELHBaseValueMetaImpl.decodeBoolFromNumber(rawColValue);
            }
            if (result != null) {
                return result;
            }
            throw new KettleException(BaseMessages.getString((Class)PKG, (String)"HBaseValueMeta.Error.UnableToDecodeBoolean", (String[])new String[0]));
        }
        if (this.isDate()) {
            if (rawColValue.length != 8) {
                throw new KettleException(BaseMessages.getString((Class)PKG, (String)"HBaseValueMeta.Error.DateValueLengthNotEqualToLong", (String[])new String[0]));
            }
            long millis = Bytes.toLong((byte[])rawColValue);
            Date d = new Date(millis);
            return d;
        }
        throw new KettleException(BaseMessages.getString((Class)PKG, (String)"HBaseValueMeta.Error.UnknownTypeForColumn", (String[])new String[0]));
    }

    public byte[] encodeColumnValue(Object columnValue, ValueMetaInterface colMeta) throws KettleException {
        if (columnValue == null) {
            return null;
        }
        byte[] encoded = null;
        int outputType = this.getType();
        switch (outputType) {
            case 2: {
                String toEncode = colMeta.getString(columnValue);
                encoded = Bytes.toBytes((String)toEncode);
                break;
            }
            case 5: {
                Long l = colMeta.getInteger(columnValue);
                if (this.getIsLongOrDouble()) {
                    encoded = Bytes.toBytes((long)l);
                    break;
                }
                encoded = Bytes.toBytes((int)l.intValue());
                break;
            }
            case 1: {
                Double d = colMeta.getNumber(columnValue);
                if (this.getIsLongOrDouble()) {
                    encoded = Bytes.toBytes((double)d);
                    break;
                }
                encoded = Bytes.toBytes((float)d.floatValue());
                break;
            }
            case 3: {
                Date date = colMeta.getDate(columnValue);
                encoded = Bytes.toBytes((long)date.getTime());
                break;
            }
            case 4: {
                Boolean b = colMeta.getBoolean(columnValue);
                String boolString = b != false ? "Y" : "N";
                encoded = Bytes.toBytes((String)boolString);
                break;
            }
            case 6: {
                BigDecimal bd = colMeta.getBigNumber(columnValue);
                String bds = bd.toString();
                encoded = Bytes.toBytes((String)bds);
                break;
            }
            case 8: {
                encoded = colMeta.getBinary(columnValue);
            }
        }
        return encoded;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public void setMappingName(String mappingName) {
        this.mappingName = mappingName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean getIsLongOrDouble() {
        return this.isLongOrDouble;
    }

    public void setIsLongOrDouble(boolean ld) {
        this.isLongOrDouble = ld;
    }

    public void getXml(StringBuilder retval) {
        String format = this.getConversionMask();
        retval.append("\n        ").append(XMLHandler.openTag((String)"field"));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"table_name", (String)this.getTableName()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"mapping_name", (String)this.getMappingName()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"alias", (String)this.getAlias()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"family", (String)this.getColumnFamily()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"column", (String)this.getColumnName()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"key", (boolean)this.isKey()));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"type", (String)ValueMetaBase.getTypeDesc((int)this.getType())));
        retval.append("\n            ").append(XMLHandler.addTagValue((String)"format", (String)format));
        retval.append("\n        ").append(XMLHandler.closeTag((String)"field"));
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step, int count) throws KettleException {
    }

    public static Boolean decodeBoolFromString(byte[] rawEncoded) {
        String tempString = Bytes.toString((byte[])rawEncoded);
        if (tempString.equalsIgnoreCase("Y") || tempString.equalsIgnoreCase("N") || tempString.equalsIgnoreCase("YES") || tempString.equalsIgnoreCase("NO") || tempString.equalsIgnoreCase("TRUE") || tempString.equalsIgnoreCase("FALSE") || tempString.equalsIgnoreCase("T") || tempString.equalsIgnoreCase("F") || tempString.equalsIgnoreCase("1") || tempString.equalsIgnoreCase("0")) {
            return tempString.equalsIgnoreCase("Y") || tempString.equalsIgnoreCase("YES") || tempString.equalsIgnoreCase("TRUE") || tempString.equalsIgnoreCase("T") || tempString.equalsIgnoreCase("1");
        }
        return null;
    }

    public static Boolean decodeBoolFromNumber(byte[] rawEncoded) {
        short tempShort;
        byte val;
        if (rawEncoded == null) {
            return null;
        }
        if (rawEncoded.length == 1 && ((val = rawEncoded[0]) == 0 || val == 1)) {
            return new Boolean(val == 1);
        }
        if (rawEncoded.length == 2 && ((tempShort = Bytes.toShort((byte[])rawEncoded)) == 0 || tempShort == 1)) {
            return new Boolean(tempShort == 1);
        }
        if (rawEncoded.length == 4 || rawEncoded.length == 4) {
            int tempInt = Bytes.toInt((byte[])rawEncoded);
            if (tempInt == 1 || tempInt == 0) {
                return new Boolean(tempInt == 1);
            }
            float tempFloat = Bytes.toFloat((byte[])rawEncoded);
            if (tempFloat == 0.0f || tempFloat == 1.0f) {
                return new Boolean(tempFloat == 1.0f);
            }
        }
        if (rawEncoded.length == 8 || rawEncoded.length == 8) {
            long tempLong = Bytes.toLong((byte[])rawEncoded);
            if (tempLong == 0L || tempLong == 1L) {
                return new Boolean(tempLong == 1L);
            }
            double tempDouble = Bytes.toDouble((byte[])rawEncoded);
            if (tempDouble == 0.0 || tempDouble == 1.0) {
                return new Boolean(tempDouble == 1.0);
            }
        }
        return null;
    }
}

