/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceupdate;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.salesforce.SalesforceStepMeta;
import org.pentaho.di.trans.steps.salesforceupdate.SalesforceUpdate;
import org.pentaho.di.trans.steps.salesforceupdate.SalesforceUpdateData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="SalesforceUpdate", i18nPackageName="org.pentaho.di.trans.steps.salesforceupdate", name="SalesforceUpdate.TypeLongDesc.SalesforceUpdate", description="SalesforceUpdate.TypeTooltipDesc.SalesforceUpdate", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Output", image="SFUD.svg", documentationUrl="Products/Salesforce_Update")
public class SalesforceUpdateMeta
extends SalesforceStepMeta {
    private static Class<?> PKG = SalesforceUpdateMeta.class;
    private String[] updateLookup;
    private Boolean[] useExternalId;
    private String[] updateStream;
    private String batchSize;
    private boolean rollbackAllChangesOnError;

    public boolean isRollbackAllChangesOnError() {
        return this.rollbackAllChangesOnError;
    }

    public void setRollbackAllChangesOnError(boolean rollbackAllChangesOnError) {
        this.rollbackAllChangesOnError = rollbackAllChangesOnError;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public Boolean[] getUseExternalId() {
        return this.useExternalId;
    }

    public void setUseExternalId(Boolean[] useExternalId) {
        this.useExternalId = useExternalId;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public void setBatchSize(String value) {
        this.batchSize = value;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public int getBatchSizeInt() {
        return Const.toInt((String)this.batchSize, (int)10);
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(stepnode, databases, metaStore);
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        SalesforceUpdateMeta retval = (SalesforceUpdateMeta)((Object)super.clone());
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.updateLookup[i] = this.updateLookup[i];
            retval.updateStream[i] = this.updateStream[i];
            retval.useExternalId[i] = this.useExternalId[i];
        }
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(super.getXML());
        retval.append("    " + XMLHandler.addTagValue((String)"batchSize", (String)this.getBatchSize()));
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.getUpdateLookup()[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.getUpdateStream()[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"useExternalId", (boolean)this.getUseExternalId()[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"rollbackAllChangesOnError", (boolean)this.isRollbackAllChangesOnError()));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.setBatchSize(XMLHandler.getTagValue((Node)stepnode, (String)"batchSize"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                String updateValue;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.updateLookup[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.updateStream[i] = XMLHandler.getTagValue((Node)fnode, (String)"field");
                if (this.updateStream[i] == null) {
                    this.updateStream[i] = this.updateLookup[i];
                }
                this.useExternalId[i] = (updateValue = XMLHandler.getTagValue((Node)fnode, (String)"useExternalId")) == null ? Boolean.FALSE : (updateValue.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE);
            }
            this.setRollbackAllChangesOnError("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rollbackAllChangesOnError")));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrvalues) {
        this.setUpdateLookup(new String[nrvalues]);
        this.setUpdateStream(new String[nrvalues]);
        this.setUseExternalId(new Boolean[nrvalues]);
    }

    @Override
    public void setDefault() {
        super.setDefault();
        this.setBatchSize("10");
        this.allocate(0);
        this.setRollbackAllChangesOnError(false);
    }

    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        super.readRep(rep, metaStore, id_step, databases);
        try {
            this.setBatchSize(rep.getStepAttributeString(id_step, "batchSize"));
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                this.updateLookup[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.updateStream[i] = rep.getStepAttributeString(id_step, i, "field_attribut");
                this.useExternalId[i] = rep.getStepAttributeBoolean(id_step, i, "field_useExternalId", false);
            }
            this.setRollbackAllChangesOnError(rep.getStepAttributeBoolean(id_step, "rollbackAllChangesOnError"));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        super.saveRep(rep, metaStore, id_transformation, id_step);
        try {
            rep.saveStepAttribute(id_transformation, id_step, "batchSize", this.getBatchSize());
            for (int i = 0; i < this.updateLookup.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.getUpdateLookup()[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_attribut", this.getUpdateStream()[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_useExternalId", this.getUseExternalId()[i].booleanValue());
            }
            rep.saveStepAttribute(id_transformation, id_step, "rollbackAllChangesOnError", this.isRollbackAllChangesOnError());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        super.check(remarks, transMeta, stepMeta, prev, input, output, info, space, repository, metaStore);
        CheckResult cr = input != null && input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = this.getUpdateLookup().length == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.FieldsOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SalesforceUpdate(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new SalesforceUpdateData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

