/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.DBCacheEntry;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.ConnectionPoolUtil;
import org.pentaho.di.core.database.DataSourceNamingException;
import org.pentaho.di.core.database.DataSourceProviderFactory;
import org.pentaho.di.core.database.DataSourceProviderInterface;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.DelegatingDriver;
import org.pentaho.di.core.database.MSSQLServerDatabaseMeta;
import org.pentaho.di.core.database.MSSQLServerNativeDatabaseMeta;
import org.pentaho.di.core.database.NeoviewDatabaseMeta;
import org.pentaho.di.core.database.OracleDatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.database.PostgreSQLDatabaseMeta;
import org.pentaho.di.core.database.SqlScriptParser;
import org.pentaho.di.core.database.SybaseDatabaseMeta;
import org.pentaho.di.core.database.SybaseIQDatabaseMeta;
import org.pentaho.di.core.database.map.DatabaseConnectionMap;
import org.pentaho.di.core.database.util.DatabaseLogExceptionFactory;
import org.pentaho.di.core.database.util.DatabaseUtil;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseBatchException;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.Metrics;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaInternetAddress;
import org.pentaho.di.core.row.value.ValueMetaNone;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.row.value.ValueMetaTimestamp;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.RepositoryDirectory;

public class Database
implements VariableSpace,
LoggingObjectInterface,
Closeable {
    private static final Class<?> PKG = Database.class;
    private static final Map<String, Set<String>> registeredDrivers = new HashMap<String, Set<String>>();
    private DatabaseMeta databaseMeta;
    private static final String DATA_SERVICES_PLUGIN_ID = "KettleThin";
    private int rowlimit;
    private int commitsize;
    private Connection connection;
    private Statement selStmt;
    private PreparedStatement pstmt;
    private PreparedStatement prepStatementLookup;
    private PreparedStatement prepStatementUpdate;
    private PreparedStatement prepStatementInsert;
    private PreparedStatement pstmtSeq;
    private CallableStatement cstmt;
    private DatabaseMetaData dbmd;
    private RowMetaInterface rowMeta;
    private int written;
    private LogChannelInterface log;
    private LoggingObjectInterface parentLoggingObject;
    private static final String[] TABLE_TYPES_TO_GET = new String[]{"TABLE", "VIEW"};
    private static final String TABLES_META_DATA_TABLE_NAME = "TABLE_NAME";
    private volatile int opened;
    private volatile int copy;
    private String connectionGroup;
    private String partitionId;
    private VariableSpace variables = new Variables();
    private LogLevel logLevel = DefaultLogLevel.getLogLevel();
    private String containerObjectId;
    private int nrExecutedCommits;
    private static List<ValueMetaInterface> valueMetaPluginClasses;

    private static void initValueMetaPluginClasses() {
        try {
            valueMetaPluginClasses = ValueMetaFactory.getValueMetaPluginClasses();
            valueMetaPluginClasses.sort((o1, o2) -> Integer.compare(o1.getType(), o2.getType()) * -1);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get list of instantiated value meta plugin classes", e);
        }
    }

    @Deprecated
    public Database(DatabaseMeta databaseMeta) {
        this.parentLoggingObject = null;
        this.databaseMeta = databaseMeta;
        this.shareVariablesWith(databaseMeta);
        this.log = new LogChannel(this);
        this.logLevel = this.log.getLogLevel();
        this.containerObjectId = this.log.getContainerObjectId();
        this.pstmt = null;
        this.rowMeta = null;
        this.dbmd = null;
        this.rowlimit = 0;
        this.written = 0;
        this.copy = 0;
        this.opened = 0;
        if (this.log.isDetailed()) {
            this.log.logDetailed("New database connection defined");
        }
    }

    public Database(LoggingObjectInterface parentObject, DatabaseMeta databaseMeta) {
        this.parentLoggingObject = parentObject;
        this.databaseMeta = databaseMeta;
        this.shareVariablesWith(databaseMeta);
        if (parentObject instanceof VariableSpace) {
            this.shareVariablesWith((VariableSpace)((Object)parentObject));
        }
        this.log = new LogChannel((Object)this, parentObject);
        this.containerObjectId = this.log.getContainerObjectId();
        this.logLevel = this.log.getLogLevel();
        if (parentObject != null) {
            this.log.setGatheringMetrics(parentObject.isGatheringMetrics());
        }
        this.pstmt = null;
        this.rowMeta = null;
        this.dbmd = null;
        this.rowlimit = 0;
        this.written = 0;
        this.copy = 0;
        this.opened = 0;
        if (this.log.isDetailed()) {
            this.log.logDetailed("New database connection defined");
        }
    }

    public boolean equals(Object obj) {
        Database other = (Database)obj;
        return this.databaseMeta.equals(other.databaseMeta);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setQueryLimit(int rows) {
        this.rowlimit = rows;
    }

    public PreparedStatement getPrepStatementInsert() {
        return this.prepStatementInsert;
    }

    public PreparedStatement getPrepStatementLookup() {
        return this.prepStatementLookup;
    }

    public PreparedStatement getPrepStatementUpdate() {
        return this.prepStatementUpdate;
    }

    public void connect() throws KettleDatabaseException {
        this.connect(null);
    }

    public void connect(String partitionId) throws KettleDatabaseException {
        this.connect(null, partitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(String group, String partitionId) throws KettleDatabaseException {
        try {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_CONNECT_START, this.databaseMeta.getName(), new long[0]);
            if (!Utils.isEmpty(group)) {
                this.connectionGroup = group;
                this.partitionId = partitionId;
                Database lookup = DatabaseConnectionMap.getInstance().getOrStoreIfAbsent(group, partitionId, this);
                if (lookup == null) {
                    lookup = this;
                }
                lookup.shareConnectionWith(partitionId, this);
            } else {
                this.normalConnect(partitionId);
            }
            try {
                ExtensionPointHandler.callExtensionPoint(this.log, KettleExtensionPoint.DatabaseConnected.id, this);
            }
            catch (KettleException e) {
                throw new KettleDatabaseException(e);
            }
        }
        finally {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_CONNECT_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    private synchronized void shareConnectionWith(String partitionId, Database anotherDb) throws KettleDatabaseException {
        ++this.opened;
        if (this.connection == null) {
            this.normalConnect(partitionId);
            this.copy = this.opened;
            this.setAutoCommit(false);
        }
        anotherDb.connection = this.connection;
        anotherDb.copy = this.opened;
    }

    /*
     * Unable to fully structure code
     */
    public void normalConnect(String partitionId) throws KettleDatabaseException {
        if (this.databaseMeta == null) {
            throw new KettleDatabaseException("No valid database connection defined!");
        }
        try {
            dsp = DataSourceProviderFactory.getDataSourceProviderInterface();
            if (dsp == null) {
                dsp = new DatabaseUtil();
            }
            if (this.databaseMeta.getAccessType() == 4) {
                jndiName = this.environmentSubstitute(this.databaseMeta.getDatabaseName());
                try {
                    this.connection = dsp.getNamedDataSource(jndiName, DataSourceProviderInterface.DatasourceType.JNDI).getConnection();
                }
                catch (DataSourceNamingException e) {
                    this.log.logError("Unable to find datasource by JNDI name: " + jndiName, e);
                    throw e;
                }
            }
            if (this.databaseMeta.isUsingConnectionPool()) {
                name = this.databaseMeta.getName();
                try {
                    try {
                        this.connection = dsp.getNamedDataSource(name, DataSourceProviderInterface.DatasourceType.POOLED).getConnection();
                    }
                    catch (NullPointerException | UnsupportedOperationException e) {
                        this.connection = ConnectionPoolUtil.getConnection(this.log, this.databaseMeta, partitionId);
                    }
                    if (this.getConnection().getAutoCommit() == this.isAutoCommit()) ** GOTO lbl30
                    this.setAutoCommit(this.isAutoCommit());
                }
                catch (DataSourceNamingException e) {
                    this.log.logError("Unable to find pooled datasource by its name: " + name, e);
                    throw e;
                }
            } else {
                this.connectUsingClass(this.databaseMeta.getDriverClass(), partitionId);
            }
lbl30:
            // 4 sources

            sql = this.environmentSubstitute(this.databaseMeta.getConnectSQL());
            if (!Utils.isEmpty(sql) && !Const.onlySpaces(sql)) {
                this.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Executed connect time SQL statements:" + Const.CR + sql);
                }
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Error occurred while trying to connect to the database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectUsingClass(String classname, String partitionId) throws KettleDatabaseException {
        PluginInterface plugin = PluginRegistry.getInstance().getPlugin(DatabasePluginType.class, this.databaseMeta.getDatabaseInterface());
        try {
            Class<DriverManager> clazz = DriverManager.class;
            synchronized (DriverManager.class) {
                ClassLoader classLoader = PluginRegistry.getInstance().getClassLoader(plugin);
                Class<?> driverClass = classLoader.loadClass(classname);
                if (driverClass.getClassLoader() != this.getClass().getClassLoader()) {
                    String pluginId = PluginRegistry.getInstance().getPluginId(DatabasePluginType.class, this.databaseMeta.getDatabaseInterface());
                    Set<String> registeredDriversFromPlugin = registeredDrivers.get(pluginId);
                    if (registeredDriversFromPlugin == null) {
                        registeredDriversFromPlugin = new HashSet<String>();
                        registeredDrivers.put(pluginId, registeredDriversFromPlugin);
                    }
                    if (!registeredDriversFromPlugin.contains(driverClass.getCanonicalName())) {
                        DriverManager.registerDriver(new DelegatingDriver((Driver)driverClass.newInstance()));
                        registeredDriversFromPlugin.add(driverClass.getCanonicalName());
                    }
                } else {
                    Class.forName(classname);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToFindClassMissingDriver", classname, plugin.getName()), e);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Exception while loading class", e);
        }
        {
            try {
                String password;
                String username;
                PartitionDatabaseMeta partition;
                String url = this.databaseMeta.isPartitioned() && !Utils.isEmpty(partitionId) ? this.environmentSubstitute(this.databaseMeta.getURL(partitionId)) : this.environmentSubstitute(this.databaseMeta.getURL());
                String clusterUsername = null;
                String clusterPassword = null;
                if (this.databaseMeta.isPartitioned() && !Utils.isEmpty(partitionId) && (partition = this.databaseMeta.getPartitionMeta(partitionId)) != null) {
                    clusterUsername = partition.getUsername();
                    clusterPassword = Encr.decryptPasswordOptionallyEncrypted(partition.getPassword());
                }
                if (!Utils.isEmpty(clusterUsername)) {
                    username = clusterUsername;
                    password = clusterPassword;
                } else {
                    username = this.environmentSubstitute(this.databaseMeta.getUsername());
                    password = Encr.decryptPasswordOptionallyEncrypted(this.environmentSubstitute(this.databaseMeta.getPassword()));
                }
                Properties properties = this.databaseMeta.getConnectionProperties();
                if (this.databaseMeta.supportsOptionsInURL()) {
                    if (!Utils.isEmpty(username) || !Utils.isEmpty(password)) {
                        String instance;
                        properties.put("user", Const.NVL(username, " "));
                        properties.put("password", Const.NVL(password, ""));
                        if (this.databaseMeta.getDatabaseInterface() instanceof MSSQLServerNativeDatabaseMeta && !Utils.isEmpty(instance = this.environmentSubstitute(this.databaseMeta.getSQLServerInstance()))) {
                            url = url + ";instanceName=" + instance;
                        }
                        this.connection = DriverManager.getConnection(url, properties);
                    } else {
                        this.connection = DriverManager.getConnection(url, properties);
                    }
                } else {
                    if (!Utils.isEmpty(username)) {
                        properties.put("user", username);
                    }
                    if (!Utils.isEmpty(password)) {
                        properties.put("password", password);
                    }
                    this.connection = DriverManager.getConnection(url, properties);
                }
            }
            catch (Exception e) {
                throw new KettleDatabaseException("Error connecting to database: (using class " + classname + ")", e);
            }
            return;
        }
    }

    public synchronized void disconnect() {
        if (this.connection == null) {
            return;
        }
        try {
            if (this.connection.isClosed()) {
                return;
            }
        }
        catch (SQLException ex) {
            this.log.logError("Error checking closing connection:" + Const.CR + ex.getMessage());
            this.log.logError(Const.getStackTracker(ex));
        }
        if (this.pstmt != null) {
            try {
                this.pstmt.close();
            }
            catch (SQLException ex) {
                this.log.logError("Error closing statement:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
            this.pstmt = null;
        }
        if (this.prepStatementLookup != null) {
            try {
                this.prepStatementLookup.close();
            }
            catch (SQLException ex) {
                this.log.logError("Error closing lookup statement:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
            this.prepStatementLookup = null;
        }
        if (this.prepStatementInsert != null) {
            try {
                this.prepStatementInsert.close();
            }
            catch (SQLException ex) {
                this.log.logError("Error closing insert statement:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
            this.prepStatementInsert = null;
        }
        if (this.prepStatementUpdate != null) {
            try {
                this.prepStatementUpdate.close();
            }
            catch (SQLException ex) {
                this.log.logError("Error closing update statement:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
            this.prepStatementUpdate = null;
        }
        if (this.pstmtSeq != null) {
            try {
                this.pstmtSeq.close();
            }
            catch (SQLException ex) {
                this.log.logError("Error closing seq statement:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
            this.pstmtSeq = null;
        }
        if (!Utils.isEmpty(this.connectionGroup)) {
            return;
        }
        if (!this.isAutoCommit()) {
            try {
                this.commit();
            }
            catch (KettleDatabaseException ex) {
                this.log.logError("Error committing:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
        }
        try {
            ExtensionPointHandler.callExtensionPoint(this.log, KettleExtensionPoint.DatabaseDisconnected.id, this);
        }
        catch (KettleException e) {
            this.log.logError("Error disconnecting from database:" + Const.CR + e.getMessage());
            this.log.logError(Const.getStackTracker(e));
        }
        finally {
            try {
                this.closeConnectionOnly();
            }
            catch (KettleDatabaseException ignoredKde) {
                this.log.logError("Error disconnecting from database - closeConnectionOnly failed:" + Const.CR + ignoredKde.getMessage());
                this.log.logError(Const.getStackTracker(ignoredKde));
            }
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public synchronized void closeConnectionOnly() throws KettleDatabaseException {
        try {
            if (this.connection != null) {
                this.connection.close();
                if (!this.databaseMeta.isUsingConnectionPool()) {
                    this.connection = null;
                }
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed("Connection to database closed!");
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error disconnecting from database '" + this.toString() + "'", e);
        }
    }

    public void cancelQuery() throws KettleDatabaseException {
        if (this.databaseMeta.isMySQLVariant() && this.databaseMeta.isStreamingResults() && this.getDatabaseMetaData().getDriverMajorVersion() == 3) {
            return;
        }
        this.cancelStatement(this.pstmt);
        this.cancelStatement(this.selStmt);
    }

    public void cancelStatement(Statement statement) throws KettleDatabaseException {
        try {
            if (statement != null) {
                statement.cancel();
            }
            if (this.log.isDebug()) {
                this.log.logDebug("Statement canceled!");
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error cancelling statement", ex);
        }
    }

    public void setCommit(int commsize) {
        block3: {
            this.commitsize = commsize;
            String onOff = this.commitsize <= 0 ? "on" : "off";
            try {
                this.connection.setAutoCommit(this.commitsize <= 0);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Auto commit " + onOff);
                }
            }
            catch (Exception e) {
                if (!this.log.isDebug()) break block3;
                this.log.logDebug("Can't turn auto commit " + onOff + Const.CR + Const.getStackTracker(e));
            }
        }
    }

    public void setAutoCommit(boolean useAutoCommit) throws KettleDatabaseException {
        try {
            this.connection.setAutoCommit(useAutoCommit);
        }
        catch (SQLException e) {
            if (useAutoCommit) {
                throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToEnableAutoCommit", this.toString()));
            }
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToDisableAutoCommit", this.toString()));
        }
    }

    public void commit() throws KettleDatabaseException {
        this.commit(false);
    }

    public void commit(boolean force) throws KettleDatabaseException {
        block7: {
            try {
                if (!Utils.isEmpty(this.connectionGroup) && !force) {
                    return;
                }
                if (this.getDatabaseMetaData().supportsTransactions()) {
                    if (this.log.isDebug()) {
                        this.log.logDebug("Commit on database connection [" + this.toString() + "]");
                    }
                    this.connection.commit();
                    ++this.nrExecutedCommits;
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("No commit possible on database connection [" + this.toString() + "]");
                }
            }
            catch (Exception e) {
                if (!this.databaseMeta.supportsEmptyTransactions()) break block7;
                throw new KettleDatabaseException("Error comitting connection", e);
            }
        }
    }

    public void commitLog(LogTableCoreInterface logTable) throws KettleDatabaseException {
        this.commitLog(false, logTable);
    }

    public void commitLog(boolean force, LogTableCoreInterface logTable) throws KettleDatabaseException {
        try {
            this.commitInternal(force);
        }
        catch (Exception e) {
            DatabaseLogExceptionFactory.getExceptionStrategy(logTable).registerException(this.log, e, PKG, "Database.Error.UnableToCommitToLogTable", logTable.getActualTableName());
        }
    }

    @Deprecated
    private void commitInternal(boolean force) throws KettleDatabaseException, SQLException {
        if (!Utils.isEmpty(this.connectionGroup) && !force) {
            return;
        }
        if (this.getDatabaseMetaData().supportsTransactions()) {
            if (this.log.isDebug()) {
                this.log.logDebug("Commit on database connection [" + this.toString() + "]");
            }
            this.connection.commit();
            ++this.nrExecutedCommits;
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("No commit possible on database connection [" + this.toString() + "]");
        }
    }

    public void rollback() throws KettleDatabaseException {
        this.rollback(false);
    }

    public void rollback(boolean force) throws KettleDatabaseException {
        try {
            if (!Utils.isEmpty(this.connectionGroup) && !force) {
                return;
            }
            if (this.getDatabaseMetaData().supportsTransactions()) {
                if (this.connection != null) {
                    if (this.log.isDebug()) {
                        this.log.logDebug("Rollback on database connection [" + this.toString() + "]");
                    }
                    this.connection.rollback();
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("No rollback possible on database connection [" + this.toString() + "]");
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error performing rollback on connection", e);
        }
    }

    public void prepareInsert(RowMetaInterface rowMeta, String tableName) throws KettleDatabaseException {
        this.prepareInsert(rowMeta, null, tableName);
    }

    public void prepareInsert(RowMetaInterface rowMeta, String schemaName, String tableName) throws KettleDatabaseException {
        if (rowMeta.size() == 0) {
            throw new KettleDatabaseException("No fields in row, can't insert!");
        }
        String ins = this.getInsertStatement(schemaName, tableName, rowMeta);
        if (this.log.isDetailed()) {
            this.log.logDetailed("Preparing statement: " + Const.CR + ins);
        }
        this.prepStatementInsert = this.prepareSQL(ins);
    }

    public PreparedStatement prepareSQL(String sql) throws KettleDatabaseException {
        return this.prepareSQL(sql, false);
    }

    public PreparedStatement prepareSQL(String sql, boolean returnKeys) throws KettleDatabaseException {
        DatabaseInterface databaseInterface = this.databaseMeta.getDatabaseInterface();
        boolean supportsAutoGeneratedKeys = databaseInterface.supportsAutoGeneratedKeys();
        try {
            if (returnKeys && supportsAutoGeneratedKeys) {
                return this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1);
            }
            return this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Couldn't prepare statement:" + Const.CR + sql, ex);
        }
    }

    public void closeLookup() throws KettleDatabaseException {
        this.closePreparedStatement(this.pstmt);
        this.pstmt = null;
    }

    public void closePreparedStatement(PreparedStatement ps) throws KettleDatabaseException {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing prepared statement", e);
            }
        }
    }

    public void closeInsert() throws KettleDatabaseException {
        if (this.prepStatementInsert != null) {
            try {
                this.prepStatementInsert.close();
                this.prepStatementInsert = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing insert prepared statement.", e);
            }
        }
    }

    public void closeUpdate() throws KettleDatabaseException {
        if (this.prepStatementUpdate != null) {
            try {
                this.prepStatementUpdate.close();
                this.prepStatementUpdate = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing update prepared statement.", e);
            }
        }
    }

    public void setValues(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.pstmt);
    }

    public void setValues(RowMetaAndData row) throws KettleDatabaseException {
        this.setValues(row.getRowMeta(), row.getData());
    }

    public void setValuesInsert(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementInsert);
    }

    public void setValuesInsert(RowMetaAndData row) throws KettleDatabaseException {
        this.setValues(row.getRowMeta(), row.getData(), this.prepStatementInsert);
    }

    public void setValuesUpdate(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementUpdate);
    }

    public void setValuesLookup(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementLookup);
    }

    public void setProcValues(RowMetaInterface rowMeta, Object[] data, int[] argnrs, String[] argdir, boolean result) throws KettleDatabaseException {
        int pos = result ? 2 : 1;
        for (int i = 0; i < argnrs.length; ++i) {
            if (argdir[i].equalsIgnoreCase("IN") || argdir[i].equalsIgnoreCase("INOUT")) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(argnrs[i]);
                Object value = data[argnrs[i]];
                this.setValue(this.cstmt, valueMeta, value, pos);
                ++pos;
                continue;
            }
            ++pos;
        }
    }

    public void setValue(PreparedStatement ps, ValueMetaInterface v, Object object, int pos) throws KettleDatabaseException {
        v.setPreparedStatementValue(this.databaseMeta, ps, pos, object);
    }

    public void setValues(RowMetaAndData row, PreparedStatement ps) throws KettleDatabaseException {
        this.setValues(row.getRowMeta(), row.getData(), ps);
    }

    public void setValues(RowMetaInterface rowMeta, Object[] data, PreparedStatement ps) throws KettleDatabaseException {
        for (int i = 0; i < rowMeta.size(); ++i) {
            ValueMetaInterface v = rowMeta.getValueMeta(i);
            Object object = data[i];
            try {
                this.setValue(ps, v, object, i + 1);
                continue;
            }
            catch (KettleDatabaseException e) {
                throw new KettleDatabaseException("offending row : " + rowMeta, e);
            }
        }
    }

    public void setValues(RowMetaInterface rowMeta, Object[] data, PreparedStatement ps, int ignoreThisValueIndex) throws KettleDatabaseException {
        int index = 0;
        for (int i = 0; i < rowMeta.size(); ++i) {
            if (i == ignoreThisValueIndex) continue;
            ValueMetaInterface v = rowMeta.getValueMeta(i);
            Object object = data[i];
            try {
                this.setValue(ps, v, object, index + 1);
                ++index;
                continue;
            }
            catch (KettleDatabaseException e) {
                throw new KettleDatabaseException("offending row : " + rowMeta, e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RowMetaAndData getGeneratedKeys(PreparedStatement ps) throws KettleDatabaseException {
        try (ResultSet keys = ps.getGeneratedKeys();){
            RowMetaInterface rowMeta;
            ResultSetMetaData resultSetMetaData = keys.getMetaData();
            if (resultSetMetaData == null) {
                resultSetMetaData = ps.getMetaData();
            }
            if (resultSetMetaData == null) {
                rowMeta = new RowMeta();
                rowMeta.addValueMeta(new ValueMetaInteger("ai-key"));
            } else {
                rowMeta = this.getRowInfo(resultSetMetaData, false, false);
            }
            RowMetaAndData rowMetaAndData = new RowMetaAndData(rowMeta, this.getRow(keys, resultSetMetaData, rowMeta));
            return rowMetaAndData;
        }
        catch (Exception ex) {
            throw new KettleDatabaseException("Unable to retrieve key(s) from auto-increment field(s)", ex);
        }
    }

    public Long getNextSequenceValue(String sequenceName, String keyfield) throws KettleDatabaseException {
        return this.getNextSequenceValue(null, sequenceName, keyfield);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextSequenceValue(String schemaName, String sequenceName, String keyfield) throws KettleDatabaseException {
        Long retval = null;
        String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, sequenceName);
        try {
            if (this.pstmtSeq == null) {
                this.pstmtSeq = this.connection.prepareStatement(this.databaseMeta.getSeqNextvalSQL(this.databaseMeta.stripCR(schemaSequence)));
            }
            try (ResultSet rs = null;){
                rs = this.pstmtSeq.executeQuery();
                if (rs.next()) {
                    retval = rs.getLong(1);
                }
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to get next value for sequence : " + schemaSequence, ex);
        }
        return retval;
    }

    public void insertRow(String tableName, RowMetaInterface fields, Object[] data) throws KettleDatabaseException {
        this.insertRow(null, tableName, fields, data);
    }

    public void insertRow(String schemaName, String tableName, RowMetaInterface fields, Object[] data) throws KettleDatabaseException {
        this.prepareInsert(fields, schemaName, tableName);
        this.setValuesInsert(fields, data);
        this.insertRow();
        this.closeInsert();
    }

    public String getInsertStatement(String tableName, RowMetaInterface fields) {
        return this.getInsertStatement(null, tableName, fields);
    }

    public String getInsertStatement(String schemaName, String tableName, RowMetaInterface fields) {
        int i;
        StringBuilder ins = new StringBuilder(128);
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        ins.append("INSERT INTO ").append(schemaTable).append(" (");
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                ins.append(", ");
            }
            String name = fields.getValueMeta(i).getName();
            ins.append(this.databaseMeta.quoteField(name));
        }
        ins.append(") VALUES (");
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                ins.append(", ");
            }
            ins.append(" ?");
        }
        ins.append(')');
        return ins.toString();
    }

    public void insertRow() throws KettleDatabaseException {
        this.insertRow(this.prepStatementInsert);
    }

    public void insertRow(boolean batch) throws KettleDatabaseException {
        this.insertRow(this.prepStatementInsert, batch);
    }

    public void updateRow() throws KettleDatabaseException {
        this.insertRow(this.prepStatementUpdate);
    }

    public void insertRow(PreparedStatement ps) throws KettleDatabaseException {
        this.insertRow(ps, false);
    }

    public boolean insertRow(PreparedStatement ps, boolean batch) throws KettleDatabaseException {
        return this.insertRow(ps, batch, true);
    }

    public boolean getUseBatchInsert(boolean batch) throws KettleDatabaseException {
        try {
            return batch && this.getDatabaseMetaData().supportsBatchUpdates() && this.databaseMeta.supportsBatchUpdates() && Utils.isEmpty(this.connectionGroup);
        }
        catch (SQLException e) {
            throw Database.createKettleDatabaseBatchException("Error determining whether to use batch", e);
        }
    }

    public boolean insertRow(PreparedStatement ps, boolean batch, boolean handleCommit) throws KettleDatabaseException {
        String debug = "insertRow start";
        boolean rowsAreSafe = false;
        boolean isBatchUpdate = false;
        try {
            boolean useBatchInsert = this.getUseBatchInsert(batch);
            if (!this.isAutoCommit()) {
                if (useBatchInsert) {
                    debug = "insertRow add batch";
                    ps.addBatch();
                } else {
                    debug = "insertRow exec update";
                    ps.executeUpdate();
                }
            } else {
                ps.executeUpdate();
            }
            ++this.written;
            if (handleCommit && !this.isAutoCommit() && this.written % this.commitsize == 0) {
                if (useBatchInsert) {
                    isBatchUpdate = true;
                    debug = "insertRow executeBatch commit";
                    ps.executeBatch();
                    this.commit();
                    ps.clearBatch();
                } else {
                    debug = "insertRow normal commit";
                    this.commit();
                }
                this.written = 0;
                rowsAreSafe = true;
            }
            return rowsAreSafe;
        }
        catch (BatchUpdateException ex) {
            throw Database.createKettleDatabaseBatchException("Error updating batch", ex);
        }
        catch (SQLException ex) {
            if (isBatchUpdate) {
                throw Database.createKettleDatabaseBatchException("Error updating batch", ex);
            }
            throw new KettleDatabaseException("Error inserting/updating row", ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unexpected error inserting/updating row in part [" + debug + "]", e);
        }
    }

    @Deprecated
    public void clearInsertBatch() throws KettleDatabaseException {
        this.clearBatch(this.prepStatementInsert);
    }

    public void clearBatch(PreparedStatement preparedStatement) throws KettleDatabaseException {
        try {
            preparedStatement.clearBatch();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to clear batch for prepared statement", e);
        }
    }

    public void executeAndClearBatch(PreparedStatement preparedStatement) throws KettleDatabaseException {
        try {
            if (this.written > 0 && this.getDatabaseMetaData().supportsBatchUpdates()) {
                preparedStatement.executeBatch();
            }
            this.written = 0;
            preparedStatement.clearBatch();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to clear batch for prepared statement", e);
        }
    }

    public void insertFinished(boolean batch) throws KettleDatabaseException {
        this.insertFinished(this.prepStatementInsert, batch);
        this.prepStatementInsert = null;
    }

    public void emptyAndCommit(PreparedStatement ps, boolean batch) throws KettleDatabaseException {
        this.emptyAndCommit(ps, batch, this.written);
    }

    public void emptyAndCommit(PreparedStatement ps, boolean batch, int batchCounter) throws KettleDatabaseException {
        boolean isBatchUpdate = false;
        try {
            if (ps != null) {
                if (!this.isAutoCommit()) {
                    if (batch && this.getDatabaseMetaData().supportsBatchUpdates() && batchCounter > 0) {
                        isBatchUpdate = true;
                        ps.executeBatch();
                        this.commit();
                        ps.clearBatch();
                    } else {
                        this.commit();
                    }
                }
                ps.close();
            }
        }
        catch (BatchUpdateException ex) {
            throw Database.createKettleDatabaseBatchException("Error updating batch", ex);
        }
        catch (SQLException ex) {
            if (isBatchUpdate) {
                throw Database.createKettleDatabaseBatchException("Error updating batch", ex);
            }
            throw new KettleDatabaseException("Unable to empty ps and commit connection.", ex);
        }
    }

    public static KettleDatabaseBatchException createKettleDatabaseBatchException(String message, SQLException ex) {
        KettleDatabaseBatchException kdbe = new KettleDatabaseBatchException(message, ex);
        if (ex instanceof BatchUpdateException) {
            kdbe.setUpdateCounts(((BatchUpdateException)ex).getUpdateCounts());
        } else {
            kdbe.setUpdateCounts(null);
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        SQLException oldException = null;
        for (SQLException nextException = ex.getNextException(); nextException != null && oldException != nextException; nextException = nextException.getNextException()) {
            exceptions.add(nextException);
            oldException = nextException;
        }
        kdbe.setExceptionsList(exceptions);
        return kdbe;
    }

    @Deprecated
    public void insertFinished(PreparedStatement ps, boolean batch) throws KettleDatabaseException {
        boolean isBatchUpdate = false;
        try {
            if (ps != null) {
                if (!this.isAutoCommit()) {
                    if (batch && this.getDatabaseMetaData().supportsBatchUpdates()) {
                        isBatchUpdate = true;
                        ps.executeBatch();
                        this.commit();
                    } else {
                        this.commit();
                    }
                }
                ps.close();
            }
        }
        catch (BatchUpdateException ex) {
            throw Database.createKettleDatabaseBatchException("Error updating batch", ex);
        }
        catch (SQLException ex) {
            if (isBatchUpdate) {
                throw Database.createKettleDatabaseBatchException("Error updating batch", ex);
            }
            throw new KettleDatabaseException("Unable to commit connection after having inserted rows.", ex);
        }
    }

    public Result execStatement(String sql) throws KettleDatabaseException {
        return this.execStatement(sql, null, null);
    }

    public Result execStatement(String rawsql, RowMetaInterface params, Object[] data) throws KettleDatabaseException {
        Result result = new Result();
        String sql = this.databaseMeta.getDatabaseInterface().createSqlScriptParser().removeComments(rawsql).trim();
        try {
            int count;
            boolean resultSet;
            if (params != null) {
                try (PreparedStatement prepStmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));){
                    this.setValues(params, data, prepStmt);
                    resultSet = prepStmt.execute();
                    count = prepStmt.getUpdateCount();
                }
            }
            String sqlStripped = this.databaseMeta.stripCR(sql);
            try (Statement stmt = this.connection.createStatement();){
                resultSet = stmt.execute(sqlStripped);
                count = stmt.getUpdateCount();
            }
            String upperSql = sql.toUpperCase();
            if (!resultSet && count > 0) {
                if (upperSql.startsWith("INSERT")) {
                    result.setNrLinesOutput(count);
                } else if (upperSql.startsWith("UPDATE")) {
                    result.setNrLinesUpdated(count);
                } else if (upperSql.startsWith("DELETE")) {
                    result.setNrLinesDeleted(count);
                }
            }
            if (upperSql.startsWith("ALTER TABLE") || upperSql.startsWith("DROP TABLE") || upperSql.startsWith("CREATE TABLE")) {
                DBCache.getInstance().clear(this.databaseMeta.getName());
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Couldn't execute SQL: " + sql + Const.CR, ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unexpected error executing SQL: " + Const.CR, e);
        }
        return result;
    }

    public Result execStatements(String script) throws KettleDatabaseException {
        return this.execStatements(script, null, null);
    }

    public Result execStatements(String script, RowMetaInterface params, Object[] data) throws KettleDatabaseException {
        Result result = new Result();
        SqlScriptParser sqlScriptParser = this.databaseMeta.getDatabaseInterface().createSqlScriptParser();
        List<String> statements = sqlScriptParser.split(script);
        int nrstats = 0;
        if (statements != null) {
            for (String stat : statements) {
                if (Const.onlySpaces(stat = sqlScriptParser.removeComments(stat))) continue;
                String sql = Const.trim(stat);
                if (sql.toUpperCase().startsWith("SELECT")) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("launch SELECT statement: " + Const.CR + sql);
                    }
                    ++nrstats;
                    ResultSet rs = null;
                    try {
                        rs = this.openQuery(sql, params, data);
                        if (rs != null) {
                            Object[] row = this.getRow(rs);
                            while (row != null) {
                                result.setNrLinesRead(result.getNrLinesRead() + 1L);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.rowMeta.getString(row));
                                }
                                row = this.getRow(rs);
                            }
                            continue;
                        }
                        if (!this.log.isDebug()) continue;
                        this.log.logDebug("Error executing query: " + Const.CR + sql);
                        continue;
                    }
                    catch (KettleValueException e) {
                        throw new KettleDatabaseException(e);
                    }
                    finally {
                        try {
                            if (rs == null) continue;
                            rs.close();
                        }
                        catch (SQLException ex) {
                            if (!this.log.isDebug()) continue;
                            this.log.logDebug("Error closing query: " + Const.CR + sql);
                        }
                        continue;
                    }
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed("launch DDL statement: " + Const.CR + sql);
                }
                ++nrstats;
                Result res = this.execStatement(sql, params, data);
                result.add(res);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(nrstats + " statement" + (nrstats == 1 ? "" : "s") + " executed");
        }
        return result;
    }

    public ResultSet openQuery(String sql) throws KettleDatabaseException {
        return this.openQuery(sql, null, null);
    }

    public ResultSet openQuery(String sql, RowMetaInterface params, Object[] data) throws KettleDatabaseException {
        return this.openQuery(sql, params, data, 1000);
    }

    public ResultSet openQuery(String sql, RowMetaInterface params, Object[] data, int fetchMode) throws KettleDatabaseException {
        return this.openQuery(sql, params, data, fetchMode, false);
    }

    public ResultSet openQuery(String sql, RowMetaInterface params, Object[] data, int fetchMode, boolean lazyConversion) throws KettleDatabaseException {
        ResultSet res;
        try {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_OPEN_QUERY_START, this.databaseMeta.getName(), new long[0]);
            if (params != null) {
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_PREPARE_SQL_START, this.databaseMeta.getName(), new long[0]);
                this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1003, 1007);
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_PREPARE_SQL_STOP, this.databaseMeta.getName(), new long[0]);
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_SQL_VALUES_START, this.databaseMeta.getName(), new long[0]);
                this.setValues(params, data);
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_SQL_VALUES_STOP, this.databaseMeta.getName(), new long[0]);
                if (this.canWeSetFetchSize(this.pstmt)) {
                    int fs;
                    int maxRows = this.pstmt.getMaxRows();
                    int n = fs = 10000 <= maxRows ? maxRows : 10000;
                    if (this.databaseMeta.isMySQLVariant()) {
                        this.setMysqlFetchSize(this.pstmt, fs, maxRows);
                    } else {
                        this.pstmt.setFetchSize(fs);
                    }
                    this.pstmt.setFetchDirection(fetchMode);
                }
                if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                    this.pstmt.setMaxRows(this.rowlimit);
                }
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_EXECUTE_SQL_START, this.databaseMeta.getName(), new long[0]);
                res = this.pstmt.executeQuery();
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_EXECUTE_SQL_STOP, this.databaseMeta.getName(), new long[0]);
            } else {
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_CREATE_SQL_START, this.databaseMeta.getName(), new long[0]);
                this.selStmt = this.connection.createStatement();
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_CREATE_SQL_STOP, this.databaseMeta.getName(), new long[0]);
                if (this.canWeSetFetchSize(this.selStmt)) {
                    int fs;
                    int n = fs = 10000 <= this.selStmt.getMaxRows() ? this.selStmt.getMaxRows() : 10000;
                    if (this.databaseMeta.getDatabaseInterface().isMySQLVariant() && this.databaseMeta.isStreamingResults()) {
                        this.selStmt.setFetchSize(Integer.MIN_VALUE);
                    } else {
                        this.selStmt.setFetchSize(fs);
                    }
                    this.selStmt.setFetchDirection(fetchMode);
                }
                if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                    this.selStmt.setMaxRows(this.rowlimit);
                }
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_EXECUTE_SQL_START, this.databaseMeta.getName(), new long[0]);
                res = this.selStmt.executeQuery(this.databaseMeta.stripCR(sql));
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_EXECUTE_SQL_STOP, this.databaseMeta.getName(), new long[0]);
            }
            this.rowMeta = this.getRowInfo(res.getMetaData(), this.databaseMeta.isMySQLVariant(), lazyConversion);
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("An error occurred executing SQL: " + Const.CR + sql, ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("An error occurred executing SQL:" + Const.CR + sql, e);
        }
        finally {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_OPEN_QUERY_STOP, this.databaseMeta.getName(), new long[0]);
        }
        return res;
    }

    private boolean canWeSetFetchSize(Statement statement) throws SQLException {
        return this.databaseMeta.isFetchSizeSupported() && (statement.getMaxRows() > 0 || this.databaseMeta.getDatabaseInterface() instanceof PostgreSQLDatabaseMeta || this.databaseMeta.isMySQLVariant() && this.databaseMeta.isStreamingResults());
    }

    public ResultSet openQuery(PreparedStatement ps, RowMetaInterface params, Object[] data) throws KettleDatabaseException {
        ResultSet res;
        try {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_OPEN_QUERY_START, this.databaseMeta.getName(), new long[0]);
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_SQL_VALUES_START, this.databaseMeta.getName(), new long[0]);
            this.setValues(params, data, ps);
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_SQL_VALUES_STOP, this.databaseMeta.getName(), new long[0]);
            if (this.canWeSetFetchSize(ps)) {
                int fs;
                int maxRows = ps.getMaxRows();
                int n = fs = 10000 <= maxRows ? maxRows : 10000;
                if (this.databaseMeta.isMySQLVariant()) {
                    this.setMysqlFetchSize(ps, fs, maxRows);
                } else {
                    ps.setFetchSize(fs);
                }
                ps.setFetchDirection(1000);
            }
            if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                ps.setMaxRows(this.rowlimit);
            }
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_EXECUTE_SQL_START, this.databaseMeta.getName(), new long[0]);
            res = ps.executeQuery();
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_EXECUTE_SQL_STOP, this.databaseMeta.getName(), new long[0]);
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_META_START, this.databaseMeta.getName(), new long[0]);
            this.rowMeta = this.getRowInfo(res.getMetaData(), this.databaseMeta.isMySQLVariant(), false);
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_META_STOP, this.databaseMeta.getName(), new long[0]);
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("ERROR executing query", ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("ERROR executing query", e);
        }
        finally {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_OPEN_QUERY_STOP, this.databaseMeta.getName(), new long[0]);
        }
        return res;
    }

    void setMysqlFetchSize(PreparedStatement ps, int fs, int getMaxRows) throws SQLException, KettleDatabaseException {
        if (this.databaseMeta.isStreamingResults() && this.getDatabaseMetaData().getDriverMajorVersion() == 3) {
            ps.setFetchSize(Integer.MIN_VALUE);
        } else if (fs <= getMaxRows) {
            ps.setFetchSize(fs);
        }
    }

    public RowMetaInterface getTableFields(String tablename) throws KettleDatabaseException {
        return this.getQueryFields(this.databaseMeta.getSQLQueryFields(tablename), false);
    }

    public RowMetaInterface getQueryFields(String sql, boolean param) throws KettleDatabaseException {
        return this.getQueryFields(sql, param, null, null);
    }

    @Deprecated
    public boolean checkTableExists(String tablename) throws KettleDatabaseException {
        try {
            if (this.log.isDebug()) {
                this.log.logDebug("Checking if table [" + tablename + "] exists!");
            }
            String sql = this.databaseMeta.getSQLTableExists(tablename);
            try {
                this.getOneRow(sql);
                return true;
            }
            catch (KettleDatabaseException e) {
                return false;
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to check if table [" + tablename + "] exists on connection [" + this.databaseMeta.getName() + "]", e);
        }
    }

    public boolean checkTableExists(String schema, String tablename) throws KettleDatabaseException {
        if (this.useJdbcMeta()) {
            return this.checkTableExistsByDbMeta(schema, tablename);
        }
        return this.checkTableExists(this.databaseMeta.getQuotedSchemaTableCombination(schema, tablename));
    }

    @Deprecated
    public boolean checkTableExistsByDbMeta(String schema, String tablename) throws KettleDatabaseException {
        boolean isTableExist = false;
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, "Database.Info.CheckingIfTableExistsInDbMetaData", tablename));
        }
        try (ResultSet resTables = this.getTableMetaData(schema, tablename);){
            while (resTables.next()) {
                String resTableName = resTables.getString(TABLES_META_DATA_TABLE_NAME);
                if (!tablename.equalsIgnoreCase(resTableName)) continue;
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, "Database.Info.TableFound", tablename));
                }
                isTableExist = true;
                break;
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Error.UnableToCheckExistingTable", tablename, this.databaseMeta.getName()), e);
        }
        return isTableExist;
    }

    private ResultSet getTableMetaData(String schema, String table) throws KettleDatabaseException {
        ResultSet tables = null;
        if (this.getDatabaseMetaData() == null) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Error.UnableToGetDbMeta", new String[0]));
        }
        try {
            tables = this.databaseMeta.getTables(this.getDatabaseMetaData(), schema, table, TABLE_TYPES_TO_GET);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Error.UnableToGetTableNames", new String[0]), e);
        }
        if (tables == null) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Error.UnableToGetTableNames", new String[0]));
        }
        return tables;
    }

    private ResultSet getColumnsMetaData(String schema, String table) throws KettleDatabaseException {
        ResultSet columns = null;
        if (this.getDatabaseMetaData() == null) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Error.UnableToGetDbMeta", new String[0]));
        }
        try {
            columns = this.getDatabaseMetaData().getColumns(null, schema, table, null);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Error.UnableToGetTableNames", new String[0]), e);
        }
        if (columns == null) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Error.UnableToGetTableNames", new String[0]));
        }
        return columns;
    }

    public boolean checkColumnExists(String schemaname, String tablename, String columnname) throws KettleDatabaseException {
        if (this.useJdbcMeta()) {
            return this.checkColumnExistsByDbMeta(schemaname, tablename, columnname);
        }
        return this.checkColumnExists(this.databaseMeta.quoteField(columnname), this.databaseMeta.getQuotedSchemaTableCombination(schemaname, tablename));
    }

    public boolean checkColumnExistsByDbMeta(String schemaname, String tablename, String columnname) throws KettleDatabaseException {
        if (this.log.isDebug()) {
            this.log.logDebug("Checking if column [" + columnname + "] exists in table [" + tablename + "] !");
        }
        try {
            ResultSet columns = this.getColumnsMetaData(schemaname, tablename);
            while (columns.next()) {
                if (!columnname.equals(columns.getString("COLUMN_NAME"))) continue;
                return true;
            }
            return false;
        }
        catch (SQLException | KettleDatabaseException e) {
            throw new KettleDatabaseException("Metadata check failed. Fallback to statement check.");
        }
    }

    @Deprecated
    public boolean checkColumnExists(String columnname, String tablename) throws KettleDatabaseException {
        try {
            if (this.log.isDebug()) {
                this.log.logDebug("Checking if column [" + columnname + "] exists in table [" + tablename + "] !");
            }
            String sql = this.databaseMeta.getSQLColumnExists(columnname, tablename);
            try {
                this.getOneRow(sql);
                return true;
            }
            catch (KettleDatabaseException e) {
                return false;
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to check if column [" + columnname + "] exists in table [" + tablename + "] on connection [" + this.databaseMeta.getName() + "]", e);
        }
    }

    public boolean checkSequenceExists(String sequenceName) throws KettleDatabaseException {
        return this.checkSequenceExists(null, sequenceName);
    }

    public boolean checkSequenceExists(String schemaName, String sequenceName) throws KettleDatabaseException {
        boolean retval = false;
        if (!this.databaseMeta.supportsSequences()) {
            return retval;
        }
        String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, sequenceName);
        try {
            String sql = this.databaseMeta.getSQLSequenceExists(schemaSequence);
            ResultSet res = this.openQuery(sql);
            if (res != null) {
                Object[] row = this.getRow(res);
                if (row != null) {
                    retval = true;
                }
                this.closeQuery(res);
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unexpected error checking whether or not sequence [" + schemaSequence + "] exists", e);
        }
        return retval;
    }

    public boolean checkIndexExists(String tableName, String[] idxFields) throws KettleDatabaseException {
        return this.checkIndexExists(null, tableName, idxFields);
    }

    public boolean checkIndexExists(String schemaName, String tableName, String[] idxFields) throws KettleDatabaseException {
        String tablename = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        if (!this.checkTableExists(tablename)) {
            return false;
        }
        if (this.log.isDebug()) {
            this.log.logDebug("CheckIndexExists() tablename = " + tablename + " type = " + this.databaseMeta.getPluginId());
        }
        return this.databaseMeta.getDatabaseInterface().checkIndexExists(this, schemaName, tableName, idxFields);
    }

    public String getCreateIndexStatement(String tablename, String indexname, String[] idxFields, boolean tk, boolean unique, boolean bitmap, boolean semiColon) {
        return this.getCreateIndexStatement(null, tablename, indexname, idxFields, tk, unique, bitmap, semiColon);
    }

    public String getCreateIndexStatement(String schemaname, String tablename, String indexname, String[] idxFields, boolean tk, boolean unique, boolean bitmap, boolean semiColon) {
        StringBuilder crIndex = new StringBuilder();
        DatabaseInterface databaseInterface = this.databaseMeta.getDatabaseInterface();
        if (!databaseInterface.supportsIndexes()) {
            return "";
        }
        crIndex.append("CREATE ");
        if (unique || tk && databaseInterface instanceof SybaseDatabaseMeta) {
            crIndex.append("UNIQUE ");
        }
        if (bitmap && this.databaseMeta.supportsBitmapIndex()) {
            crIndex.append("BITMAP ");
        }
        crIndex.append("INDEX ").append(this.databaseMeta.quoteField(indexname)).append(" ");
        crIndex.append("ON ");
        crIndex.append(tablename);
        crIndex.append("(");
        for (int i = 0; i < idxFields.length; ++i) {
            if (i > 0) {
                crIndex.append(", ");
            }
            crIndex.append(this.databaseMeta.quoteField(idxFields[i]));
        }
        crIndex.append(")").append(Const.CR);
        crIndex.append(databaseInterface.getIndexTablespaceDDL(this.variables, this.databaseMeta));
        if (semiColon) {
            crIndex.append(";").append(Const.CR);
        }
        return crIndex.toString();
    }

    public String getCreateSequenceStatement(String sequence, long startAt, long incrementBy, long maxValue, boolean semiColon) {
        return this.getCreateSequenceStatement(null, sequence, Long.toString(startAt), Long.toString(incrementBy), Long.toString(maxValue), semiColon);
    }

    public String getCreateSequenceStatement(String sequence, String startAt, String incrementBy, String maxValue, boolean semiColon) {
        return this.getCreateSequenceStatement(null, sequence, startAt, incrementBy, maxValue, semiColon);
    }

    public String getCreateSequenceStatement(String schemaName, String sequence, long startAt, long incrementBy, long maxValue, boolean semiColon) {
        return this.getCreateSequenceStatement(schemaName, sequence, Long.toString(startAt), Long.toString(incrementBy), Long.toString(maxValue), semiColon);
    }

    public String getCreateSequenceStatement(String schemaName, String sequenceName, String startAt, String incrementBy, String maxValue, boolean semiColon) {
        String crSeq = "";
        if (Utils.isEmpty(sequenceName)) {
            return crSeq;
        }
        if (this.databaseMeta.supportsSequences()) {
            String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, sequenceName);
            crSeq = crSeq + "CREATE SEQUENCE " + schemaSequence + " " + Const.CR;
            crSeq = crSeq + "START WITH " + startAt + " " + Const.CR;
            crSeq = crSeq + "INCREMENT BY " + incrementBy + " " + Const.CR;
            if (maxValue != null) {
                if (this.databaseMeta.supportsSequenceNoMaxValueOption() && maxValue.trim().equals("-1")) {
                    DatabaseInterface databaseInterface = this.databaseMeta.getDatabaseInterface();
                    crSeq = crSeq + databaseInterface.getSequenceNoMaxValueOption() + Const.CR;
                } else {
                    crSeq = crSeq + "MAXVALUE " + maxValue + Const.CR;
                }
            }
            if (semiColon) {
                crSeq = crSeq + ";" + Const.CR;
            }
        }
        return crSeq;
    }

    public RowMetaInterface getTableFieldsMeta(String schemaName, String tableName) throws KettleDatabaseException {
        if (this.useJdbcMeta()) {
            return this.getTableFieldsMetaByDbMeta(schemaName, tableName);
        }
        String tableSchema = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        String sql = this.databaseMeta.getSQLQueryFields(tableSchema);
        return this.getQueryFields(sql, false);
    }

    public RowMetaInterface getTableFieldsMetaByDbMeta(String schemaName, String tableName) throws KettleDatabaseException {
        try {
            if ("".equals(schemaName)) {
                schemaName = null;
            }
            if ("".equals(tableName)) {
                tableName = null;
            }
            RowMetaInterface fields = null;
            DBCache dbcache = DBCache.getInstance();
            DBCacheEntry entry = null;
            if (dbcache != null && (fields = dbcache.get(entry = new DBCacheEntry(this.databaseMeta.getName(), "LIGHTWEIGHT_SALT".concat(schemaName == null ? "nullSchema" : schemaName).concat(tableName == null ? "nullTable" : tableName)))) != null) {
                return fields;
            }
            if (this.connection == null) {
                return null;
            }
            ResultSet rm = this.connection.getMetaData().getColumns(null, schemaName, tableName, null);
            if (fields == null) {
                fields = new RowMeta();
            }
            while (rm.next()) {
                ValueMetaInterface valueMeta = null;
                for (ValueMetaInterface valueMetaClass : valueMetaPluginClasses) {
                    try {
                        ValueMetaInterface v = valueMetaClass.getMetadataPreview(this.databaseMeta, rm);
                        if (v == null) continue;
                        valueMeta = v;
                        break;
                    }
                    catch (KettleDatabaseException e) {
                        if (!this.log.isDebug()) continue;
                        this.log.logDebug("Skipping ValueMetaInterface:" + valueMetaClass.getClass().getName(), e);
                    }
                }
                fields.addValueMeta(valueMeta);
            }
            if (dbcache != null && entry != null && fields != null) {
                dbcache.put(entry, fields);
            }
            return fields;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Failed to fetch fields from jdbc meta ", e);
        }
    }

    public RowMetaInterface getQueryFields(String sql, boolean param, RowMetaInterface inform, Object[] data) throws KettleDatabaseException {
        RowMetaInterface fields;
        DBCache dbcache = DBCache.getInstance();
        DBCacheEntry entry = null;
        if (dbcache != null && (fields = dbcache.get(entry = new DBCacheEntry(this.databaseMeta.getName(), sql))) != null) {
            return fields;
        }
        if (this.connection == null) {
            return null;
        }
        try {
            fields = this.databaseMeta.supportsPreparedStatementMetadataRetrieval() ? this.getQueryFieldsFromPreparedStatement(sql) : (this.isDataServiceConnection() ? this.getQueryFieldsFromDatabaseMetaData(sql) : this.getQueryFieldsFromDatabaseMetaData());
        }
        catch (Exception e) {
            fields = this.getQueryFieldsFallback(sql, param, inform, data);
        }
        if (dbcache != null && entry != null && fields != null) {
            dbcache.put(entry, fields);
        }
        return fields;
    }

    private boolean isDataServiceConnection() {
        return DATA_SERVICES_PLUGIN_ID.equals(this.databaseMeta.getPluginId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RowMetaInterface getQueryFieldsFromPreparedStatement(String sql) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1003, 1007);){
            preparedStatement.setMaxRows(1);
            ResultSetMetaData rsmd = preparedStatement.getMetaData();
            RowMetaInterface rowMetaInterface = this.getRowInfo(rsmd, false, false);
            return rowMetaInterface;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public RowMetaInterface getQueryFieldsFromDatabaseMetaData() throws Exception {
        return this.getQueryFieldsFromDatabaseMetaData(null);
    }

    private RowMetaInterface getQueryFieldsFromDatabaseMetaData(String sql) throws Exception {
        ResultSet columns = this.connection.getMetaData().getColumns("", "", StringUtils.isNotBlank((String)sql) ? sql : this.databaseMeta.getName(), "");
        RowMeta rowMeta = new RowMeta();
        while (columns.next()) {
            ValueMetaBase valueMeta = null;
            String name = columns.getString("COLUMN_NAME");
            String type = columns.getString("SOURCE_DATA_TYPE");
            int size = columns.getInt("COLUMN_SIZE");
            if (type.equals("Integer") || type.equals("Long")) {
                valueMeta = new ValueMetaInteger();
            } else if (type.equals("BigDecimal") || type.equals("BigNumber")) {
                valueMeta = new ValueMetaBigNumber();
            } else if (type.equals("Double") || type.equals("Number")) {
                valueMeta = new ValueMetaNumber();
            } else if (type.equals("String")) {
                valueMeta = new ValueMetaString();
            } else if (type.equals("Date")) {
                valueMeta = new ValueMetaDate();
            } else if (type.equals("Boolean")) {
                valueMeta = new ValueMetaBoolean();
            } else if (type.equals("Binary")) {
                valueMeta = new ValueMetaBinary();
            } else if (type.equals("Timestamp")) {
                valueMeta = new ValueMetaTimestamp();
            } else if (type.equals("Internet Address")) {
                valueMeta = new ValueMetaInternetAddress();
            }
            if (valueMeta != null) {
                valueMeta.setName(name);
                valueMeta.setComments(name);
                valueMeta.setLength(size);
                valueMeta.setOriginalColumnTypeName(type);
                valueMeta.setConversionMask(columns.getString("SOURCE_MASK"));
                valueMeta.setDecimalSymbol(columns.getString("SOURCE_DECIMAL_SYMBOL"));
                valueMeta.setGroupingSymbol(columns.getString("SOURCE_GROUPING_SYMBOL"));
                valueMeta.setCurrencySymbol(columns.getString("SOURCE_CURRENCY_SYMBOL"));
                rowMeta.addValueMeta(valueMeta);
                continue;
            }
            this.log.logBasic("Database.getQueryFields() ValueMetaInterface mapping not resolved for the column " + name);
            rowMeta = null;
            break;
        }
        if (rowMeta != null && !rowMeta.isEmpty()) {
            return rowMeta;
        }
        throw new Exception("Error in Database.getQueryFields()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowMetaInterface getQueryFieldsFallback(String sql, boolean param, RowMetaInterface inform, Object[] data) throws KettleDatabaseException {
        RowMetaInterface fields;
        block22: {
            try {
                if (inform == null && this.databaseMeta.getDatabaseInterface() instanceof MSSQLServerDatabaseMeta || this.databaseMeta.getDatabaseInterface().supportsResultSetMetadataRetrievalOnly()) {
                    this.selStmt = this.connection.createStatement(1003, 1007);
                    try {
                        if (this.databaseMeta.isFetchSizeSupported() && this.selStmt.getMaxRows() >= 1) {
                            if (this.databaseMeta.getDatabaseInterface().isMySQLVariant()) {
                                this.selStmt.setFetchSize(Integer.MIN_VALUE);
                            } else {
                                this.selStmt.setFetchSize(1);
                            }
                        }
                        if (this.databaseMeta.supportsSetMaxRows()) {
                            this.selStmt.setMaxRows(1);
                        }
                        try (ResultSet r = this.selStmt.executeQuery(this.databaseMeta.stripCR(sql));){
                            fields = this.getRowInfo(r.getMetaData(), false, false);
                            break block22;
                        }
                    }
                    finally {
                        this.selStmt.close();
                        this.selStmt = null;
                    }
                }
                try (PreparedStatement ps = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));){
                    if (param) {
                        RowMetaInterface par = inform;
                        if (par == null || par.isEmpty()) {
                            par = this.getParameterMetaData(ps);
                        }
                        if (par == null || par.isEmpty()) {
                            par = this.getParameterMetaData(sql, inform, data);
                        }
                        this.setValues(par, data, ps);
                    }
                    try (ResultSet r = ps.executeQuery();){
                        ResultSetMetaData metadata = r.getMetaData();
                        fields = this.getRowInfo(metadata, false, false);
                    }
                }
            }
            catch (Exception ex) {
                throw new KettleDatabaseException("Couldn't get field info from [" + sql + "]" + Const.CR, ex);
            }
        }
        return fields;
    }

    public void closeQuery(ResultSet res) throws KettleDatabaseException {
        try {
            if (res != null) {
                res.close();
            }
            if (this.selStmt != null) {
                this.selStmt.close();
                this.selStmt = null;
            }
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Couldn't close query: resultset or prepared statements", ex);
        }
    }

    private RowMetaInterface getRowInfo(ResultSetMetaData rm, boolean ignoreLength, boolean lazyConversion) throws KettleDatabaseException {
        try {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_META_START, this.databaseMeta.getName(), new long[0]);
            if (rm == null) {
                throw new KettleDatabaseException("No result set metadata available to retrieve row metadata!");
            }
            RowMeta rowMeta = new RowMeta();
            try {
                int nrcols = rm.getColumnCount();
                for (int i = 1; i <= nrcols; ++i) {
                    ValueMetaInterface valueMeta = this.getValueFromSQLType(rm, i, ignoreLength, lazyConversion);
                    rowMeta.addValueMeta(valueMeta);
                }
                RowMeta rowMeta2 = rowMeta;
                return rowMeta2;
            }
            catch (SQLException ex) {
                throw new KettleDatabaseException("Error getting row information from database: ", ex);
            }
        }
        finally {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_META_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    private ValueMetaInterface getValueFromSQLType(ResultSetMetaData rm, int i, boolean ignoreLength, boolean lazyConversion) throws KettleDatabaseException, SQLException {
        String name = this.databaseMeta.isMySQLVariant() ? this.databaseMeta.getDatabaseInterface().getLegacyColumnName(this.getDatabaseMetaData(), rm, i) : new String(rm.getColumnName(i));
        if (Utils.isEmpty(name) || Const.onlySpaces(name)) {
            name = "Field" + (i + 1);
        }
        ValueMetaInterface valueMeta = null;
        for (ValueMetaInterface valueMetaClass : valueMetaPluginClasses) {
            ValueMetaInterface v = valueMetaClass.getValueFromSQLType(this.databaseMeta, name, rm, i, ignoreLength, lazyConversion);
            if (v == null) continue;
            valueMeta = v;
            break;
        }
        if (valueMeta != null) {
            return valueMeta;
        }
        throw new KettleDatabaseException("Unable to handle database column '" + name + "', on column index " + i + " : not a handled data type");
    }

    public boolean absolute(ResultSet rs, int position) throws KettleDatabaseException {
        try {
            return rs.absolute(position);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move resultset to position " + position, e);
        }
    }

    public boolean relative(ResultSet rs, int rows) throws KettleDatabaseException {
        try {
            return rs.relative(rows);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move the resultset forward " + rows + " rows", e);
        }
    }

    public void afterLast(ResultSet rs) throws KettleDatabaseException {
        try {
            rs.afterLast();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move resultset to after the last position", e);
        }
    }

    public void first(ResultSet rs) throws KettleDatabaseException {
        try {
            rs.first();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move resultset to the first position", e);
        }
    }

    public Object[] getRow(ResultSet rs) throws KettleDatabaseException {
        return this.getRow(rs, false);
    }

    public Object[] getRow(ResultSet rs, boolean lazyConversion) throws KettleDatabaseException {
        if (this.rowMeta == null) {
            ResultSetMetaData rsmd = null;
            try {
                rsmd = rs.getMetaData();
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Unable to retrieve metadata from resultset", e);
            }
            this.rowMeta = this.getRowInfo(rsmd, false, lazyConversion);
        }
        return this.getRow(rs, null, this.rowMeta);
    }

    public Object[] getRow(ResultSet rs, ResultSetMetaData dummy, RowMetaInterface rowInfo) throws KettleDatabaseException {
        Object[] objectArray;
        block8: {
            long startTime = System.currentTimeMillis();
            try {
                int nrcols = rowInfo.size();
                Object[] data = RowDataUtil.allocateRowData(nrcols);
                if (rs.next()) {
                    for (int i = 0; i < nrcols; ++i) {
                        ValueMetaInterface val = rowInfo.getValueMeta(i);
                        data[i] = this.databaseMeta.getValueFromResultSet(rs, val, i);
                    }
                } else {
                    data = null;
                }
                objectArray = data;
                if (!this.log.isGatheringMetrics()) break block8;
            }
            catch (Exception ex) {
                try {
                    throw new KettleDatabaseException("Couldn't get row from result set", ex);
                }
                catch (Throwable throwable) {
                    if (this.log.isGatheringMetrics()) {
                        long time = System.currentTimeMillis() - startTime;
                        this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_SUM_TIME, this.databaseMeta.getName(), time);
                        this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_MIN_TIME, this.databaseMeta.getName(), time);
                        this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_MAX_TIME, this.databaseMeta.getName(), time);
                        this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_COUNT, this.databaseMeta.getName(), new long[0]);
                    }
                    throw throwable;
                }
            }
            long time = System.currentTimeMillis() - startTime;
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_SUM_TIME, this.databaseMeta.getName(), time);
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_MIN_TIME, this.databaseMeta.getName(), time);
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_MAX_TIME, this.databaseMeta.getName(), time);
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_ROW_COUNT, this.databaseMeta.getName(), new long[0]);
        }
        return objectArray;
    }

    public void printSQLException(SQLException ex) {
        this.log.logError("==> SQLException: ");
        while (ex != null) {
            this.log.logError("Message:   " + ex.getMessage());
            this.log.logError("SQLState:  " + ex.getSQLState());
            this.log.logError("ErrorCode: " + ex.getErrorCode());
            ex = ex.getNextException();
            this.log.logError("");
        }
    }

    public void setLookup(String table, String[] codes, String[] condition, String[] gets, String[] rename, String orderby) throws KettleDatabaseException {
        this.setLookup(table, codes, condition, gets, rename, orderby, false);
    }

    public void setLookup(String schema, String table, String[] codes, String[] condition, String[] gets, String[] rename, String orderby) throws KettleDatabaseException {
        this.setLookup(schema, table, codes, condition, gets, rename, orderby, false);
    }

    public void setLookup(String tableName, String[] codes, String[] condition, String[] gets, String[] rename, String orderby, boolean checkForMultipleResults) throws KettleDatabaseException {
        this.setLookup(null, tableName, codes, condition, gets, rename, orderby, checkForMultipleResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookup(String schemaName, String tableName, String[] codes, String[] condition, String[] gets, String[] rename, String orderby, boolean checkForMultipleResults) throws KettleDatabaseException {
        try {
            int i;
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_SET_LOOKUP_START, this.databaseMeta.getName(), new long[0]);
            String table = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
            StringBuilder sql = new StringBuilder("SELECT ");
            for (i = 0; i < gets.length; ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append(this.databaseMeta.quoteField(gets[i]));
                if (rename == null || rename[i] == null || gets[i].equalsIgnoreCase(rename[i])) continue;
                sql.append(" AS ").append(this.databaseMeta.quoteField(rename[i]));
            }
            sql.append(" FROM ").append(table).append(" WHERE ");
            for (i = 0; i < codes.length; ++i) {
                if (i != 0) {
                    sql.append(" AND ");
                }
                sql.append(this.databaseMeta.quoteField(codes[i]));
                if ("BETWEEN".equalsIgnoreCase(condition[i])) {
                    sql.append(" BETWEEN ? AND ? ");
                    continue;
                }
                if ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i])) {
                    sql.append(" ").append(condition[i]).append(" ");
                    continue;
                }
                sql.append(" ").append(condition[i]).append(" ? ");
            }
            if (orderby != null && orderby.length() != 0) {
                sql.append(" ORDER BY ").append(orderby);
            }
            try {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Setting preparedStatement to [" + sql + "]");
                }
                this.prepStatementLookup = this.connection.prepareStatement(this.databaseMeta.stripCR(sql.toString()));
                if (!checkForMultipleResults && this.databaseMeta.supportsSetMaxRows()) {
                    this.prepStatementLookup.setMaxRows(1);
                }
            }
            catch (SQLException ex) {
                throw new KettleDatabaseException("Unable to prepare statement for update [" + sql + "]", ex);
            }
        }
        finally {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_SET_LOOKUP_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    public boolean prepareUpdate(String table, String[] codes, String[] condition, String[] sets) {
        return this.prepareUpdate(null, table, codes, condition, sets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareUpdate(String schemaName, String tableName, String[] codes, String[] condition, String[] sets) {
        try {
            int i;
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_PREPARE_UPDATE_START, this.databaseMeta.getName(), new long[0]);
            StringBuilder sql = new StringBuilder(128);
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
            sql.append("UPDATE ").append(schemaTable).append(Const.CR).append("SET ");
            for (i = 0; i < sets.length; ++i) {
                if (i != 0) {
                    sql.append(",   ");
                }
                sql.append(this.databaseMeta.quoteField(sets[i]));
                sql.append(" = ?").append(Const.CR);
            }
            sql.append("WHERE ");
            for (i = 0; i < codes.length; ++i) {
                if (i != 0) {
                    sql.append("AND   ");
                }
                sql.append(this.databaseMeta.quoteField(codes[i]));
                if ("BETWEEN".equalsIgnoreCase(condition[i])) {
                    sql.append(" BETWEEN ? AND ? ");
                    continue;
                }
                if ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i])) {
                    sql.append(' ').append(condition[i]).append(' ');
                    continue;
                }
                sql.append(' ').append(condition[i]).append(" ? ");
            }
            try {
                String s = sql.toString();
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Setting update preparedStatement to [" + s + "]");
                }
                this.prepStatementUpdate = this.connection.prepareStatement(this.databaseMeta.stripCR(s));
            }
            catch (SQLException ex) {
                this.printSQLException(ex);
                boolean bl = false;
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_PREPARE_UPDATE_STOP, this.databaseMeta.getName(), new long[0]);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_PREPARE_UPDATE_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    public boolean prepareDelete(String table, String[] codes, String[] condition) {
        return this.prepareDelete(null, table, codes, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareDelete(String schemaName, String tableName, String[] codes, String[] condition) {
        try {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_PREPARE_DELETE_START, this.databaseMeta.getName(), new long[0]);
            String table = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
            StringBuilder sql = new StringBuilder("DELETE FROM " + table + Const.CR);
            sql.append("WHERE ");
            for (int i = 0; i < codes.length; ++i) {
                if (i != 0) {
                    sql.append("AND   ");
                }
                sql.append(codes[i]);
                if ("BETWEEN".equalsIgnoreCase(condition[i])) {
                    sql.append(" BETWEEN ? AND ? ");
                    continue;
                }
                if ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i])) {
                    sql.append(" ").append(condition[i]).append(" ");
                    continue;
                }
                sql.append(" ").append(condition[i]).append(" ? ");
            }
            try {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Setting update preparedStatement to [" + sql + "]");
                }
                this.prepStatementUpdate = this.connection.prepareStatement(this.databaseMeta.stripCR(sql.toString()));
            }
            catch (SQLException ex) {
                this.printSQLException(ex);
                boolean bl = false;
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_PREPARE_DELETE_STOP, this.databaseMeta.getName(), new long[0]);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_PREPARE_DELETE_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcLookup(String proc, String[] arg, String[] argdir, int[] argtype, String returnvalue, int returntype) throws KettleDatabaseException {
        try {
            int i;
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_PREPARE_DBPROC_START, this.databaseMeta.getName(), new long[0]);
            int pos = 0;
            StringBuilder sql = new StringBuilder("{ ");
            if (returnvalue != null && returnvalue.length() != 0) {
                sql.append("? = ");
            }
            sql.append("call ").append(proc).append(" ");
            if (arg.length > 0) {
                sql.append("(");
            }
            for (i = 0; i < arg.length; ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append(" ?");
            }
            if (arg.length > 0) {
                sql.append(")");
            }
            sql.append("}");
            try {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("DBA setting callableStatement to [" + sql + "]");
                }
                this.cstmt = this.connection.prepareCall(sql.toString());
                pos = 1;
                if (!Utils.isEmpty(returnvalue)) {
                    switch (returntype) {
                        case 1: {
                            this.cstmt.registerOutParameter(pos, 8);
                            break;
                        }
                        case 6: {
                            this.cstmt.registerOutParameter(pos, 3);
                            break;
                        }
                        case 5: {
                            this.cstmt.registerOutParameter(pos, -5);
                            break;
                        }
                        case 2: {
                            this.cstmt.registerOutParameter(pos, 12);
                            break;
                        }
                        case 3: {
                            this.cstmt.registerOutParameter(pos, 93);
                            break;
                        }
                        case 4: {
                            this.cstmt.registerOutParameter(pos, 16);
                            break;
                        }
                    }
                    ++pos;
                }
                block22: for (i = 0; i < arg.length; ++i) {
                    if (!argdir[i].equalsIgnoreCase("OUT") && !argdir[i].equalsIgnoreCase("INOUT")) continue;
                    switch (argtype[i]) {
                        case 1: {
                            this.cstmt.registerOutParameter(i + pos, 8);
                            continue block22;
                        }
                        case 6: {
                            this.cstmt.registerOutParameter(i + pos, 3);
                            continue block22;
                        }
                        case 5: {
                            this.cstmt.registerOutParameter(i + pos, -5);
                            continue block22;
                        }
                        case 2: {
                            this.cstmt.registerOutParameter(i + pos, 12);
                            continue block22;
                        }
                        case 3: {
                            this.cstmt.registerOutParameter(i + pos, 93);
                            continue block22;
                        }
                        case 4: {
                            this.cstmt.registerOutParameter(i + pos, 16);
                            continue block22;
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new KettleDatabaseException("Unable to prepare database procedure call", ex);
            }
        }
        finally {
            this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_PREPARE_DBPROC_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    public Object[] getLookup() throws KettleDatabaseException {
        return this.getLookup(this.prepStatementLookup, false);
    }

    public Object[] getLookup(boolean failOnMultipleResults) throws KettleDatabaseException {
        return this.getLookup(failOnMultipleResults, false);
    }

    public Object[] getLookup(boolean failOnMultipleResults, boolean lazyConversion) throws KettleDatabaseException {
        return this.getLookup(this.prepStatementLookup, failOnMultipleResults, lazyConversion);
    }

    public Object[] getLookup(PreparedStatement ps) throws KettleDatabaseException {
        this.rowMeta = null;
        return this.getLookup(ps, false);
    }

    public Object[] getLookup(PreparedStatement ps, boolean failOnMultipleResults) throws KettleDatabaseException {
        return this.getLookup(ps, failOnMultipleResults, false);
    }

    /*
     * Exception decompiling
     */
    public Object[] getLookup(PreparedStatement ps, boolean failOnMultipleResults, boolean lazyConversion) throws KettleDatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DatabaseMetaData getDatabaseMetaData() throws KettleDatabaseException {
        if (this.dbmd == null) {
            try {
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_DBMETA_START, this.databaseMeta.getName(), new long[0]);
                if (this.connection == null) {
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Exception.EmptyConnectionError", this.databaseMeta.getDatabaseName()));
                }
                this.dbmd = this.connection.getMetaData();
            }
            catch (Exception e) {
                throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToGetMetadata", new String[0]), e);
            }
            finally {
                this.log.snap((MetricsInterface)Metrics.METRIC_DATABASE_GET_DBMETA_STOP, this.databaseMeta.getName(), new long[0]);
            }
        }
        return this.dbmd;
    }

    public String getDDL(String tablename, RowMetaInterface fields) throws KettleDatabaseException {
        return this.getDDL(tablename, fields, null, false, null, true);
    }

    public String getDDL(String tablename, RowMetaInterface fields, String tk, boolean useAutoinc, String pk) throws KettleDatabaseException {
        return this.getDDL(tablename, fields, tk, useAutoinc, pk, true);
    }

    public String getDDL(String tableName, RowMetaInterface fields, String tk, boolean useAutoinc, String pk, boolean semicolon) throws KettleDatabaseException {
        this.databaseMeta.quoteReservedWords(fields);
        String quotedTk = tk != null ? this.databaseMeta.quoteField(tk) : null;
        String retval = this.checkTableExists(tableName) ? this.getAlterTableStatement(tableName, fields, quotedTk, useAutoinc, pk, semicolon) : this.getCreateTableStatement(tableName, fields, quotedTk, useAutoinc, pk, semicolon);
        return retval;
    }

    public String getCreateTableStatement(String tableName, RowMetaInterface fields, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        StringBuilder retval = new StringBuilder();
        DatabaseInterface databaseInterface = this.databaseMeta.getDatabaseInterface();
        retval.append(databaseInterface.getCreateTableStatement());
        retval.append(tableName + Const.CR);
        retval.append("(").append(Const.CR);
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                retval.append(", ");
            } else {
                retval.append("  ");
            }
            ValueMetaInterface v = fields.getValueMeta(i);
            retval.append(this.databaseMeta.getFieldDefinition(v, tk, pk, useAutoinc));
        }
        if (tk != null && this.databaseMeta.requiresCreateTablePrimaryKeyAppend()) {
            retval.append(", PRIMARY KEY (").append(tk).append(")").append(Const.CR);
        }
        if (pk != null && this.databaseMeta.requiresCreateTablePrimaryKeyAppend()) {
            retval.append(", PRIMARY KEY (").append(pk).append(")").append(Const.CR);
        }
        retval.append(")").append(Const.CR);
        retval.append(this.databaseMeta.getDatabaseInterface().getDataTablespaceDDL(this.variables, this.databaseMeta));
        if (pk == null && tk == null && this.databaseMeta.getDatabaseInterface() instanceof NeoviewDatabaseMeta) {
            retval.append("NO PARTITION");
        }
        if (semicolon) {
            retval.append(";");
        }
        return retval.toString();
    }

    public String getAlterTableStatement(String tableName, RowMetaInterface fields, String tk, boolean useAutoinc, String pk, boolean semicolon) throws KettleDatabaseException {
        int i;
        ValueMetaInterface v;
        int i2;
        ValueMetaInterface v2;
        int i3;
        StringBuilder retval = new StringBuilder();
        RowMetaInterface tabFields = this.getTableFields(tableName);
        this.databaseMeta.quoteReservedWords(tabFields);
        RowMeta missing = new RowMeta();
        for (i3 = 0; i3 < fields.size(); ++i3) {
            v2 = fields.getValueMeta(i3);
            if (tabFields.searchValueMeta(v2.getName()) != null) continue;
            missing.addValueMeta(v2);
        }
        if (missing.size() != 0) {
            for (i3 = 0; i3 < missing.size(); ++i3) {
                v2 = missing.getValueMeta(i3);
                retval.append(this.databaseMeta.getAddColumnStatement(tableName, v2, tk, useAutoinc, pk, true));
            }
        }
        RowMeta surplus = new RowMeta();
        for (i2 = 0; i2 < tabFields.size(); ++i2) {
            v = tabFields.getValueMeta(i2);
            if (fields.searchValueMeta(v.getName()) != null) continue;
            surplus.addValueMeta(v);
        }
        if (surplus.size() != 0) {
            for (i2 = 0; i2 < surplus.size(); ++i2) {
                v = surplus.getValueMeta(i2);
                retval.append(this.databaseMeta.getDropColumnStatement(tableName, v, tk, useAutoinc, pk, true));
            }
        }
        RowMeta modify = new RowMeta();
        for (i = 0; i < fields.size(); ++i) {
            String currentDDL;
            boolean mod;
            ValueMetaInterface desiredField = fields.getValueMeta(i);
            ValueMetaInterface currentField = tabFields.searchValueMeta(desiredField.getName());
            if (desiredField == null || currentField == null) continue;
            String desiredDDL = this.databaseMeta.getFieldDefinition(desiredField, tk, pk, useAutoinc);
            boolean bl = mod = !desiredDDL.equalsIgnoreCase(currentDDL = this.databaseMeta.getFieldDefinition(currentField, tk, pk, useAutoinc));
            if (!mod) continue;
            modify.addValueMeta(desiredField);
        }
        if (modify.size() > 0) {
            for (i = 0; i < modify.size(); ++i) {
                ValueMetaInterface v3 = modify.getValueMeta(i);
                retval.append(this.databaseMeta.getModifyColumnStatement(tableName, v3, tk, useAutoinc, pk, true));
            }
        }
        return retval.toString();
    }

    public void truncateTable(String tablename) throws KettleDatabaseException {
        if (Utils.isEmpty(this.connectionGroup)) {
            String truncateStatement = this.databaseMeta.getTruncateTableStatement(null, tablename);
            if (truncateStatement == null) {
                throw new KettleDatabaseException("Truncate table not supported by " + this.databaseMeta.getDatabaseInterface().getPluginName());
            }
            this.execStatement(truncateStatement);
        } else {
            this.execStatement("DELETE FROM " + this.databaseMeta.quoteField(tablename));
        }
    }

    public void truncateTable(String schema, String tablename) throws KettleDatabaseException {
        if (Utils.isEmpty(this.connectionGroup)) {
            String truncateStatement = this.databaseMeta.getTruncateTableStatement(schema, tablename);
            if (truncateStatement == null) {
                throw new KettleDatabaseException("Truncate table not supported by " + this.databaseMeta.getDatabaseInterface().getPluginName());
            }
            this.execStatement(truncateStatement);
        } else {
            this.execStatement("DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(schema, tablename));
        }
    }

    public RowMetaAndData getOneRow(String sql) throws KettleDatabaseException {
        ResultSet rs = this.openQuery(sql);
        if (rs != null) {
            Object[] row = this.getRow(rs);
            try {
                rs.close();
            }
            catch (Exception e) {
                throw new KettleDatabaseException("Unable to close resultset", e);
            }
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                }
                catch (Exception e) {
                    throw new KettleDatabaseException("Unable to close prepared statement pstmt", e);
                }
                this.pstmt = null;
            }
            if (this.selStmt != null) {
                try {
                    this.selStmt.close();
                }
                catch (Exception e) {
                    throw new KettleDatabaseException("Unable to close prepared statement sel_stmt", e);
                }
                this.selStmt = null;
            }
            return new RowMetaAndData(this.rowMeta, row);
        }
        throw new KettleDatabaseException("error opening resultset for query: " + sql);
    }

    public RowMeta getMetaFromRow(Object[] row, ResultSetMetaData md) throws SQLException, KettleDatabaseException {
        RowMeta meta = new RowMeta();
        for (int i = 0; i < md.getColumnCount(); ++i) {
            ValueMetaInterface valueMeta = this.getValueFromSQLType(md, i + 1, true, false);
            meta.addValueMeta(valueMeta);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowMetaAndData getOneRow(String sql, RowMetaInterface param, Object[] data) throws KettleDatabaseException {
        ResultSet rs = this.openQuery(sql, param, data);
        if (rs != null) {
            Object[] row = this.getRow(rs);
            this.rowMeta = null;
            RowMeta tmpMeta = null;
            try {
                ResultSetMetaData md = rs.getMetaData();
                tmpMeta = this.getMetaFromRow(row, md);
            }
            catch (Exception e) {
                this.log.logError(e.getMessage(), e);
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    throw new KettleDatabaseException("Unable to close resultset", e);
                }
                if (this.pstmt != null) {
                    try {
                        this.pstmt.close();
                    }
                    catch (Exception e) {
                        throw new KettleDatabaseException("Unable to close prepared statement pstmt", e);
                    }
                    this.pstmt = null;
                }
                if (this.selStmt != null) {
                    try {
                        this.selStmt.close();
                    }
                    catch (Exception e) {
                        throw new KettleDatabaseException("Unable to close prepared statement sel_stmt", e);
                    }
                    this.selStmt = null;
                }
            }
            return new RowMetaAndData(tmpMeta, row);
        }
        return null;
    }

    public RowMetaInterface getParameterMetaData(PreparedStatement ps) {
        RowMeta par = new RowMeta();
        try {
            ParameterMetaData pmd = ps.getParameterMetaData();
            for (int i = 1; i <= pmd.getParameterCount(); ++i) {
                ValueMetaBase val;
                String name = "par" + i;
                int sqltype = pmd.getParameterType(i);
                int length = pmd.getPrecision(i);
                int precision = pmd.getScale(i);
                switch (sqltype) {
                    case 1: 
                    case 12: {
                        val = new ValueMetaString(name);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 2: 
                    case 4: 
                    case 5: {
                        val = new ValueMetaInteger(name);
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        val = new ValueMetaNumber(name);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        val = new ValueMetaDate(name);
                        break;
                    }
                    case -7: 
                    case 16: {
                        val = new ValueMetaBoolean(name);
                        break;
                    }
                    default: {
                        val = new ValueMetaNone(name);
                    }
                }
                if (val.isNumeric() && (length > 18 || precision > 18)) {
                    val = new ValueMetaBigNumber(name);
                }
                par.addValueMeta(val);
            }
        }
        catch (AbstractMethodError | Exception e) {
            return null;
        }
        return par;
    }

    public int countParameters(String sql) {
        int q = 0;
        boolean quoteOpened = false;
        boolean dquoteOpened = false;
        block5: for (int x = 0; x < sql.length(); ++x) {
            char c = sql.charAt(x);
            switch (c) {
                case '\'': {
                    quoteOpened = !quoteOpened;
                    continue block5;
                }
                case '\"': {
                    dquoteOpened = !dquoteOpened;
                    continue block5;
                }
                case '?': {
                    if (quoteOpened || dquoteOpened) continue block5;
                    ++q;
                    continue block5;
                }
            }
        }
        return q;
    }

    public RowMetaInterface getParameterMetaData(String sql, RowMetaInterface inform, Object[] data) {
        int q = this.countParameters(sql);
        RowMeta par = new RowMeta();
        if (inform != null && q == inform.size()) {
            for (int i = 0; i < q; ++i) {
                ValueMetaInterface inf = inform.getValueMeta(i);
                ValueMetaInterface v = inf.clone();
                par.addValueMeta(v);
            }
        } else {
            for (int i = 0; i < q; ++i) {
                ValueMetaNumber v = new ValueMetaNumber("name" + i);
                par.addValueMeta(v);
            }
        }
        return par;
    }

    public void writeLogRecord(LogTableCoreInterface logTable, LogStatus status, Object subject, Object parent) throws KettleDatabaseException {
        try {
            RowMetaAndData logRecord = logTable.getLogRecord(status, subject, parent);
            if (logRecord == null) {
                return;
            }
            boolean update = logTable.getKeyField() != null && !status.equals(LogStatus.START);
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.environmentSubstitute(logTable.getActualSchemaName()), this.environmentSubstitute(logTable.getActualTableName()));
            RowMetaInterface rowMetaInterface = logRecord.getRowMeta();
            Object[] rowData = logRecord.getData();
            if (update) {
                RowMeta updateRowMeta = new RowMeta();
                Object[] updateRowData = new Object[rowMetaInterface.size()];
                ValueMetaInterface keyValueMeta = rowMetaInterface.getValueMeta(0);
                StringBuilder sqlBuff = new StringBuilder(250);
                sqlBuff.append("UPDATE ").append(schemaTable).append(" SET ");
                for (int i = 1; i < rowMetaInterface.size(); ++i) {
                    ValueMetaInterface valueMeta = rowMetaInterface.getValueMeta(i);
                    if (i > 1) {
                        sqlBuff.append(", ");
                    }
                    sqlBuff.append(this.databaseMeta.quoteField(valueMeta.getName())).append("=? ");
                    updateRowMeta.addValueMeta(valueMeta);
                    updateRowData[i - 1] = rowData[i];
                }
                sqlBuff.append("WHERE ").append(this.databaseMeta.quoteField(keyValueMeta.getName())).append("=? ");
                updateRowMeta.addValueMeta(keyValueMeta);
                updateRowData[rowMetaInterface.size() - 1] = rowData[0];
                String sql = sqlBuff.toString();
                this.execStatement(sql, updateRowMeta, updateRowData);
            } else {
                this.insertRow(this.environmentSubstitute(logTable.getActualSchemaName()), this.environmentSubstitute(logTable.getActualTableName()), logRecord.getRowMeta(), logRecord.getData());
            }
        }
        catch (Exception e) {
            DatabaseLogExceptionFactory.getExceptionStrategy(logTable, e).registerException(this.log, e, PKG, "Database.Error.WriteLogTable", this.environmentSubstitute(logTable.getActualTableName()));
        }
    }

    public void cleanupLogRecords(LogTableCoreInterface logTable) throws KettleDatabaseException {
        LogTableField logField;
        double timeout = Const.toDouble(Const.trim(this.environmentSubstitute(logTable.getTimeoutInDays())), 0.0);
        if (timeout < 1.0E-6) {
            return;
        }
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.environmentSubstitute(logTable.getActualSchemaName()), this.environmentSubstitute(logTable.getActualTableName()));
        if (schemaTable.isEmpty()) {
            DatabaseLogExceptionFactory.getExceptionStrategy(logTable).registerException(this.log, PKG, "DatabaseMeta.Error.LogTableNameNotFound", new String[0]);
        }
        if ((logField = logTable.getLogDateField()) == null) {
            DatabaseLogExceptionFactory.getExceptionStrategy(logTable).registerException(this.log, PKG, "Database.Exception.LogTimeoutDefinedOnTableWithoutLogField", new String[0]);
        }
        String sql = "DELETE FROM " + schemaTable + " WHERE " + this.databaseMeta.quoteField(logField.getFieldName()) + " < ?";
        long now = System.currentTimeMillis();
        long limit = now - Math.round(timeout * 24.0 * 60.0 * 60.0 * 1000.0);
        RowMetaAndData row = new RowMetaAndData();
        row.addValue(logField.getFieldName(), 3, new Date(limit));
        try {
            this.execStatement(sql, row.getRowMeta(), row.getData());
        }
        catch (Exception e) {
            DatabaseLogExceptionFactory.getExceptionStrategy(logTable).registerException(this.log, PKG, "Database.Exception.UnableToCleanUpOlderRecordsFromLogTable", this.environmentSubstitute(logTable.getActualTableName()));
        }
    }

    public Object[] getLastLogDate(String logtable, String name, boolean job, LogStatus status) throws KettleDatabaseException {
        Object[] row = null;
        String jobtrans = job ? this.databaseMeta.quoteField("JOBNAME") : this.databaseMeta.quoteField("TRANSNAME");
        String sql = "";
        sql = sql + " SELECT " + this.databaseMeta.quoteField("ENDDATE") + ", " + this.databaseMeta.quoteField("DEPDATE") + ", " + this.databaseMeta.quoteField("STARTDATE");
        sql = sql + " FROM " + logtable;
        sql = sql + " WHERE  " + this.databaseMeta.quoteField("ERRORS") + "    = 0";
        sql = sql + " AND    " + this.databaseMeta.quoteField("STATUS") + "    = 'end'";
        sql = sql + " AND    " + jobtrans + " = ?";
        sql = sql + " ORDER BY " + this.databaseMeta.quoteField("LOGDATE") + " DESC, " + this.databaseMeta.quoteField("ENDDATE") + " DESC";
        try {
            this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            RowMeta r = new RowMeta();
            r.addValueMeta(new ValueMetaString("TRANSNAME", 255, -1));
            this.setValues(r, new Object[]{name});
            try (ResultSet res = this.pstmt.executeQuery();){
                this.rowMeta = this.getRowInfo(res.getMetaData(), false, false);
                row = this.getRow(res);
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to obtain last logdate from table " + logtable, ex);
        }
        return row;
    }

    public synchronized Long getNextValue(Hashtable<String, Counter> counters, String tableName, String valKey) throws KettleDatabaseException {
        return this.getNextValue(counters, null, tableName, valKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Long getNextValue(Hashtable<String, Counter> counters, String schemaName, String tableName, String valKey) throws KettleDatabaseException {
        long previous;
        Long nextValue = null;
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        String lookup = schemaTable + "." + this.databaseMeta.quoteField(valKey);
        Counter counter = null;
        if (counters != null) {
            counter = counters.get(lookup);
        }
        if (counter != null) return counter.next();
        RowMetaAndData rmad = this.getOneRow("SELECT MAX(" + this.databaseMeta.quoteField(valKey) + ") FROM " + schemaTable);
        if (rmad == null) throw new KettleDatabaseException("Couldn't find maximum key value from table " + schemaTable);
        try {
            Long tmp = rmad.getRowMeta().getInteger(rmad.getData(), 0);
            previous = tmp != null ? tmp : 0L;
        }
        catch (KettleValueException e) {
            throw new KettleDatabaseException("Error getting the first long value from the max value returned from table : " + schemaTable);
        }
        counter = new Counter(previous + 1L, 1L);
        nextValue = counter.next();
        if (counters == null) return nextValue;
        counters.put(lookup, counter);
        return nextValue;
    }

    public String toString() {
        if (this.databaseMeta != null) {
            return this.databaseMeta.getName();
        }
        return "-";
    }

    public boolean isSystemTable(String tableName) {
        return this.databaseMeta.isSystemTable(tableName);
    }

    public List<Object[]> getRows(String sql, int limit) throws KettleDatabaseException {
        return this.getRows(sql, limit, null);
    }

    public List<Object[]> getRows(String sql, int limit, ProgressMonitorListener monitor) throws KettleDatabaseException {
        return this.getRows(sql, null, null, 1000, false, limit, monitor);
    }

    public List<Object[]> getRows(String sql, RowMetaInterface params, Object[] data, int fetchMode, boolean lazyConversion, int limit, ProgressMonitorListener monitor) throws KettleDatabaseException {
        if (monitor != null) {
            monitor.setTaskName("Opening query...");
        }
        ResultSet rset = this.openQuery(sql, params, data, fetchMode, lazyConversion);
        return this.getRows(rset, limit, monitor);
    }

    public List<Object[]> getRows(ResultSet rset, int limit, ProgressMonitorListener monitor) throws KettleDatabaseException {
        try {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            boolean stop = false;
            int i = 0;
            if (rset != null) {
                if (monitor != null && limit > 0) {
                    monitor.beginTask("Reading rows...", limit);
                }
                while (!(limit > 0 && i >= limit || stop)) {
                    Object[] row = this.getRow(rset);
                    if (row != null) {
                        result.add(row);
                        ++i;
                    } else {
                        stop = true;
                    }
                    if (monitor != null && limit > 0) {
                        monitor.worked(1);
                    }
                    if (monitor == null || !monitor.isCanceled()) continue;
                    break;
                }
                this.closeQuery(rset);
                if (monitor != null) {
                    monitor.done();
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to get list of rows from ResultSet : ", e);
        }
    }

    public List<Object[]> getFirstRows(String tableName, int limit) throws KettleDatabaseException {
        return this.getFirstRows(tableName, limit, null);
    }

    public List<Object[]> getFirstRows(String tableName, int limit, ProgressMonitorListener monitor) throws KettleDatabaseException {
        String sql = "SELECT";
        if (this.databaseMeta.getDatabaseInterface() instanceof NeoviewDatabaseMeta) {
            sql = sql + " [FIRST " + limit + "]";
        } else if (this.databaseMeta.getDatabaseInterface() instanceof SybaseIQDatabaseMeta) {
            sql = sql + " TOP " + limit + " ";
        }
        sql = sql + " * FROM " + tableName;
        if (limit > 0) {
            sql = sql + this.databaseMeta.getLimitClause(limit);
        }
        return this.getRows(sql, limit, monitor);
    }

    public RowMetaInterface getReturnRowMeta() {
        return this.rowMeta;
    }

    public String[] getTableTypes() throws KettleDatabaseException {
        try {
            ArrayList<String> types = new ArrayList<String>();
            ResultSet rstt = this.getDatabaseMetaData().getTableTypes();
            while (rstt.next()) {
                String ttype = rstt.getString("TABLE_TYPE");
                types.add(ttype);
            }
            return types.toArray(new String[types.size()]);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to get table types from database!", e);
        }
    }

    public String[] getTablenames() throws KettleDatabaseException {
        return this.getTablenames(false);
    }

    public String[] getTablenames(boolean includeSchema) throws KettleDatabaseException {
        return this.getTablenames(null, includeSchema);
    }

    public String[] getTablenames(String schemanamein, boolean includeSchema) throws KettleDatabaseException {
        return this.getTablenames(schemanamein, includeSchema, null);
    }

    public String[] getTablenames(String schemanamein, boolean includeSchema, Map<String, String> props) throws KettleDatabaseException {
        Map<String, Collection<String>> tableMap = this.getTableMap(schemanamein, props);
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Collection<String>> entry : tableMap.entrySet()) {
            String schema = entry.getKey();
            Collection<String> tables = entry.getValue();
            for (String table : tables) {
                if (includeSchema) {
                    res.add(this.databaseMeta.getQuotedSchemaTableCombination(schema, table));
                    continue;
                }
                res.add(this.databaseMeta.getQuotedSchemaTableCombination(null, table));
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public Map<String, Collection<String>> getTableMap() throws KettleDatabaseException {
        return this.getTableMap(null);
    }

    public Map<String, Collection<String>> getTableMap(String schemanamein) throws KettleDatabaseException {
        return this.getTableMap(schemanamein, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Collection<String>> getTableMap(String schemanamein, Map<String, String> props) throws KettleDatabaseException {
        String schemaname = schemanamein;
        if (schemaname == null && this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.environmentSubstitute(this.databaseMeta.getUsername()).toUpperCase();
        }
        HashMap<String, Collection<String>> tableMap = new HashMap<String, Collection<String>>();
        ResultSet alltables = null;
        try {
            alltables = this.databaseMeta.getTables(this.getDatabaseMetaData(), schemaname, null, this.databaseMeta.getTableTypes());
            while (alltables.next()) {
                String schema;
                String cat;
                block24: {
                    block23: {
                        cat = "";
                        try {
                            cat = alltables.getString("TABLE_CAT");
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block23;
                            this.log.logDebug("Error getting tables for field TABLE_CAT (ignored): " + e.toString());
                        }
                    }
                    schema = "";
                    try {
                        schema = alltables.getString("TABLE_SCHEM");
                    }
                    catch (Exception e) {
                        if (!this.log.isDebug()) break block24;
                        this.log.logDebug("Error getting tables for field TABLE_SCHEM (ignored): " + e.toString());
                    }
                }
                if (Utils.isEmpty(schema)) {
                    schema = cat;
                }
                String table = alltables.getString(TABLES_META_DATA_TABLE_NAME);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), "got table from meta-data: " + this.databaseMeta.getQuotedSchemaTableCombination(schema, table));
                }
                if (props != null && !props.isEmpty()) {
                    for (Map.Entry<String, String> prop : props.entrySet()) {
                        String propValue;
                        String propName = prop.getKey();
                        String tableProperty = alltables.getString(propName);
                        if (tableProperty == null || !tableProperty.equals(propValue = prop.getValue())) continue;
                        this.multimapPut(schema, table, tableMap);
                    }
                    continue;
                }
                this.multimapPut(schema, table, tableMap);
            }
        }
        catch (SQLException e) {
            this.log.logError("Error getting tablenames from schema [" + schemaname + "]");
        }
        finally {
            try {
                if (alltables != null) {
                    alltables.close();
                }
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", e);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed("read :" + this.multimapSize(tableMap) + " table names from db meta-data.");
        }
        return tableMap;
    }

    public String[] getViews() throws KettleDatabaseException {
        return this.getViews(false);
    }

    public String[] getViews(boolean includeSchema) throws KettleDatabaseException {
        return this.getViews(null, includeSchema);
    }

    public String[] getViews(String schemanamein, boolean includeSchema) throws KettleDatabaseException {
        Map<String, Collection<String>> viewMap = this.getViewMap(schemanamein);
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Collection<String>> entry : viewMap.entrySet()) {
            String schema = entry.getKey();
            Collection<String> views = entry.getValue();
            for (String view : views) {
                if (includeSchema) {
                    res.add(this.databaseMeta.getQuotedSchemaTableCombination(schema, view));
                    continue;
                }
                res.add(view);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public Map<String, Collection<String>> getViewMap() throws KettleDatabaseException {
        return this.getViewMap(null);
    }

    public Map<String, Collection<String>> getViewMap(String schemanamein) throws KettleDatabaseException {
        if (!this.databaseMeta.supportsViews()) {
            return Collections.emptyMap();
        }
        String schemaname = schemanamein;
        if (schemaname == null && this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.environmentSubstitute(this.databaseMeta.getUsername()).toUpperCase();
        }
        HashMap<String, Collection<String>> viewMap = new HashMap<String, Collection<String>>();
        try (ResultSet allviews = this.getDatabaseMeta().getTables(this.getDatabaseMetaData(), schemaname, null, this.databaseMeta.getViewTypes());){
            while (allviews.next()) {
                String schema;
                String cat;
                block25: {
                    block24: {
                        cat = "";
                        try {
                            cat = allviews.getString("TABLE_CAT");
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block24;
                            this.log.logDebug("Error getting views for field TABLE_CAT (ignored): " + e.toString());
                        }
                    }
                    schema = "";
                    try {
                        schema = allviews.getString("TABLE_SCHEM");
                    }
                    catch (Exception e) {
                        if (!this.log.isDebug()) break block25;
                        this.log.logDebug("Error getting views for field TABLE_SCHEM (ignored): " + e.toString());
                    }
                }
                if (Utils.isEmpty(schema)) {
                    schema = cat;
                }
                String table = allviews.getString(TABLES_META_DATA_TABLE_NAME);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), "got view from meta-data: " + this.databaseMeta.getQuotedSchemaTableCombination(schema, table));
                }
                this.multimapPut(schema, table, viewMap);
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error getting views from schema [" + schemaname + "]", e);
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed("read :" + this.multimapSize(viewMap) + " views from db meta-data.");
        }
        return viewMap;
    }

    public String[] getSynonyms() throws KettleDatabaseException {
        return this.getSynonyms(false);
    }

    public String[] getSynonyms(boolean includeSchema) throws KettleDatabaseException {
        return this.getSynonyms(null, includeSchema);
    }

    public String[] getSynonyms(String schemanamein, boolean includeSchema) throws KettleDatabaseException {
        Map<String, Collection<String>> synonymMap = this.getSynonymMap(schemanamein);
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Collection<String>> entry : synonymMap.entrySet()) {
            String schema = entry.getKey();
            Collection<String> synonyms = entry.getValue();
            for (String synonym : synonyms) {
                if (includeSchema) {
                    res.add(this.databaseMeta.getQuotedSchemaTableCombination(schema, synonym));
                    continue;
                }
                res.add(synonym);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public Map<String, Collection<String>> getSynonymMap() throws KettleDatabaseException {
        return this.getSynonymMap(null);
    }

    public Map<String, Collection<String>> getSynonymMap(String schemanamein) throws KettleDatabaseException {
        if (!this.databaseMeta.supportsSynonyms()) {
            return Collections.emptyMap();
        }
        String schemaname = schemanamein;
        if (schemaname == null && this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.environmentSubstitute(this.databaseMeta.getUsername()).toUpperCase();
        }
        HashMap<String, Collection<String>> synonymMap = new HashMap<String, Collection<String>>();
        ResultSet alltables = null;
        try {
            alltables = this.getDatabaseMeta().getTables(this.getDatabaseMetaData(), schemaname, null, this.databaseMeta.getSynonymTypes());
            while (alltables.next()) {
                String schema;
                String cat;
                block21: {
                    block20: {
                        cat = "";
                        try {
                            cat = alltables.getString("TABLE_CAT");
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block20;
                            this.log.logDebug("Error getting synonyms for field TABLE_CAT (ignored): " + e.toString());
                        }
                    }
                    schema = "";
                    try {
                        schema = alltables.getString("TABLE_SCHEM");
                    }
                    catch (Exception e) {
                        if (!this.log.isDebug()) break block21;
                        this.log.logDebug("Error getting synonyms for field TABLE_SCHEM (ignored): " + e.toString());
                    }
                }
                if (Utils.isEmpty(schema)) {
                    schema = cat;
                }
                String table = alltables.getString(TABLES_META_DATA_TABLE_NAME);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), "got synonym from meta-data: " + this.databaseMeta.getQuotedSchemaTableCombination(schema, table));
                }
                this.multimapPut(schema, table, synonymMap);
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error getting synonyms from schema [" + schemaname + "]", e);
        }
        finally {
            try {
                if (alltables != null) {
                    alltables.close();
                }
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing resultset after getting synonyms from schema [" + schemaname + "]", e);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed("read :" + this.multimapSize(synonymMap) + " synonyms from db meta-data.");
        }
        return synonymMap;
    }

    private <K, V> void multimapPut(K key, V value, Map<K, Collection<V>> map) {
        Collection<V> valueCollection = map.get(key);
        if (valueCollection == null) {
            valueCollection = new HashSet<V>();
        }
        valueCollection.add(value);
        map.put(key, valueCollection);
    }

    private <K, V> int multimapSize(Map<K, Collection<V>> map) {
        int count = 0;
        for (Collection<V> valueCollection : map.values()) {
            count += valueCollection.size();
        }
        return count;
    }

    public String[] getSchemas() throws KettleDatabaseException {
        ArrayList<String> catalogList = new ArrayList<String>();
        ResultSet catalogResultSet = null;
        try {
            catalogResultSet = this.databaseMeta.getSchemas(this.getDatabaseMetaData());
            while (catalogResultSet != null && catalogResultSet.next()) {
                catalogList.add(catalogResultSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error getting schemas!", e);
        }
        finally {
            try {
                if (catalogResultSet != null) {
                    catalogResultSet.close();
                }
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing resultset after getting schemas!", e);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed("read :" + catalogList.size() + " schemas from db meta-data.");
        }
        return catalogList.toArray(new String[catalogList.size()]);
    }

    public String[] getCatalogs() throws KettleDatabaseException {
        ArrayList<String> catalogList = new ArrayList<String>();
        ResultSet catalogResultSet = null;
        try {
            catalogResultSet = this.getDatabaseMetaData().getCatalogs();
            while (catalogResultSet != null && catalogResultSet.next()) {
                catalogList.add(catalogResultSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error getting catalogs!", e);
        }
        finally {
            try {
                if (catalogResultSet != null) {
                    catalogResultSet.close();
                }
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing resultset after getting catalogs!", e);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed("read :" + catalogList.size() + " catalogs from db meta-data.");
        }
        return catalogList.toArray(new String[catalogList.size()]);
    }

    public String[] getProcedures() throws KettleDatabaseException {
        String sql = this.databaseMeta.getSQLListOfProcedures();
        if (sql != null) {
            List<Object[]> procs = this.getRows(sql, 1000);
            String[] str = new String[procs.size()];
            for (int i = 0; i < procs.size(); ++i) {
                str[i] = procs.get(i)[0].toString();
            }
            return str;
        }
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = this.getDatabaseMetaData();
            rs = dbmd.getProcedures(null, null, null);
            List<Object[]> rows = this.getRows(rs, 0, null);
            String[] result = new String[rows.size()];
            for (int i = 0; i < rows.size(); ++i) {
                Object[] row = rows.get(i);
                String procCatalog = this.rowMeta.getString(row, "PROCEDURE_CAT", null);
                String procSchema = this.rowMeta.getString(row, "PROCEDURE_SCHEM", null);
                String procName = this.rowMeta.getString(row, "PROCEDURE_NAME", "");
                StringBuilder name = new StringBuilder("");
                if (procCatalog != null) {
                    name.append(procCatalog).append(".");
                }
                if (procSchema != null) {
                    name.append(procSchema).append(".");
                }
                name.append(procName);
                result[i] = name.toString();
            }
            String[] stringArray = result;
            return stringArray;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to get list of procedures from database meta-data: ", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isAutoCommit() {
        return this.commitsize <= 0;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void lockTables(String[] tableNames) throws KettleDatabaseException {
        if (Utils.isEmpty(tableNames)) {
            return;
        }
        String sql = this.databaseMeta.getSQLLockTables(tableNames);
        if (sql != null) {
            this.execStatements(sql);
        }
    }

    public void unlockTables(String[] tableNames) throws KettleDatabaseException {
        if (Utils.isEmpty(tableNames)) {
            return;
        }
        String[] quotedTableNames = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            quotedTableNames[i] = this.databaseMeta.getQuotedSchemaTableCombination(null, tableNames[i]);
        }
        String sql = this.databaseMeta.getSQLUnlockTables(quotedTableNames);
        if (sql != null) {
            this.execStatement(sql);
        }
    }

    public int getOpened() {
        return this.opened;
    }

    public synchronized void setOpened(int opened) {
        this.opened = opened;
    }

    public String getConnectionGroup() {
        return this.connectionGroup;
    }

    public void setConnectionGroup(String connectionGroup) {
        this.connectionGroup = connectionGroup;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(String partitionId) {
        this.partitionId = partitionId;
    }

    public int getCopy() {
        return this.copy;
    }

    public synchronized void setCopy(int copy) {
        this.copy = copy;
    }

    @Override
    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    @Override
    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    @Override
    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    @Override
    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    @Override
    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    @Override
    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    @Override
    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    @Override
    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    @Override
    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty(variableName) && !Utils.isEmpty(value = this.environmentSubstitute(variableName))) {
            return ValueMetaBase.convertStringToBoolean(value);
        }
        return defaultValue;
    }

    @Override
    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    @Override
    public String[] listVariables() {
        return this.variables.listVariables();
    }

    @Override
    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    @Override
    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
        if (space != this.databaseMeta) {
            this.databaseMeta.shareVariablesWith(space);
        }
    }

    @Override
    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowMetaAndData callProcedure(String[] arg, String[] argdir, int[] argtype, String resultname, int resulttype) throws KettleDatabaseException {
        try {
            boolean moreResults = this.cstmt.execute();
            RowMetaAndData ret = new RowMetaAndData();
            int pos = 1;
            if (resultname != null && resultname.length() != 0) {
                ValueMeta vMeta = new ValueMeta(resultname, resulttype);
                Object v = null;
                switch (resulttype) {
                    case 4: {
                        v = this.cstmt.getBoolean(pos);
                        break;
                    }
                    case 1: {
                        v = this.cstmt.getDouble(pos);
                        break;
                    }
                    case 6: {
                        v = this.cstmt.getBigDecimal(pos);
                        break;
                    }
                    case 5: {
                        v = this.cstmt.getLong(pos);
                        break;
                    }
                    case 2: {
                        v = this.cstmt.getString(pos);
                        break;
                    }
                    case 8: {
                        if (this.databaseMeta.supportsGetBlob()) {
                            Blob blob = this.cstmt.getBlob(pos);
                            if (blob != null) {
                                v = blob.getBytes(1L, (int)blob.length());
                                break;
                            }
                            v = null;
                            break;
                        }
                        v = this.cstmt.getBytes(pos);
                        break;
                    }
                    case 3: {
                        if (this.databaseMeta.supportsTimeStampToDateConversion()) {
                            v = this.cstmt.getTimestamp(pos);
                            break;
                        }
                        v = this.cstmt.getDate(pos);
                        break;
                    }
                }
                ret.addValue(vMeta, v);
                ++pos;
            }
            for (int i = 0; i < arg.length; ++i) {
                if (!argdir[i].equalsIgnoreCase("OUT") && !argdir[i].equalsIgnoreCase("INOUT")) continue;
                ValueMetaInterface vMeta = ValueMetaFactory.createValueMeta(arg[i], argtype[i]);
                Object v = null;
                switch (argtype[i]) {
                    case 4: {
                        v = this.cstmt.getBoolean(pos + i);
                        break;
                    }
                    case 1: {
                        v = this.cstmt.getDouble(pos + i);
                        break;
                    }
                    case 6: {
                        v = this.cstmt.getBigDecimal(pos + i);
                        break;
                    }
                    case 5: {
                        v = this.cstmt.getLong(pos + i);
                        break;
                    }
                    case 2: {
                        v = this.cstmt.getString(pos + i);
                        break;
                    }
                    case 8: {
                        if (this.databaseMeta.supportsGetBlob()) {
                            Blob blob = this.cstmt.getBlob(pos + i);
                            if (blob != null) {
                                v = blob.getBytes(1L, (int)blob.length());
                                break;
                            }
                            v = null;
                            break;
                        }
                        v = this.cstmt.getBytes(pos + i);
                        break;
                    }
                    case 3: {
                        if (this.databaseMeta.supportsTimeStampToDateConversion()) {
                            v = this.cstmt.getTimestamp(pos + i);
                            break;
                        }
                        v = this.cstmt.getDate(pos + i);
                        break;
                    }
                }
                ret.addValue(vMeta, v);
            }
            ResultSet rs = null;
            int updateCount = -1;
            do {
                rs = null;
                try {
                    if (moreResults) {
                        rs = this.cstmt.getResultSet();
                    } else {
                        updateCount = this.cstmt.getUpdateCount();
                    }
                    moreResults = this.cstmt.getMoreResults();
                }
                finally {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
            } while (moreResults || updateCount > -1);
            return ret;
        }
        catch (Exception ex) {
            throw new KettleDatabaseException("Unable to call procedure", ex);
        }
    }

    public void closeProcedureStatement() throws KettleDatabaseException {
        try {
            if (this.cstmt != null) {
                this.cstmt.close();
                this.cstmt = null;
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Exception.ErrorClosingCallableStatement", new String[0]), ex);
        }
    }

    public String getDDLCreationTable(String tableName, RowMetaInterface fields) throws KettleDatabaseException {
        this.databaseMeta.quoteReservedWords(fields);
        String quotedTk = this.databaseMeta.quoteField(null);
        String retval = this.getCreateTableStatement(tableName, fields, quotedTk, false, null, true);
        return retval;
    }

    public String getDDLTruncateTable(String schema, String tablename) throws KettleDatabaseException {
        if (Utils.isEmpty(this.connectionGroup)) {
            String truncateStatement = this.databaseMeta.getTruncateTableStatement(schema, tablename);
            if (truncateStatement == null) {
                throw new KettleDatabaseException("Truncate table not supported by " + this.databaseMeta.getDatabaseInterface().getPluginName());
            }
            return truncateStatement;
        }
        return "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(schema, tablename);
    }

    public String getSQLOutput(String schemaName, String tableName, RowMetaInterface fields, Object[] r, String dateFormat) throws KettleDatabaseException {
        StringBuilder ins = new StringBuilder(128);
        try {
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
            ins.append("INSERT INTO ").append(schemaTable).append('(');
            for (int i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    ins.append(", ");
                }
                String name = fields.getValueMeta(i).getName();
                ins.append(this.databaseMeta.quoteField(name));
            }
            ins.append(") VALUES (");
            SimpleDateFormat[] fieldDateFormatters = new SimpleDateFormat[fields.size()];
            block9: for (int i = 0; i < fields.size(); ++i) {
                ValueMetaInterface valueMeta = fields.getValueMeta(i);
                Object valueData = r[i];
                if (i > 0) {
                    ins.append(",");
                }
                if (valueMeta.isNull(valueData)) {
                    ins.append("null");
                    continue;
                }
                switch (valueMeta.getType()) {
                    case 2: 
                    case 4: {
                        String string = valueMeta.getString(valueData);
                        string = this.databaseMeta.quoteSQLString(string);
                        ins.append(string);
                        continue block9;
                    }
                    case 3: {
                        Date date = fields.getDate(r, i);
                        if (Utils.isEmpty(dateFormat)) {
                            if (this.databaseMeta.getDatabaseInterface() instanceof OracleDatabaseMeta) {
                                if (fieldDateFormatters[i] == null) {
                                    fieldDateFormatters[i] = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                                }
                                ins.append("TO_DATE('").append(fieldDateFormatters[i].format(date)).append("', 'YYYY/MM/DD HH24:MI:SS')");
                                continue block9;
                            }
                            ins.append("'" + fields.getString(r, i) + "'");
                            continue block9;
                        }
                        try {
                            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                            ins.append("'" + formatter.format(fields.getDate(r, i)) + "'");
                            continue block9;
                        }
                        catch (Exception e) {
                            throw new KettleDatabaseException("Error : ", e);
                        }
                    }
                    default: {
                        ins.append(fields.getString(r, i));
                    }
                }
            }
            ins.append(')');
        }
        catch (Exception e) {
            throw new KettleDatabaseException(e);
        }
        return ins.toString();
    }

    public Savepoint setSavepoint() throws KettleDatabaseException {
        try {
            return this.connection.setSavepoint();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToSetSavepoint", new String[0]), e);
        }
    }

    public Savepoint setSavepoint(String savePointName) throws KettleDatabaseException {
        try {
            return this.connection.setSavepoint(savePointName);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToSetSavepointName", savePointName), e);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws KettleDatabaseException {
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToReleaseSavepoint", new String[0]), e);
        }
    }

    public void rollback(Savepoint savepoint) throws KettleDatabaseException {
        try {
            this.connection.rollback(savepoint);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToRollbackToSavepoint", new String[0]), e);
        }
    }

    public Object getParentObject() {
        return this.parentLoggingObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPrimaryKeyColumnNames(String tablename) throws KettleDatabaseException {
        ArrayList<String> names = new ArrayList<String>();
        ResultSet allkeys = null;
        try {
            allkeys = this.getDatabaseMetaData().getPrimaryKeys(null, null, tablename);
            while (allkeys.next()) {
                String keyname = allkeys.getString("PK_NAME");
                String columnName = allkeys.getString("COLUMN_NAME");
                if (!names.contains(columnName)) {
                    names.add(columnName);
                }
                if (!this.log.isRowLevel()) continue;
                this.log.logRowlevel(this.toString(), "getting key : " + keyname + " on column " + columnName);
            }
        }
        catch (SQLException e) {
            this.log.logError(this.toString(), "Error getting primary keys columns from table [" + tablename + "]");
        }
        finally {
            try {
                if (allkeys != null) {
                    allkeys.close();
                }
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing connection while searching primary keys in table [" + tablename + "]", e);
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] getSequences() throws KettleDatabaseException {
        if (this.databaseMeta.supportsSequences()) {
            String sql = this.databaseMeta.getSQLListOfSequences();
            if (sql != null) {
                List<Object[]> seqs = this.getRows(sql, 0);
                String[] str = new String[seqs.size()];
                for (int i = 0; i < seqs.size(); ++i) {
                    str[i] = seqs.get(i)[0].toString();
                }
                return str;
            }
        } else {
            throw new KettleDatabaseException("Sequences are only available for Oracle databases.");
        }
        return null;
    }

    @Override
    public String getFilename() {
        return null;
    }

    @Override
    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    @Override
    public String getObjectName() {
        return this.databaseMeta.getName();
    }

    @Override
    public String getObjectCopy() {
        return null;
    }

    @Override
    public ObjectId getObjectId() {
        return this.databaseMeta.getObjectId();
    }

    @Override
    public ObjectRevision getObjectRevision() {
        return this.databaseMeta.getObjectRevision();
    }

    @Override
    public LoggingObjectType getObjectType() {
        return LoggingObjectType.DATABASE;
    }

    @Override
    public LoggingObjectInterface getParent() {
        return this.parentLoggingObject;
    }

    @Override
    public RepositoryDirectory getRepositoryDirectory() {
        return null;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        this.log.setLogLevel(logLevel);
    }

    @Override
    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    public void setContainerObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    @Override
    public Date getRegistrationDate() {
        return null;
    }

    public int getNrExecutedCommits() {
        return this.nrExecutedCommits;
    }

    public void setNrExecutedCommits(int nrExecutedCommits) {
        this.nrExecutedCommits = nrExecutedCommits;
    }

    public Result execStatementsFromFile(String filename, boolean sendSinglestatement) throws KettleException {
        Result result;
        FileObject sqlFile = null;
        InputStream is = null;
        InputStreamReader bis = null;
        try {
            if (Utils.isEmpty(filename)) {
                throw new KettleException("Filename is missing!");
            }
            sqlFile = KettleVFS.getFileObject(filename);
            if (!sqlFile.exists()) {
                throw new KettleException("We can not find file [" + filename + "]!");
            }
            is = KettleVFS.getInputStream(sqlFile);
            bis = new InputStreamReader(new BufferedInputStream(is, 500));
            StringBuilder lineStringBuilder = new StringBuilder(256);
            lineStringBuilder.setLength(0);
            BufferedReader buff = new BufferedReader(bis);
            String sLine = null;
            StringBuilder sql = new StringBuilder(Const.CR);
            while ((sLine = buff.readLine()) != null) {
                if (Utils.isEmpty(sLine)) {
                    sql.append(Const.CR);
                    continue;
                }
                sql.append(Const.CR).append(sLine);
            }
            if (sendSinglestatement) {
                Result result2 = this.execStatement(sql.toString());
                return result2;
            }
            result = this.execStatements(sql.toString());
        }
        catch (Exception e) {
            throw new KettleException(e);
        }
        finally {
            try {
                if (sqlFile != null) {
                    sqlFile.close();
                }
                if (is != null) {
                    is.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public boolean isGatheringMetrics() {
        return this.log != null && this.log.isGatheringMetrics();
    }

    @Override
    public void setGatheringMetrics(boolean gatheringMetrics) {
        if (this.log != null) {
            this.log.setGatheringMetrics(gatheringMetrics);
        }
    }

    @Override
    public boolean isForcingSeparateLogging() {
        return this.log != null && this.log.isForcingSeparateLogging();
    }

    @Override
    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        if (this.log != null) {
            this.log.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }

    private boolean useJdbcMeta() {
        String useJdbcMeta = this.variables.getVariable("KETTLE_COMPATIBILITY_USE_JDBC_METADATA", "false");
        return Boolean.TRUE.toString().equals(useJdbcMeta);
    }

    static {
        Database.initValueMetaPluginClasses();
        PluginRegistry.getInstance().addPluginListener(ValueMetaPluginType.class, new PluginTypeListener(){

            @Override
            public void pluginAdded(Object serviceObject) {
                Database.initValueMetaPluginClasses();
            }

            @Override
            public void pluginRemoved(Object serviceObject) {
                Database.initValueMetaPluginClasses();
            }

            @Override
            public void pluginChanged(Object serviceObject) {
                Database.initValueMetaPluginClasses();
            }
        });
    }
}

