/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.variables;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.version.BuildVersion;

public class Variables
implements VariableSpace {
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private VariableSpace parent = null;
    private Map<String, String> injection = null;
    private boolean initialized = false;

    public Variables() {
        this.properties.put("Internal.Kettle.Version", BuildVersion.getInstance().getVersion());
        String revision = BuildVersion.getInstance().getRevision();
        if (revision == null) {
            revision = "";
        }
        this.properties.put("Internal.Kettle.Build.Version", revision);
        String buildDate = BuildVersion.getInstance().getBuildDate();
        if (buildDate == null) {
            buildDate = "";
        }
        this.properties.put("Internal.Kettle.Build.Date", buildDate);
    }

    @Override
    public void copyVariablesFrom(VariableSpace space) {
        if (space != null && this != space) {
            String[] variableNames = space.listVariables();
            for (int idx = 0; idx < variableNames.length; ++idx) {
                this.properties.put(variableNames[idx], space.getVariable(variableNames[idx]));
            }
        }
    }

    @Override
    public VariableSpace getParentVariableSpace() {
        return this.parent;
    }

    @Override
    public void setParentVariableSpace(VariableSpace parent) {
        this.parent = parent;
    }

    @Override
    public String getVariable(String variableName, String defaultValue) {
        String var = this.properties.get(variableName);
        if (var == null) {
            return defaultValue;
        }
        return var;
    }

    @Override
    public String getVariable(String variableName) {
        return this.properties.get(variableName);
    }

    @Override
    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty(variableName) && !Utils.isEmpty(value = this.environmentSubstitute(variableName))) {
            return ValueMetaBase.convertStringToBoolean(value);
        }
        return defaultValue;
    }

    @Override
    public void initializeVariablesFrom(VariableSpace parent) {
        this.parent = parent;
        Set<String> systemPropertiesNames = System.getProperties().stringPropertyNames();
        for (String key : systemPropertiesNames) {
            this.getProperties().put(key, System.getProperties().getProperty(key));
        }
        if (parent != null) {
            this.copyVariablesFrom(parent);
        }
        if (this.injection != null) {
            this.properties.putAll(this.injection);
            this.injection = null;
        }
        this.initialized = true;
    }

    @Override
    public String[] listVariables() {
        Set<String> keySet = this.properties.keySet();
        return keySet.toArray(new String[0]);
    }

    @Override
    public void setVariable(String variableName, String variableValue) {
        if (variableValue != null) {
            this.properties.put(variableName, variableValue);
        } else {
            this.properties.remove(variableName);
        }
    }

    @Override
    public String environmentSubstitute(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        return StringUtil.environmentSubstitute(aString, this.properties);
    }

    @Override
    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        return StringUtil.substituteField(aString, rowMeta, rowData);
    }

    @Override
    public String[] environmentSubstitute(String[] string) {
        String[] retval = new String[string.length];
        for (int i = 0; i < string.length; ++i) {
            retval[i] = this.environmentSubstitute(string[i]);
        }
        return retval;
    }

    @Override
    public void shareVariablesWith(VariableSpace space) {
    }

    @Override
    public void injectVariables(Map<String, String> prop) {
        if (this.initialized) {
            if (prop != null) {
                for (Map.Entry<String, String> entry : prop.entrySet()) {
                    String value = entry.getValue();
                    String key = entry.getKey();
                    if (Utils.isEmpty(key)) continue;
                    this.properties.put(key, Const.NVL(value, ""));
                }
                this.injection = null;
            }
        } else {
            this.injection = new Hashtable<String, String>();
            for (Map.Entry<String, String> entry : prop.entrySet()) {
                String value = entry.getValue();
                String key = entry.getKey();
                if (Utils.isEmpty(key)) continue;
                this.injection.put(key, Const.NVL(value, ""));
            }
        }
    }

    public static VariableSpace getADefaultVariableSpace() {
        Variables space = new Variables();
        space.initializeVariablesFrom(null);
        return space;
    }

    Map<String, String> getProperties() {
        return this.properties;
    }
}

