/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.pentaho.scheduler;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Base64;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.engine.configuration.impl.pentaho.scheduler.JobScheduleParam;
import org.pentaho.di.engine.configuration.impl.pentaho.scheduler.JobScheduleRequest;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;

public class SchedulerRequest {
    public static final String API_SCHEDULER_JOB = "/api/scheduler/job";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_XML = "application/xml";
    public static final String UTF_8 = "UTF-8";
    public static final String AUTHORIZATION = "Authorization";
    public static final String STRING_TYPE = "string";
    private HttpClient httpclient = HttpClients.createDefault();
    private HttpPost httpPost;
    private Repository repository;
    private String baseUrl;
    private static Class<?> PKG = SchedulerRequest.class;

    public SchedulerRequest(Builder builder) {
        this.httpPost = builder.httpPost;
        this.repository = builder.repository;
        this.baseUrl = builder.baseUrl;
    }

    public void submit(AbstractMeta meta) {
        try {
            this.httpPost.setEntity((HttpEntity)this.buildSchedulerRequestEntity(meta));
            this.httpclient.execute((HttpUriRequest)this.httpPost);
            this.logMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logMessage() {
        String url = this.baseUrl + "/kettle/status";
        String message = "[" + url + "](" + url + ")";
        this.repository.getLog().logBasic(BaseMessages.getString(PKG, (String)"SchedulerRequest.submit.message", (String[])new String[0]), new Object[]{message});
    }

    private String getFullPath(AbstractMeta meta) {
        return meta.getRepositoryDirectory().getPath() + "/" + meta.getName() + "." + meta.getDefaultExtension();
    }

    StringEntity buildSchedulerRequestEntity(AbstractMeta meta) throws UnsupportedEncodingException, UnknownParamException {
        String filename = this.getFullPath(meta);
        JobScheduleRequest jobScheduleRequest = new JobScheduleRequest();
        jobScheduleRequest.setInputFile(filename);
        if (meta.getLogLevel() != null) {
            JobScheduleParam jobScheduleParam = new JobScheduleParam();
            jobScheduleParam.setName("logLevel");
            jobScheduleParam.setType(STRING_TYPE);
            jobScheduleParam.setStringValue(Arrays.asList(meta.getLogLevel().getCode()));
            jobScheduleRequest.getJobParameters().add(jobScheduleParam);
        }
        JobScheduleParam jobScheduleParamClearingLog = new JobScheduleParam();
        jobScheduleParamClearingLog.setName("clearLog");
        jobScheduleParamClearingLog.setType(STRING_TYPE);
        jobScheduleParamClearingLog.setStringValue(Arrays.asList(String.valueOf(meta.isClearingLog())));
        jobScheduleRequest.getJobParameters().add(jobScheduleParamClearingLog);
        JobScheduleParam jobScheduleParamSafeModeEnable = new JobScheduleParam();
        jobScheduleParamSafeModeEnable.setName("runSafeMode");
        jobScheduleParamSafeModeEnable.setType(STRING_TYPE);
        jobScheduleParamSafeModeEnable.setStringValue(Arrays.asList(String.valueOf(meta.isSafeModeEnabled())));
        jobScheduleRequest.getJobParameters().add(jobScheduleParamSafeModeEnable);
        JobScheduleParam jobScheduleParamGatheringMetricsParam = new JobScheduleParam();
        jobScheduleParamGatheringMetricsParam.setName("gatheringMetrics");
        jobScheduleParamGatheringMetricsParam.setType(STRING_TYPE);
        jobScheduleParamGatheringMetricsParam.setStringValue(Arrays.asList(String.valueOf(meta.isGatheringMetrics())));
        jobScheduleRequest.getJobParameters().add(jobScheduleParamGatheringMetricsParam);
        if (meta instanceof JobMeta) {
            String[] jobMeta = (String[])meta;
            if (jobMeta.getStartCopyName() != null) {
                JobScheduleParam jobScheduleParamStartStepName = new JobScheduleParam();
                jobScheduleParamStartStepName.setName("startCopyName");
                jobScheduleParamStartStepName.setType(STRING_TYPE);
                jobScheduleParamStartStepName.setStringValue(Arrays.asList(jobMeta.getStartCopyName()));
                jobScheduleRequest.getJobParameters().add(jobScheduleParamStartStepName);
            }
            JobScheduleParam jobScheduleParamExpandingRemoteJob = new JobScheduleParam();
            jobScheduleParamExpandingRemoteJob.setName("expandingRemoteJob");
            jobScheduleParamExpandingRemoteJob.setType(STRING_TYPE);
            jobScheduleParamExpandingRemoteJob.setStringValue(Arrays.asList(String.valueOf(jobMeta.isExpandingRemoteJob())));
            jobScheduleRequest.getJobParameters().add(jobScheduleParamExpandingRemoteJob);
        }
        if (meta.listParameters() != null) {
            for (String param : meta.listParameters()) {
                jobScheduleRequest.getPdiParameters().put(param, meta.getParameterValue(param));
            }
        }
        StringWriter sw = new StringWriter();
        String jobScheduleRequestString = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{JobScheduleRequest.class});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.marshal((Object)jobScheduleRequest, (Writer)sw);
            jobScheduleRequestString = sw.toString();
        }
        catch (JAXBException e) {
            this.repository.getLog().logError(BaseMessages.getString(PKG, (String)"SchedulerRequest.error.marshal", (String[])new String[0]), new Object[]{e.getMessage()});
        }
        return new StringEntity(jobScheduleRequestString);
    }

    public static class Builder {
        private HttpPost httpPost;
        private Repository repository;
        private String baseUrl;

        public SchedulerRequest build() {
            this.baseUrl = this.getRepositoryServiceBaseUrl();
            this.httpPost = new HttpPost(this.baseUrl + SchedulerRequest.API_SCHEDULER_JOB);
            this.httpPost.setHeader(SchedulerRequest.CONTENT_TYPE, SchedulerRequest.APPLICATION_XML);
            String username = this.repository.getUserInfo().getName();
            String password = this.repository.getUserInfo().getPassword();
            if (username != null && password != null) {
                try {
                    String userPass = username + ":" + password;
                    byte[] encoding = Base64.getEncoder().encode(userPass.getBytes(SchedulerRequest.UTF_8));
                    this.httpPost.setHeader(SchedulerRequest.AUTHORIZATION, "Basic " + new String(encoding));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return new SchedulerRequest(this);
        }

        public Builder repository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public String getRepositoryServiceBaseUrl() {
            String repoLocation = "http://localhost:8080/pentaho";
            try {
                Method m = this.repository.getRepositoryMeta().getClass().getMethod("getRepositoryLocation", new Class[0]);
                Object loc = m.invoke((Object)this.repository.getRepositoryMeta(), new Object[0]);
                m = loc.getClass().getMethod("getUrl", new Class[0]);
                repoLocation = (String)m.invoke(loc, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return repoLocation;
        }
    }
}

