/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.spark;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SparkTunableProperties {
    private static final Map<String, List<String>> stepMap = ImmutableMap.builder().put((Object)"ParquetInput", SparkTunableProperties.nonTunable()).put((Object)"ParquetOutput", SparkTunableProperties.multiTunable(SparkTunableProperties.dataFrameWriterTunable(), SparkTunableProperties.datasetTunable())).put((Object)"AvroOutput", SparkTunableProperties.multiTunable(SparkTunableProperties.dataFrameWriterTunable(), SparkTunableProperties.datasetTunable())).put((Object)"AvroInputNew", SparkTunableProperties.nonTunable()).put((Object)"OrcOutput", SparkTunableProperties.multiTunable(SparkTunableProperties.dataFrameWriterTunable(), SparkTunableProperties.datasetTunable())).put((Object)"OrcInput", SparkTunableProperties.nonTunable()).put((Object)"Dummy", SparkTunableProperties.datasetTunable()).put((Object)"TableInput", SparkTunableProperties.jdbcTunable()).put((Object)"TextFileInput", SparkTunableProperties.nonTunable()).put((Object)"HadoopFileInputPlugin", SparkTunableProperties.nonTunable()).put((Object)"TextFileOutput", SparkTunableProperties.datasetTunable()).put((Object)"HadoopFileOutputPlugin", SparkTunableProperties.datasetTunable()).put((Object)"FilterRows", SparkTunableProperties.datasetTunable()).put((Object)"StreamLookup", SparkTunableProperties.datasetTunable()).put((Object)"SortRows", SparkTunableProperties.datasetTunable()).put((Object)"GroupBy", SparkTunableProperties.datasetTunable()).put((Object)"MemoryGroupBy", SparkTunableProperties.datasetTunable()).put((Object)"MergeJoin", SparkTunableProperties.multiTunable(SparkTunableProperties.datasetTunable(), SparkTunableProperties.joinTunable())).put((Object)"RecordsFromStream", SparkTunableProperties.datasetTunable()).put((Object)"Abort", SparkTunableProperties.datasetTunable()).put((Object)"TransExecutor", SparkTunableProperties.datasetTunable()).put((Object)"RowsFromResult", SparkTunableProperties.datasetTunable()).put((Object)"RowsToResult", SparkTunableProperties.datasetTunable()).put((Object)"WriteToLog", SparkTunableProperties.datasetTunable()).put((Object)"MetaInject", SparkTunableProperties.datasetTunable()).put((Object)"SimpleMapping", SparkTunableProperties.datasetTunable()).put((Object)"MappingInput", SparkTunableProperties.datasetTunable()).put((Object)"MappingOutput", SparkTunableProperties.datasetTunable()).put((Object)"Mapping", SparkTunableProperties.datasetTunable()).put((Object)"TableOutput", SparkTunableProperties.datasetTunable()).put((Object)"SwitchCase", SparkTunableProperties.datasetTunable()).put((Object)"MergeRows", SparkTunableProperties.multiTunable(SparkTunableProperties.datasetTunable(), SparkTunableProperties.joinTunable())).put((Object)"JoinRows", SparkTunableProperties.multiTunable(SparkTunableProperties.datasetTunable(), SparkTunableProperties.joinTunable())).put((Object)"JavaFilter", SparkTunableProperties.datasetTunable()).put((Object)"HBaseInput", SparkTunableProperties.nonTunable()).put((Object)"HBaseOutput", SparkTunableProperties.datasetTunable()).put((Object)"KafkaConsumerInput", SparkTunableProperties.nonTunable()).put((Object)"KinesisConsumer", SparkTunableProperties.nonTunable()).put((Object)"MQTTConsumer", SparkTunableProperties.nonTunable()).put((Object)"AmqpConsumer", SparkTunableProperties.nonTunable()).put((Object)"JobExecutor", SparkTunableProperties.nonTunable()).put((Object)"SingleThreader", SparkTunableProperties.nonTunable()).put((Object)"PrioritizeStreams", SparkTunableProperties.nonTunable()).put((Object)"Append", SparkTunableProperties.nonTunable()).put((Object)"BlockUntilStepsFinish", SparkTunableProperties.nonTunable()).put((Object)"S3CSVINPUT", SparkTunableProperties.nonTunable()).put((Object)"S3FileOutputPlugin", SparkTunableProperties.nonTunable()).build();

    public static List<String> getProperties(String stepId) {
        return stepMap.containsKey(stepId) ? stepMap.get(stepId) : SparkTunableProperties.datasetTunable();
    }

    protected static List<String> dataFrameWriterTunable() {
        return Arrays.asList("write.partitionBy.columns", "write.bucketBy.columns", "write.bucketBy.numBuckets", "write.sortBy.columns");
    }

    protected static List<String> datasetTunable() {
        return Arrays.asList("cache", "coalesce", "repartition.numPartitions", "repartition.columns", "persist.storageLevel");
    }

    protected static List<String> joinTunable() {
        return Arrays.asList("join.broadcast.stepName");
    }

    protected static List<String> jdbcTunable() {
        return Arrays.asList("read.jdbc.columnName", "read.jdbc.lowerBound", "read.jdbc.upperBound", "read.jdbc.numPartitions");
    }

    private static List<String> nonTunable() {
        return Arrays.asList(new String[0]);
    }

    private static List<String> multiTunable(List<String> ... tunables) {
        return Stream.of(tunables).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private SparkTunableProperties() {
    }
}

