/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.action.hadoop.PipesMain;
import org.apache.oozie.action.hadoop.StreamingMain;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.Namespace;
import org.json.simple.JSONObject;

public class MapReduceActionExecutor
extends JavaActionExecutor {
    public static final String HADOOP_COUNTERS = "hadoop.counters";
    private XLog log = XLog.getLog(this.getClass());

    public MapReduceActionExecutor() {
        super("map-reduce");
    }

    @Override
    protected List<Class> getLauncherClasses() {
        List<Class> classes = super.getLauncherClasses();
        classes.add(LauncherMain.class);
        classes.add(MapReduceMain.class);
        classes.add(StreamingMain.class);
        classes.add(PipesMain.class);
        return classes;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        Namespace ns = actionXml.getNamespace();
        String mainClass = actionXml.getChild("streaming", ns) != null ? launcherConf.get("oozie.launcher.action.main.class", StreamingMain.class.getName()) : (actionXml.getChild("pipes", ns) != null ? launcherConf.get("oozie.launcher.action.main.class", PipesMain.class.getName()) : launcherConf.get("oozie.launcher.action.main.class", MapReduceMain.class.getName()));
        return mainClass;
    }

    @Override
    Configuration setupLauncherConf(Configuration conf, Element actionXml, Path appPath, ActionExecutor.Context context) throws ActionExecutorException {
        super.setupLauncherConf(conf, actionXml, appPath, context);
        conf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", true);
        return conf;
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        Namespace ns = actionXml.getNamespace();
        if (actionXml.getChild("streaming", ns) != null) {
            Element streamingXml = actionXml.getChild("streaming", ns);
            String mapper = streamingXml.getChildTextTrim("mapper", ns);
            String reducer = streamingXml.getChildTextTrim("reducer", ns);
            String recordReader = streamingXml.getChildTextTrim("record-reader", ns);
            List list = streamingXml.getChildren("record-reader-mapping", ns);
            String[] recordReaderMapping = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                recordReaderMapping[i] = ((Element)list.get(i)).getTextTrim();
            }
            list = streamingXml.getChildren("env", ns);
            String[] env = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                env[i] = ((Element)list.get(i)).getTextTrim();
            }
            StreamingMain.setStreaming(actionConf, mapper, reducer, recordReader, recordReaderMapping, env);
        } else if (actionXml.getChild("pipes", ns) != null) {
            Element pipesXml = actionXml.getChild("pipes", ns);
            String map = pipesXml.getChildTextTrim("map", ns);
            String reduce = pipesXml.getChildTextTrim("reduce", ns);
            String inputFormat = pipesXml.getChildTextTrim("inputformat", ns);
            String partitioner = pipesXml.getChildTextTrim("partitioner", ns);
            String writer = pipesXml.getChildTextTrim("writer", ns);
            String program = pipesXml.getChildTextTrim("program", ns);
            PipesMain.setPipes(actionConf, map, reduce, inputFormat, partitioner, writer, program, appPath);
        }
        actionConf = super.setupActionConf(actionConf, context, actionXml, appPath);
        return actionConf;
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        super.end(context, action);
        JobClient jobClient = null;
        boolean exception = false;
        try {
            if (action.getStatus() == WorkflowAction.Status.OK) {
                Element actionXml = XmlUtils.parseXml(action.getConf());
                Configuration conf = this.createBaseHadoopConf(context, actionXml);
                JobConf jobConf = new JobConf();
                XConfiguration.copy(conf, (Configuration)jobConf);
                jobClient = this.createJobClient(context, jobConf);
                RunningJob runningJob = jobClient.getJob(JobID.forName((String)action.getExternalId()));
                if (runningJob == null) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "MR002", "Unknown hadoop job [{0}] associated with action [{1}].  Failing this action!", action.getExternalId(), action.getId());
                }
                if (!runningJob.getJobName().startsWith("oozie:action:")) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "MR001", "ID swap should have happened in launcher job [{0}]", action.getExternalId());
                }
                Counters counters = runningJob.getCounters();
                if (counters != null) {
                    JSONObject json = this.counterstoJson(counters);
                    context.setVar(HADOOP_COUNTERS, json.toJSONString());
                } else {
                    context.setVar(HADOOP_COUNTERS, "");
                    XLog.getLog(this.getClass()).warn("Could not find Hadoop Counters for: [{0}]", action.getExternalId());
                }
            }
        }
        catch (Exception ex) {
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            if (jobClient != null) {
                try {
                    jobClient.close();
                }
                catch (Exception e) {
                    if (exception) {
                        this.log.error((Object)"JobClient error: ", e);
                    }
                    throw this.convertException(e);
                }
            }
        }
    }

    private JSONObject counterstoJson(Counters counters) {
        if (counters == null) {
            return null;
        }
        JSONObject groups = new JSONObject();
        for (String gName : counters.getGroupNames()) {
            JSONObject group = new JSONObject();
            for (Counters.Counter counter : counters.getGroup(gName)) {
                String cName = counter.getName();
                Long cValue = counter.getCounter();
                group.put((Object)cName, (Object)cValue);
            }
            groups.put((Object)gName, (Object)group);
        }
        return groups;
    }
}

