/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionsForDatesJPAExecutor
implements JPAExecutor<List<CoordinatorActionBean>> {
    private String jobId = null;
    private Date startDate;
    private Date endDate;

    public CoordJobGetActionsForDatesJPAExecutor(String jobId, Date startDate, Date endDate) {
        ParamChecker.notNull(jobId, "jobId");
        this.jobId = jobId;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionsForDatesJPAExecutor";
    }

    @Override
    public List<CoordinatorActionBean> execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_ACTIONS_FOR_DATES");
            q.setParameter("jobId", (Object)this.jobId);
            q.setParameter("startTime", (Object)new Timestamp(this.startDate.getTime()));
            q.setParameter("endTime", (Object)new Timestamp(this.endDate.getTime()));
            List actions = q.getResultList();
            ArrayList<CoordinatorActionBean> actionList = new ArrayList<CoordinatorActionBean>();
            for (CoordinatorActionBean a : actions) {
                CoordinatorActionBean aa = this.getBeanForRunningCoordAction(a);
                actionList.add(aa);
            }
            return actionList;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
    }

    private CoordinatorActionBean getBeanForRunningCoordAction(CoordinatorActionBean a) {
        if (a != null) {
            CoordinatorActionBean action = new CoordinatorActionBean();
            action.setId(a.getId());
            action.setActionNumber(a.getActionNumber());
            action.setActionXml(a.getActionXml());
            action.setConsoleUrl(a.getConsoleUrl());
            action.setCreatedConf(a.getCreatedConf());
            action.setExternalStatus(a.getExternalStatus());
            action.setMissingDependencies(a.getMissingDependencies());
            action.setRunConf(a.getRunConf());
            action.setTimeOut(a.getTimeOut());
            action.setTrackerUri(a.getTrackerUri());
            action.setType(a.getType());
            action.setCreatedTime(a.getCreatedTime());
            action.setExternalId(a.getExternalId());
            action.setJobId(a.getJobId());
            action.setLastModifiedTime(a.getLastModifiedTime());
            action.setNominalTime(a.getNominalTime());
            action.setSlaXml(a.getSlaXml());
            action.setStatus(a.getStatus());
            return action;
        }
        return null;
    }
}

