/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.mqtt.MQTTConsumerMeta;
import org.pentaho.di.trans.step.mqtt.MqttDialogOptionsLayout;
import org.pentaho.di.trans.step.mqtt.MqttDialogSecurityLayout;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStreamingDialog;

public class MQTTConsumerDialog
extends BaseStreamingDialog
implements StepDialogInterface {
    private static final Class<?> PKG = MQTTConsumerMeta.class;
    private MQTTConsumerMeta mqttMeta;
    private TextVar wConnection;
    private TableView topicsTable;
    private ComboVar wQOS;
    private final Point startingDimensions = new Point(527, 676);
    private MqttDialogSecurityLayout securityLayout;
    private MqttDialogOptionsLayout optionsLayout;
    private static String[] messageTypes = (String[])Stream.of(8, 2).map(ValueMetaInterface::getTypeDescription).toArray(String[]::new);

    public MQTTConsumerDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, in, tr, sname);
        this.mqttMeta = (MQTTConsumerMeta)((Object)in);
    }

    protected void getData() {
        super.getData();
        this.wConnection.setText(this.mqttMeta.getMqttServer());
        this.populateTopicsData();
        this.wQOS.setText(this.mqttMeta.getQos());
        this.securityLayout.setUsername(this.mqttMeta.getUsername());
        this.securityLayout.setPassword(this.mqttMeta.getPassword());
        this.securityLayout.setUIText();
    }

    private void populateTopicsData() {
        List<String> topics = this.mqttMeta.getTopics();
        int rowIndex = 0;
        for (String topic : topics) {
            TableItem key = this.topicsTable.getTable().getItem(rowIndex++);
            if (topic == null) continue;
            key.setText(1, topic);
        }
    }

    protected String getDialogTitle() {
        return BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.Shell.Title", (String[])new String[0]);
    }

    public void setSize() {
        MQTTConsumerDialog.setSize((Shell)this.shell);
        this.shell.setMinimumSize(this.startingDimensions);
        this.shell.setSize(this.startingDimensions);
    }

    protected void buildSetup(Composite wSetupComp) {
        this.props.setLook((Control)wSetupComp);
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        wSetupComp.setLayout((Layout)setupLayout);
        Label wlConnection = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlConnection);
        wlConnection.setText(BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.Connection", (String[])new String[0]));
        FormData fdlConnection = new FormData();
        fdlConnection.left = new FormAttachment(0, 0);
        fdlConnection.top = new FormAttachment(0, 0);
        fdlConnection.right = new FormAttachment(50, 0);
        wlConnection.setLayoutData((Object)fdlConnection);
        this.wConnection = new TextVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wConnection);
        this.wConnection.addModifyListener(this.lsMod);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(0, 363);
        fdConnection.top = new FormAttachment((Control)wlConnection, 5);
        this.wConnection.setLayoutData((Object)fdConnection);
        Label wlTopics = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlTopics);
        wlTopics.setText(BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.Topics", (String[])new String[0]));
        FormData fdlTopics = new FormData();
        fdlTopics.left = new FormAttachment(0, 0);
        fdlTopics.top = new FormAttachment((Control)this.wConnection, 10);
        fdlTopics.right = new FormAttachment(50, 0);
        wlTopics.setLayoutData((Object)fdlTopics);
        this.wQOS = new ComboVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wQOS);
        this.wQOS.addModifyListener(this.lsMod);
        FormData fdQOS = new FormData();
        fdQOS.left = new FormAttachment(0, 0);
        fdQOS.bottom = new FormAttachment(100, 0);
        fdQOS.width = 135;
        this.wQOS.setLayoutData((Object)fdQOS);
        this.wQOS.add("0");
        this.wQOS.add("1");
        this.wQOS.add("2");
        Label wlQOS = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlQOS);
        wlQOS.setText(BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.QOS", (String[])new String[0]));
        FormData fdlQOS = new FormData();
        fdlQOS.left = new FormAttachment(0, 0);
        fdlQOS.bottom = new FormAttachment((Control)this.wQOS, -5);
        fdlQOS.right = new FormAttachment(50, 0);
        wlQOS.setLayoutData((Object)fdlQOS);
        this.buildTopicsTable(wSetupComp, (Control)wlTopics, (Control)wlQOS);
    }

    private void buildTopicsTable(Composite parentWidget, Control controlAbove, Control controlBelow) {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.TopicHeading", (String[])new String[0]), 1, new String[1], false)};
        columns[0].setUsingVariables(true);
        int topicsCount = this.mqttMeta.getTopics().size();
        this.topicsTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, topicsCount, false, this.lsMod, this.props, false);
        this.topicsTable.setSortable(false);
        this.topicsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(330);
        });
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(controlAbove, 5);
        fdData.right = new FormAttachment(0, 350);
        fdData.bottom = new FormAttachment(controlBelow, -10);
        Arrays.stream(this.topicsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.topicsTable.setLayoutData((Object)fdData);
    }

    protected void createAdditionalTabs() {
        this.shell.setMinimumSize(527, 600);
        this.securityLayout = new MqttDialogSecurityLayout(this.props, this.wTabFolder, this.lsMod, this.transMeta, this.mqttMeta.getSslConfig(), this.mqttMeta.isUseSsl());
        this.securityLayout.buildSecurityTab();
        this.buildFieldsTab();
        this.optionsLayout = new MqttDialogOptionsLayout(this.props, this.wTabFolder, this.lsMod, this.transMeta, this.mqttMeta.retrieveOptions());
        this.optionsLayout.buildTab();
    }

    private void buildFieldsTab() {
        CTabItem wFieldsTab = new CTabItem(this.wTabFolder, 0, 3);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.FieldsTab", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        FormData fieldsFormData = new FormData();
        fieldsFormData.left = new FormAttachment(0, 0);
        fieldsFormData.top = new FormAttachment((Control)wFieldsComp, 0);
        fieldsFormData.right = new FormAttachment(100, 0);
        fieldsFormData.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fieldsFormData);
        this.buildFieldTable(wFieldsComp, (Control)wFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
    }

    private void buildFieldTable(Composite parentWidget, Control relativePosition) {
        ColumnInfo[] columns = this.getFieldColumns();
        this.fieldsTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, 2, true, this.lsMod, this.props, false);
        this.fieldsTable.setSortable(false);
        this.fieldsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(147);
            table.getColumn(2).setWidth(147);
            table.getColumn(3).setWidth(147);
        });
        this.populateFieldData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(relativePosition, 5);
        fdData.right = new FormAttachment(100, 0);
        Arrays.stream(this.fieldsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.fieldsTable.setReadonly(true);
        this.fieldsTable.setLayoutData((Object)fdData);
    }

    private void populateFieldData() {
        TableItem messageItem = this.fieldsTable.getTable().getItem(0);
        messageItem.setText(1, BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.InputName.Message", (String[])new String[0]));
        messageItem.setText(2, this.mqttMeta.getMsgOutputName());
        messageItem.setText(3, ValueMetaInterface.getTypeDescription((int)this.mqttMeta.getMessageDataType()));
        TableItem topicItem = this.fieldsTable.getTable().getItem(1);
        topicItem.setText(1, BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.InputName.Topic", (String[])new String[0]));
        topicItem.setText(2, this.mqttMeta.getTopicOutputName());
        topicItem.setText(3, ValueMetaInterface.getTypeDescription((int)2));
    }

    private ColumnInfo[] getFieldColumns() {
        ColumnInfo referenceName = new ColumnInfo(BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.Column.Ref", (String[])new String[0]), 1, false, true);
        ColumnInfo name = new ColumnInfo(BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.Column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo type = new ColumnInfo(BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.Column.Type", (String[])new String[0]), 2, messageTypes, false);
        type.setDisabledListener(rowNumber -> !BaseMessages.getString(PKG, (String)"MQTTConsumerDialog.InputName.Message", (String[])new String[0]).equals(this.fieldsTable.getTable().getItem(rowNumber).getText(1)));
        return new ColumnInfo[]{referenceName, name, type};
    }

    protected void additionalOks(BaseStreamStepMeta meta) {
        this.mqttMeta.setMqttServer(this.wConnection.getText());
        this.mqttMeta.setTopics(Arrays.stream(this.topicsTable.getTable().getItems()).map(item -> item.getText(1)).filter(t -> !"".equals(t)).distinct().collect(Collectors.toList()));
        this.mqttMeta.setMsgOutputName(this.fieldsTable.getTable().getItem(0).getText(2));
        this.mqttMeta.setTopicOutputName(this.fieldsTable.getTable().getItem(1).getText(2));
        this.mqttMeta.setQos(this.wQOS.getText());
        this.mqttMeta.setUsername(this.securityLayout.getUsername());
        this.mqttMeta.setPassword(this.securityLayout.getPassword());
        this.mqttMeta.setUseSsl(this.securityLayout.useSsl());
        this.mqttMeta.setSslConfig(this.securityLayout.sslConfig());
        this.mqttMeta.messageDataType = this.fieldsTable.getTable().getItem(0).getText(3);
        this.optionsLayout.retrieveOptions().forEach(option -> {
            switch (option.getKey()) {
                case "KEEP_ALIVE_INTERVAL": {
                    this.mqttMeta.setKeepAliveInterval(option.getValue());
                    break;
                }
                case "MAX_INFLIGHT": {
                    this.mqttMeta.setMaxInflight(option.getValue());
                    break;
                }
                case "CONNECTION_TIMEOUT": {
                    this.mqttMeta.setConnectionTimeout(option.getValue());
                    break;
                }
                case "CLEAN_SESSION": {
                    this.mqttMeta.setCleanSession(option.getValue());
                    break;
                }
                case "STORAGE_LEVEL": {
                    this.mqttMeta.setStorageLevel(option.getValue());
                    break;
                }
                case "SERVER_URIS": {
                    this.mqttMeta.setServerUris(option.getValue());
                    break;
                }
                case "MQTT_VERSION": {
                    this.mqttMeta.setMqttVersion(option.getValue());
                    break;
                }
                case "AUTOMATIC_RECONNECT": {
                    this.mqttMeta.setAutomaticReconnect(option.getValue());
                    break;
                }
                default: {
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"MQTTDialog.Error.UnknownOption", (String[])new String[]{option.getKey()}));
                }
            }
        });
    }
}

