/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon;

import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.amazon.AbstractAmazonJobEntry;
import org.pentaho.amazon.AbstractAmazonJobExecutorController;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public abstract class AbstractAmazonJobEntryDialog<E extends AbstractAmazonJobEntry>
extends JobEntryDialog
implements JobEntryDialogInterface {
    protected ResourceBundle bundle = new ResourceBundle(){

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString(AbstractAmazonJobEntryDialog.this.getMessagesClass(), (String)key, (String[])new String[0]);
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }
    };
    private AbstractAmazonJobExecutorController controller;

    protected AbstractAmazonJobEntryDialog(Shell parent, JobEntryInterface jobEntry, Repository rep, JobMeta jobMeta) throws XulException {
        super(parent, jobEntry, rep, jobMeta);
        this.init((AbstractAmazonJobEntry)jobEntry);
    }

    protected abstract Class<?> getMessagesClass();

    protected abstract String getXulFile();

    protected abstract AbstractAmazonJobExecutorController createController(XulDomContainer var1, AbstractAmazonJobEntry var2, BindingFactory var3);

    protected void init(AbstractAmazonJobEntry jobEntry) throws XulException {
        SwtXulLoader swtXulLoader = new SwtXulLoader();
        swtXulLoader.setSettingsManager((XulSettingsManager)XulSpoonSettingsManager.getInstance());
        swtXulLoader.registerClassLoader((Object)((Object)((Object)this)).getClass().getClassLoader());
        swtXulLoader.register("VARIABLETEXTBOX", ExtTextbox.class.getName());
        swtXulLoader.setOuterContext((Object)this.shell);
        XulDomContainer container = swtXulLoader.loadXul(this.getXulFile(), (Object)this.bundle);
        DefaultBindingFactory bf = new DefaultBindingFactory();
        bf.setDocument(container.getDocumentRoot());
        this.controller = this.createController(container, jobEntry, (BindingFactory)bf);
        container.addEventHandler((XulEventHandler)this.controller);
        this.setDialogSize();
        SwtXulRunner runner = new SwtXulRunner();
        runner.addContainer(container);
        runner.initialize();
    }

    public JobEntryInterface open() {
        return this.controller.open();
    }

    private void setDialogSize() {
        XulSpoonSettingsManager settingsManager = XulSpoonSettingsManager.getInstance();
        SwtDialog dialog = this.controller.getDialog();
        if (Const.isWindows()) {
            settingsManager.storeSetting(this.controller.getDialogElementId() + ".Width", String.valueOf(dialog.getWidth()));
            settingsManager.storeSetting(this.controller.getDialogElementId() + ".Height", String.valueOf(dialog.getHeight()));
        } else {
            settingsManager.storeSetting(this.controller.getDialogElementId() + ".Width", String.valueOf(dialog.getAttributeValue("linuxWidth")));
            settingsManager.storeSetting(this.controller.getDialogElementId() + ".Height", String.valueOf(dialog.getAttributeValue("linuxHeight")));
        }
    }
}

