/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.hive.job;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.amazon.AbstractAmazonJobExecutor;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@JobEntry(id="HiveJobExecutorPlugin", image="AWS-HIVE.svg", name="HiveJobExecutorPlugin.Name", description="HiveJobExecutorPlugin.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", documentationUrl="Products/Amazon_Hive_Job_Executor", i18nPackageName="org.pentaho.amazon.hive.job")
public class AmazonHiveJobExecutor
extends AbstractAmazonJobExecutor {
    private static Class<?> PKG = AmazonHiveJobExecutor.class;
    private static final String STEP_HIVE = "hive";
    protected String qUrl = "";
    protected String bootstrapActions = "";

    public String getQUrl() {
        return this.qUrl;
    }

    public void setQUrl(String qUrl) {
        this.qUrl = qUrl;
    }

    public String getBootstrapActions() {
        return this.bootstrapActions;
    }

    public void setBootstrapActions(String bootstrapActions) {
        this.bootstrapActions = bootstrapActions;
    }

    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public File createStagingFile() throws IOException, KettleException {
        FileObject qFile = KettleVFS.getFileObject((String)this.buildFilename(this.qUrl));
        File tmpFile = File.createTempFile("customEMR", "q");
        tmpFile.deleteOnExit();
        FileOutputStream tmpFileOut = new FileOutputStream(tmpFile);
        IOUtils.copy((InputStream)qFile.getContent().getInputStream(), (OutputStream)tmpFileOut);
        this.setS3BucketKey(qFile);
        return tmpFile;
    }

    @Override
    public String getStepBootstrapActions() {
        return this.bootstrapActions;
    }

    @Override
    public String getMainClass() throws Exception {
        return null;
    }

    @Override
    public String getStepType() {
        return STEP_HIVE;
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        this.hadoopJobName = XMLHandler.getTagValue((Node)entrynode, (String)"hadoop_job_name");
        this.hadoopJobFlowId = XMLHandler.getTagValue((Node)entrynode, (String)"hadoop_job_flow_id");
        this.qUrl = XMLHandler.getTagValue((Node)entrynode, (String)"q_url");
        this.accessKey = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"access_key"));
        this.secretKey = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"secret_key"));
        this.region = XMLHandler.getTagValue((Node)entrynode, (String)"region");
        this.ec2Role = XMLHandler.getTagValue((Node)entrynode, (String)"ec2_role");
        this.emrRole = XMLHandler.getTagValue((Node)entrynode, (String)"emr_role");
        this.masterInstanceType = XMLHandler.getTagValue((Node)entrynode, (String)"master_instance_type");
        this.slaveInstanceType = XMLHandler.getTagValue((Node)entrynode, (String)"slave_instance_type");
        this.numInstances = XMLHandler.getTagValue((Node)entrynode, (String)"num_instances");
        this.emrRelease = XMLHandler.getTagValue((Node)entrynode, (String)"emr_release");
        this.bootstrapActions = XMLHandler.getTagValue((Node)entrynode, (String)"bootstrap_actions");
        this.stagingDir = XMLHandler.getTagValue((Node)entrynode, (String)"staging_dir");
        this.cmdLineArgs = XMLHandler.getTagValue((Node)entrynode, (String)"command_line_args");
        this.alive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"alive"));
        this.runOnNewCluster = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"runOnNewCluster"));
        this.blocking = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"blocking"));
        this.loggingInterval = XMLHandler.getTagValue((Node)entrynode, (String)"logging_interval");
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(1024);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_name", (String)this.hadoopJobName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_flow_id", (String)this.hadoopJobFlowId));
        retval.append("      ").append(XMLHandler.addTagValue((String)"q_url", (String)this.qUrl));
        retval.append("      ").append(XMLHandler.addTagValue((String)"access_key", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.accessKey)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"secret_key", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.secretKey)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"region", (String)this.region));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ec2_role", (String)this.ec2Role));
        retval.append("      ").append(XMLHandler.addTagValue((String)"emr_role", (String)this.emrRole));
        retval.append("      ").append(XMLHandler.addTagValue((String)"master_instance_type", (String)this.masterInstanceType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"slave_instance_type", (String)this.slaveInstanceType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"emr_release", (String)this.emrRelease));
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_instances", (String)this.numInstances));
        retval.append("      ").append(XMLHandler.addTagValue((String)"bootstrap_actions", (String)this.bootstrapActions));
        retval.append("      ").append(XMLHandler.addTagValue((String)"staging_dir", (String)this.stagingDir));
        retval.append("      ").append(XMLHandler.addTagValue((String)"command_line_args", (String)this.cmdLineArgs));
        retval.append("      ").append(XMLHandler.addTagValue((String)"alive", (boolean)this.alive));
        retval.append("      ").append(XMLHandler.addTagValue((String)"runOnNewCluster", (boolean)this.runOnNewCluster));
        retval.append("      ").append(XMLHandler.addTagValue((String)"blocking", (boolean)this.blocking));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logging_interval", (String)this.loggingInterval));
        return retval.toString();
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        if (rep == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AmazonHiveJobExecutor.LoadFromRepository.Error", (String[])new String[0]));
        }
        super.loadRep(rep, metaStore, id_jobentry, databases, slaveServers);
        this.setHadoopJobName(rep.getJobEntryAttributeString(id_jobentry, "hadoop_job_name"));
        this.setHadoopJobFlowId(rep.getJobEntryAttributeString(id_jobentry, "hadoop_job_flow_id"));
        this.setQUrl(rep.getJobEntryAttributeString(id_jobentry, "q_url"));
        this.setAccessKey(Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "access_key")));
        this.setSecretKey(Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "secret_key")));
        this.setRegion(rep.getJobEntryAttributeString(id_jobentry, "region"));
        this.setEc2Role(rep.getJobEntryAttributeString(id_jobentry, "ec2_role"));
        this.setEmrRole(rep.getJobEntryAttributeString(id_jobentry, "emr_role"));
        this.setMasterInstanceType(rep.getJobEntryAttributeString(id_jobentry, "master_instance_type"));
        this.setSlaveInstanceType(rep.getJobEntryAttributeString(id_jobentry, "slave_instance_type"));
        this.setEmrRelease(rep.getJobEntryAttributeString(id_jobentry, "emr_release"));
        this.setNumInstances(rep.getJobEntryAttributeString(id_jobentry, "num_instances"));
        this.setBootstrapActions(rep.getJobEntryAttributeString(id_jobentry, "bootstrap_actions"));
        this.setStagingDir(rep.getJobEntryAttributeString(id_jobentry, "staging_dir"));
        this.setCmdLineArgs(rep.getJobEntryAttributeString(id_jobentry, "command_line_args"));
        this.setAlive(rep.getJobEntryAttributeBoolean(id_jobentry, "alive"));
        this.setRunOnNewCluster(rep.getJobEntryAttributeBoolean(id_jobentry, "runOnNewCluster"));
        this.setBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, "blocking"));
        this.setLoggingInterval(rep.getJobEntryAttributeString(id_jobentry, "logging_interval"));
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        if (rep == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AmazonHiveJobExecutor.SaveToRepository.Error", (String[])new String[0]));
        }
        super.saveRep(rep, metaStore, id_job);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_name", this.hadoopJobName);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_flow_id", this.hadoopJobFlowId);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "q_url", this.qUrl);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "secret_key", Encr.encryptPasswordIfNotUsingVariables((String)this.secretKey));
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "access_key", Encr.encryptPasswordIfNotUsingVariables((String)this.accessKey));
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "region", this.region);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ec2_role", this.ec2Role);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "emr_role", this.emrRole);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "master_instance_type", this.masterInstanceType);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "slave_instance_type", this.slaveInstanceType);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "emr_release", this.emrRelease);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_instances", this.numInstances);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "bootstrap_actions", this.bootstrapActions);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "staging_dir", this.stagingDir);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "command_line_args", this.cmdLineArgs);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "alive", this.alive);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "blocking", this.blocking);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "runOnNewCluster", this.runOnNewCluster);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logging_interval", this.loggingInterval);
    }

    @Override
    public String buildFilename(String filename) {
        if ((filename = this.environmentSubstitute(filename)).startsWith("s3")) {
            String authPart = filename.substring("s3".length() + 3, filename.indexOf("@s3")).replaceAll("\\+", "%2B").replaceAll("/", "%2F");
            filename = "s3://" + authPart + "@s3" + filename.substring(filename.indexOf("@s3") + 3);
        }
        return filename;
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public String getDialogClassName() {
        String className = this.getClass().getCanonicalName();
        className = className.replaceFirst("\\.job\\.", ".ui.");
        className = className + "Dialog";
        return className;
    }
}

