/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryExtended;
import org.pentaho.di.ui.cluster.dialog.SlaveServerDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryExplorerDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.LazilyInitializedController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UISlave;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UISlaves;
import org.pentaho.di.ui.spoon.SharedObjectSyncUtil;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class SlavesController
extends LazilyInitializedController
implements IUISupportController {
    private static Class<?> PKG = RepositoryExplorerDialog.class;
    private XulTree slavesTable = null;
    protected BindingFactory bf = null;
    private Shell shell = null;
    private UISlaves slaveList = new UISlaves();
    private MainController mainController;

    @Override
    public void init(Repository repository) throws ControllerInitializationException {
        this.repository = repository;
    }

    public String getName() {
        return "slavesController";
    }

    public void createBindings() {
        block2: {
            this.refreshSlaves();
            try {
                this.slavesTable = (XulTree)this.document.getElementById("slaves-table");
                this.bf.setBindingType(Binding.Type.ONE_WAY);
                this.bf.createBinding((Object)this.slaveList, "children", (Object)this.slavesTable, "elements", new BindingConvertor[0]).fireSourceChanged();
                this.bf.createBinding((Object)this.slavesTable, "selectedItems", (Object)this, "enableButtons", new BindingConvertor[0]);
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository(e)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected boolean doLazyInit() {
        this.shell = ((SwtDialog)this.document.getElementById("repository-explorer-dialog")).getShell();
        this.enableButtons(true, false, false);
        this.bf = new SwtBindingFactory();
        this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
        try {
            this.mainController = (MainController)this.getXulDomContainer().getEventHandler("mainController");
        }
        catch (XulException e) {
            return false;
        }
        if (this.bf != null) {
            this.createBindings();
        }
        return true;
    }

    public void refreshSlaves() {
        if (this.repository != null) {
            ArrayList tmpList = new ArrayList();
            Runnable r = () -> {
                block3: {
                    try {
                        List slaveServers = this.repository instanceof RepositoryExtended ? ((RepositoryExtended)this.repository).getSlaveServers(false) : this.repository.getSlaveServers();
                        if (slaveServers != null) {
                            slaveServers.forEach(slaveServer -> tmpList.add(new UISlave((SlaveServer)slaveServer)));
                        }
                    }
                    catch (KettleException e) {
                        if (this.mainController != null && this.mainController.handleLostRepository(e)) break block3;
                        throw new RuntimeException(e);
                    }
                }
            };
            this.doWithBusyIndicator(r);
            this.slaveList.setChildren(tmpList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSlave() {
        try {
            SlaveServer slaveServer = new SlaveServer();
            SlaveServerDialog ssd = new SlaveServerDialog(this.shell, slaveServer);
            if (ssd.open()) {
                ObjectId slaveId = this.repository.getSlaveID(slaveServer.getName());
                if (slaveId != null) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.AlreadyExists.Message", (String[])new String[]{slaveServer.getName()}));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Create.Title", (String[])new String[0]));
                    mb.open();
                } else if (slaveServer.getName() != null && !slaveServer.getName().equals("")) {
                    this.repository.insertLogEntry(BaseMessages.getString(PKG, (String)"SlavesController.Message.CreatingSlave", (String[])new String[]{slaveServer.getName()}));
                    this.repository.save((RepositoryElementInterface)slaveServer, "Creation of initial version", null);
                    if (this.getSharedObjectSyncUtil() != null) {
                        this.getSharedObjectSyncUtil().reloadJobRepositoryObjects(true);
                        this.getSharedObjectSyncUtil().reloadTransformationRepositoryObjects(true);
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Edit.InvalidName.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Create.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (KettleException e) {
            if (this.mainController == null || !this.mainController.handleLostRepository(e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Create.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Create.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
            }
        }
        finally {
            this.refreshSlaves();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editSlave() {
        String slaveServerName = "";
        try {
            Collection slaves = this.slavesTable.getSelectedItems();
            if (slaves != null && !slaves.isEmpty()) {
                SlaveServer slaveServer = ((UISlave)((Object)slaves.toArray()[0])).getSlaveServer();
                slaveServerName = slaveServer.getName();
                ObjectId slaveId = this.repository.getSlaveID(slaveServer.getName());
                if (slaveId == null) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.DoesNotExists.Message", (String[])new String[]{slaveServerName}));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Edit.Title", (String[])new String[0]));
                    mb.open();
                } else {
                    SlaveServerDialog ssd = new SlaveServerDialog(this.shell, slaveServer);
                    if (ssd.open()) {
                        if (slaveServer.getName() != null && !slaveServer.getName().equals("")) {
                            this.repository.insertLogEntry(BaseMessages.getString(PKG, (String)"SlavesController.Message.UpdatingSlave", (String[])new String[]{slaveServer.getName()}));
                            this.repository.save((RepositoryElementInterface)slaveServer, "Modification by user", null);
                            if (this.getSharedObjectSyncUtil() != null) {
                                this.getSharedObjectSyncUtil().synchronizeSlaveServers(slaveServer, slaveServerName);
                            }
                        } else {
                            MessageBox mb = new MessageBox(this.shell, 33);
                            mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Edit.InvalidName.Message", (String[])new String[0]));
                            mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Edit.Title", (String[])new String[0]));
                            mb.open();
                        }
                    }
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Edit.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException e) {
            if (this.mainController == null || !this.mainController.handleLostRepository(e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Edit.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Edit.UnexpectedError.Message", (String[])new String[0]) + slaveServerName + "]", (Exception)((Object)e));
            }
        }
        finally {
            this.refreshSlaves();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSlave() {
        String slaveServerName = "";
        try {
            Collection slaves = this.slavesTable.getSelectedItems();
            if (slaves != null && !slaves.isEmpty()) {
                for (Object obj : slaves) {
                    if (obj == null || !(obj instanceof UISlave)) continue;
                    UISlave slave = (UISlave)((Object)obj);
                    SlaveServer slaveServer = slave.getSlaveServer();
                    slaveServerName = slaveServer.getName();
                    ObjectId slaveId = this.repository.getSlaveID(slaveServer.getName());
                    if (slaveId == null) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.DoesNotExists.Message", (String[])new String[]{slaveServerName}));
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Delete.Title", (String[])new String[0]));
                        mb.open();
                        continue;
                    }
                    this.repository.deleteSlave(slaveId);
                    if (this.getSharedObjectSyncUtil() == null) continue;
                    this.getSharedObjectSyncUtil().deleteSlaveServer(slaveServer);
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Delete.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException e) {
            if (this.mainController == null || !this.mainController.handleLostRepository(e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Delete.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Delete.UnexpectedError.Message", (String[])new String[0]) + slaveServerName + "]", (Exception)((Object)e));
            }
        }
        finally {
            this.refreshSlaves();
        }
    }

    public void setEnableButtons(List<UISlave> slaves) {
        boolean enableEdit = false;
        boolean enableRemove = false;
        if (slaves != null && slaves.size() > 0) {
            enableRemove = true;
            if (slaves.size() == 1) {
                enableEdit = true;
            }
        }
        this.enableButtons(true, enableEdit, enableRemove);
    }

    public void enableButtons(boolean enableNew, boolean enableEdit, boolean enableRemove) {
        XulButton bNew = (XulButton)this.document.getElementById("slaves-new");
        XulButton bEdit = (XulButton)this.document.getElementById("slaves-edit");
        XulButton bRemove = (XulButton)this.document.getElementById("slaves-remove");
        bNew.setDisabled(!enableNew);
        bEdit.setDisabled(!enableEdit);
        bRemove.setDisabled(!enableRemove);
    }

    public void tabClicked() {
        this.lazyInit();
    }

    private SharedObjectSyncUtil getSharedObjectSyncUtil() {
        return this.mainController != null ? this.mainController.getSharedObjectSyncUtil() : null;
    }
}

