/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.metastore.locator.api.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import org.pentaho.di.core.osgi.api.MetastoreLocatorOsgi;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.osgi.blueprint.collection.utils.ServiceMap;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;
import org.pentaho.osgi.metastore.locator.api.MetastoreProvider;

public class MetastoreLocatorImpl
extends ServiceMap<MetastoreProvider>
implements MetastoreLocator,
MetastoreLocatorOsgi {
    public IMetaStore getExplicitMetastore(String providerKey) {
        MetastoreProvider provider = (MetastoreProvider)super.getItem(providerKey);
        return provider == null ? null : provider.getMetastore();
    }

    public IMetaStore getMetastore() {
        return this.getMetastore(null);
    }

    public IMetaStore getMetastore(String providerKey) {
        IMetaStore metaStore = this.getExplicitMetastore("RepositoryMetastoreProvider");
        if (metaStore == null) {
            metaStore = this.getExplicitMetastore("LocalMetastoreProvider");
        }
        if (metaStore == null && providerKey != null) {
            metaStore = this.getExplicitMetastore(providerKey);
        }
        if (metaStore == null) {
            try {
                metaStore = MetaStoreConst.openLocalPentahoMetaStore((boolean)false);
            }
            catch (MetaStoreException e) {
                return null;
            }
        }
        return metaStore;
    }

    public String setEmbeddedMetastore(final IMetaStore metastore) {
        MetastoreProvider metastoreProvider = new MetastoreProvider(){

            public IMetaStore getMetastore() {
                return metastore;
            }
        };
        UUID uuid = UUID.randomUUID();
        String providerKey = "Embedded" + uuid.toString();
        this.itemAdded(metastoreProvider, (Map)ImmutableMap.of((Object)"serviceMapKey", (Object)providerKey));
        return providerKey;
    }

    public void disposeMetastoreProvider(String providerKey) {
        this.itemRemoved(null, (Map)ImmutableMap.of((Object)"serviceMapKey", (Object)providerKey));
    }
}

