/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.jobentry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.metaverse.api.analyzer.kettle.BaseKettleMetaverseComponent;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IClonableJobEntryAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryAnalyzerProvider;

public class JobEntryAnalyzerProvider
extends BaseKettleMetaverseComponent
implements IJobEntryAnalyzerProvider {
    protected List<IJobEntryAnalyzer> jobEntryAnalyzers = new ArrayList<IJobEntryAnalyzer>();
    protected Map<Class<? extends JobEntryInterface>, Set<IJobEntryAnalyzer>> analyzerTypeMap = new HashMap<Class<? extends JobEntryInterface>, Set<IJobEntryAnalyzer>>();

    public List<IJobEntryAnalyzer> getAnalyzers() {
        return this.jobEntryAnalyzers;
    }

    public List<IJobEntryAnalyzer> getAnalyzers(Collection<Class<?>> types) {
        List<IJobEntryAnalyzer> jobEntryAnalyzers = this.getAnalyzers();
        if (types != null) {
            HashSet specificStepAnalyzers = new HashSet();
            for (Class<?> clazz : types) {
                if (!this.analyzerTypeMap.containsKey(clazz)) continue;
                specificStepAnalyzers.addAll(this.analyzerTypeMap.get(clazz));
            }
            jobEntryAnalyzers = new ArrayList<IJobEntryAnalyzer>(specificStepAnalyzers);
        }
        return jobEntryAnalyzers;
    }

    public void setJobEntryAnalyzers(List<IJobEntryAnalyzer> analyzers) {
        if (analyzers == null) {
            this.jobEntryAnalyzers = null;
        } else {
            if (this.jobEntryAnalyzers == null) {
                this.jobEntryAnalyzers = new ArrayList<IJobEntryAnalyzer>();
            }
            for (IJobEntryAnalyzer analyzer : analyzers) {
                if (this.jobEntryAnalyzers.contains(analyzer)) continue;
                this.jobEntryAnalyzers.add(analyzer);
            }
            this.loadAnalyzerTypeMap();
        }
    }

    public void setClonableJobEntryAnalyzers(List<IJobEntryAnalyzer> analyzers) {
        this.setJobEntryAnalyzers(analyzers);
    }

    protected void loadAnalyzerTypeMap() {
        this.analyzerTypeMap = new HashMap<Class<? extends JobEntryInterface>, Set<IJobEntryAnalyzer>>();
        if (this.jobEntryAnalyzers != null) {
            for (IJobEntryAnalyzer analyzer : this.jobEntryAnalyzers) {
                this.addAnalyzer(analyzer);
            }
        }
    }

    public void addAnalyzer(IJobEntryAnalyzer analyzer) {
        Set types;
        if (!this.jobEntryAnalyzers.contains(analyzer)) {
            this.jobEntryAnalyzers.add(analyzer);
        }
        if ((types = analyzer.getSupportedEntries()) != null) {
            for (Class type : types) {
                Set<IJobEntryAnalyzer> analyzerSet = null;
                analyzerSet = this.analyzerTypeMap.containsKey(type) ? this.analyzerTypeMap.get(type) : new HashSet<IJobEntryAnalyzer>();
                analyzerSet.add(analyzer);
                this.analyzerTypeMap.put(type, analyzerSet);
            }
        }
    }

    public void addClonableAnalyzer(IClonableJobEntryAnalyzer analyzer) {
        this.addAnalyzer((IJobEntryAnalyzer)analyzer);
    }

    public void removeAnalyzer(IJobEntryAnalyzer analyzer) {
        if (analyzer != null) {
            Set types;
            if (this.jobEntryAnalyzers.contains(analyzer)) {
                try {
                    this.jobEntryAnalyzers.remove(analyzer);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            if ((types = analyzer.getSupportedEntries()) != null) {
                for (Class type : types) {
                    Set<IJobEntryAnalyzer> analyzerSet = null;
                    if (!this.analyzerTypeMap.containsKey(type)) continue;
                    analyzerSet = this.analyzerTypeMap.get(type);
                    analyzerSet.remove(analyzer);
                    if (analyzerSet.size() != 0) continue;
                    this.analyzerTypeMap.remove(type);
                }
            }
        }
    }

    public void removeClonableAnalyzer(IClonableJobEntryAnalyzer analyzer) {
        this.removeAnalyzer((IJobEntryAnalyzer)analyzer);
    }
}

