/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.jobentry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryExternalResourceConsumer;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryExternalResourceConsumerProvider;

public class JobEntryExternalResourceConsumerProvider
implements IJobEntryExternalResourceConsumerProvider {
    private List<IJobEntryExternalResourceConsumer> jobEntryExternalResourceConsumers;
    private Map<Class<? extends JobEntryBase>, Set<IJobEntryExternalResourceConsumer>> jobEntryConsumerMap = new ConcurrentHashMap<Class<? extends JobEntryBase>, Set<IJobEntryExternalResourceConsumer>>();

    public void setExternalResourceConsumers(List<IJobEntryExternalResourceConsumer> jobEntryConsumers) {
        this.jobEntryExternalResourceConsumers = jobEntryConsumers;
        this.loadJobEntryExternalResourceConsumerMap();
    }

    public List<IJobEntryExternalResourceConsumer> getExternalResourceConsumers() {
        return this.jobEntryExternalResourceConsumers;
    }

    public List<IJobEntryExternalResourceConsumer> getExternalResourceConsumers(Collection<Class<?>> types) {
        List<IJobEntryExternalResourceConsumer> jobEntryConsumers = this.getExternalResourceConsumers();
        if (types != null) {
            HashSet specificJobEntryAnalyzers = new HashSet();
            for (Class<?> clazz : types) {
                if (!this.jobEntryConsumerMap.containsKey(clazz)) continue;
                specificJobEntryAnalyzers.addAll(this.jobEntryConsumerMap.get(clazz));
            }
            jobEntryConsumers = new ArrayList<IJobEntryExternalResourceConsumer>(specificJobEntryAnalyzers);
        }
        return jobEntryConsumers;
    }

    public void addExternalResourceConsumer(IJobEntryExternalResourceConsumer externalResourceConsumer) {
        Class metaClass;
        if (!this.jobEntryExternalResourceConsumers.contains(externalResourceConsumer)) {
            this.jobEntryExternalResourceConsumers.add(externalResourceConsumer);
        }
        if ((metaClass = externalResourceConsumer.getMetaClass()) != null) {
            Set<IJobEntryExternalResourceConsumer> consumerSet = null;
            consumerSet = this.jobEntryConsumerMap.containsKey(metaClass) ? this.jobEntryConsumerMap.get(metaClass) : new HashSet<IJobEntryExternalResourceConsumer>();
            consumerSet.add(externalResourceConsumer);
            this.jobEntryConsumerMap.put(metaClass, consumerSet);
        }
    }

    public void removeExternalResourceConsumer(IJobEntryExternalResourceConsumer externalResourceConsumer) {
        Class metaClass;
        if (this.jobEntryExternalResourceConsumers.contains(externalResourceConsumer)) {
            try {
                this.jobEntryExternalResourceConsumers.remove(externalResourceConsumer);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (externalResourceConsumer != null && (metaClass = externalResourceConsumer.getMetaClass()) != null) {
            Set<IJobEntryExternalResourceConsumer> consumerSet = null;
            if (this.jobEntryConsumerMap.containsKey(metaClass)) {
                consumerSet = this.jobEntryConsumerMap.get(metaClass);
                consumerSet.remove(externalResourceConsumer);
                if (consumerSet.isEmpty()) {
                    this.jobEntryConsumerMap.remove(metaClass);
                }
            }
        }
    }

    public Map<Class<? extends JobEntryBase>, Set<IJobEntryExternalResourceConsumer>> getJobEntryConsumerMap() {
        return this.jobEntryConsumerMap;
    }

    protected void loadJobEntryExternalResourceConsumerMap() {
        this.jobEntryConsumerMap = new HashMap<Class<? extends JobEntryBase>, Set<IJobEntryExternalResourceConsumer>>();
        if (this.jobEntryExternalResourceConsumers != null) {
            for (IJobEntryExternalResourceConsumer jobEntryConsumer : this.jobEntryExternalResourceConsumers) {
                this.addExternalResourceConsumer(jobEntryConsumer);
            }
        }
    }
}

