/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.fileinput.text;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class TextFileInputStepAnalyzer
extends ExternalResourceStepAnalyzer<TextFileInputMeta> {
    protected Set<StepField> getUsedFields(TextFileInputMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        if (meta.isAcceptingFilenames() && StringUtils.isNotEmpty((String)meta.getAcceptingStepName())) {
            StepField stepField = new StepField(meta.getAcceptingStepName(), meta.getAcceptingField());
            usedFields.add(stepField);
        }
        return usedFields;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(TextFileInputMeta.class);
            }
        };
    }

    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        return this.createFileNode(resource.getName(), this.descriptor);
    }

    public String getResourceInputNodeType() {
        return "File Field";
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    protected IClonableStepAnalyzer newInstance() {
        return new TextFileInputStepAnalyzer();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

