/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase;

import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.w3c.dom.Node;

public class NamedClusterLoadSaveUtil {
    public static final String CLUSTER_NAME = "cluster_name";
    public static final String ZOOKEEPER_HOSTS = "zookeeper_hosts";
    public static final String ZOOKEEPER_PORT = "zookeeper_port";

    public NamedCluster loadClusterConfig(NamedClusterService namedClusterService, ObjectId id_jobentry, Repository rep, IMetaStore metaStore, Node entrynode, LogChannelInterface logChannelInterface) {
        NamedCluster nc = null;
        String clusterName = null;
        try {
            if (entrynode != null) {
                clusterName = XMLHandler.getTagValue((Node)entrynode, (String)CLUSTER_NAME);
            } else if (rep != null) {
                clusterName = rep.getJobEntryAttributeString(id_jobentry, CLUSTER_NAME);
            }
            if (!StringUtils.isEmpty((String)clusterName)) {
                nc = namedClusterService.getNamedClusterByName(clusterName, metaStore);
            }
            if (nc != null) {
                return nc;
            }
        }
        catch (Throwable t) {
            logChannelInterface.logDebug(t.getMessage(), new Object[]{t});
        }
        nc = namedClusterService.getClusterTemplate();
        if (!StringUtils.isEmpty((String)clusterName)) {
            nc.setName(clusterName);
        }
        if (entrynode != null) {
            nc.setZooKeeperHost(XMLHandler.getTagValue((Node)entrynode, (String)ZOOKEEPER_HOSTS));
            nc.setZooKeeperPort(XMLHandler.getTagValue((Node)entrynode, (String)ZOOKEEPER_PORT));
        } else if (rep != null) {
            try {
                nc.setZooKeeperHost(rep.getJobEntryAttributeString(id_jobentry, ZOOKEEPER_HOSTS));
                nc.setZooKeeperPort(rep.getJobEntryAttributeString(id_jobentry, ZOOKEEPER_PORT));
            }
            catch (KettleException ke) {
                logChannelInterface.logError(ke.getMessage(), (Throwable)ke);
            }
        }
        return nc;
    }

    public void getXml(StringBuilder retval, NamedClusterService namedClusterService, NamedCluster namedCluster, IMetaStore metaStore, LogChannelInterface logChannelInterface) {
        String namedClusterName = namedCluster.getName();
        String m_zookeeperHosts = namedCluster.getZooKeeperHost();
        String m_zookeeperPort = namedCluster.getZooKeeperPort();
        if (!StringUtils.isEmpty((String)namedClusterName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)CLUSTER_NAME, (String)namedClusterName));
            try {
                NamedCluster nc;
                if (metaStore != null && namedClusterService.contains(namedClusterName, metaStore) && (nc = namedClusterService.read(namedClusterName, metaStore)) != null) {
                    m_zookeeperHosts = nc.getZooKeeperHost();
                    m_zookeeperPort = nc.getZooKeeperPort();
                }
            }
            catch (MetaStoreException e) {
                logChannelInterface.logDebug(e.getMessage(), new Object[]{e});
            }
        }
        if (!Utils.isEmpty((CharSequence)m_zookeeperHosts)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)ZOOKEEPER_HOSTS, (String)m_zookeeperHosts));
        }
        if (!Utils.isEmpty((CharSequence)m_zookeeperPort)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)ZOOKEEPER_PORT, (String)m_zookeeperPort));
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step, NamedClusterService namedClusterService, NamedCluster namedCluster, LogChannelInterface logChannelInterface) throws KettleException {
        String namedClusterName = namedCluster.getName();
        String m_zookeeperHosts = namedCluster.getZooKeeperHost();
        String m_zookeeperPort = namedCluster.getZooKeeperPort();
        if (!StringUtils.isEmpty((String)namedClusterName)) {
            rep.saveStepAttribute(id_transformation, id_step, CLUSTER_NAME, namedClusterName);
            try {
                if (namedClusterService.contains(namedClusterName, metaStore)) {
                    NamedCluster nc = namedClusterService.read(namedClusterName, metaStore);
                    m_zookeeperHosts = nc.getZooKeeperHost();
                    m_zookeeperPort = nc.getZooKeeperPort();
                }
            }
            catch (MetaStoreException e) {
                logChannelInterface.logDebug(e.getMessage(), new Object[]{e});
            }
        }
        if (!Utils.isEmpty((CharSequence)m_zookeeperHosts)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, ZOOKEEPER_HOSTS, m_zookeeperHosts);
        }
        if (!Utils.isEmpty((CharSequence)m_zookeeperPort)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, ZOOKEEPER_PORT, m_zookeeperPort);
        }
    }
}

