/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.input;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.big.data.kettle.plugins.hbase.input.HBaseInputMeta;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.HBaseRowToKettleTuple;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.hadoop.shim.api.hbase.HBaseService;
import org.pentaho.hadoop.shim.api.hbase.Result;
import org.pentaho.hadoop.shim.api.hbase.mapping.ColumnFilter;
import org.pentaho.hadoop.shim.api.hbase.mapping.Mapping;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.hadoop.shim.api.hbase.table.ResultScannerBuilder;

public class HBaseInputData
extends BaseStepData
implements StepDataInterface {
    protected RowMetaInterface m_outputRowMeta;

    public RowMetaInterface getOutputRowMeta() {
        return this.m_outputRowMeta;
    }

    public void setOutputRowMeta(RowMetaInterface rmi) {
        this.m_outputRowMeta = rmi;
    }

    public static URL stringToURL(String pathOrURL) throws MalformedURLException {
        URL result = null;
        if (!Const.isEmpty((String)pathOrURL)) {
            if (pathOrURL.toLowerCase().startsWith("http://") || pathOrURL.toLowerCase().startsWith("file://")) {
                result = new URL(pathOrURL);
            } else {
                String c = "file://" + pathOrURL;
                result = new URL(c);
            }
        }
        return result;
    }

    public static void setScanColumns(ResultScannerBuilder resultScannerBuilder, List<HBaseValueMetaInterface> limitCols, Mapping tableMapping) throws KettleException {
        for (HBaseValueMetaInterface currentCol : limitCols) {
            if (currentCol.isKey()) continue;
            String colFamilyName = currentCol.getColumnFamily();
            String qualifier = currentCol.getColumnName();
            boolean binaryColName = false;
            if (qualifier.startsWith("@@@binary@@@")) {
                qualifier = qualifier.replace("@@@binary@@@", "");
                binaryColName = true;
            }
            try {
                resultScannerBuilder.addColumnToScan(colFamilyName, qualifier, binaryColName);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToAddColumnToScan", (String[])new String[0]), (Throwable)ex);
            }
        }
    }

    public static void setScanFilters(ResultScannerBuilder resultScannerBuilder, Collection<ColumnFilter> columnFilters, boolean matchAnyFilter, Map<String, HBaseValueMetaInterface> columnsMappedByAlias, VariableSpace vars) throws KettleException {
        for (ColumnFilter cf : columnFilters) {
            String fieldAliasS = vars.environmentSubstitute(cf.getFieldAlias());
            HBaseValueMetaInterface mappedCol = columnsMappedByAlias.get(fieldAliasS);
            if (mappedCol == null) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.ColumnFilterIsNotInTheMapping", (String[])new String[]{fieldAliasS}));
            }
            String fieldTypeS = vars.environmentSubstitute(cf.getFieldType());
            if (!Const.isEmpty((String)fieldTypeS) && !mappedCol.getHBaseTypeDesc().equalsIgnoreCase(fieldTypeS)) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.FieldTypeMismatch", (String[])new String[]{fieldTypeS, fieldAliasS, mappedCol.getHBaseTypeDesc()}));
            }
            try {
                resultScannerBuilder.addColumnFilterToScan(cf, mappedCol, vars, matchAnyFilter);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToAddColumnFilterToScan", (String[])new String[0]), (Throwable)ex);
            }
        }
    }

    public static List<Object[]> getTupleOutputRows(HBaseService hBaseService, Result result, List<HBaseValueMetaInterface> userOutputColumns, Map<String, HBaseValueMetaInterface> columnsMappedByAlias, Mapping tableMapping, HBaseRowToKettleTuple tupleHandler, RowMetaInterface outputRowMeta) throws KettleException {
        if (userOutputColumns != null && userOutputColumns.size() > 0) {
            return tupleHandler.hbaseRowToKettleTupleMode(result, tableMapping, userOutputColumns, outputRowMeta);
        }
        return tupleHandler.hbaseRowToKettleTupleMode(hBaseService.getHBaseValueMetaInterfaceFactory(), result, tableMapping, columnsMappedByAlias, outputRowMeta);
    }

    public static Object[] getOutputRow(Result result, List<HBaseValueMetaInterface> userOutputColumns, Map<String, HBaseValueMetaInterface> columnsMappedByAlias, Mapping tableMapping, RowMetaInterface outputRowMeta) throws KettleException {
        int size = userOutputColumns != null && userOutputColumns.size() > 0 ? userOutputColumns.size() : tableMapping.numMappedColumns() + 1;
        Object[] outputRowData = RowDataUtil.allocateRowData((int)size);
        if (userOutputColumns != null && userOutputColumns.size() > 0) {
            for (HBaseValueMetaInterface currentCol : userOutputColumns) {
                Object decodedVal;
                if (currentCol.isKey()) {
                    byte[] rawKey = null;
                    try {
                        rawKey = result.getRow();
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                    Object decodedKey = tableMapping.decodeKeyValue(rawKey);
                    int keyIndex = outputRowMeta.indexOfValue(currentCol.getAlias());
                    outputRowData[keyIndex] = decodedKey;
                    continue;
                }
                String colFamilyName = currentCol.getColumnFamily();
                String qualifier = currentCol.getColumnName();
                boolean binaryColName = false;
                if (qualifier.startsWith("@@@binary@@@")) {
                    qualifier = qualifier.replace("@@@binary@@@", "");
                    binaryColName = true;
                }
                byte[] kv = null;
                try {
                    kv = result.getValue(colFamilyName, qualifier, binaryColName);
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
                int outputIndex = outputRowMeta.indexOfValue(currentCol.getAlias());
                if (outputIndex < 0) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.ColumnNotDefinedInOutput", (String[])new String[]{currentCol.getAlias()}));
                }
                outputRowData[outputIndex] = decodedVal = currentCol.decodeColumnValue(kv == null ? null : kv);
            }
        } else {
            byte[] rawKey = null;
            try {
                rawKey = result.getRow();
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            Object decodedKey = tableMapping.decodeKeyValue(rawKey);
            int keyIndex = outputRowMeta.indexOfValue(tableMapping.getKeyName());
            outputRowData[keyIndex] = decodedKey;
            Set<String> aliasSet = columnsMappedByAlias.keySet();
            for (String name : aliasSet) {
                Object decodedVal;
                HBaseValueMetaInterface currentCol = columnsMappedByAlias.get(name);
                String colFamilyName = currentCol.getColumnFamily();
                String qualifier = currentCol.getColumnName();
                if (currentCol.isKey()) continue;
                boolean binaryColName = false;
                if (qualifier.startsWith("@@@binary@@@")) {
                    qualifier = qualifier.replace("@@@binary@@@", "");
                    binaryColName = true;
                }
                byte[] kv = null;
                try {
                    kv = result.getValue(colFamilyName, qualifier, binaryColName);
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
                int outputIndex = outputRowMeta.indexOfValue(name);
                if (outputIndex < 0) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.ColumnNotDefinedInOutput", (String[])new String[]{name}));
                }
                outputRowData[outputIndex] = decodedVal = currentCol.decodeColumnValue(kv == null ? null : kv);
            }
        }
        return outputRowData;
    }
}

