/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.mapping;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.big.data.kettle.plugins.hbase.HBaseConnectionException;
import org.pentaho.big.data.kettle.plugins.hbase.MappingDefinition;
import org.pentaho.big.data.kettle.plugins.hbase.input.HBaseInput;
import org.pentaho.big.data.kettle.plugins.hbase.input.Messages;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.ConfigurationProducer;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingAdmin;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hadoop.shim.api.cluster.ClusterInitializationException;
import org.pentaho.hadoop.shim.api.hbase.ByteConversionUtil;
import org.pentaho.hadoop.shim.api.hbase.HBaseConnection;
import org.pentaho.hadoop.shim.api.hbase.HBaseService;
import org.pentaho.hadoop.shim.api.hbase.mapping.Mapping;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterfaceFactory;

public class MappingUtils {
    public static final int TUPLE_COLUMNS_COUNT = 5;
    public static final int UNDEFINED_VALUE = -1;
    private static final Set<String> TUPLE_COLUMNS = new HashSet<String>();
    public static final String TUPLE_MAPPING_VISIBILITY = "Visibility";

    public static MappingAdmin getMappingAdmin(ConfigurationProducer cProducer) throws HBaseConnectionException {
        HBaseConnection hbConnection = null;
        try {
            hbConnection = cProducer.getHBaseConnection();
            hbConnection.checkHBaseAvailable();
            return new MappingAdmin(hbConnection);
        }
        catch (IOException | ClusterInitializationException e) {
            throw new HBaseConnectionException(Messages.getString("MappingDialog.Error.Message.UnableToConnect"), e);
        }
    }

    public static MappingAdmin getMappingAdmin(HBaseService hBaseService, VariableSpace variableSpace, String siteConfig, String defaultConfig) throws IOException {
        HBaseConnection hBaseConnection = hBaseService.getHBaseConnection(variableSpace, siteConfig, defaultConfig, null);
        return new MappingAdmin(hBaseConnection);
    }

    public static Mapping getMapping(MappingDefinition mappingDefinition, HBaseService hBaseService) throws KettleException {
        String tableName = mappingDefinition.getTableName();
        if (Const.isEmpty((String)tableName) || Const.isEmpty((String)mappingDefinition.getMappingName())) {
            throw new KettleException(Messages.getString("MappingDialog.Error.Message.MissingTableMappingName"));
        }
        if (mappingDefinition.getMappingColumns() == null || mappingDefinition.getMappingColumns().isEmpty()) {
            throw new KettleException(Messages.getString("MappingDialog.Error.Message.NoFieldsDefined"));
        }
        Mapping theMapping = hBaseService.getMappingFactory().createMapping(tableName, mappingDefinition.getMappingName());
        boolean isTupleMapping = MappingUtils.isTupleMapping(mappingDefinition);
        if (isTupleMapping) {
            theMapping.setTupleMapping(true);
        }
        List<MappingDefinition.MappingColumn> mappingColumns = mappingDefinition.getMappingColumns();
        int columnNumber = 0;
        boolean keyDefined = false;
        for (MappingDefinition.MappingColumn column : mappingColumns) {
            HBaseValueMetaInterface valueMeta;
            ++columnNumber;
            String alias = column.getAlias();
            boolean isKey = column.isKey();
            if (isKey) {
                if (keyDefined) {
                    throw new KettleException(Messages.getString("MappingDialog.Error.Message.MoreThanOneKey"));
                }
                keyDefined = true;
            }
            String family = null;
            if (!Const.isEmpty((String)column.getColumnFamily())) {
                family = column.getColumnFamily();
            } else if (!isKey && !isTupleMapping) {
                throw new KettleException(Messages.getString("MappingDialog.Error.Message.FamilyIssue") + ": " + columnNumber);
            }
            String colName = null;
            if (!Const.isEmpty((String)column.getColumnName())) {
                colName = column.getColumnName();
            } else if (!isKey && !isTupleMapping) {
                throw new KettleException(Messages.getString("MappingDialog.Error.Message.ColumnIssue") + ": " + columnNumber);
            }
            String type = null;
            if (Const.isEmpty((String)column.getType())) {
                throw new KettleException(Messages.getString("MappingDialog.Error.Message.TypeIssue") + ": " + columnNumber);
            }
            type = column.getType();
            HBaseValueMetaInterfaceFactory valueMetaInterfaceFactory = hBaseService.getHBaseValueMetaInterfaceFactory();
            if (isKey) {
                if (Const.isEmpty((String)alias)) {
                    throw new KettleException(Messages.getString("MappingDialog.Error.Message.NoAliasForKey"));
                }
                if (isTupleMapping) {
                    theMapping.setKeyName(alias);
                    theMapping.setTupleFamilies(family);
                } else {
                    theMapping.setKeyName(alias);
                }
                valueMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(null, null, alias, 0, -1, -1);
                valueMeta.setKey(true);
                try {
                    theMapping.setKeyTypeAsString(type);
                    valueMeta.setType(HBaseInput.getKettleTypeByKeyType(theMapping.getKeyType()));
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                valueMeta = MappingUtils.buildNonKeyValueMeta(alias, family, colName, type, column.getIndexedValues(), hBaseService);
                theMapping.addMappedColumn(valueMeta, isTupleMapping);
            }
            catch (Exception ex) {
                String message = Messages.getString("MappingDialog.Error.Message1.DuplicateColumn") + family + "," + colName + Messages.getString("MappingDialog.Error.Message2.DuplicateColumn");
                throw new KettleException(message);
            }
        }
        if (!keyDefined) {
            throw new KettleException(Messages.getString("MappingDialog.Error.Message.NoKeyDefined"));
        }
        return theMapping;
    }

    public static HBaseValueMetaInterface buildNonKeyValueMeta(String alias, String family, String columnName, String type, String indexedVals, HBaseService hBaseService) throws KettleException {
        HBaseValueMetaInterfaceFactory valueMetaInterfaceFactory = hBaseService.getHBaseValueMetaInterfaceFactory();
        HBaseValueMetaInterface valueMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family, columnName, alias, 0, -1, -1);
        try {
            valueMeta.setHBaseTypeFromString(type);
            if (valueMeta.isString() && !Const.isEmpty((String)indexedVals)) {
                ByteConversionUtil byteConversionUtil = hBaseService.getByteConversionUtil();
                Object[] vals = byteConversionUtil.stringIndexListToObjects(indexedVals);
                valueMeta.setIndex(vals);
                valueMeta.setStorageType(2);
            }
            return valueMeta;
        }
        catch (IllegalArgumentException e) {
            throw new KettleException((Throwable)e);
        }
    }

    public static boolean isTupleMapping(MappingDefinition mappingDefinition) {
        List<MappingDefinition.MappingColumn> mappingColumns = mappingDefinition.getMappingColumns();
        int mappingSize = mappingColumns.size();
        if (mappingSize != 5 && mappingSize != 6) {
            return false;
        }
        int tupleIdCount = 0;
        for (MappingDefinition.MappingColumn column : mappingColumns) {
            if (!MappingUtils.isTupleMappingColumn(column.getAlias())) continue;
            ++tupleIdCount;
        }
        return tupleIdCount == 5 || tupleIdCount == 6;
    }

    public static boolean isTupleMappingColumn(String columnName) {
        return TUPLE_COLUMNS.contains(columnName) || columnName.equals(TUPLE_MAPPING_VISIBILITY);
    }

    static {
        TUPLE_COLUMNS.add(Mapping.TupleMapping.KEY.toString());
        TUPLE_COLUMNS.add(Mapping.TupleMapping.FAMILY.toString());
        TUPLE_COLUMNS.add(Mapping.TupleMapping.COLUMN.toString());
        TUPLE_COLUMNS.add(Mapping.TupleMapping.VALUE.toString());
        TUPLE_COLUMNS.add(Mapping.TupleMapping.TIMESTAMP.toString());
    }
}

