/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.json.simple.JSONObject;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.HadoopClusterManager;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.model.ThinNameClusterModel;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;
import org.pentaho.runtime.test.RuntimeTester;

public class HadoopClusterEndpoints {
    private final Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private final NamedClusterService namedClusterService;
    private final MetastoreLocator metastoreLocator;
    private final RuntimeTester runtimeTester;
    private final String internalShim;
    private final boolean secureEnabled;

    public HadoopClusterEndpoints(MetastoreLocator metastoreLocator, NamedClusterService namedClusterService, RuntimeTester runtimeTester, String internalShim, boolean secureEnabled) {
        this.namedClusterService = namedClusterService;
        this.metastoreLocator = metastoreLocator;
        this.runtimeTester = runtimeTester;
        this.internalShim = internalShim;
        this.secureEnabled = secureEnabled;
    }

    private HadoopClusterManager getClusterManager() {
        return new HadoopClusterManager(this.spoonSupplier.get(), this.namedClusterService, this.metastoreLocator.getMetastore(), this.internalShim);
    }

    private List<FileItem> parseRequest(HttpServletRequest request, FILE_TYPE fileType) {
        ArrayList<Object> files = new ArrayList<FileItem>();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)factory);
                List fileItems = fileUpload.parseRequest(request);
                for (FileItem fileItem : fileItems) {
                    this.validateUpload(fileItem, fileType, files);
                }
            }
            catch (FileUploadException e) {
                files = new ArrayList();
            }
        }
        return files;
    }

    private void validateUpload(FileItem fileItem, FILE_TYPE fileType, List<FileItem> files) {
        if (fileType.equals((Object)FILE_TYPE.CONFIGURATION) && this.getClusterManager().isValidConfigurationFile(fileItem) || fileType.equals((Object)FILE_TYPE.DRIVER) && fileItem.getFieldName().endsWith(FILE_TYPE.DRIVER.getValue())) {
            files.add(fileItem);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/importNamedCluster")
    @Produces(value={"application/json"})
    public Response importNamedCluster(@Context HttpServletRequest request) {
        List<FileItem> siteFilesSource = this.parseRequest(request, FILE_TYPE.CONFIGURATION);
        ThinNameClusterModel model = ThinNameClusterModel.unmarshall(siteFilesSource);
        JSONObject response = this.getClusterManager().importNamedCluster(model, siteFilesSource);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/createNamedCluster")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response createNamedCluster(@Context HttpServletRequest request) {
        List<FileItem> siteFilesSource = this.parseRequest(request, FILE_TYPE.CONFIGURATION);
        ThinNameClusterModel model = ThinNameClusterModel.unmarshall(siteFilesSource);
        JSONObject response = this.getClusterManager().createNamedCluster(model, siteFilesSource);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/editNamedCluster")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response editNamedCluster(@Context HttpServletRequest request) {
        List<FileItem> siteFilesSource = this.parseRequest(request, FILE_TYPE.CONFIGURATION);
        ThinNameClusterModel model = ThinNameClusterModel.unmarshall(siteFilesSource);
        JSONObject response = this.getClusterManager().editNamedCluster(model, true, siteFilesSource);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/duplicateNamedCluster")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response duplicateNamedCluster(@Context HttpServletRequest request) {
        List<FileItem> siteFilesSource = this.parseRequest(request, FILE_TYPE.CONFIGURATION);
        ThinNameClusterModel model = ThinNameClusterModel.unmarshall(siteFilesSource);
        JSONObject response = this.getClusterManager().editNamedCluster(model, false, siteFilesSource);
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/getNamedCluster")
    @Produces(value={"application/json"})
    public Response getNamedCluster(@QueryParam(value="namedCluster") String namedCluster) {
        return Response.ok((Object)this.getClusterManager().getNamedCluster(namedCluster)).build();
    }

    @GET
    @Path(value="/getShimIdentifiers")
    @Produces(value={"application/json"})
    public Response getShimIdentifiers() {
        return Response.ok(this.getClusterManager().getShimIdentifiers()).build();
    }

    @GET
    @Path(value="/runTests")
    @Produces(value={"application/json"})
    public Response runTests(@QueryParam(value="namedCluster") String namedCluster) {
        return Response.ok((Object)this.getClusterManager().runTests(this.runtimeTester, namedCluster)).build();
    }

    @POST
    @Path(value="/installDriver")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response installDriver(@Context HttpServletRequest request) {
        List<FileItem> driver = this.parseRequest(request, FILE_TYPE.DRIVER);
        return Response.ok((Object)this.getClusterManager().installDriver(driver)).build();
    }

    @GET
    @Path(value="/getSecure")
    @Produces(value={"application/json"})
    public Response getSecure() {
        return Response.ok((Object)("{\"secureEnabled\":\"" + Boolean.toString(this.secureEnabled) + "\"}")).build();
    }

    private static enum FILE_TYPE {
        CONFIGURATION("configuration"),
        DRIVER(".kar");

        private String val;

        private FILE_TYPE(String val) {
            this.val = val;
        }

        public String getValue() {
            return this.val;
        }
    }
}

