/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.json.simple.JSONObject;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.dialog.HadoopClusterDialog;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.Category;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.Test;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.TestCategory;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.model.ThinNameClusterModel;
import org.pentaho.big.data.plugins.common.ui.HadoopClusterDelegateImpl;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.hadoop.shim.api.ShimIdentifierInterface;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.runtime.test.RuntimeTest;
import org.pentaho.runtime.test.RuntimeTestProgressCallback;
import org.pentaho.runtime.test.RuntimeTestStatus;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.module.RuntimeTestModuleResults;
import org.pentaho.runtime.test.result.RuntimeTestResult;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HadoopClusterManager
implements RuntimeTestProgressCallback {
    private static final Class<?> PKG = HadoopClusterDialog.class;
    public static final String STRING_NAMED_CLUSTERS = BaseMessages.getString(PKG, (String)"HadoopClusterTree.Title", (String[])new String[0]);
    private final String fileSeparator = System.getProperty("file.separator");
    private static final String PASS = "Pass";
    private static final String WARNING = "Warning";
    private static final String FAIL = "Fail";
    private static final String NAMED_CLUSTER = "namedCluster";
    private static final String INSTALLED = "installed";
    private static final String CONFIG_PROPERTIES = "config.properties";
    private static final String KEYTAB_AUTH_FILE = "keytabAuthFile";
    private static final String KEYTAB_IMPL_FILE = "keytabImpFile";
    private final String internalShim;
    private static final String KERBEROS_AUTHENTICATION_USERNAME = "pentaho.authentication.default.kerberos.principal";
    private static final String KERBEROS_AUTHENTICATION_PASS = "pentaho.authentication.default.kerberos.password";
    private static final String KERBEROS_IMPERSONATION_USERNAME = "pentaho.authentication.default.mapping.server.credentials.kerberos.principal";
    private static final String KERBEROS_IMPERSONATION_PASS = "pentaho.authentication.default.mapping.server.credentials.kerberos.password";
    private static final String IMPERSONATION = "pentaho.authentication.default.mapping.impersonation.type";
    private static final String KEYTAB_AUTHENTICATION_LOCATION = "pentaho.authentication.default.kerberos.keytabLocation";
    private static final String KEYTAB_IMPERSONATION_LOCATION = "pentaho.authentication.default.mapping.server.credentials.kerberos.keytabLocation";
    @VisibleForTesting
    Supplier<List<ShimIdentifierInterface>> shimIdentifiersSupplier = () -> PentahoSystem.getAll(ShimIdentifierInterface.class);
    private final Spoon spoon;
    private final NamedClusterService namedClusterService;
    private final IMetaStore metaStore;
    private final VariableSpace variableSpace;
    private RuntimeTestStatus runtimeTestStatus = null;
    private static final Logger logChannel = LoggerFactory.getLogger(HadoopClusterManager.class);

    public HadoopClusterManager(Spoon spoon, NamedClusterService namedClusterService, IMetaStore metaStore, String internalShim) {
        this.spoon = spoon;
        this.namedClusterService = namedClusterService;
        this.metaStore = metaStore != null ? metaStore : spoon.getMetaStore();
        this.variableSpace = spoon == null ? new Variables() : (AbstractMeta)spoon.getActiveMeta();
        this.internalShim = internalShim;
    }

    public JSONObject importNamedCluster(ThinNameClusterModel model, List<FileItem> siteFilesSource) {
        JSONObject response = new JSONObject();
        response.put((Object)NAMED_CLUSTER, (Object)"");
        try {
            NamedCluster nc = this.namedClusterService.getClusterTemplate();
            nc.setHdfsHost("");
            nc.setHdfsPort("");
            nc.setJobTrackerHost("");
            nc.setJobTrackerPort("");
            nc.setZooKeeperHost("");
            nc.setZooKeeperPort("");
            nc.setOozieUrl("");
            nc.setName(model.getName());
            nc.setHdfsUsername(model.getHdfsUsername());
            nc.setHdfsPassword(model.getHdfsPassword());
            if (this.variableSpace != null) {
                nc.shareVariablesWith(this.variableSpace);
            } else {
                nc.initializeVariablesFrom(null);
            }
            boolean isConfigurationSet = this.configureNamedCluster(siteFilesSource, nc, model.getShimVendor(), model.getShimVersion());
            if (isConfigurationSet) {
                this.deleteNamedClusterSchemaOnly(model);
                this.setupKnoxSecurity(nc, model);
                this.namedClusterService.create(nc, this.metaStore);
                this.deleteConfigFolder(nc.getName());
                this.installSiteFiles(siteFilesSource, nc);
                this.createConfigProperties(nc);
                this.setupKerberosSecurity(model, siteFilesSource, "", "");
                response.put((Object)NAMED_CLUSTER, (Object)nc.getName());
            }
        }
        catch (Exception e) {
            logChannel.error(e.getMessage());
        }
        return response;
    }

    private void deleteNamedClusterSchemaOnly(ThinNameClusterModel model) throws MetaStoreException {
        List existingNcNames = this.namedClusterService.listNames(this.metaStore);
        for (String existingNcName : existingNcNames) {
            if (!existingNcName.equalsIgnoreCase(model.getName())) continue;
            this.namedClusterService.delete(existingNcName, this.metaStore);
        }
    }

    private NamedCluster createXMLSchema(ThinNameClusterModel model) throws MetaStoreException {
        NamedCluster nc = this.namedClusterService.getClusterTemplate();
        nc.setName(model.getName());
        nc.setHdfsHost(model.getHdfsHost());
        nc.setHdfsPort(model.getHdfsPort());
        nc.setHdfsUsername(model.getHdfsUsername());
        nc.setHdfsPassword(model.getHdfsPassword());
        nc.setJobTrackerHost(model.getJobTrackerHost());
        nc.setJobTrackerPort(model.getJobTrackerPort());
        nc.setZooKeeperHost(model.getZooKeeperHost());
        nc.setZooKeeperPort(model.getZooKeeperPort());
        nc.setOozieUrl(model.getOozieUrl());
        nc.setKafkaBootstrapServers(model.getKafkaBootstrapServers());
        this.resolveShimIdentifier(nc, model.getShimVendor(), model.getShimVersion());
        this.setupKnoxSecurity(nc, model);
        if (this.variableSpace != null) {
            nc.shareVariablesWith(this.variableSpace);
        } else {
            nc.initializeVariablesFrom(null);
        }
        this.deleteNamedClusterSchemaOnly(model);
        this.namedClusterService.create(nc, this.metaStore);
        return nc;
    }

    private void deleteConfigFolder(String configFolderName) throws IOException {
        File configFolder = new File(this.getNamedClusterConfigsRootDir());
        File[] files = configFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || !file.getName().equalsIgnoreCase(configFolderName)) continue;
                FileUtils.deleteDirectory((File)file);
                break;
            }
        }
    }

    public JSONObject createNamedCluster(ThinNameClusterModel model, List<FileItem> siteFilesSource) {
        JSONObject response = new JSONObject();
        response.put((Object)NAMED_CLUSTER, (Object)"");
        try {
            NamedCluster nc = this.createXMLSchema(model);
            this.deleteConfigFolder(nc.getName());
            this.installSiteFiles(siteFilesSource, nc);
            this.createConfigProperties(nc);
            this.setupKerberosSecurity(model, siteFilesSource, "", "");
            response.put((Object)NAMED_CLUSTER, (Object)nc.getName());
        }
        catch (Exception e) {
            logChannel.error(e.getMessage());
        }
        return response;
    }

    public JSONObject editNamedCluster(ThinNameClusterModel model, boolean isEditMode, List<FileItem> siteFilesSource) {
        JSONObject response = new JSONObject();
        response.put((Object)NAMED_CLUSTER, (Object)"");
        try {
            String shimId = this.namedClusterService.getNamedClusterByName(model.getOldName(), this.metaStore).getShimIdentifier();
            NamedCluster nc = this.createXMLSchema(model);
            File oldConfigFolder = new File(this.getNamedClusterConfigsRootDir() + this.fileSeparator + model.getOldName());
            File newConfigFolder = new File(this.getNamedClusterConfigsRootDir() + this.fileSeparator + nc.getName());
            if (!oldConfigFolder.getName().equalsIgnoreCase(newConfigFolder.getName())) {
                this.deleteConfigFolder(nc.getName());
                FileUtils.copyDirectory((File)oldConfigFolder, (File)newConfigFolder);
            } else {
                boolean success = oldConfigFolder.renameTo(newConfigFolder);
                if (!success) {
                    logChannel.error("Renaming Named Cluster configuration folder failed.");
                }
            }
            this.installSiteFiles(siteFilesSource, nc);
            String keytabAuthenticationLocation = "";
            String keytabImpersonationLocation = "";
            String kerberosSubType = model.getKerberosSubType();
            if (!kerberosSubType.equals(KERBEROS_SUBTYPE.PASSWORD.getValue())) {
                String configFile = this.getNamedClusterConfigsRootDir() + this.fileSeparator + nc.getName() + this.fileSeparator + CONFIG_PROPERTIES;
                PropertiesConfiguration config = new PropertiesConfiguration(new File(configFile));
                keytabAuthenticationLocation = (String)config.getProperty(KEYTAB_AUTHENTICATION_LOCATION);
                keytabImpersonationLocation = (String)config.getProperty(KEYTAB_IMPERSONATION_LOCATION);
            }
            if (nc.getShimIdentifier() != null && !nc.getShimIdentifier().equals(shimId)) {
                this.createConfigProperties(nc);
            }
            this.setupKerberosSecurity(model, siteFilesSource, keytabAuthenticationLocation, keytabImpersonationLocation);
            if (isEditMode && !oldConfigFolder.getName().equalsIgnoreCase(newConfigFolder.getName())) {
                this.deleteNamedCluster(this.metaStore, model.getOldName(), false);
            }
            response.put((Object)NAMED_CLUSTER, (Object)nc.getName());
        }
        catch (Exception e) {
            logChannel.error(e.getMessage());
        }
        return response;
    }

    public ThinNameClusterModel getNamedCluster(String namedCluster) {
        ThinNameClusterModel model = null;
        try {
            List namedClusters = this.namedClusterService.list(this.metaStore);
            for (NamedCluster nc : namedClusters) {
                if (!nc.getName().equalsIgnoreCase(namedCluster)) continue;
                model = new ThinNameClusterModel();
                model.setName(nc.getName());
                model.setHdfsHost(nc.getHdfsHost());
                model.setHdfsUsername(nc.getHdfsUsername());
                model.setHdfsPassword(nc.getHdfsPassword());
                model.setHdfsPort(nc.getHdfsPort());
                model.setJobTrackerHost(nc.getJobTrackerHost());
                model.setJobTrackerPort(nc.getJobTrackerPort());
                model.setKafkaBootstrapServers(nc.getKafkaBootstrapServers());
                model.setOozieUrl(nc.getOozieUrl());
                model.setZooKeeperPort(nc.getZooKeeperPort());
                model.setZooKeeperHost(nc.getZooKeeperHost());
                this.resolveShimVendorAndVersion(model, nc.getShimIdentifier());
                model.setGatewayPassword(nc.getGatewayPassword());
                model.setGatewayUrl(nc.getGatewayUrl());
                model.setGatewayUsername(nc.getGatewayUsername());
                model.setSecurityType(SECURITY_TYPE.NONE.getValue());
                if (nc.isUseGateway()) {
                    model.setSecurityType(SECURITY_TYPE.KNOX.getValue());
                } else {
                    this.resolveKerberosSecurity(model, nc);
                }
                break;
            }
        }
        catch (MetaStoreException e) {
            logChannel.error(e.getMessage());
        }
        return model;
    }

    private boolean configureNamedCluster(List<FileItem> siteFilesSource, NamedCluster nc, String shimVendor, String shimVersion) {
        String oozieAddress;
        String jobTrackerAddress;
        this.resolveShimIdentifier(nc, shimVendor, shimVersion);
        String oozieBaseUrl = "oozie.base.url";
        HashMap<String, String> properties = new HashMap<String, String>();
        this.extractProperties(siteFilesSource, "core-site.xml", properties, new String[]{"fs.defaultFS"});
        this.extractProperties(siteFilesSource, "yarn-site.xml", properties, new String[]{"yarn.resourcemanager.address"});
        this.extractProperties(siteFilesSource, "hive-site.xml", properties, new String[]{"hive.zookeeper.quorum", "hive.zookeeper.client.port"});
        this.extractProperties(siteFilesSource, "oozie-site.xml", properties, new String[]{oozieBaseUrl});
        if (properties.get(oozieBaseUrl) == null) {
            this.extractProperties(siteFilesSource, "oozie-default.xml", properties, new String[]{oozieBaseUrl});
        }
        boolean isConfigurationSet = false;
        String hdfsAddress = (String)properties.get("fs.defaultFS");
        if (hdfsAddress != null) {
            URI hdfsURL = URI.create(hdfsAddress);
            nc.setHdfsHost(hdfsURL.getHost());
            nc.setHdfsPort(hdfsURL.getPort() != -1 ? hdfsURL.getPort() + "" : "");
            isConfigurationSet = true;
        }
        if ((jobTrackerAddress = (String)properties.get("yarn.resourcemanager.address")) != null) {
            if (!jobTrackerAddress.startsWith("http://")) {
                jobTrackerAddress = "http://" + jobTrackerAddress;
            }
            URI jobTrackerURL = URI.create(jobTrackerAddress);
            nc.setJobTrackerHost(jobTrackerURL.getHost());
            nc.setJobTrackerPort(jobTrackerURL.getPort() != -1 ? jobTrackerURL.getPort() + "" : "");
            isConfigurationSet = true;
        }
        String zooKeeperAddress = (String)properties.get("hive.zookeeper.quorum");
        String zooKeeperPort = (String)properties.get("hive.zookeeper.client.port");
        if (zooKeeperAddress != null && zooKeeperPort != null) {
            nc.setZooKeeperHost(zooKeeperAddress);
            nc.setZooKeeperPort(zooKeeperPort);
            isConfigurationSet = true;
        }
        if ((oozieAddress = (String)properties.get(oozieBaseUrl)) != null) {
            nc.setOozieUrl(oozieAddress);
            isConfigurationSet = true;
        }
        return isConfigurationSet;
    }

    private void resolveShimIdentifier(NamedCluster nc, String shimVendor, String shimVersion) {
        List<ShimIdentifierInterface> shims = this.getShimIdentifiers();
        for (ShimIdentifierInterface shim : shims) {
            if (!shim.getVendor().equals(shimVendor) || !shim.getVersion().equals(shimVersion)) continue;
            nc.setShimIdentifier(shim.getId());
        }
    }

    private void resolveShimVendorAndVersion(ThinNameClusterModel model, String shimIdentifier) {
        List<ShimIdentifierInterface> shims = this.getShimIdentifiers();
        for (ShimIdentifierInterface shim : shims) {
            if (!shim.getId().equals(shimIdentifier)) continue;
            model.setShimVersion(shim.getVersion());
            model.setShimVendor(shim.getVendor());
        }
    }

    private void extractProperties(List<FileItem> siteFilesSource, String fileName, Map<String, String> properties, String[] keys) {
        Document document;
        FileItem siteFile = (FileItem)CollectionUtils.find(siteFilesSource, object -> {
            FileItem fileItem = (FileItem)object;
            return fileItem.getName().endsWith(fileName);
        });
        if (siteFile != null && (document = this.parseSiteFileDocument(siteFile)) != null) {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            for (String key : keys) {
                try {
                    XPathExpression expr = xpath.compile("/configuration/property[name[starts-with(.,'" + key + "')]]/value/text()");
                    NodeList nodes = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
                    if (nodes.getLength() <= 0) continue;
                    properties.put(key, nodes.item(0).getNodeValue());
                }
                catch (XPathExpressionException e) {
                    logChannel.warn(e.getMessage());
                }
            }
        }
    }

    public JSONObject installDriver(List<FileItem> driver) {
        boolean success = true;
        try {
            String destination = Const.getShimDriverDeploymentLocation();
            FileItem driverFile = driver.get(0);
            FileUtils.copyInputStreamToFile((InputStream)driverFile.getInputStream(), (File)new File(destination + this.fileSeparator + driverFile.getFieldName()));
        }
        catch (IOException e) {
            success = false;
            logChannel.error(e.getMessage());
        }
        JSONObject response = new JSONObject();
        response.put((Object)INSTALLED, (Object)success);
        return response;
    }

    private void installSiteFiles(List<FileItem> siteFilesSource, NamedCluster nc) throws IOException {
        for (FileItem sitefile : siteFilesSource) {
            if (!this.isValidConfigurationFile(sitefile)) continue;
            String name = sitefile.getFieldName();
            if (name.equals(KEYTAB_AUTH_FILE) || name.equals(KEYTAB_IMPL_FILE)) {
                name = this.extractFileNameFromFullPath(sitefile.getName());
            }
            File destination = new File(this.getNamedClusterConfigsRootDir() + this.fileSeparator + nc.getName() + this.fileSeparator + name);
            FileUtils.copyInputStreamToFile((InputStream)sitefile.getInputStream(), (File)destination);
        }
    }

    public boolean isValidConfigurationFile(FileItem fileItem) {
        return fileItem.getFieldName() != null && (fileItem.getFieldName().endsWith("-site.xml") || fileItem.getFieldName().endsWith("-default.xml") || fileItem.getFieldName().equals(CONFIG_PROPERTIES) || fileItem.getFieldName().equals(KEYTAB_AUTH_FILE) || fileItem.getFieldName().equals(KEYTAB_IMPL_FILE) || fileItem.getFieldName().equals("data"));
    }

    private Document parseSiteFileDocument(FileItem file) {
        Document document = null;
        try {
            document = XMLHandler.loadXMLFile((InputStream)file.getInputStream());
        }
        catch (KettleXMLException e) {
            logChannel.warn(String.format("Site file %s is not a well formed XML document", file.getName()));
        }
        catch (IOException e) {
            logChannel.error(e.getMessage());
        }
        return document;
    }

    private void createConfigProperties(NamedCluster namedCluster) throws IOException {
        Path clusterConfigDirPath = Paths.get(this.getNamedClusterConfigsRootDir() + this.fileSeparator + namedCluster.getName(), new String[0]);
        Path configPropertiesPath = Paths.get(this.getNamedClusterConfigsRootDir() + this.fileSeparator + namedCluster.getName() + this.fileSeparator + CONFIG_PROPERTIES, new String[0]);
        Files.createDirectories(clusterConfigDirPath, new FileAttribute[0]);
        String sampleConfigProperties = namedCluster.getShimIdentifier() + "sampleconfig.properties";
        InputStream inputStream = HadoopClusterDelegateImpl.class.getClassLoader().getResourceAsStream(sampleConfigProperties);
        if (inputStream != null) {
            Files.copy(inputStream, configPropertiesPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void setupKerberosSecurity(ThinNameClusterModel model, List<FileItem> siteFilesSource, String keytabAuthenticationLocation, String keytabImpersonationLocation) {
        Path configPropertiesPath = Paths.get(this.getNamedClusterConfigsRootDir() + this.fileSeparator + model.getName() + this.fileSeparator + CONFIG_PROPERTIES, new String[0]);
        String securityType = model.getSecurityType();
        if (!StringUtil.isEmpty((String)securityType)) {
            this.resetKerberosSecurity(configPropertiesPath);
            if (securityType.equals(SECURITY_TYPE.KERBEROS.getValue())) {
                String kerberosSubType = model.getKerberosSubType();
                if (kerberosSubType.equals(KERBEROS_SUBTYPE.PASSWORD.getValue())) {
                    this.setupKerberosPasswordSecurity(configPropertiesPath, model);
                }
                if (kerberosSubType.equals(KERBEROS_SUBTYPE.KEYTAB.getValue())) {
                    this.setupKeytabSecurity(model, configPropertiesPath, siteFilesSource, keytabAuthenticationLocation, keytabImpersonationLocation);
                }
            }
        }
    }

    private void resetKerberosSecurity(Path configPropertiesPath) {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(configPropertiesPath.toFile());
            config.setProperty(KEYTAB_AUTHENTICATION_LOCATION, (Object)"");
            config.setProperty(KEYTAB_IMPERSONATION_LOCATION, (Object)"");
            config.setProperty(IMPERSONATION, (Object)IMPERSONATION_TYPE.DISABLED.getValue());
            config.setProperty(KERBEROS_AUTHENTICATION_USERNAME, (Object)"");
            config.setProperty(KERBEROS_AUTHENTICATION_PASS, (Object)"");
            config.setProperty(KERBEROS_IMPERSONATION_USERNAME, (Object)"");
            config.setProperty(KERBEROS_IMPERSONATION_PASS, (Object)"");
            config.save();
        }
        catch (ConfigurationException e) {
            logChannel.warn(e.getMessage());
        }
    }

    private void resolveKerberosSecurity(ThinNameClusterModel model, NamedCluster nc) {
        try {
            String configFile = this.getNamedClusterConfigsRootDir() + this.fileSeparator + nc.getName() + this.fileSeparator + CONFIG_PROPERTIES;
            PropertiesConfiguration config = new PropertiesConfiguration(new File(configFile));
            model.setKerberosAuthenticationUsername((String)config.getProperty(KERBEROS_AUTHENTICATION_USERNAME));
            model.setKerberosAuthenticationPassword((String)config.getProperty(KERBEROS_AUTHENTICATION_PASS));
            model.setKerberosImpersonationUsername((String)config.getProperty(KERBEROS_IMPERSONATION_USERNAME));
            model.setKerberosImpersonationPassword((String)config.getProperty(KERBEROS_IMPERSONATION_PASS));
            String keytabAuthenticationLocation = (String)config.getProperty(KEYTAB_AUTHENTICATION_LOCATION);
            String keytabImpersonationLocation = (String)config.getProperty(KEYTAB_IMPERSONATION_LOCATION);
            if (!StringUtil.isEmpty((String)keytabAuthenticationLocation)) {
                String keytabAuthFile = keytabAuthenticationLocation.substring(keytabAuthenticationLocation.lastIndexOf(this.fileSeparator) + 1);
                model.setKeytabAuthFile(keytabAuthFile);
            }
            if (!StringUtil.isEmpty((String)keytabImpersonationLocation)) {
                String keytabImpFile = keytabImpersonationLocation.substring(keytabImpersonationLocation.lastIndexOf(this.fileSeparator) + 1);
                model.setKeytabImpFile(keytabImpFile);
            }
            if (StringUtil.isEmpty((String)keytabAuthenticationLocation) && StringUtil.isEmpty((String)keytabImpersonationLocation) && StringUtil.isEmpty((String)model.getKerberosAuthenticationPassword()) && StringUtil.isEmpty((String)model.getKerberosImpersonationPassword())) {
                model.setSecurityType(SECURITY_TYPE.NONE.getValue());
            } else {
                model.setSecurityType(SECURITY_TYPE.KERBEROS.getValue());
            }
            if (StringUtil.isEmpty((String)keytabAuthenticationLocation) && StringUtil.isEmpty((String)keytabImpersonationLocation)) {
                model.setKerberosSubType(KERBEROS_SUBTYPE.PASSWORD.getValue());
            } else {
                model.setKerberosSubType(KERBEROS_SUBTYPE.KEYTAB.getValue());
            }
        }
        catch (ConfigurationException e) {
            logChannel.error(e.getMessage());
        }
    }

    private void setupKerberosPasswordSecurity(Path configPropertiesPath, ThinNameClusterModel model) {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(configPropertiesPath.toFile());
            config.setProperty(KERBEROS_AUTHENTICATION_USERNAME, (Object)model.getKerberosAuthenticationUsername());
            config.setProperty(KERBEROS_AUTHENTICATION_PASS, (Object)model.getKerberosAuthenticationPassword());
            config.setProperty(KERBEROS_IMPERSONATION_USERNAME, (Object)model.getKerberosImpersonationUsername());
            config.setProperty(KERBEROS_IMPERSONATION_PASS, (Object)model.getKerberosImpersonationPassword());
            if (!StringUtil.isEmpty((String)model.getKerberosImpersonationUsername()) && !StringUtil.isEmpty((String)model.getKerberosImpersonationPassword()) || !StringUtil.isEmpty((String)model.getKerberosAuthenticationUsername()) && !StringUtil.isEmpty((String)model.getKerberosAuthenticationPassword())) {
                config.setProperty(IMPERSONATION, (Object)IMPERSONATION_TYPE.SIMPLE.getValue());
            } else {
                config.setProperty(IMPERSONATION, (Object)IMPERSONATION_TYPE.DISABLED.getValue());
            }
            config.save();
        }
        catch (ConfigurationException e) {
            logChannel.warn(e.getMessage());
        }
    }

    private String extractFileNameFromFullPath(String fileName) {
        int lastIndex = fileName.lastIndexOf(47) != -1 ? fileName.lastIndexOf(47) : fileName.lastIndexOf(92);
        lastIndex = lastIndex == -1 ? 0 : lastIndex + 1;
        fileName = fileName.substring(lastIndex);
        return fileName;
    }

    private void setupKeytabSecurity(ThinNameClusterModel model, Path configPropertiesPath, List<FileItem> siteFilesSource, String keytabAuthenticationLocation, String keytabImpersonationLocation) {
        String name;
        String namedClusterName = model.getName();
        FileItem keytabAuthFile = (FileItem)CollectionUtils.find(siteFilesSource, object -> {
            FileItem fileItem = (FileItem)object;
            return fileItem.getFieldName().equals(KEYTAB_AUTH_FILE);
        });
        FileItem keytabImpFile = (FileItem)CollectionUtils.find(siteFilesSource, object -> {
            FileItem fileItem = (FileItem)object;
            return fileItem.getFieldName().equals(KEYTAB_IMPL_FILE);
        });
        if (keytabAuthFile != null) {
            name = this.extractFileNameFromFullPath(keytabAuthFile.getName());
            keytabAuthenticationLocation = this.getNamedClusterConfigsRootDir() + this.fileSeparator + namedClusterName + this.fileSeparator + name;
        }
        if (keytabImpFile != null) {
            name = this.extractFileNameFromFullPath(keytabImpFile.getName());
            keytabImpersonationLocation = this.getNamedClusterConfigsRootDir() + this.fileSeparator + namedClusterName + this.fileSeparator + name;
        }
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(configPropertiesPath.toFile());
            config.setProperty(KERBEROS_AUTHENTICATION_USERNAME, (Object)model.getKerberosAuthenticationUsername());
            if (!StringUtil.isEmpty((String)keytabAuthenticationLocation)) {
                config.setProperty(KEYTAB_AUTHENTICATION_LOCATION, (Object)keytabAuthenticationLocation);
            }
            config.setProperty(KERBEROS_IMPERSONATION_USERNAME, (Object)model.getKerberosImpersonationUsername());
            if (keytabImpFile == null && StringUtil.isEmpty((String)model.getKeytabImpFile())) {
                config.setProperty(KEYTAB_IMPERSONATION_LOCATION, (Object)"");
            } else if (!StringUtil.isEmpty((String)keytabImpersonationLocation)) {
                config.setProperty(KEYTAB_IMPERSONATION_LOCATION, (Object)keytabImpersonationLocation);
            }
            if (!StringUtil.isEmpty((String)((String)config.getProperty(KEYTAB_AUTHENTICATION_LOCATION))) || !StringUtil.isEmpty((String)((String)config.getProperty(KEYTAB_IMPERSONATION_LOCATION)))) {
                config.setProperty(IMPERSONATION, (Object)IMPERSONATION_TYPE.SIMPLE.getValue());
            } else {
                config.setProperty(IMPERSONATION, (Object)IMPERSONATION_TYPE.DISABLED.getValue());
            }
            config.save();
        }
        catch (ConfigurationException e) {
            logChannel.warn(e.getMessage());
        }
    }

    private void setupKnoxSecurity(NamedCluster nc, ThinNameClusterModel model) {
        if (model.getSecurityType() != null && model.getSecurityType().equals(SECURITY_TYPE.KNOX.getValue())) {
            String userName = model.getGatewayUsername();
            String url = model.getGatewayUrl();
            String password = model.getGatewayPassword();
            nc.setGatewayPassword(password);
            nc.setGatewayUrl(url);
            nc.setGatewayUsername(userName);
            nc.setUseGateway(!StringUtil.isEmpty((String)userName) && !StringUtil.isEmpty((String)url) && !StringUtil.isEmpty((String)password));
        }
    }

    public void deleteNamedCluster(IMetaStore metaStore, String namedCluster, boolean refreshTree) {
        try {
            if (this.namedClusterService.read(namedCluster, metaStore) != null) {
                this.namedClusterService.delete(namedCluster, metaStore);
                this.deleteConfigFolder(namedCluster);
            }
            if (refreshTree) {
                this.refreshTree();
            }
        }
        catch (Exception e) {
            logChannel.warn(e.getMessage());
        }
    }

    List<ShimIdentifierInterface> getShimIdentifiers() {
        return this.shimIdentifiersSupplier.get().stream().filter(s -> !this.internalShim.equals(s.getId())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runTests(RuntimeTester runtimeTester, String namedCluster) {
        NamedCluster nc = this.namedClusterService.getNamedClusterByName(namedCluster, this.metaStore);
        if (nc != null) {
            block7: {
                try {
                    if (runtimeTester == null) break block7;
                    this.runtimeTestStatus = null;
                    runtimeTester.runtimeTest((Object)nc, (RuntimeTestProgressCallback)this);
                    HadoopClusterManager hadoopClusterManager = this;
                    synchronized (hadoopClusterManager) {
                        while (this.runtimeTestStatus == null) {
                            this.wait();
                        }
                    }
                }
                catch (Exception e) {
                    logChannel.warn(e.getLocalizedMessage());
                }
            }
            return this.produceTestCategories(this.runtimeTestStatus, nc);
        }
        return "[]";
    }

    private Object[] produceTestCategories(RuntimeTestStatus runtimeTestStatus, NamedCluster nc) {
        LinkedHashMap<String, TestCategory> categories = new LinkedHashMap<String, TestCategory>();
        categories.put("Hadoop File System", new TestCategory("Hadoop file system"));
        categories.put("Zookeeper", new TestCategory("Zookeeper connection"));
        categories.put("Map Reduce", new TestCategory("Job tracker / resource manager"));
        categories.put("Oozie", new TestCategory("Oozie host connection"));
        categories.put("Kafka", new TestCategory("Kafka connection"));
        if (runtimeTestStatus != null && nc != null) {
            for (RuntimeTestModuleResults moduleResults : runtimeTestStatus.getModuleResults()) {
                for (RuntimeTestResult testResult : moduleResults.getRuntimeTestResults()) {
                    RuntimeTest runtimeTest = testResult.getRuntimeTest();
                    String name = runtimeTest.getName();
                    String status = this.getTestStatus(testResult.getOverallStatusEntry());
                    String module = runtimeTest.getModule();
                    Category category = (Category)categories.get(module);
                    category.setCategoryActive(true);
                    if (module.equals("Hadoop File System")) {
                        Test test = new Test(name);
                        test.setTestStatus(status);
                        test.setTestActive(true);
                        category.addTest(test);
                        this.configureHadoopFileSystemTestCategory(category, !StringUtil.isEmpty((String)nc.getHdfsHost()), status);
                        continue;
                    }
                    if (module.equals("Oozie")) {
                        this.configureTestCategories(category, !StringUtil.isEmpty((String)nc.getOozieUrl()), status);
                        continue;
                    }
                    if (module.equals("Kafka")) {
                        this.configureTestCategories(category, !StringUtil.isEmpty((String)nc.getKafkaBootstrapServers()), status);
                        continue;
                    }
                    if (module.equals("Zookeeper")) {
                        this.configureTestCategories(category, !StringUtil.isEmpty((String)nc.getZooKeeperHost()), status);
                        continue;
                    }
                    if (!module.equals("Map Reduce")) continue;
                    this.configureTestCategories(category, !StringUtil.isEmpty((String)nc.getJobTrackerHost()), status);
                }
            }
        }
        return categories.values().toArray();
    }

    private void configureHadoopFileSystemTestCategory(Category category, boolean isActive, String status) {
        category.setCategoryActive(isActive);
        if (category.isCategoryActive()) {
            String currentStatus = category.getCategoryStatus();
            if (status.equals(FAIL) || status.equals(WARNING) && !currentStatus.equals(FAIL) || status.equals(PASS) && StringUtil.isEmpty((String)currentStatus)) {
                category.setCategoryStatus(status);
            }
        }
    }

    private void configureTestCategories(Category category, boolean isActive, String status) {
        category.setCategoryActive(isActive);
        if (category.isCategoryActive()) {
            category.setCategoryStatus(status);
        }
    }

    private String getTestStatus(RuntimeTestResultEntry summary) {
        String status = "";
        switch (summary.getSeverity()) {
            case INFO: {
                status = PASS;
                break;
            }
            case SKIPPED: {
                status = WARNING;
                break;
            }
            case FATAL: {
                status = FAIL;
                break;
            }
            case ERROR: {
                status = FAIL;
                break;
            }
            case WARNING: {
                status = FAIL;
                break;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgress(RuntimeTestStatus clusterTestStatus) {
        HadoopClusterManager hadoopClusterManager = this;
        synchronized (hadoopClusterManager) {
            if (clusterTestStatus.isDone()) {
                this.runtimeTestStatus = clusterTestStatus;
                this.notifyAll();
            }
        }
    }

    @VisibleForTesting
    void refreshTree() {
        if (this.spoon != null && this.spoon.getShell() != null) {
            this.spoon.getShell().getDisplay().asyncExec(() -> this.spoon.refreshTree(STRING_NAMED_CLUSTERS));
        }
    }

    @VisibleForTesting
    String getNamedClusterConfigsRootDir() {
        return System.getProperty("user.home") + File.separator + ".pentaho" + File.separator + "metastore" + File.separator + "pentaho" + File.separator + "NamedCluster" + File.separator + "Configs";
    }

    private static enum IMPERSONATION_TYPE {
        SIMPLE("simple"),
        DISABLED("disabled");

        private String val;

        private IMPERSONATION_TYPE(String val) {
            this.val = val;
        }

        public String getValue() {
            return this.val;
        }
    }

    private static enum SECURITY_TYPE {
        NONE("None"),
        KERBEROS("Kerberos"),
        KNOX("Knox");

        private String val;

        private SECURITY_TYPE(String val) {
            this.val = val;
        }

        public String getValue() {
            return this.val;
        }
    }

    private static enum KERBEROS_SUBTYPE {
        PASSWORD("Password"),
        KEYTAB("Keytab");

        private String val;

        private KERBEROS_SUBTYPE(String val) {
            this.val = val;
        }

        public String getValue() {
            return this.val;
        }
    }
}

