/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.tree;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;
import org.pentaho.di.ui.util.SwtSvgImageUtil;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class ThinHadoopClusterFolderProvider
extends TreeFolderProvider {
    public static final String STRING_NEW_HADOOP_CLUSTER = BaseMessages.getString(ThinHadoopClusterFolderProvider.class, (String)"HadoopClusterTree.Title", (String[])new String[0]);
    private static Class<?> PKG = Spoon.class;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;

    public void refresh(AbstractMeta meta, TreeNode treeNode, String filter) {
        List namedClusters;
        try {
            namedClusters = NamedClusterManager.getInstance().list((IMetaStore)Spoon.getInstance().metaStore);
        }
        catch (MetaStoreException e) {
            new ErrorDialog(Spoon.getInstance().getShell(), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.NamedCluster", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        for (NamedCluster namedCluster : namedClusters) {
            if (!this.filterMatch(namedCluster.getName(), filter)) continue;
            this.createTreeNode(treeNode, namedCluster.getName(), this.getHadoopClusterImage());
        }
    }

    public String getTitle() {
        return STRING_NEW_HADOOP_CLUSTER;
    }

    private Image getHadoopClusterImage() {
        return SwtSvgImageUtil.getImage((Display)this.spoonSupplier.get().getShell().getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"images/hadoop_clusters.svg", (int)32, (int)32);
    }
}

