/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.format;

import java.util.Objects;
import java.util.Optional;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.format.FormatService;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoOutputFormat;
import org.pentaho.hadoop.shim.spi.FormatShim;

public class FormatServiceImpl
implements FormatService {
    private final FormatShim formatShim;
    private static final String PKG = "org.pentaho.big.data.impl.shim";
    private final String namedClusterName;

    public FormatServiceImpl(NamedCluster namedCluster, FormatShim formatShim) {
        this.namedClusterName = namedCluster == null ? "undefined" : namedCluster.getName();
        this.formatShim = Objects.requireNonNull(formatShim);
    }

    public <T extends IPentahoInputFormat> T createInputFormat(Class<T> type, NamedCluster namedCluster) {
        return (T)((IPentahoInputFormat)Optional.ofNullable(this.formatShim.createInputFormat(type, namedCluster)).orElseThrow(() -> new IllegalStateException(BaseMessages.getString((String)PKG, (String)"FormatService.FailedToFindFormat", (String[])new String[]{type.getCanonicalName(), this.namedClusterName}))));
    }

    public <T extends IPentahoOutputFormat> T createOutputFormat(Class<T> type, NamedCluster namedCluster) {
        return (T)((IPentahoOutputFormat)Optional.ofNullable(this.formatShim.createOutputFormat(type, namedCluster)).orElseThrow(() -> new IllegalStateException(BaseMessages.getString((String)PKG, (String)"FormatService.FailedToFindFormat", (String[])new String[]{type.getCanonicalName(), this.namedClusterName}))));
    }
}

